sub version_lic
    {
    print "\n";
    print "$ProgName,Version $prog_version\n";
    print "\n";
    print "This vmware Infrastructure monitoring plugin is free software, and comes with ABSOLUTELY NO WARRANTY.\n";
    print "It may be used, redistributed and/or modified under the terms of the GNU General Public Licence \n";
    print "(see http://www.fsf.org/licensing/licenses/gpl.txt).\n\n";
    print "Copyright (c) 2013 all modifications starting from check_vmware_api.pl Martin Fuerstenau - Oce Printing Systems <martin.fuerstenau\@oce.com>\n";
    print "Copyright (c) 2008 op5 AB Kostyantyn Hushchyn <dev\@op5.com>\n";
    print "\n";
    }

sub help_options
    {
    print "   -h|--help=<all>                    The complete help for all.\n";
    print "   -h|--help=<dc|datacenter|vcenter>  Help for datacenter/vcenter checks.\n";
    print "   -h|--help=<host>                   Help for vmware host checks.\n";
    print "   -h|--help=<vm>                     Help for virtual machines checks.\n";
    print "   -h|--help=<cluster>                Help for cluster checks.\n";
    }

sub hint
    {
    print "\n";
    print "Some general information:\n";
    print "There are options like -B, --exclude=<black_list>, -W, --include=<white_list>,--isregexp or --multiline. These options are implemented for ";
    print "some selects/subselects but not for all. To make it more handy for the user and to avoid paging up and down we have listed these options more ";
    print "than once. So for every select statement all the options are listed that can be used there\n";
    print "\n";
    print "Example:\n";
    print "\n";
    print "    Host service info:\n";
    print "    ------------------\n";
    print "    -S, --select=service                shows host service info.\n";
    print "    -B, --exclude=<black_list>          blacklist services.\n";
    print "    -W, --include=<white_list>          whitelist services.\n";
    print "        --isregexp                      whether to treat blacklist and whitelist as regexp\n";
    print "        --multiline                     Multiline output in overview. This mean technically that\n";
    print "                                        a multiline output uses a HTML <br> for the GUI instead of\n";
    print "                                        Be aware that your messing connections (email, SMS...) must use\n";
    print "                                        a filter to file out the <br>. A sed oneliner like the following\n";
    print "                                        will do the job: sed 's/<[^<>]*>//g'\n";
    print "\n";
    }

sub print_help
    {
    my ($section) = @_;
    my $page;
    
    if (!defined($section))
       {
       $section = "all";
       }
    
    if ($section =~ m/^[a-z].*$/i)
       {
       $section = lc($section);
       if (!(($section eq "dc") || ($section eq "datacenter") || ($section eq "vcenter") || ($section eq "host") || ($section eq "vm") || ($section eq "all") || ($section eq "cluster")))
          {
          print "\n$section is not a valid value for help. Valid values are:\n\n";
          help_options();
          version_lic();
          exit 1;
          }
       }
    else
       {
       print "\nBecause the output of the complete help is very large you have to select what you want:\n\n";
       help_options();
       if(-t STDOUT) {
           print "<--Hit enter for next page-->";
           $page = <STDIN>;
           undef $page;
       }
       hint();
       if(-t STDOUT) {
            print "<--Hit enter for next page-->";
            $page = <STDIN>;
            undef $page;
       }
       version_lic();
       exit 0;
       }

    if (($section eq "dc") || ($section eq "datacenter") || ($section eq "vcenter") || ($section eq "host") || ($section eq "vm") || ($section eq "all") || ($section eq "cluster"))
       {
       version_lic();
       print "General options:\n";
       print "================\n";
       print "\n";
       print "-?, --usage                          Print usage information\n";
       print "-h, --help                           Print detailed help screen\n";
       print "-V, --version                        Print version information\n";
       print "--ignore_unknown                     Sometimes 3 (unknown) is returned from a component.\n";
       print "                                     But the check itself is ok.\n";
       print "                                     With this option the plugin will return OK (0) instead of UNKNOWN (3).\n";
       print "--ignore_warning                     Sometimes 2 (warning) is returned from a component.\n";
       print "                                     But the check itself is ok (from an operator view).\n";
       print "                                     With this option the plugin will return OK (0) instead of WARNING (1).\n";
       print "-t, --timeout=INTEGER                Seconds before plugin times out (default: 90)\n";
       print "    --trace=<level>                  Set verbosity level of vSphere API request/respond trace.\n";
       print "\n";

       print "Options for authentication:\n";
       print "===========================\n";
       print "\n";
       print "                                     To reduce amounts of login/logout events in the vShpere logfiles or a lot of\n";
       print "                                     open sessions using sessionfiles the login part has been rewritten. Using session\n";
       print "                                     files is now the default. Only one session file per host or vCenter is used as\n";
       print "                                     default.\n";
       print "\n";
       print "                                     The sessionfile name is automatically set to the vSphere host or the vCenter\n";
       print "                                     (IP or name - whatever is used in the check).\n";
       print "\n";
       print "                                     Multiple sessions are possible using different session file names. To form different\n";
       print "                                     session file names the default name is enhenced by the value you set with\n";
       print "                                     --sessionfile.\n";
       print "\n";
       print "                                     NOTICE! All checks using the same session are serialized. So a lot of checks\n";
       print "                                     using only one session can cause timeouts. In this case you should enhence the\n";
       print "                                     number of sessions by using --sessionfile in the command definition and define\n";
       print "                                     the value in the service definition command as an extra argument so it can be used\n";
       print "                                     in the command definition as \$ARGn\$.\n";
       print "     --sessionfile=<sessionfile>     (Optional).Session file name enhancement.\n";
       print "     --sessionfiledir=<directory>    (Optional).If this option is set a path different from the path stored in\n";
       print "                                     \$nagios_plugin_cache will be used.\n";
       print "     --nosession                     (Optional). Don't use a session file. This is the old behaviour. It should\n";
       print "     --nosession                     be used for production use because it can cause a lot of entries in the log\n";
       print "                                     files an therefore can cause abnormal growing of the log.\n";
       print "                                     IT SHOULD BE USED FOR TESTING PURPOSES ONLY!\n";
       print "-u, --username=<username>            Username to connect with.\n";
       print "-p, --password=<password>            Password to use with the username.\n";
       print "-f, --authfile=<path>                Authentication file with login and password.\n";
       print "                                     File syntax :\n";
       print "                                     username=<login>\n";
       print "                                     password=<password>\n";
       print "\n";
       }

#--- Data Center ----------------------

    if (($section eq "dc") || ($section eq "datacenter") || ($section eq "vcenter") || ($section eq "all"))
       {
       print "Monitoring the vmware datacenter:\n";
       print "=================================\n";
       print "\n";
       print "-D, --datacenter=<DCname>           Datacenter/Vcenter hostname.\n";
       print "    --sslport=<port>                If a SSL port different from 443 is used.\n";
       print "\n";
       print "Volumes:\n";
       print "--------\n";
       print "\n";
       print "-S, --select=volumes                Shows all datastore volumes info\n";
       print "or with\n";
       print "-s, --subselect=<name>              free space info for volume with name <name>\n\n";
       print "    --usedspace                     Output used space instead of free\n";
       print "\n";
       print "    --perf_free_space               Perfdata for free space instead of used space. In versions prior to 0.9.18\n";
       print "                                    performance data was always as freespace even if you selected --usedspace.\n";
       print "                                    Now with --usedspace perf data will be also in used space.\n";
       print "                                    This option is mainly to preserve existing performce data.\n";
       print "\n";
       print "    --alertonly                     List only alerting volumes\n";
       print "-B, --exclude=<black_list>          Blacklist volumes.\n";
       print "-W, --include=<white_list>          Whitelist volumes.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat name, blacklist and whitelist as regexp\n";
       print "-w, --warning=<threshold>           Warning threshold.\n";
       print "-c, --critical=<threshold>          Critical threshold.\n";
       print "                                    Thresholds should be either a simple counter or a percentage\n";
       print "                                    value in the nn% (i.e. 90%). If checking more than a single\n";
       print "                                    with --usedspace volume only percent is allowed as threshold.\n";
       print "\n";
       print "Runtime Info:\n";
       print "-------------\n";
       print "\n";
       print "-S, --select=runtime                Shows all runtime info for the datacenter/Vcenter.\n";
       print "                                    No thresholds are allowed here\n";
       print "or with\n";
       print "-s, --subselect=listvms             List of vmware machines and their power state..\n";
       print "\n";
       print "                                    BEWARE!! In larger environments systems can cause trouble displaying\n";
       print "                                    the informations needed due to the mass of data.\n";
       print "                                  . Use --alertonly to avoid this.\n";
       print "\n";
       print "-B, --exclude=<black_list>          Blacklist VMs.\n";
       print "-W, --include=<white_list>          Whitelist VMs.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat blacklist and whitelist as regexp\n";
       print "    --multiline                     Multiline output in overview. This mean technically that\n";
       print "                                    a multiline output uses a HTML <br> for the GUI instead of\n";
       print "                                    Be aware that your messing connections (email, SMS...) must use\n";
       print "                                    a filter to file out the <br>. A sed oneliner like the following\n";
       print "                                    will do the job: sed 's/<[^<>]*>//g'\n";
       print "    --alertonly                     List only alerting VMs. Important here to avoid masses of data.\n";
       print "or\n";
       print "-s, --subselect=listhost            List of VMware ESX hosts and their power state..\n";
       print "                                    Power state can be (from the docs):\n";
       print "                                    - poweredOff  The host was specifically powered off by the user\n";
       print "                                                  through VirtualCenter. This state is not a cetain state,\n";
       print "                                                  because after VirtualCenter issues the command to power\n";
       print "                                                  off the host, the host might crash, or kill all the\n";
       print "                                                  processes but fail to power off.\n";
       print "                                    - poweredOn   The host is powered on\n";
       print "                                    - standBy     The host was specifically put in standby mode, either\n";
       print "                                                  explicitly by the user, or automatically by DPM. This\n";
       print "                                                  state is not a cetain state, because after VirtualCenter\n";
       print "                                                  issues the command to put the host in stand-by state,\n";
       print "                                                  the host might crash, or kill all the processes but fail\n";
       print "                                                  to power off.\n";
       print "                                    - unknown     If the host is disconnected, or notResponding, we can not\n";
       print "                                                  possibly have knowledge of its power state. Hence, the\n";
       print "                                                  host is marked as unknown.\n";
       print "\n";
       print "                                    BEWARE!! In larger environments systems can cause trouble displaying\n";
       print "                                    the informations needed due to the mass of data.\n";
       print "                                  . Use --alertonly to avoid this.\n";
       print "\n";
       print "-B, --exclude=<black_list>          Blacklist VMware ESX hosts.\n";
       print "-W, --include=<white_list>          Whitelist VMware ESX hosts.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat blacklist and whitelist as regexp\n";
       print "    --multiline                     Multiline output in overview. This mean technically that\n";
       print "                                    a multiline output uses a HTML <br> for the GUI instead of\n";
       print "                                    Be aware that your messing connections (email, SMS...) must use\n";
       print "                                    a filter to file out the <br>. A sed oneliner like the following\n";
       print "                                    will do the job: sed 's/<[^<>]*>//g'\n";
       print "    --alertonly                     List only alerting hosts. Important here to avoid masses of data.\n";
       print "or\n";
       print "-s, --subselect=listcluster         List of vmware clusters and their states.\n";
       print "                                    States can be (from the docs):\n";
       print "                                    - gray    The status is unknown.\n";
       print "                                    - green   The entity is OK.\n";
       print "                                    - red     The entity definitely has a problem.\n";
       print "                                    - yellow  The entity might have a problem.\n";
       print "-B, --exclude=<black_list>          Blacklist VMware cluster.\n";
       print "-W, --include=<white_list>          Whitelist VMware cluster.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat blacklist and whitelist as regexp\n";
       print "    --multiline                     Multiline output in overview. This mean technically that\n";
       print "                                    a multiline output uses a HTML <br> for the GUI instead of\n";
       print "                                    Be aware that your messing connections (email, SMS...) must use\n";
       print "                                    a filter to file out the <br>. A sed oneliner like the following\n";
       print "                                    will do the job: sed 's/<[^<>]*>//g'\n";
       print "    --alertonly                     List only alerting hosts. Important here to avoid masses of data.\n";
       print "or\n";
       print "-s, --subselect=issues              All issues for the host.\n";
       print "-B, --exclude=<black_list>          Blacklist issues.\n";
       print "-W, --include=<white_list>          Whitelist issues.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat blacklist and whitelist as regexp\n";
       print "    --multiline                     Multiline output in overview. This mean technically that\n";
       print "                                    a multiline output uses a HTML <br> for the GUI instead of\n";
       print "                                    Be aware that your messing connections (email, SMS...) must use\n";
       print "                                    a filter to file out the <br>. A sed oneliner like the following\n";
       print "                                    will do the job: sed 's/<[^<>]*>//g'\n";
       print "or\n";
       print "-s, --subselect=status              Overall object status (gray/green/red/yellow).\n";
       print "                                    State can be (from the docs):\n";
       print "                                    - gray    The status is unknown.\n";
       print "                                    - green   The entity is OK.\n";
       print "                                    - red     The entity definitely has a problem.\n";
       print "                                    - yellow  The entity might have a problem.\n";
       print "or\n";
       print "-s, --subselect=tools               Vmware Tools status. Tool status can be:\n";
       print "                                    - Installed,running and current.\n";
       print "                                    - Installed,running,but the installed version is known to\n";
       print "                                      have a grave bug and should be immediately upgraded.\n";
       print "                                    - Installed,running,version is not current\n";
       print "                                    - Installed,running,supported and newer than the\n";
       print "                                      version available on the host\n";
       print "                                    - Installed,running,supported, but a newer version is available\n";
       print "                                    - Installed,running,but the version is known to be too new\n";
       print "                                      too new to work correctly with this virtual machine\n";
       print "                                    - Installed,running,but the version is too old\n";
       print "                                    - Installed,running,but not managed by VMWare\n";
       print "    --poweredonly                   List only VMs which are powered on.\n";
       print "-B, --exclude=<black_list>          Blacklist VMs.\n";
       print "-W, --include=<white_list>          Whitelist VMs.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat blacklist and whitelist as regexp\n";
       print "    --multiline                     Multiline output in overview. This mean technically that\n";
       print "                                    a multiline output uses a HTML <br> for the GUI instead of\n";
       print "                                    Be aware that your messing connections (email, SMS...) must use\n";
       print "                                    a filter to file out the <br>. A sed oneliner like the following\n";
       print "                                    will do the job: sed 's/<[^<>]*>//g'\n";
       print "    --alertonly                     List only alerting VMs. Important here to avoid masses of data.\n";
       print "\n";
       print "SOAP API:\n";
       print "---------\n";
       print "\n";
       print "-S, --select=soap                   simple check to verify a successfull connection\n";
       print "                                    to VMWare SOAP API.\n";
       print "\n";
       }

#--- Host ----------------------

    if (($section eq "host") || ($section eq "all"))
       {
       print "Monitoring the vmware host:\n";
       print "===========================\n";
       print "\n";
       print "-H, --host=<hostname>               ESX or ESXi hostname.\n";
       print "    --sslport=<port>                If a SSL port different from 443 is used.\n";
       print "\n";
       print "Uptime:\n";
       print "-------\n";
       print "\n";
       print "-S, --select=uptime                 Displays uptime of the vmware host.\n";
       print "or with\n";
       print "\n";
       print "CPU:\n";
       print "----\n";
       print "\n";
       print "-S, --select=cpu                    CPU usage in percentage\n";
       print "-w, --warning=<threshold>           Warning threshold in percent.\n";
       print "-c, --critical=<threshold>          Critical threshold in percent.\n";
       print "or with\n";
       print "-s, --subselect=ready               Percentage of time that the virtual machine was\n";
       print "                                    ready, but could not get scheduled to run on the\n";
       print "                                    physical CPU. CPU ready time is dependent on the\n";
       print "                                    number of virtual machines on the host and their\n";
       print "                                    CPU loads. High or growing ready time can be a\n";
       print "                                    hint CPU bottlenecks\n";
       print "or\n";
       print "-s, --subselect=wait                CPU time spent in wait state. The wait total includes\n";
       print "                                    time spent the CPU idle, CPU swap wait, and CPU I/O\n";
       print "                                    wait states. High or growing wait time can be a\n";
       print "                                    hint I/O bottlenecks.\n";
       print "or\n";
       print "-s, --subselect=usage               Actively used CPU of the host, as a percentage of\n";
       print "                                    the total available CPU. Active CPU is approximately\n";
       print "                                    equal to the ratio of the used CPU to the available\n";
       print "                                    CPU.\n";
       print "\n";
       print "                                    Available CPU = # of physical CPUs x clock rate\n";
       print "\n";
       print "                                    100% represents all CPUs on the host. For example,\n";
       print "                                    if a four-CPU host is running a virtual machine with\n";
       print "                                    two CPUs, and the usage is 50%, the host is using two\n";
       print "                                    CPUs completely.\n";
       print "-w, --warning=<threshold>           Warning threshold in percent.\n";
       print "-c, --critical=<threshold>          Critical threshold in percent.\n";
       print "\n";
       print "Memory:\n";
       print "-------\n";
       print "\n";
       print "-S, --select=mem                    All mem info(except overall and no thresholds)\n";
       print "or with\n";
       print "-s, --subselect=usage               Average mem usage in percentage\n";
       print "or\n";
       print "-s, --subselect=consumed            Amount of machine memory used on the host. Consumed\n";
       print "                                    memory includes Includes memory used by the Service\n";
       print "                                    Console, the VMkernel vSphere services, plus the\n";
       print "                                    total consumed metrics for all running virtual\n";
       print "                                    machines in MB\n";
       print "or\n";
       print "-s, --subselect=swapused            Amount of memory that is used by swap. Sum of memory\n";
       print "                                    swapped of all powered on VMs and vSphere services\n";
       print "                                    on the host in MB. In case of an error all VMs with their\n";
       print "                                    swap used will be displayed. Use --multiline to have\n";
       print "                                    a better formatted output.\n";
       print "    --multiline                     Multiline output in overview. This mean technically that\n";
       print "                                    a multiline output uses a HTML <br> for the GUI instead of\n";
       print "                                    Be aware that your messing connections (email, SMS...) must use\n";
       print "                                    a filter to file out the <br>. A sed oneliner like the following\n";
       print "                                    will do the job: sed 's/<[^<>]*>//g'\n";
       print "or\n";
       print "-s, --subselect=overhead            Additional mem used by VM Server in MB\n";
       print "or\n";
       print "-s, --subselect=memctl              The sum of all vmmemctl values in MB for all powered-on\n";
       print "                                    virtual machines, plus vSphere services on the host.\n";
       print "                                    If the balloon target value is greater than the balloon\n";
       print "                                    value, the VMkernel inflates the balloon, causing more\n";
       print "                                    virtual machine memory to be reclaimed. If the balloon\n";
       print "                                    target value is less than the balloon value, the VMkernel\n";
       print "                                    deflates the balloon, which allows the virtual machine to\n";
       print "                                    consume additional memory if needed.used by VM memory\n";
       print "                                    control driver. In case of an error all VMs with their\n";
       print "                                    vmmemctl values will be displayed. Use --multiline to have\n";
       print "                                    a better formatted output.\n";
       print "    --multiline                     Multiline output in overview. This mean technically that\n";
       print "                                    a multiline output uses a HTML <br> for the GUI instead of\n";
       print "                                    Be aware that your messing connections (email, SMS...) must use\n";
       print "                                    a filter to file out the <br>. A sed oneliner like the following\n";
       print "                                    will do the job: sed 's/<[^<>]*>//g'\n";
       print "\n";
       print "Network:\n";
       print "-------\n";
       print "\n";
       print "-S, --select=net                    Shows net info\n";
       print "-B, --exclude=<black_list>          Blacklist NICs.\n";
       print "    --isregexp                      Whether to treat blacklist as regexp\n";
       print "or with\n";
       print "-s, --subselect=usage               Overall network usage in KBps(Kilobytes per Second).\n";
       print "or\n";
       print "-s, --subselect=receive             Receive in KBps(Kilobytes per Second).\n";
       print "or\n";
       print "-s, --subselect=send                Send in KBps(Kilobytes per Second).\n";
       print "or\n";
       print "-s, --subselect=nic                 Check all active NICs.\n";
       print "-B, --exclude=<black_list>          Blacklist NICs.\n";
       print "    --isregexp                      Whether to treat blacklist as regexp\n";
       print "\n";
       print "Volumes:\n";
       print "--------\n";
       print "\n";
       print "-S, --select=volumes                Shows all datastore volumes info\n";
       print "or with\n";
       print "-s, --subselect=<name>              Free space info for volume with name <name>\n\n";
       print "    --gigabyte                      Output in GB instead of MB\n";
       print "    --usedspace                     Output used space instead of free\n";
       print "\n";
       print "    --perf_free_space               Perfdata for free space instead of used space. In versions prior to 0.9.18\n";
       print "                                    performance data was always as freespace even if you selected --usedspace.\n";
       print "                                    Now with --usedspace perf data will be also in used space.\n";
       print "                                    This option is mainly to preserve existing performce data.\n";
       print "\n";
       print "    --alertonly                     List only alerting volumes\n";
       print "-B, --exclude=<black_list>          Blacklist volumes.\n";
       print "-W, --include=<white_list>          Whitelist volumes.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat name, blacklist and whitelist as regexp\n";
       print "-w, --warning=<threshold>           Warning threshold.\n";
       print "-c, --critical=<threshold>          Critical threshold.\n";
       print "                                    Thresholds should be either a simple counter or a percentage\n";
       print "                                    value in the nn% (i.e. 90%). If checking more than a single\n";
       print "                                    with --usedspace volume only percent is allowed as threshold.\n";
       print "\n";
       print "Disk I/O:\n";
       print "---------\n";
       print "\n";
       print "-S, --select=io                     Shows all disk io info. Without subselect no thresholds\n";
       print "                                    can be given. All I/O values are aggregated from historical\n";
       print "                                    intervals over the past 24 hours with a 5 minute sample rate\n";
       print "or with\n";
       print "-s, --subselect=aborted             Number of aborted SCSI commands\n";
       print "or\n";
       print "-s, --subselect=resets              Number of SCSI bus resets\n";
       print "or\n";
       print "-s, --subselect=read                Average number of kilobytes read from the disk each second\n";
       print "                                    Rate at which data is read from each LUN on the host.\n";
       print "                                    read rate = # blocksRead per second x blockSize\n";
       print "                                    issued from the Guest OS to the virtual machine.\n";
       print "or\n";
       print "-s, --subselect=read_latency        Average amount of time (ms) to process a SCSI read command\n";
       print "                                    issued from the Guest OS to the virtual machine.\n";
       print "or\n";
       print "-s, --subselect=write               Average number of kilobytes written to disk each second.\n";
       print "                                    Rate at which data is written to each LUN on the host.\n";
       print "                                    write rate = # blocksRead per second x blockSize\n";
       print "or\n";
       print "-s, --subselect=write_latency       Average amount of time (ms) taken to process a SCSI write\n";
       print "                                    command issued by the Guest OS to the virtual machine.\n";
       print "or\n";
       print "-s, --subselect=usage               Aggregated disk I/O rate. For hosts, this metric includes\n";
       print "                                    the rates for all virtual machines running on the host\n";
       print "or\n";
       print "-s, --subselect=kernel_latency      Average amount of time (ms) spent by VMkernel processing\n";
       print "                                    each SCSI command.\n";
       print "or\n";
       print "-s, --subselect=device_latency      Average amount of time (ms) to complete a SCSI command\n";
       print "                                    from the physical device\n";
       print "or\n";
       print "-s, --subselect=queue_latency       Average amount of time (ms) spent in the VMkernel queue,\n";
       print "or\n";
       print "-s, --subselect=total_latency       Average amount of time (ms) taken during the collection interval\n";
       print "                                    to process a SCSI command issued by the guest OS to the virtual\n";
       print "                                    machine. The sum of kernelWriteLatency and deviceWriteLatency.\n";
       print "\n";
       print "Host mounted media:\n";
       print "-------------------\n";
       print "\n";
       print "-S, --select=hostmedia              List vm's with attached host mounted media like cd,dvd or\n";
       print "                                    floppy drives. This is important for monitoring because a\n";
       print "                                    virtual machine with a mount cd or dvd drive can not be\n";
       print "                                    moved to another host.\n";
       print "-B, --exclude=<black_list>          Blacklist VMs.\n";
       print "-W, --include=<white_list>          Whitelist VMs.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat blacklist and whitelist as regexp\n";
       print "    --listall                       List all VMs with all mounted media.\n";
       print "    --multiline                     Multiline output in overview. This mean technically that\n";
       print "                                    a multiline output uses a HTML <br> for the GUI instead of\n";
       print "                                    Be aware that your messing connections (email, SMS...) must use\n";
       print "                                    a filter to file out the <br>. A sed oneliner like the following\n";
       print "                                    will do the job: sed 's/<[^<>]*>//g'\n";
       print "\n";
       print "Service info:\n";
       print "-------------\n";
       print "-S, --select=service                Shows host service info.\n";
       print "-B, --exclude=<black_list>          Blacklist services.\n";
       print "-W, --include=<white_list>          Whitelist services.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat blacklist and whitelist as regexp\n";
       print "    --multiline                     Multiline output in overview. This mean technically that\n";
       print "                                    a multiline output uses a HTML <br> for the GUI instead of\n";
       print "                                    Be aware that your messing connections (email, SMS...) must use\n";
       print "                                    a filter to file out the <br>. A sed oneliner like the following\n";
       print "                                    will do the job: sed 's/<[^<>]*>//g'\n";
       print "\n";
       print "Runtime info:\n";
       print "-------------\n";
       print "-S, --select=runtime                Shows runtime info. Used without -s show all runtime info:\n";
       print "                                    VMs, overall status, connection state, health, storagehealth, temperature\n";
       print "                                    and sensor are represented as one value and without thresholds.\n";
       print "or with\n";
       print "-s, --subselect=con                 Shows connection state.\n";
       print "or\n";
       print "-s, --subselect=listvms             List of vmware machines and their statuses.\n";
       print "-B, --exclude=<black_list>          Blacklist VMs.\n";
       print "-W, --include=<white_list>          Whitelist VMs.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat blacklist and whitelist as regexp\n";
       print "    --multiline                     Multiline output in overview. This mean technically that\n";
       print "                                    a multiline output uses a HTML <br> for the GUI instead of\n";
       print "                                    Be aware that your messing connections (email, SMS...) must use\n";
       print "                                    a filter to file out the <br>. A sed oneliner like the following\n";
       print "                                    will do the job: sed 's/<[^<>]*>//g'\n";
       print "or\n";
       print "-s, --subselect=status              Overall object status (gray/green/red/yellow).\n";
       print "                                    State can be (from the docs):\n";
       print "                                    - gray    The status is unknown.\n";
       print "                                    - green   The entity is OK.\n";
       print "                                    - red     The entity definitely has a problem.\n";
       print "                                    - yellow  The entity might have a problem.\n";
       print "or\n";
       print "-s, --subselect=health              Checks cpu/storage/memory/sensor status.\n";
       print "    --listsensors                   List all available sensors(use for listing purpose only)\n";
       print "\n";
       print "    --nostoragestatus               This is to avoid a double alarm if you use -s health and\n";
       print "                                    -s storagehealth.\n";
       print "\n";
       print "-B, --exclude=<black_list>          Blacklist storage, memory and sensors.\n";
       print "-W, --include=<white_list>          Whitelist storage, memory and sensors.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat blacklist and whitelist as regexp\n";
       print "or\n";
       print "-s, --subselect=storagehealth       Local(!) storage status check.\n";
       print "-B, --exclude=<black_list>          Blacklist storage.\n";
       print "-W, --include=<white_list>          Whitelist storage.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat blacklist and whitelist as regexp\n";
       print "    --multiline                     Multiline output in overview. This mean technically that\n";
       print "                                    a multiline output uses a HTML <br> for the GUI instead of\n";
       print "                                    Be aware that your messing connections (email, SMS...) must use\n";
       print "                                    a filter to file out the <br>. A sed oneliner like the following\n";
       print "                                    will do the job: sed 's/<[^<>]*>//g'\n";
       print "or\n";
       print "-s, --subselect=temp                Lists all temperature sensors.\n";
       print "-B, --exclude=<black_list>          Blacklist sensors.\n";
       print "-W, --include=<white_list>          Whitelist sensors.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat blacklist and whitelist as regexp\n";
       print "    --multiline                     Multiline output in overview. This mean technically that\n";
       print "                                    a multiline output uses a HTML <br> for the GUI instead of\n";
       print "                                    Be aware that your messing connections (email, SMS...) must use\n";
       print "                                    a filter to file out the <br>. A sed oneliner like the following\n";
       print "                                    will do the job: sed 's/<[^<>]*>//g'\n";
       print "or\n";
       print "-s, --subselect=issues              Lists all configuration issues for the host.\n";
       print "-B, --exclude=<black_list>          Blacklist configuration issues.\n";
       print "-W, --include=<white_list>          Whitelist configuration issues.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat blacklist and whitelist as regexp\n";
       print "    --multiline                     Multiline output in overview. This mean technically that\n";
       print "                                    a multiline output uses a HTML <br> for the GUI instead of\n";
       print "                                    Be aware that your messing connections (email, SMS...) must use\n";
       print "                                    a filter to file out the <br>. A sed oneliner like the following\n";
       print "                                    will do the job: sed 's/<[^<>]*>//g'\n";
       print "\n";
       print "Storage info:\n";
       print "-------------\n";
       print "\n";
       print "-S, --select=storage                Shows Host storage info.\n";
       print "\n";
       print "                                    BEWARE!! Without a subselect only a summary will be listed.\n";
       print "                                    Larger environments in SAN systems can cause trouble displaying the\n";
       print "                                    informations needed due to the mass of data even when used with subselects\n";
       print "                                  . Use --alertonly to avoid this.\n";
       print "\n";
       print "-B, --exclude=<black_list>          Blacklist adapters, luns (use blacklist on canonical names for it)\n";
       print "                                    and paths. All items can be in one blacklist. Beware of regexp.\n";
       print "                                    A given regexp must give a destinct result.\n";
       print "-W, --include=<white_list>          Whitelist adapters, luns (use whitelist on canonical names for it)\n";
       print "                                    and paths. All items can be in one whitelist. Beware of regexp.\n";
       print "                                    A given regexp must give a destinct result.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat blacklist and whitelist as regexp\n";
       print "or with\n";
       print "-s, --subselect=adapter             List host bus adapters.\n";
       print "-B, --exclude=<black_list>          Blacklist adapters. Blacklisted adapters will not be displayed.\n";
       print "-W, --include=<white_list>          Whitelist adapters.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat blacklist and whitelist as regexp\n";
       print "    --multiline                     Multiline output in overview. This mean technically that\n";
       print "                                    a multiline output uses a HTML <br> for the GUI instead of\n";
       print "                                    Be aware that your messing connections (email, SMS...) must use\n";
       print "                                    a filter to file out the <br>. A sed oneliner like the following\n";
       print "                                    will do the job: sed 's/<[^<>]*>//g'\n";
       print "or with\n";
       print "-s, --subselect=lun                 List SCSI logical units. The listing will include:\n";
       print "                                    - LUN\n";
       print "                                    - canonical name of the disc\n";
       print "                                    - all of displayed name which is not part of the canonical name\n";
       print "                                    - the status\n";
       print "-B, --exclude=<black_list>          Blacklist luns (use blacklist on canonical names for it).\n";
       print "                                    Blacklisted luns will not be displayed.\n";
       print "-W, --include=<white_list>          Whitelist luns (use whitelist on canonical names for it).\n";
       print "                                    Only whitelisted adapters will be displayed.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat blacklist and whitelist as regexp\n";
       print "    --alertonly                     List only alerting units. Important here to avoid masses of data.\n";
       print "    --multiline                     Multiline output in overview. This mean technically that\n";
       print "                                    a multiline output uses a HTML <br> for the GUI instead of\n";
       print "                                    Be aware that your messing connections (email, SMS...) must use\n";
       print "                                    a filter to file out the <br>. A sed oneliner like the following\n";
       print "                                    will do the job: sed 's/<[^<>]*>//g'\n";
       print "or with\n";
       print "-s, --subselect=path                List multipaths and the associated paths.\n";
       print "    --standbyok                     For storage systems where a standby multipath\n";
       print "                                    is ok and not a warning.\n";
       print "-B, --exclude=<black_list>          Blacklist paths.\n";
       print "-W, --include=<white_list>          Whitelist paths.\n";
       print "                                    A multipath SCSI ID is in the form:\n";
       print "                                    02003c000060a98000375274315a244276694e67684c554e202020\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat blacklist and whitelist as regexp\n";
       print "    --alertonly                     List only alerting units. Important here to avoid masses of data.\n";
       print "    --multiline                     Multiline output in overview. This mean technically that\n";
       print "                                    a multiline output uses a HTML <br> for the GUI instead of\n";
       print "                                    Be aware that your messing connections (email, SMS...) must use\n";
       print "                                    a filter to file out the <br>. A sed oneliner like the following\n";
       print "                                    will do the job: sed 's/<[^<>]*>//g'\n";
       print "\n";
       print "SOAP API:\n";
       print "---------\n";
       print "\n";
       print "-S, --select=soap                   Simple check to verify a successfull connection\n";
       print "                                    to VMWare SOAP API.\n";
       print "\n";
       }


#--- Virtual machine ----------------------

    if (($section eq "vm") || ($section eq "all"))
       {
       print "Monitoring a virtual machine via vmware datacenter or vmware host:\n";
       print "==================================================================\n";
       print "\n";
       print "-D, --datacenter=<DCname>           Datacenter hostname.\n";
       print "  or \n";
       print "-H, --host=<hostname>               ESX or ESXi hostname.\n";
       print "\n";
       print "-N, --name=<vmname>                 Virtual machine name.\n";
       print "    --sslport=<port>                If a SSL port different from 443 is used.\n";
       print "\n";
       print "CPU:\n";
       print "----\n";
       print "\n";
       print "-S, --select=cpu                    CPU usage in percentage\n";
       print "-w, --warning=<threshold>           Warning threshold in percent.\n";
       print "-c, --critical=<threshold>          Critical threshold in percent.\n";
       print "or with\n";
       print "-s, --subselect=ready               Percentage of time that the virtual machine was\n";
       print "                                    ready, but could not get scheduled to run on the\n";
       print "                                    physical CPU. CPU ready time is dependent on the\n";
       print "                                    number of virtual machines on the host and their\n";
       print "                                    CPU loads. High or growing ready time can be a\n";
       print "                                    hint CPU bottlenecks\n";
       print "or\n";
       print "-s, --subselect=wait                CPU time spent in wait state. The wait total includes\n";
       print "                                    time spent the CPU idle, CPU swap wait, and CPU I/O\n";
       print "                                    wait states. High or growing wait time can be a\n";
       print "                                    hint I/O bottlenecks.\n";
       print "or\n";
       print "-s, --subselect=usage               Amount of actively used virtual CPU, as a percentage\n";
       print "                                    of total available CPU. This is the host's view of\n";
       print "                                    the CPU usage, not the guest operating system view.\n";
       print "                                    It is the average CPU utilization over all available\n";
       print "                                    virtual CPUs in the virtual machine. For example, if\n";
       print "                                    a virtual machine with one virtual CPU is running on\n";
       print "                                    a host that has four physical CPUs and the CPU usage\n";
       print "                                    is 100%, the virtual machine is using one physical CPU\n";
       print "                                    completely. \n";
       print "-w, --warning=<threshold>           Warning threshold in percent.\n";
       print "-c, --critical=<threshold>          Critical threshold in percent.\n";
       print "\n";
       print "Memory:\n";
       print "-------\n";
       print "\n";
       print "-S, --select=mem                    all mem info(except overall and no thresholds)\n";
       print "or with\n";
       print "-s, --subselect=usage               Average mem usage in percentage of configured virtual\n";
       print "                                    machine \"physical\" memory.\n";
       print "or\n";
       print "-s, --subselect=consumed            Amount of guest physical memory in MB consumed by the\n";
       print "                                    virtual machine for guest memory. Consumed memory does\n";
       print "                                    not include overhead memory. It includes shared memory\n";
       print "                                    and memory that might be reserved, but not actually\n";
       print "                                    used. Use this metric for charge-back purposes.\n";
       print "                                    vm consumed memory = memory granted - memory saved\n";
       print "or\n";
       print "-s, --subselect=memctl              Amount of guest physical memory that is currently\n";
       print "                                    reclaimed from the virtual machine through ballooning.\n";
       print "                                    This is the amount of guest physical memory that has been\n";
       print "                                    allocated and pinned by the balloon driver.\n";
       print "\n";
       print "Network:\n";
       print "-------\n";
       print "\n";
       print "-S, --select=net                    Shows net info\n";
       print "or with\n";
       print "-s, --subselect=usage               Overall network usage in KBps(Kilobytes per Second).\n";
       print "or\n";
       print "-s, --subselect=receive             Receive in KBps(Kilobytes per Second).\n";
       print "or\n";
       print "-s, --subselect=send                Send in KBps(Kilobytes per Second).\n";
       print "\n";
       print "Disk I/O:\n";
       print "---------\n";
       print "\n";
       print "-S, --select=io                     Shows all disk io info. Without subselect no thresholds\n";
       print "                                    can be given. All I/O values are aggregated from historical\n";
       print "                                    intervals over the past 24 hours with a 5 minute sample rate.\n";
       print "or with\n";
       print "-s, --subselect=read                Average number of kilobytes read from the disk each second.\n";
       print "or\n";
       print "-s, --subselect=write               Average number of kilobytes written to disk each second.\n";
       print "or\n";
       print "-s, --subselect=usage               Aggregated disk I/O rate.\n";
       print "or\n";
       print "\n";
       print "Runtime Info:\n";
       print "-------------\n";
       print "\n";
       print "-S, --select=runtime                Shows runtime info, When used without subselect\n";
       print "                                    no thresholds can be given.\n";
       print "or with\n";
       print "-s, --subselect=con                 Shows the connection state. Connection state can be:\n";
       print "                                    connected	The server has access to the virtual machine.\n";
       print "                                    disconnected	When checked directly by a VMware host, then\n";
       print "                                                  the disconnected state is not possible. However,\n";
       print "                                                  when accessed through VirtualCenter, the state\n";
       print "                                                  of a virtual machine is set to disconnected if\n";
       print "                                                  the hosts that manage the virtual machine becomes\n";
       print "                                                  unavailable.\n";
       print "                                    inaccessible	One or more of the virtual machine configuration\n";
       print "                                                  files are inaccessible. For example, this can be\n";
       print "                                                  due to transient disk failures. In this case, no\n";
       print "                                                  configuration can be returned for a virtual machine.\n";
       print "                                    invalid	The virtual machine configuration format is invalid.\n";
       print "                                                  Thus, it is accessible on disk, but corrupted in a\n";
       print "                                                  way that does not allow the server to read the content\n";
       print "                                                . In this case, no configuration can be returned for\n";
       print "                                                  a virtual machine.\n";
       print "                                    orphaned	The virtual machine is no longer registered on the\n";
       print "                                                  host it is associated with. For example, a virtual\n";
       print "                                                  machine that is unregistered or deleted directly on\n";
       print "                                                  a host managed by VirtualCenter shows up in this state.\n";
       print "or with\n";
       print "-s, --subselect=powerstate          Virtual machine power state poweredOn, poweredOff, suspended)\n";
       print "or with\n";
       print "-s, --subselect=status              Overall object status (gray/green/red/yellow)\n";
       print "                                    State can be (from the docs):\n";
       print "                                    - gray    The status is unknown.\n";
       print "                                    - green   The entity is OK.\n";
       print "                                    - red     The entity definitely has a problem.\n";
       print "                                    - yellow  The entity might have a problem.\n";
       print "or with\n";
       print "-s, --subselect=consoleconnections  Console connections to VM.\n";
       print "-w, --warning=<threshold>           Warning threshold.\n";
       print "-c, --critical=<threshold>          Critical threshold.\n";
       print "or with\n";
       print " -s, --subselect=gueststate         Guest OS status. Needs VMware Tools installed and running.\n";
       print "                                    The status can be:\n";
       print "                                    running      -> Guest is running normally. (Ok)\n";
       print "                                    shuttingdown -> Guest has a pending shutdown command. (Warning)\n";
       print "                                    resetting    -> Guest has a pending reset command. (Warning)\n";
       print "                                    standby      -> Guest has a pending standby command. (Warning)\n";
       print "                                    notrunning   -> Guest is not running. (Warning)\n";
       print "                                    unknown      -> Guest information is not available. (Unknown)\n";
       print "\n";
       print "                                    Due to the fact that it depends on running VMware tools some of\n";
       print "                                    the tools stats are checked here either:\n";
       print "                                    - VMware tools are starting. (Warning)\n";
       print "                                    - VMware tools are not running.\n";
       print "                                      (Warning) if VM up and running.\n";
       print "                                      (Ok) if VM powerd off or suspended.\n";
       print "or with\n";
       print " -s, --subselect=tools              Vmware tools  status. The status can be:\n";
       print "                                    - VMware tools are starting. (Warning)\n";
       print "                                    - VMware tools are not running.\n";
       print "                                      (Warning) if VM up and running.\n";
       print "                                      (Ok) if VM powerd off or suspended.\n";
       print "                                    - VMware tools are running. (Ok) \n";
       print "                                    - VMware tools are installed, but the installed version is known\n";
       print "                                      to have a grave bug and should be immediately upgraded. (Critical)\n";
       print "                                    - VMware tools are installed, but the version is not current. (Warning)\n";
       print "                                    - VMware tools were never been installed. (Warning)\n";
       print "                                    - VMware tools are installed, supported, and newer than the version\n";
       print "                                      available on the host. (Warning)\n";
       print "                                    - No information about VMware tools available. (Warning)\n";
       print "\n";
       print "                                    New since vSphere API 5.0:\n";
       print "                                    - VMware tools are installed, and the version is current. (Ok)\n";
       print "                                    - VMware tools are installed, supported, but a newer version is\n";
       print "                                      available. (Warning)\n";
       print "                                    - VMware tools are installed, and the version is known to be too new to\n";
       print "                                      work correctly with this virtual machine. (Critical)\n";
       print "                                    - VMware tools are installed, but the version is too old. (Warning)\n";
       print "                                    - VMware tools are installed, but it is not managed by VMWare. (Critical)\n";
       print "or with\n";
       print " -s, --subselect=issues             All issues for the host\n";
       print "     --multiline                    Multiline output in overview. This mean technically that\n";
       print "                                    a multiline output uses a HTML <br> for the GUI instead of\n";
       print "                                    Be aware that your messing connections (email, SMS...) must use\n";
       print "                                    a filter to file out the <br>. A sed oneliner like the following\n";
       print "                                    will do the job: sed 's/<[^<>]*>//g'\n";
       print "\n";
       }

#--- Cluster ----------------------

    if (($section eq "all") || ($section eq "cluster"))
       {
       print "Monitoring a vmware cluster via vmware datacenter or vmware host:\n";
       print "=================================================================\n";
       print "\n";
       print "-D, --datacenter=<DCname>           Datacenter hostname.\n";
       print "  or \n";
       print "-H, --host=<hostname>               ESX or ESXi hostname.\n";
       print "\n";
       print "-C, --cluster=<clustername>         ESX or ESXi clustername.\n";
       print "    --sslport=<port>                If a SSL port different from 443 is used.\n";
   
       print "-S, --select=COMMAND\n";
       print "   Specify command type (cpu,mem,net,io,volumes,runtime, ...)\n";
       print "-s, --subselect=SUBCOMMAND\n";
       print "   Specify subselect\n";
       print "\n";
       print "-B, --exclude=<black_list>\n";
       print "   Specify black list\n";
       print "\n";
       print "    Cluster specific :\n";
       print "\n";
       print "Memory:\n";
       print "-------\n";
       print "\n";
       print "        * cluster - shows cluster services info\n";
       print "            + effectivecpu - total available cpu resources of all hosts within cluster\n";
       print "            + effectivemem - total amount of machine memory of all hosts in the cluster\n";
       print "            + failover - vmware HA number of failures that can be tolerated\n";
       print "            + cpufainess - fairness of distributed cpu resource allocation\n";
       print "            + memfainess - fairness of distributed mem resource allocation\n";
       print "            ^ only effectivecpu and effectivemem values for cluster services\n";
       print "        * runtime - shows runtime info\n";
       print "            + listvms - list of vmware machines in cluster and their statuses\n";
       print "            + listhost - list of vmware esx host servers in cluster and their statuses\n";
       print "            + status - overall cluster status (gray/green/red/yellow)\n";
       print "                                    States can be (from the docs):\n";
       print "                                    - gray    The status is unknown.\n";
       print "                                    - green   The entity is OK.\n";
       print "                                    - red     The entity definitely has a problem.\n";
       print "                                    - yellow  The entity might have a problem.\n";
       print "            + issues - all issues for the cluster\n";
       print "                b - blacklist issues\n";
       print "            ^ all cluster runtime info\n";
       print "\n";
       print "Volumes:\n";
       print "--------\n";
       print "\n";
       print "-S, --select=volumes                Shows all datastore volumes info\n";
       print "or with\n";
       print "-s, --subselect=<name>              free space info for volume with name <name>\n\n";
       print "    --usedspace                     Output used space instead of free\n";
       print "\n";
       print "    --perf_free_space               Perfdata for free space instead of used space. In versions prior to 0.9.18\n";
       print "                                    performance data was always as freespace even if you selected --usedspace.\n";
       print "                                    Now with --usedspace perf data will be also in used space.\n";
       print "                                    This option is mainly to preserve existing performce data.\n";
       print "\n";
       print "    --alertonly                     List only alerting volumes\n";
       print "-B, --exclude=<black_list>          Blacklist volumes.\n";
       print "-W, --include=<white_list>          Whitelist volumes.\n";
       print "\n";
       print "                                    Use blacklist OR(!) whitelist. Using both in one statement\n";
       print "                                    is not allowed.\n";
       print "\n";
       print "    --isregexp                      Whether to treat name, blacklist and whitelist as regexp\n";
       print "-w, --warning=<threshold>           Warning threshold.\n";
       print "-c, --critical=<threshold>          Critical threshold.\n";
       print "                                    Thresholds should be either a simple counter or a percentage\n";
       print "                                    value in the nn% (i.e. 90%). If checking more than a single\n";
       print "                                    with --usedspace volume only percent is allowed as threshold.\n";
       print "\n";
       }
    }

# A module always must end with a returncode of 1. So placing 1 at the end of a module 
# is a common method to ensure this.
1;
