<?php
/*
Nagios ModGearman Manager
Version 1.4
---------------------
Bryan Heden
Agile Networks
---------------------
bheden@agilenetworks.com

This file is part of "Nagios ModGearman Manager".

    "Nagios ModGearman Manager" is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    "Nagios ModGearman Manager" is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with "Nagios ModGearman Manager".  If not, see <http://www.gnu.org/licenses/>.
*/

// include the component helper
require_once(dirname(__FILE__).'/../componenthelper.inc.php');

// component stuff
$modgearman_component_name="modgearman";
modgearman_component_init();
function modgearman_component_init() {
	global $modgearman_component_name;
	$args=array(
		COMPONENT_NAME => $modgearman_component_name,
		COMPONENT_AUTHOR => "Bryan Heden @ Agile Networks",
		COMPONENT_DESCRIPTION => "Manage ModGearman workers from a central location.",
		COMPONENT_TITLE => "Nagios ModGearman Manager",
		COMPONENT_VERSION => 1.4,
		COMPONENT_DATE => "04/16/2014");
	register_component($modgearman_component_name, $args);
	register_callback(CALLBACK_MENUS_INITIALIZED, 'modgearman_component_addmenu');
}
function modgearman_component_addmenu($arg = null) {
	global $modgearman_component_name;
	$urlbase = get_component_url_base($modgearman_component_name);
	$mi = find_menu_item(MENU_ADMIN,"menu-admin-managesystemconfig","id");
	if ($mi == null)
		return;
	$order = grab_array_var($mi, "order","");
	if ($order == "")
		return;
	$neworder = $order + 1;
	add_menu_item(MENU_ADMIN, array(
		"type" 	=> "link",
		"title" => "ModGearman",
		"id" 	=> "menu-admin-modgearman",
		"order" => $neworder,
		"opts" 	=> array(
			"href" 	=> $urlbase."/modgearman.php",
			)
		));
}
?>