<?php
/*
Nagios ModGearman Manager
Version 1.4
---------------------
Bryan Heden
Agile Networks
---------------------
bheden@agilenetworks.com

This file is part of "Nagios ModGearman Manager".

    "Nagios ModGearman Manager" is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    "Nagios ModGearman Manager" is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with "Nagios ModGearman Manager".  If not, see <http://www.gnu.org/licenses/>.
*/

// include the component helper
require_once(dirname(__FILE__).'/../componenthelper.inc.php');

// initialization stuff
pre_init();

// start session
init_session();

// grab GET or POST variables 
grab_request_vars();

// check prereqs
check_prereqs();

// check authentication
check_authentication();

// route request / show page stuff
route_request();
function route_request() {
	global $request;
	show_page();
	exit;
}
function show_page($error = false, $msg = "") {
	global $request;
	global $lstr;
	
	////////////////////////////////////////////////
	// BEGIN CHANGABLE VARIABLES
	////////////////////////////////////////////////
	
	// gearman worker server array
	$gearman_worker_array = array( 
		"worker-1" => "10.0.0.1",
		"worker-2" => "10.0.0.2");
				
	// where does the mod_gearman_worker.conf file exist on the servers?
	$gearman_conf_file = "/etc/mod_gearman/mod_gearman_worker.conf";
	
	// where can apache safely store the remote configuration files?
	$gearman_apache_safe_dir = "/tmp/nagiostemp/mod_gearman";
	
	////////////////////////////////////////////////
	// END CHANGABLE VARIABLES
	////////////////////////////////////////////////
	
	// create gearman_apache_safe_dir
	exec("mkdir -p $gearman_apache_safe_dir");
	
	// delete all current configuration files (the ones on the server, not on each of the hosts)
	foreach ($gearman_worker_array as $worker_name => $worker_ip) {
		exec("rm -f $gearman_apache_safe_dir/$worker_name.conf");
	}
	
	// handle post data
	$update = grab_request_var("update", "");
	$restart = grab_request_var("restart", "");
	$restart_active = grab_request_var("restart_active", "");
	$disconnect_worker = false;
	$connect_worker = false;
	foreach ($gearman_worker_array as $worker_name => $worker_ip) {
		
		// we have to replace the ip address's dots with underscores because of post (this comes up later in the conf_ update, also)
		$safe_worker_ip = str_replace(".", "_", $worker_ip);
		$disconnect = grab_request_var("disconnect_$safe_worker_ip", "");
		$connect = grab_request_var("connect_$safe_worker_ip", "");
		if ($disconnect != "")
			$disconnect_worker = $worker_ip;
		if ($connect != "")
			$connect_worker = $worker_ip;
	}
	
	// update worker configuration files
	if ($update != "") {
		
		// cycle through each worker to check for configuration
		foreach ($gearman_worker_array as $worker_name => $worker_ip) {
			
			// replace dots with underscores
			$safe_worker_name = str_replace(".", "_", $worker_name);
			$conf_file = grab_request_var("conf_$safe_worker_name", "");
			if ($conf_file != "") {
				
				// replace the \r (dos format) with blank (nix)
				$conf_file = str_replace("\r", "", $conf_file);
				
				// write the conf file, and check for errors in the meantime
				// but we don't check for errors IF the file is written successfully, because since we've got this far, we can (not safely)
				// assume that the configuration file textarea was present to begin with, which means that the original ssh command was executed.
				if (@file_put_contents("$gearman_apache_safe_dir/$worker_name.conf.new", $conf_file) !== false) {
					
					// backup the worker's current configuration file
					$ssh_cmd = "ssh nagios@$worker_ip \"cp $gearman_conf_file $gearman_conf_file.backup_`date +%F_%H%m`\"";
					exec($ssh_cmd);
					
					// copy the new file to the server
					$ssh_cmd = "scp $gearman_apache_safe_dir/$worker_name.conf.new nagios@$worker_ip:$gearman_conf_file";
					exec($ssh_cmd);
					
					// delete our .conf.new file!
					exec("rm -f $gearman_apache_safe_dir/$worker_name.conf.new");
						
				} else {
					
					// if it failed, print this error and move along
					echo "NOT-QUITE-FATAL ERROR: Cannot write $conf_file for $worker_name : $worker_ip\n";
				}
			}
		}
		
		// we want to restart all of the workers we just made a change to
		$restart_active = "Restart ACTIVE Workers";
	}

	// restart ALL client workers
	// THIS IS POTENTIALLY STUPID AND DANGEROUS BUT WHATEVER
	if ($restart != "") {
		
		// cycle through each worker to restart!
		foreach ($gearman_worker_array as $worker_name => $worker_ip) {
			control_server($worker_name, $worker_ip, "restart");
		}
	}
	
	// restart only active client workers
	if ($restart_active != "") {
		
		// cycle through each worker to restart!
		foreach ($gearman_worker_array as $worker_name => $worker_ip) {
		
			// replace dots with underscores, and check if we have an active_$worker_name
			// only proceed if we do!
			$safe_worker_name = str_replace(".", "_", $worker_name);
			$active = grab_request_var("active_$safe_worker_name", "");
			if ($active != "") {
				control_server($worker_name, $worker_ip, "restart");
			}
		}
	}
	
	// disconnect a worker
	if ($disconnect_worker !== false) {
		control_server("", $disconnect_worker, "stop");
	}
	
	// connect a worker
	if ($connect_worker !== false) {
		control_server("", $connect_worker, "start");
	}
	
	// get worker information
	$gearman_worker_html = "";
	$gearman_worker_info_array = array();
	foreach ($gearman_worker_array as $worker_name => $worker_ip) {
	
		// the scp(ssh) command to pull this gearmans conf over
		$ssh_cmd = "scp nagios@$worker_ip:$gearman_conf_file $gearman_apache_safe_dir/$worker_name.conf 2>&1";
			
		// execute the ssh command and get each line that we checked for in its own array
		$gearman_worker_info_array["$worker_name"] = array();
		exec($ssh_cmd, $gearman_worker_info_array["$worker_name"]);
				
		// check if we have any error output from the ssh command
		if (preg_match("/^ssh:/", $gearman_worker_info_array["$worker_name"])) {

			// this is unexpected maintenance, can we handle the errors gracefully?
			$gearman_worker_info_array["$worker_name"][] = "UNEXPECTED_ERROR";
		}
		
		// execute a check_gearman command to check and see if this worker is disconnected!
		// this only works if the $worker_name variable is the fqdn name that gearmand expects
		// AND it only works if our gearman server is running on localhost
		// good output starts with: "check_gearman OK -"
		// bad output starts with: "check_gearman WARNING -" - THIS IS THE ONE WE'RE WORRIED ABOUT RUH-ROH RAGGY
		$check_array = array();
		$check_cmd = "ssh nagios@$worker_ip \"/etc/init.d/mod_gearman_worker status\"";
		exec($check_cmd, $check_array);
		foreach ($check_array as $check_array_line) {
			if (strpos($check_array_line, "mod_gearman_worker is not running") !== false) {
				$gearman_worker_info_array["$worker_name"][] = "DISCONNECTED";
			}
		}
                
		// build our gearman_worker_html that contains the information for each worker
		if (in_array("UNEXPECTED_ERROR", $gearman_worker_info_array["$worker_name"])) {
			$gearman_worker_html .= "<div class=\"error worker\">\n
				<div class=\"name\">$worker_name</div>\n
				<div class=\"ip\">$worker_ip</div>\n
				<div class=\"message\">Unable to open SSH connection</div>\n
				<div class=\"clear\"></div>\n
				</div>\n
				<div class=\"clear\"></div>\n";
		} elseif (in_array("DISCONNECTED", $gearman_worker_info_array["$worker_name"])) {
			$gearman_worker_html .= "<div class=\"disconnected worker\">\n
				<div class=\"name\">$worker_name NOT CONNECTED</div>\n
				<div class=\"ip\">$worker_ip</div>\n
				<input type=\"submit\" name=\"connect_$worker_ip\" value=\"Connect this Worker\" />\n
				<textarea name=\"conf_$worker_name\" id=\"conf_$worker_name\" class=\"conftext\">\n" .
				@file_get_contents("$gearman_apache_safe_dir/$worker_name.conf") .
				"</textarea>\n
				<div class=\"clear\"></div>\n
				</div>\n
				<div class=\"clear\"></div>\n";
		} else {
			$gearman_worker_html .= "<div class=\"conf worker\">\n
				<input type=\"hidden\" name=\"active_$worker_name\" value=\"true\" />\n
				<div class=\"name\">$worker_name</div>\n
				<div class=\"ip\">$worker_ip</div>\n
				<input type=\"submit\" name=\"disconnect_$worker_ip\" value=\"Disconnect this Worker\" />\n
				<textarea name=\"conf_$worker_name\" id=\"conf_$worker_name\" class=\"conftext\">\n" .
				@file_get_contents("$gearman_apache_safe_dir/$worker_name.conf") .
				"</textarea>\n
				<div class=\"clear\"></div>\n
				</div>\n
				<div class=\"clear\"></div>\n";
		}
	}
	

?>
<!DOCTYPE html>
<html>
<head>
	<title>Nagios XI - ModGearman</title>
	<meta name="viewport" content="initial-scale=1.0, user-scalable=no" />
	<meta name="ROBOTS" content="NOINDEX, NOFOLLOW">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<?php do_page_head_links(); ?>
	<style type="text/css">
#gearman_top {
	margin: 10px 20px 25px;
	border: 1px solid black;
	display: inline-block;
	padding: 10px;
}
.worker {
	margin: 10px 20px 25px;
	clear: both;
	border: 1px solid black;
	background-color: #00ff00;
	display: inline-block;
	padding: 10px;
}
textarea.conftext {
	width: 50em;
	height: 20em;
}
.worker .name {
	font-size: 1.5em;
	font-weight: bold;
	text-decoration: underline;
}
.worker .ip {
	font-size: 1.25em;
	font-style: italic;
}
.error {
	background-color: #fe2e2e;
}
.disconnected {
	background-color: #ff8000;
}
.worker textarea {
	float: left;
	clear: both;
}
.worker input {
	float: left;
	clear: both;
}
.clear {
	clear: both;
}
	</style>
	<script type="text/javascript">
		window.setInterval(function() {
			$.ajax('modgearman.ajax.php?gearmantop=true').done(function(html) {
				$('#gearman_top').empty().append(html);
			});
		}, 1000);
	</script>
</head>
<body>
	<h2>gearman_top Output</h2>
	<div id="gearman_top"></div>
	<h2>ModGearman Workers</h2>
	<div id="workers">
		<form method="post">
			<input type="submit" name="update" value="Update Worker Configuration" />
			<input type="submit" name="restart" value="Restart ALL Workers" />
			<input type="submit" name="restart_active" value="Restart ACTIVE Workers" />
			<div class="clear"></div>
<?php
		// show worker status/config
		echo $gearman_worker_html; ?>
		</form>
		<div class="clear"></div>
	</div>
</body>
</html>
<?php
	exit();
}

// control a server
function control_server($worker_name, $worker_ip, $cmd = "restart") {

	// only accept start/stop/restart
	if (($cmd != "start") &&
		($cmd != "stop"))
		$cmd = "restart";
		
	// format for worker_name (get rid of trailing colon if no data)
	$worker_name = ($worker_name != "") ? "$worker_name:" : "";

	// the restart command to execute
	$ssh_cmd = "ssh nagios@$worker_ip \"/etc/init.d/mod_gearman_worker $cmd\" 2>&1";
	
	// the array to check for errors
	$ssh_output = array();
	
	// execute, dammit
	exec($ssh_cmd, $ssh_output);
	
	// check for /NO:ssh errors/ and for gearman errors 
	foreach ($ssh_output as $output) {
		if (strpos($output, "[ERROR]") !== false) {
			
			echo "$worker_name$worker_ip: " . substr($output, strpos($output, "[ERROR]")) . "\n" .
				strtoupper($cmd) . " FAILED - (Correct your error and try again?)\n\n";
		}
	}
}
?>
