<?php
// Better Better Bullet Map (BBBMAP) Component
//
// Copyright (c) 2010 Nagios Enterprises, LLC.  All rights reserved.
//  
// $Id: bbmap.inc.php 155 2010-11-06 02:36:00Z egalstad $

require_once(dirname(__FILE__).'/../componenthelper.inc.php');

include_once(dirname(__FILE__).'/dashlet.inc.php');

// respect the name
$bbmap_component_name="bbbmap";

// run the initialization function
bbbmap_component_init();

////////////////////////////////////////////////////////////////////////
// COMPONENT INIT FUNCTIONS
////////////////////////////////////////////////////////////////////////

function bbbmap_component_init(){
	global $bbbmap_component_name;
	
	$versionok=bbbmap_component_checkversion();
	
	$desc="";
	if(!$versionok)
		$desc="<b>Error: ".gettext("This component requires Nagios XI 2009R1.4 or later.")."</b>";
	
	$args=array(

		// need a name
		COMPONENT_NAME => $bbbmap_component_name,
		COMPONENT_VERSION => '0.1',
		// informative information
		COMPONENT_AUTHOR => "Nagios Enterprises, LLC",
		COMPONENT_DESCRIPTION => gettext("Displays a grid-like view of host and service status. ").$desc,
		COMPONENT_TITLE => "BBBMap",
		// configuration function (optional)
		//COMPONENT_CONFIGFUNCTION => "bbbmap_component_config_func",
		);
		
	register_component($bbbmap_component_name,$args);
	
	// add a menu link
	if($versionok)
		register_callback(CALLBACK_MENUS_INITIALIZED,'bbbmap_component_addmenu');
		
	// register a dashlet
	$args=array();
	$args[DASHLET_NAME]="bbbmap";
	$args[DASHLET_TITLE]="BBBMap";
	$args[DASHLET_FUNCTION]="bbbmap_dashlet_func";
	$args[DASHLET_DESCRIPTION]=gettext("Displays a grid-like view of host and service status.");
	$args[DASHLET_WIDTH]="350";
	$args[DASHLET_HEIGHT]="250";
	$args[DASHLET_INBOARD_CLASS]="bbbmap_map_inboard";
	$args[DASHLET_OUTBOARD_CLASS]="bbbmap_map_outboard";
	$args[DASHLET_CLASS]="bbbmap_map";
	$args[DASHLET_AUTHOR]="Nagios Enterprises, LLC";
	$args[DASHLET_COPYRIGHT]="Dashlet Copyright &copy; 2011 Nagios Enterprises. All rights reserved.";
	$args[DASHLET_HOMEPAGE]="http://www.nagios.com";
	$args[DASHLET_SHOWASAVAILABLE]=true;
	register_dashlet($args[DASHLET_NAME],$args);
	}
	



///////////////////////////////////////////////////////////////////////////////////////////
// MISC FUNCTIONS
///////////////////////////////////////////////////////////////////////////////////////////

function bbbmap_component_checkversion(){

	if(!function_exists('get_product_release'))
		return false;
	//requires greater than 2009R1.2
	if(get_product_release()<114)
		return false;

	return true;
	}
	
function bbbmap_component_addmenu($arg=null){
	global $bbbmap_component_name;
	
	$mi=find_menu_item(MENU_HOME,"menu-home-networkstatusmap","id");
	if($mi==null)
		return;
		
	$order=grab_array_var($mi,"order","");
	if($order=="")
		return;
		
	$neworder=$order-0.1;

	add_menu_item(MENU_HOME,array(
		"type" => "link",
		"title" => "BBBmap",
		"id" => "menu-home-bbbmap",
		"order" => $neworder,
		"opts" => array(
			"href" => get_base_url().'includes/components/bbbmap/',
			)
		));
	
	}


///////////////////////////////////////////////////////////////////////////////////////////
// AJAX FUNCTIONS
///////////////////////////////////////////////////////////////////////////////////////////

function xicore_ajax_get_bbbmap_dashlet_html($args=null){

	$host=grab_array_var($args,"host","");
	$hostgroup=grab_array_var($args,"hostgroup","");
	$servicegroup=grab_array_var($args,"servicegroup","");

	// special "all" stuff
	if($hostgroup=="all")
		$hostgroup="";
	if($servicegroup=="all")
		$servicegroup="";
	if($host=="all")
		$host="";
		
	// can do hostgroup OR servicegroup OR host
	if($hostgroup!=""){
		$servicegroup="";
		$host="";
		}
	else if($servicegroup!=""){
		$host="";
		}

	//  limit hosts by hostgroup or host
	$host_ids=array();
	$host_ids_str="";
	//  limit by hostgroup
	if($hostgroup!=""){
		$host_ids=get_hostgroup_member_ids($hostgroup);
		}
	//  limit by host
	else if($host!=""){
		$host_ids[]=get_host_id($host);
		}
	$y=0;
	foreach($host_ids as $hid){
		if($y>0)
			$host_ids_str.=",";
		$host_ids_str.=$hid;
		$y++;
		}
	//  limit service by servicegroup
	$service_ids=array();
	$service_ids_str="";
	if($servicegroup!=""){
		$service_ids=get_servicegroup_member_ids($servicegroup);
		}
	$y=0;
	foreach($service_ids as $sid){
		if($y>0)
			$service_ids_str.=",";
		$service_ids_str.=$sid;
		$y++;
		}
		
		
	// get service status from backend
	$backendargs=array();
	$backendargs["cmd"]="getservicestatus";
	$backendargs["limitrecords"]=false;  // don't limit records
	$backendargs["combinedhost"]=true;  // get host status too
	$backendargs["brevity"]=1;  // we don't everything
        $backendargs["current_state"]="in:1,2,3";                       //problems only
	$backendargs["problem_acknowledged"]=0;                         //un-ack'd problems only
	$backendargs["scheduled_downtime_depth"]=0;                     //not in sched downtime
	// host id limiters
	if($host_ids_str!="")
		$backendargs["host_id"]="in:".$host_ids_str;
	// service id limiters
	if($service_ids_str!="")
		$backendargs["service_id"]="in:".$service_ids_str;
	// order by host name, service description
	$backendargs["orderby"]="host_name:a,service_description:a";

	$xml=get_xml_service_status($backendargs);
	
	
	// get service names
	$servicenames=array();
	foreach($xml->servicestatus as $ss){
		$sn=strval($ss->name);
		if(!in_array($sn,$servicenames))
			$servicenames[]=$sn;
		}
		
	//echo "<BR>NAMES1<BR>";
	//print_r($servicenames);
	sort($servicenames);
	//echo "<BR>NAMES2<BR>";
	//print_r($servicenames);
	$cols=count($servicenames);
	if($cols<1)
		$cols=1;

		
	$output="";
	
	$pretitle="";
	if($host!="")
		$pretitle=gettext("Host")." '$host' ";
	else if($hostgroup!="")
		$pretitle=gettext(Hostgroup)." '$hostgroup' ";
	else if($servicegroup!="")
		$pretitle=gettext(Servicegroup)." '$servicegroup' ";
	
	$output.='<div class="infotable_title">'.$pretitle.gettext('Status Grid').'</div>';
	
	//$output.='ARGS='.serialize($args).'<BR>';

	$output.='
	<table class="infotable" border="1">
	<thead>
	<tr><th rowspan="2">'.gettext('Host').'</th><th colspan="'.$cols.'">'.gettext('Services').'</th></tr>
	<tr>
	';
	for($x=0;$x<$cols;$x++){
		$output.='<td>'.bbbmap_get_service_title($servicenames[$x]).'</td>';
		}
	$output.='
	</tr>
	</thead>
	<tbody>
	';

	if($xml){
		//$output.='<tr><td>ARGS</td><td>'.serialize($backendargs).'</td><tr>';
		//$output.='<tr><td colspan="2">'.serialize($xml).'</td><tr>';
		
		$base_url=get_base_url();
		$status_url=$base_url."includes/components/xicore/status.php";
		$image_url=$base_url."includes/components/bbbmap/images/";
		
		$lasthost="";
		$coloutput=array();
		foreach($xml->servicestatus as $ss){
			//$output.='<tr><td>SVC</td></tr>';
			
			$thishost=strval($ss->host_name);
			
			if($thishost!=$lasthost){
			
				// end last row
				if($lasthost!=""){
				
					for($x=0;$x<$cols;$x++){
						$co="";
						if(array_key_exists($x,$coloutput))
							$co=$coloutput[$x];
						$output.='<td>'.$co.'</td>';
						}

					$output.='</tr>';
					
					// clear columnn output
					unset($coloutput);
					$coloutput=array();
					}
			
				$hosttext=strval($ss->host_status_text);
				$hoststate=intval($ss->host_current_state);
				$hosthbc=intval($ss->host_has_been_checked);
				
				$statetext="";
				
				switch($hoststate){
					case 0:
						if($hosthbc==1){
							$img=$image_url."up.png";
							$statetext="Up";
							}
						else{
							$img=$image_url."pending.png";
							$statetext="Pending";
							}
						break;
					case 1:
						$img=$image_url."down.png";
						$statetext="Down";
						break;
					case 2:
						$img=$image_url."unreachable.png";
						$statetext="Unreachable";
						break;
					default:
						$img="";
						break;
					}

				// check for acknowledgements, scheduled downtime
				if($hoststate!=0){
					$ack=intval($ss->host_problem_acknowledged);
					$sdd=intval($ss->host_scheduled_downtime_depth);
					if($ack==1){
						$statetext.=" (Acknowledged)";
						$img=$image_url."handled.png";
						}
					else if($sdd>0){
						$statetext.=" (Scheduled Downtime)";
						$img=$image_url."handled.png";
						}
					}

				$imgtitle="Host ".$statetext.": ".htmlentities($hosttext);

				// start new row
				$output.='<tr><td nowrap>';
				$output.='<a href="'.$status_url.'?show=hostdetail&host='.urlencode($thishost).'" target="_blank"><img src="'.$img.'" alt="'.$imgtitle.'" title="'.$imgtitle.'">'.$thishost.'</a>';
				}
				
			// remember last host
			$lasthost=$thishost;
				
			// service status
			$service=strval($ss->name);

			$servicetext=strval($ss->status_text);
			$servicestate=intval($ss->current_state);
			$servicehbc=intval($ss->has_been_checked);
			
			$statetext="";
			
			switch($servicestate){
				case 0:
					if($servicehbc==1){
						$img=$image_url."ok.png";
						$statetext="Ok";
						}
					else{
						$img=$image_url."pending.png";
						$statetext="Pending";
						}
					break;
				case 1:
					$img=$image_url."warning.png";
					$statetext="Warning";
					break;
				case 2:
					$img=$image_url."critical.png";
					$statetext="Critical";
					break;
				case 3:
					$img=$image_url."unknown.png";
					$statetext="Unknown";
					break;
				default:
					$img="";
					break;
				}
				
			// check for acknowledgements, scheduled downtime
			if($servicestate!=0){
				$ack=intval($ss->problem_acknowledged);
				$sdd=intval($ss->scheduled_downtime_depth);
				if($ack==1){
					$statetext.=" (Acknowledged)";
					$img=$image_url."handled.png";
					}
				else if($sdd>0){
					$statetext.=" (Scheduled Downtime)";
					$img=$image_url."handled.png";
					}
				}

			// check for host acknowledgements, scheduled downtime
			if($hoststate!=0){
				$ack=intval($ss->host_problem_acknowledged);
				$sdd=intval($ss->host_scheduled_downtime_depth);
				if($ack==1){
					$statetext.=" (Host Problem Acknowledged)";
					$img=$image_url."handled.png";
					}
				else if($sdd>0){
					$statetext.=" (Host In Scheduled Downtime)";
					$img=$image_url."handled.png";
					}
				}

			$imgtitle="".htmlentities($service)." ".$statetext.": ".htmlentities($servicetext);

			// what column does this go in?
			$col=array_search($service,$servicenames);	

			$coloutput[$col]='<a href="'.$status_url.'?show=servicedetail&host='.urlencode($thishost).'&service='.urlencode($service).'" target="_blank"><img src="'.$img.'" alt="'.$imgtitle.'" title="'.$imgtitle.'"></a>';
			
			}
		
		// end last row
		if($lasthost!=""){
		
			for($x=0;$x<$cols;$x++){
				$co="";
				if(array_key_exists($x,$coloutput))
					$co=$coloutput[$x];
				$output.='<td>'.$co.'</td>';
				}

			$output.='</tr>';
				
			// clear columnn output
			unset($coloutput);
			$coloutput=array();
			}
		}
	else{
		$output.='<tr><td  colspan="'.($cols+1).'">'.gettext('No data to display').'</td></tr>';
		}
		

	$output.='
	</tbody>
	</table>';

	$output.='
	<div class="ajax_date">'.gettext('Last Updated').': '.get_datetime_string(time()).'</div>
	';
	
	return $output;
	}

function bbbmap_get_service_title($s){

	//$title=$s;
	
	$title="<div class='bbbmapverticaltext'>$s</div>";
	
	/*
	$title="";
	$words=explode(" ",$s);
	foreach($words as $word){
		$title.="<div style='float: left;'>";
		$len=strlen($word);
		for($x=0;$x<$len;$x++){
			$title.=substr($word,$x,1)."<BR>";
			}
		$title.="</div>";
		}
	*/

	return $title;
	}
?>
