#!/usr/bin/perl
# nagios: -epn
## $Id: check_nb_noyaux by J.Ph. LEMOINE$

## Nagios Plugin for check how many kernels are installed

## Copyright (C) 2004  Joe Anthony
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use strict;
use warnings;
use Switch;

sub try_load_module($) {
    my $module = shift;

    eval "require $module";
    if ($@) {
     print "DOMAIN UNKNOWN - Can't load module $module, ",
     "perhaps it isn't installed\n$@";
     print "Config::INI::Reader --> sudo apt-get install libconfig-ini-perl\n";
     print "Nagios::Plugin      --> sudo apt-get install libnagios-pluging-perl\n";
     exit 3;
    }

    $module->import;
   
}

BEGIN {
    try_load_module 'Config::INI::Reader';
    try_load_module 'Nagios::Plugin';
}

use vars qw/ $VERSION /;
use lib "/usr/lib/perl5/B";

my $VERSION = '1.2';
my $LICENCE = "Ce plugin Nagios est gratuit et libre de droits, et vous pouvez l'utiliser à votre convenance."
  . ' Il est livré avec ABSOLUMENT AUCUNE GARANTIE.';

my $plugin_nagios = Nagios::Plugin->new(
  shortname => 'check_nb_noyaux',
  usage     => 'Usage : %s -t|--type <1|2|3> -w|--warning <warning value> -c|--critical <critical value> -l|--lang <language code fr or en> -i|--ini_path <path ini file>',
  version   => $VERSION,
  license   => $LICENCE,
);

# put the 2 letters of the country code
# in 10/28/2012, there is 2 possibilies :
# fr for french
# en for english
# can be changed if needed
my $country_code_def="fr";

# start with a / is absolute path
# with 1st directory if relative path
# can be changed if needed
my $path_to_ini="ini";

# variables declaration
# do not modify

# script pamameter
my $TYPE         = '';
my $WARN         = '';
my $CRIT         = '';
my $COUNTRY_CODE = '';
my $INI_PATH     = '';
# name of the perl script
my $PROGNAME     = '';
# path to perl script
my $PATH         = '';
# name of the ini file
my $NAME_INI     = '';
# content of the ini file = traduction
my $hash_ref     = '';
# path & name oh the ini file
my $ini_file     = '';

# define the current path as possible search path
my $PATH_PL = '';
BEGIN {
    $PATH_PL = `dirname $0`;
    $PATH_PL = substr($PATH_PL, 0, -1);
    if (substr($PATH_PL,0,2) eq "./")
        {
        $PATH_PL=substr($PATH_PL,2);
        }
}

use lib "${PATH_PL}";
# sub routines are in sub file
require "check_nb_noyaux_sub.pl";

$plugin_nagios->add_arg(
spec     => 'type|t=s',
help     => '<type 1 (headers), 2 (image), 3 (image-extra)>',    # Help of option
required => 1,                  # required
);

$plugin_nagios->add_arg(
spec     => 'lang|l=s',
help     => 'fr ou en',    # Help of option
required => 0,                  # optional
);

$plugin_nagios->add_arg(
spec     => 'ini_path|i=s',
help     => 'ini path',    # Help of option
required => 0,                  # optional
);
$plugin_nagios->add_arg(
spec     => 'warning|w=s',
help     => 'value warning state',    # Help of option
required => 1,                  # required
);

$plugin_nagios->add_arg(
spec     => 'critical|c=s',
help     => 'value critical state',    # Help of option
required => 1,                  # required
);

$plugin_nagios->getopts();

$TYPE         = $plugin_nagios->opts->get('type');
$WARN         = $plugin_nagios->opts->get('warning');
$CRIT         = $plugin_nagios->opts->get('critical');
$COUNTRY_CODE = $plugin_nagios->opts->get('lang');
$INI_PATH     = $plugin_nagios->opts->get('ini_path');

if (defined($INI_PATH))
    {
    $path_to_ini=$INI_PATH;
    }

# check parameter : type must be 1, 2 ou 3
if (($TYPE != 1) &&
    ($TYPE != 2) &&
    ($TYPE != 3))
    {
    print "Type : <1|2[3>";
    exit 3;
    }


# ---- end parameters retrieve

# check if translation file exists
# if not, try to use default one

if (!(defined($COUNTRY_CODE)))
    {
    $COUNTRY_CODE = $country_code_def;
    }

# retrieve name of pl script
$PROGNAME=`basename $0`;
chomp($PROGNAME);


# retrieve the path of the script
$PATH=get_ini_path($path_to_ini);

# name of ini file is the same of pl script exect extension (.pl)
$NAME_INI=substr($PROGNAME, 0, -3);

# ini_file content the path & name of the ini file
$ini_file = "${PATH}${NAME_INI}_${COUNTRY_CODE}.ini";

if (!(-e $ini_file))
    {
    # ini file is not beeing found , try with default name
    $ini_file = "${PATH}${NAME_INI}.ini";
    if (!(-e $ini_file))
        {
        print "fatal error : conf file (${ini_file}) not found";
        exit 3;
        } 
    }

#put translations in memory
$hash_ref = Config::INI::Reader->read_file($ini_file);

# recuperation des libelles de noyaux
my $lib_noyau = '';
my $nom_noyau = '';

if ($TYPE == 1)
    {
    $lib_noyau = "linux-headers-3*";
    $nom_noyau = "headers";
    }
if ($TYPE == 2)
    {
    $lib_noyau = "linux-image-3*";
    $nom_noyau = "image";
    }
if ($TYPE == 3)
    {
    $lib_noyau = "linux-image-extra-3*";
    $nom_noyau = "image-extra";
    }

# calcul du nombres de noyau installés
my $nb_inst=`dpkg -l "$lib_noyau" | grep generic | grep -c ii`;
chomp($nb_inst);
# calcul du nombres de noyau à purger
my $nb_purge=`dpkg -l "$lib_noyau" | grep generic | grep -c -v ii`;
chomp($nb_purge);
#print "$nom_noyau : inst = $nb_inst ; purge = $nb_purge";


#recuperation des textes
my $status0a=$hash_ref->{status}->{status0a}; 
my $status1a=$hash_ref->{status}->{status1a};
my $status1b=$hash_ref->{status}->{status1b};
my $status2a=$hash_ref->{status}->{status2a};
my $status2b=$hash_ref->{status}->{status2b};
my $status2c=$hash_ref->{status}->{status2c};

# on teste si on dépasse les seuils 
# le nombre installé ne doit pas dépasser le seuil critique
if ($nb_inst > $CRIT)
{
  print "$nom_noyau : $status2a $nb_inst $status2b$nb_purge$status2c";
  exit 2;
}

if ($nb_purge > $WARN)
{
  print "$nom_noyau : $status1a $nb_purge $status1b";
  exit 1;
}

print "$nom_noyau : $status0a";
exit 0;


