#!/usr/bin/perl
# nagios: -epn
## $Id: check_acpi by J.Ph. LEMOINE$

## Nagios Plugin for acpi

##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use strict;
use warnings;
use Switch;
use Config::INI::Reader;
use Nagios::Plugin;
use vars qw/ $VERSION /;
use lib "/usr/lib/perl5/B";

my $VERSION = '1.1';
my $LICENCE = "Ce plugin Nagios est gratuit et libre de droits, et vous pouvez l'utiliser à votre convenance."
  . ' Il est livré avec ABSOLUMENT AUCUNE GARANTIE.';

my $plugin_nagios = Nagios::Plugin->new(
  shortname => 'check acpi',
  usage     => 'Usage : %s -w|--warning <warning value> -c|--critical <critical value> -l|--lang <language code fr or en> -i|--ini_path <path ini file>',
  version   => $VERSION,
  license   => $LICENCE,
);

# put the 2 letters of the country code
# in 10/28/2012, there is 2 possibilies :
# fr for french
# en for english
# can be changed if needed
my $country_code_def="fr";

# start with a / is absolute path
# with 1st directory if relative path
# can be changed if needed
my $path_to_ini="ini";

# variables declaration
# do not modify

# script pamameter
#my $ACTION       = '';
my $WARN         = '';
my $CRIT         = '';
my $COUNTRY_CODE = '';
my $INI_PATH     = '';
# name of the perl script
my $PROGNAME     = '';
# path to perl script
my $PATH         = '';
# name of the ini file
my $NAME_INI     = '';
# content of the ini file = traduction
my $hash_ref     = '';
# path & name oh the ini file
my $ini_file     = '';
# define the current path as possible search path
my $PATH_PL = '';
BEGIN {
    $PATH_PL = `dirname $0`;
    $PATH_PL = substr($PATH_PL, 0, -1);
    if (substr($PATH_PL,0,2) eq "./")
        {
        $PATH_PL=substr($PATH_PL,2);
        }
}

use lib "${PATH_PL}";
# sub routines are in sub file
require "check_acpi_sub.pl";

$plugin_nagios->add_arg(
spec     => 'lang|l=s',
help     => 'fr ou en',    # Help of option
required => 0,                  # optional
);

$plugin_nagios->add_arg(
spec     => 'ini_path|i=s',
help     => 'ini path',    # Help of option
required => 0,                  # optional
);
$plugin_nagios->add_arg(
spec     => 'warning|w=s',
help     => 'value warning state',    # Help of option
required => 1,                  # mandatory
);

$plugin_nagios->add_arg(
spec     => 'critical|c=s',
help     => 'value critical state',    # Help of option
required => 1,                  # Mandatory
);

$plugin_nagios->getopts();

$WARN         = $plugin_nagios->opts->get('warning');
$CRIT         = $plugin_nagios->opts->get('critical');
$COUNTRY_CODE = $plugin_nagios->opts->get('lang');
$INI_PATH     = $plugin_nagios->opts->get('ini_path');

if (defined($INI_PATH))
    {
    $path_to_ini=$INI_PATH;
    }

# check if translation file exists
# if not, try to use default one

if (!(defined($COUNTRY_CODE)))
    {
    $COUNTRY_CODE = $country_code_def;
    }

# retrieve name of pl script
$PROGNAME=`basename $0`;
chomp($PROGNAME);


# retrieve the path of the script
$PATH=get_ini_path($path_to_ini);

# name of ini file is the same of pl script exect extension (.pl)
$NAME_INI=substr($PROGNAME, 0, -3);

# ini_file content the path & name of the ini file
$ini_file = "${PATH}${NAME_INI}_${COUNTRY_CODE}.ini";

if (!(-e $ini_file))
    {
    # ini file is not beeing found , try with default name
    $ini_file = "${PATH}${NAME_INI}.ini";
    if (!(-e $ini_file))
        {
        print "fatal error : conf file (${ini_file}) not found";
        exit 3;
        } 
    }

#put translations in memory
$hash_ref = Config::INI::Reader->read_file($ini_file);


my $loadC=$hash_ref->{bat}->{batC};                
my $loadW=$hash_ref->{bat}->{batW};
my $load0=$hash_ref->{bat}->{bat0};

my $BAT = `acpi | awk '{print \$4}'`;
# delete CR + %
chomp($BAT);
if (substr($BAT,-1) eq ',')
  {
  $BAT=substr($BAT,0,-2);
  }
else
  {
  $BAT=substr($BAT,0,-1);
  }

if  ($BAT < $CRIT )
    {
    print "$loadC - Bat:  ${BAT}% < $CRIT%\n";
    # le PC doit s'éteindre de maniere douce
    # à faire plus tard.
    exit 2;
    }
if ($BAT < $WARN)
    {
    print "$loadW - Bat:  ${BAT}% < $WARN%\n";
    exit 1;
    }			
print "$load0 - BAT: ${BAT}%\n";
exit 0;

