<?php

/*
 * Nagios PHP Interface: cmd.cachexml.php
 * 2004 Eldad Zack <eldadzack@gmail.com>
 *
 * Pre-compile command-list XML to array, serialize it,
 * put it into cmd.def.compiled.

 LICENSE:
  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

# function adapted from comment by mmustafa@vsnl.com on the xml_parse_into_struct page
# (www.php.net/manual/en/function.xml-parse-into-struct.php)
function read_xml_file($file,&$xml_object)
{

	$xml_parser = xml_parser_create();

	if (!($fp = fopen($file, "r")))
	{
		return false;
	}

	$data = fread($fp, filesize($file));
	fclose($fp);

	xml_parse_into_struct($xml_parser, $data, $vals, $index);
	xml_parser_free($xml_parser);

	$xml_object = array();
	$level = array();
	foreach ($vals as $element)
	{
		if ($element['type'] == 'open')
		{
			if (array_key_exists('attributes',$element))
			{
				list($level[$element['level']],$extra) = array_values($element['attributes']);
			}

			else
			{
				$level[$element['level']] = $element['tag'];
			}
		}
		if ($element['type'] == 'complete')
		{
			$start_level = 1;
			$php_stmt = '$xml_object';

			while($start_level < $element['level'])
			{
				$php_stmt .= '[$level['.$start_level.']]';
				$start_level++;
			}
			$php_stmt .= '[$element[\'tag\']] = $element[\'value\'];';
			eval($php_stmt);
		}
	}

	return true;
}

read_xml_file("cmd.def.xml",$cmd_obj_temp);
$cmd_obj = serialize($cmd_obj_temp['COMMANDS']);

#print $cmd_obj;

$cmdfile = fopen("cmd.def.compiled","w");
fwrite($cmdfile,$cmd_obj);
fclose($cmdfile);

?>

