<?php

/*
 * Nagios PHP Interface: comments.php
 * 2004 Eldad Zack <eldadzack@gmail.com>

 LICENSE:
  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

if (!include "nagios.inc.php")
{
	exit("Nagios PHP initalization error.");
}

$comment_array = array();
$comment_array['hosts'] = array();
$comment_array['services'] = array();

$comment = file ($nagios->config['comment_file']);
foreach ($comment as $commentline)
{
	if (preg_match("/\[(\d+)\] HOST_COMMENT;(\d+);([^;]+);(\d);([^;]+);([^;]+)/",$commentline,$match))
	{
		$element = array();
	
		$element['time'] = $nagios->datetime($match[1]);
		$element['id'] = $match[2];
		$element['host'] = $match[3];
		$element['persistent'] = $nagios->yesno($match[4]);
		$element['author'] = $match[5];
		$element['comment'] = $match[6];

		array_push($comment_array['hosts'],$element);
	}
	elseif (preg_match("/\[(\d+)\] SERVICE_COMMENT;(\d+);([^;]+);([^;]+);(\d);([^;]+);([^;]+)/",$commentline,$match))
	{
		$elements = array();

		$element['time'] = $nagios->datetime($match[1]);
		$element['id'] = $match[2];
		$element['host'] = $match[3];
		$element['service'] = $match[4];
		$element['persistent'] = $nagios->yesno($match[5]);
		$element['author'] = $match[6];
		$element['comment'] = $match[7];

		array_push($comment_array['services'],$element);
	}
}


#
# SMTM
#

$nagios->print_header("Comments",true);

$blacksmith->assign("comment_array",$comment_array);
$blacksmith->display("comments.tpl");

$blacksmith->display("nagios-footer.tpl");

?>