<?php

/*
 * Nagios PHP Interface: downtime.php
 * 2004 Eldad Zack <eldadzack@gmail.com>

 LICENSE:
  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

if (!include "nagios.inc.php")
{
	exit("Nagios PHP initalization error.");
}

$downtime_array = array();
$downtime_array['hosts'] = array();
$downtime_array['services'] = array();

$downtime = file ($nagios->config['downtime_file']);
foreach ($downtime as $downtimeline)
{
	if (preg_match("/\[(\d+)\] HOST_DOWNTIME;(\d+);([^;]+);(\d+);(\d+);(\d);(\d+);([^;]+);([^;]+)/",$downtimeline,$match))
	{
		$element = array();
	
		$element['time'] = $nagios->datetime($match[1]);
		$element['id'] = $match[2];
		$element['host'] = $match[3];
		$element['starttime'] = $nagios->datetime($match[4]);
		$element['endtime'] = $nagios->datetime($match[5]);
		$element['fixed'] = $nagios->yesno($match[6]);
		$element['duration'] = $nagios->duration($match[7]);
		$element['author'] = $match[8];
		$element['comment'] = $match[9];

		array_push($downtime_array['hosts'],$element);
	}
	elseif (preg_match("/\[(\d+)\] SERVICE_DOWNTIME;(\d+);([^;]+);([^;]+);(\d+);(\d+);(\d);(\d+);([^;]+);([^;]+)/",$downtimeline,$match))
	{
		$elements = array();

		$element['time'] = $nagios->datetime($match[1]);
		$element['id'] = $match[2];
		$element['host'] = $match[3];
		$element['service'] = $match[4];
		$element['starttime'] = $nagios->datetime($match[5]);
		$element['endtime'] = $nagios->datetime($match[6]);
		$element['fixed'] = $nagios->yesno($match[7]);
		$element['duration'] = $nagios->duration($match[8]);
		$element['author'] = $match[9];
		$element['comment'] = $match[10];

		array_push($downtime_array['services'],$element);
	}
}


#
# SMTM
#

$nagios->print_header("Downtime",true);

$blacksmith->assign("downtime_array",$downtime_array);
$blacksmith->display("downtime.tpl");

$blacksmith->display("nagios-footer.tpl");

?>