<?php

/*
 * Nagios PHP Interface: extinfo.php
 * 2003-2004 Eldad Zack <eldadzack@gmail.com>
 *
 * TODO: Process: health check command
 * TODO: add command links

 LICENSE:

 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

if (!include "nagios.inc.php")
{
	exit("Nagios php script init error.");
}

$info_array = array();

function add_info($title,$value)
{
	global $info_array;

	$element = array();

	$element['title']=$title;
	$element['value']=$value;

	if ($value == "No" || $value == "CRITICAL" || $value == "DOWN")
	{
		$element['color']="red";
	}
	elseif ($value == "Yes" || $value == "OK" || $value == "UP") 
	{
		$element['color']="green";
	}
	else
	{
		$element['color']="pale";
	}

	array_push($info_array,$element);
}

# $type values:
# 1 = host
# 2 = service 

$status = file ($nagios->statusfile);

if (isset($_GET['host']))
{
	if (isset($_GET['service']))
	{
		$scanstr = "SERVICE;".$_GET['host'].";".$_GET['service'].";";
		$title = "Extended Service Information";
		$delete_comment_type = "SVC";
		$type = 2;
	}
	else
	{
		$scanstr = "HOST;".$_GET['host'].";";
		$title = "Extended Host Information";
		$delete_comment_type = "HOST";
		$type = 1;
	}
}
else
{
	$scanstr = "^\[[0-9]+\] PROGRAM;";
	$title = "Nagios Process Information";
	$type = 0;
}

$scanstr = $nagios->escape_preg($scanstr);
foreach ($status as $statusline)
{
	if (preg_match("/$scanstr/",$statusline))
	{
		$statusinfo=explode(";",rtrim($statusline));
		last;
	}
}

if (!isset($statusinfo))
{
	$nagios->print_error("No Such Host/Service<br>");
}

# Comments

$comment_array = array();

$comment = file ($nagios->config['comment_file']);
$scanstr = preg_replace("/(HOST|SERVICE);/","$1_COMMENT;(\d+);",$scanstr,1);
foreach ($comment as $commentline)
{
	if (preg_match("/$scanstr/",$commentline))
	{
		if (preg_match("/\[(\d+)\] $scanstr(\d);([^;]+);([^;]+)/",$commentline,$match))
		{
			$element = array();

			$element['time'] = $nagios->datetime($match[1]);
			$element['id'] = $match[2];
			$element['persistent'] = $nagios->yesno($match[3]);
			$element['author'] = $match[4];
			$element['comment'] = $match[5];

			array_push($comment_array,$element);
		}
		else
		{
			$nagios->error("Comment reading error.");
		}
	}
}

$nagios->print_header($title,true);

if ($type == 1)
// Host
{
	add_info("Service Status",$statusinfo[2]);
	add_info("Plugin Output",$statusinfo[20]);
	add_info("Last Check Time",$nagios->datetime($statusinfo[3]));
	add_info("Last State Change",$nagios->datetime($statusinfo[4]));	
	add_info("Problem Acknowledged",$nagios->yesno($statusinfo[5]));
	add_info("Time UP",$nagios->duration($statusinfo[6]));
	add_info("Time Down",$nagios->duration($statusinfo[7]));
	add_info("Time Unreachable",$nagios->duration($statusinfo[8]));
	add_info("Last Notification Time",$statusinfo[9]);
	add_info("Current Notification Number",$statusinfo[10]);
	add_info("Notifications Enabled",$nagios->yesno($statusinfo[11]));
	add_info("Event Handlers Enabled",$nagios->yesno($statusinfo[12]));
	add_info("Checks Enabled",$nagios->yesno($statusinfo[13]));
	add_info("Flap Detection Enabled",$nagios->yesno($statusinfo[14]));
	add_info("Host Is Flapping",$nagios->yesno($statusinfo[15]));
	add_info("Percent State Change",$statusinfo[16]);
	add_info("Scheduled Downtime Depth",$statusinfo[17]);
	add_info("Failure Prediction Enabled",$nagios->yesno($statusinfo[18]));
	add_info("Process Performance Date",$nagios->yesno($statusinfo[19]));

	$host_name = $statusinfo[1];
	$blacksmith->assign("host_name",$host_name);
	
	$address = $nagios->$nagiosconfig->hosts[$host_name]['address'];
	$blacksmith->assign("address",$address);
	
	$blacksmith->assign("info_array",$info_array);
	$blacksmith->display("extinfo-host.tpl");	
}
elseif ($type == 2)
// Service
{
	add_info("Service Status",$statusinfo[3]);
	add_info("Plugin Output",$statusinfo[31]);
	add_info("Retry Number",$statusinfo[4]);
	add_info("State Type",$statusinfo[5]);
	add_info("Last Check Time",$nagios->datetime($statusinfo[6]));
	add_info("Next Check Time",$nagios->datetime($statusinfo[7]));
	add_info("Check Interval",(($statusinfo[7]-$statusinfo[6])/60)." Minute(s)");
	add_info("Check Type",$statusinfo[8]);
	add_info("Checks Enabled",$nagios->yesno($statusinfo[9]));
	add_info("Accepting Passive Checks",$nagios->yesno($statusinfo[10]));
	add_info("Event Handlers Enabled",$nagios->yesno($statusinfo[11]));
	add_info("Last State Change",$nagios->datetime($statusinfo[12]));
	add_info("Problem Acknowledged",$nagios->yesno($statusinfo[13]));
	add_info("Last Hard State",$nagios->datetime($statusinfo[14]));
	add_info("Time OK",$nagios->duration($statusinfo[15]));
	add_info("Time Unknown",$nagios->duration($statusinfo[16]));
	add_info("Time Warning",$nagios->duration($statusinfo[17]));
	add_info("Time Critical",$nagios->duration($statusinfo[18]));
	add_info("Last Notification Time",$nagios->datetime($statusinfo[19]));
	add_info("Current Notification Number",$statusinfo[20]);
	add_info("Notifications Enabled",$nagios->yesno($statusinfo[21]));
	add_info("Latency",$statusinfo[22]);
	add_info("Execution Time",$statusinfo[23]);
	add_info("Flap Detection Enabled",$nagios->yesno($statusinfo[24]));
	add_info("Service Is Flapping",$nagios->yesno($statusinfo[25]));
	add_info("Percent State Change",$statusinfo[26]);
	add_info("Scheduled Downtime Depth",$statusinfo[27]);
	add_info("Failure Prediction Enabled",$nagios->yesno($statusinfo[28]));
	add_info("Process Performance Date",$nagios->yesno($statusinfo[29]));
	add_info("Obsess Over Service",$nagios->yesno($statusinfo[30]));

	$host_name = $statusinfo[1];
	$service_name = $statusinfo[2];
	$blacksmith->assign("host_name",$host_name);
	$blacksmith->assign("service_name",$service_name);
	
	$address = $nagios->$nagiosconfig->hosts[$host_name]['address'];
	$blacksmith->assign("address",$address);

	$info_array_flags = array();
	$info_array_flags['notifications_enabled'] = $statusinfo[21];
	$info_array_flags['active_checks_enabled'] = $statusinfo[9];
	$info_array_flags['passive_checks_enabled'] = $statusinfo[10];
	$info_array_flags['event_handler_enabled'] = $statusinfo[11];
	$info_array_flags['flap_detection_enabled'] = $statusinfo[24];

	$blacksmith->assign("host_name",$statusinfo[1]);
	$blacksmith->assign("service_name",$statusinfo[2]);
	$blacksmith->assign("info_array",$info_array);
	$blacksmith->assign("info_array_flags",$info_array_flags);
	$blacksmith->display("extinfo-svc.tpl");
}
else
// Process
{
	add_info("Program Start Time",$nagios->datetime($statusinfo[1]));
	add_info("Total Running Time",$nagios->duration(time() - $statusinfo[1]));
	add_info("Last External Command Check",$nagios->datetime($statusinfo[4]));
	add_info("Last Log File Rotation",$nagios->datetime($statusinfo[5]));
	add_info("Nagios PID",$statusinfo[2]);
	add_info("Notifications Enabled",$nagios->yesno($statusinfo[6]));
	add_info("Service Checks Executed",$nagios->yesno($statusinfo[7]));
	add_info("Passive Service Checks Accepted",$nagios->yesno($statusinfo[8]));
	add_info("Event Handlers Enabled",$nagios->yesno($statusinfo[9]));
	add_info("Obsess Over Services",$nagios->yesno($statusinfo[10]));
	add_info("Flap Detection Enabled",$nagios->yesno($statusinfo[11]));
	add_info("Performance Data Processed",$nagios->yesno($statusinfo[13]));

	$info_array_flags = array();	
	$info_array_flags['notifications_enabled'] = $statusinfo[6];
	$info_array_flags['exec_service_checks'] = $statusinfo[7];
	$info_array_flags['accept_passive_checks'] = $statusinfo[8];
	$info_array_flags['event_handlers'] = $statusinfo[9];
	$info_array_flags['obsess_over_svc'] = $statusinfo[10];
	$info_array_flags['flap_detection'] = $statusinfo[11];
	$info_array_flags['perf_data_proc'] = $statusinfo[13];
	
	$blacksmith->assign("info_array",$info_array);
	$blacksmith->assign("info_array_flags",$info_array_flags);
	$blacksmith->display("extinfo-proc.tpl");
}

$blacksmith->assign("comment_array",$comment_array);
$blacksmith->assign("delete_comment_type",$delete_comment_type);
$blacksmith->display("extinfo-comment.tpl");

$blacksmith->display("nagios-footer.tpl");

?>
