<?php

/*
 * Nagios PHP Interface Supplemental: graph.php
 * This script graphs an RRD database according to a recipe file.
 * 2004 Eldad Zack <eldadzack@gmail.com>
 *
 * TODO: Move debugs into smarty template (currently disabled)
 * TODO: Reduce dupe code between rrdrecipe and rrdrecipetpl

 LICENSE:

 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

if (!include "nagios.inc.php")
{
	exit("Nagios PHP script init error. (tac.php)");
}

#
# Scope (daily, weekly...)
#

$scope = $_GET['scope'];

if (preg_match("/^[wmyh]$/",$scope)) $start="-s -1".$scope." ";
else $scope = "d";

$scope_name = array ("h"=>"Hourly","d"=>"Daily","w"=>"Weekly","m"=>"Monthly","y"=>"Yearly");

#
# Debugging
#

if (isset($_GET['debug']))
{
	$_GET['cmdline'] = "";
	$_GET['output'] = "";
	$_GET['nolazy'] = "";
}

if (isset($_GET['altbg']))
{
	$altbg = 1;
}

$cmdline[OPTIONS] = " -l 0 -u 0 -a PNG --alt-autoscale-max ";
if (!isset($_GET['nolazy']))
{
	$cmdline[OPTIONS] .= " -z ";
}

$color[BACK]="#AAAAAA";
$color[SHADEA]=$color[BACK];
$color[SHADEB]=$color[BACK];
$color[ARROW]="#4040d0";

foreach ($color as $key => $value)
{
	$cmdline[COLORS].=" -c ".$key.$value." ";
}

$cmdline = $cmdline[OPTIONS].$cmdline[COLORS].$start;


$graph_array = array();
#$error_array = array();

#
# RRD Recipe
#

function rrdrecipe($recipe,$globalcmdline)
{
	global $blacksmith,$width,$height,$scope,$graph_array;

	$recipefile = $blacksmith->config['rrdrecipe'].$recipe;
	if (!is_readable($recipefile))
	{
		return false;
	}

	$graphbase = $recipe."_".$scope."_".$width."x".$height.".png";
	$graphurl = $blacksmith->config['rrdgraphurl'].$graphbase;
	$graphfile = $blacksmith->config['rrdgraphdir'].$graphbase;
	$cmdline = "rrdtool graph $graphfile $globalcmdline ";
	$cmdline = rrdrecipecmdline($recipefile,array(),$cmdline);

	$output = shell_exec("$cmdline 2>&1");

	if (is_readable($graphfile))
	{
		array_push($graph_array,$graphurl);
	}
	else
	{
		#array_push($error_array,"Failed to read graph ($graphurl)");		
		#print "<br><br><br>Failed to read graph.<br><a href=$url?recipe=$recipe&debug=1>Debug</a>";
		#print "<br>$graphurl<br>";
		#print "<br><br><br>";
	}

	if (isset($_GET['cmdline']))
	{
		#print("<div id=debug><br><b>Command Line</b><br>$cmdline<br></div>");
	}

	if (isset($_GET['output']))
	{
		#print "<div id=debug><br><b>Output</b><br>$output<br></div>";
	}

	if (!isset($_GET['refresh']))
	{
		#print "<a href=$url?recipe=$recipe&scope=$scope&refresh>[Auto Refresh]</a></font>";
	}

	return true;
}

function rrdrecipetpl($recipe,$globalcmdline,$keys)
{
	global $blacksmith,$width,$height,$scope,$graph_array;

	$recipefile = $blacksmith->config['rrdtemplate'].$recipe;
	if (!is_readable($recipefile))
	{
		return false;
	}

	$graphbase = $keys['name']."-".$recipe."_".$scope."_".$width."x".$height.".png";
	$graphurl = $blacksmith->config['rrdgraphurl'].$graphbase;
	$graphfile = $blacksmith->config['rrdgraphdir'].$graphbase;
	$cmdline = "rrdtool graph $graphfile $globalcmdline ";
	$cmdline = rrdrecipecmdline($recipefile,$keys,$cmdline);

	$output = shell_exec("$cmdline 2>&1");

	if (is_readable($graphfile))
	{
		array_push($graph_array,$graphurl);
	}
	else
	{
		#TODO: do_debug(...)
		#print "<br><br><br>Failed to read graph.<br><a href=$url?recipe=$recipe&debug>Debug</a>";
		#print "<br>$graphurl<br>";
		#print "<br><br><br>";
	}

	#TODO:move these to check_debug()?

	if (isset($_GET['cmdline']))
	{
		#print("<div id=debug><br><b>Command Line</b><br>$cmdline<br></div>");
	}

	if (isset($_GET['output']))
	{
		#print "<div id=debug><br><b>Output</b><br>$output<br></div>";
	}

	if (!isset($_GET['refresh']))
	{
		#print "<a href=$url?recipe=$recipe&scope=$scope&refresh>[Auto Refresh]</a></font>";
	}

	return true;
}

function rrdrecipecmdline($recipefile,$keys,$cmdline)
{
	global $blacksmith,$scope,$scope_name;

	$recipe = file ($recipefile);

	$i = 0;

	#
	# Recipefile Key:
	# # comment
	# & add unconditional commandline parameter
	# ! add statistics without graph : DS Name;Legend Description;
	# - DEF (no auto-graph) : rrdfile;DS;CF;Color;Legend Description;Style;DS Name;
	# : DS Source Only : ;;;Color;;Style;DS Name;
	# + CDEF : VName;RPN Expression;DS Source (Color, Style)
	# regular line: DEF (auto-graph): rrd file;DS;CF;Color;Legend Description;Style;
	#

	$dscfg = array();

	foreach ($recipe as $recipeline)
	{
		foreach (array_keys($keys) as $key)
		{
			$recipeline = preg_replace("/%".$key."%/",$keys[$key],$recipeline);
		}

		$recipeline = trim($recipeline);
		if (preg_match("/^&/",$recipeline))
		{
			$cmdline .= " ".ltrim($recipeline,"&")." ";
		}
		elseif (preg_match("/^\!/",$recipeline))
		{
			$recipeline = ltrim($recipeline,"!");
	
			$value = explode(";",$recipeline);
	
			$cdef = $value[0];

			$cmdline .= "COMMENT:'".$value[1]."' ";
			$cmdline .= "GPRINT:$cdef:MAX:'Max %1.2lf' ";
			$cmdline .= "GPRINT:$cdef:AVERAGE:'Average %1.2lf' ";
			$cmdline .= "GPRINT:$cdef:MIN:'Min %1.2lf' ";
			$cmdline .= "GPRINT:$cdef:LAST:'Current %1.2lf\l' ";
		}
		elseif (preg_match("/^-/",$recipeline))
		{
			$recipeline = ltrim($recipeline,"-");

			$value = explode(";",$recipeline);

			$cmdline .= " DEF:".$value[6]."=".$blacksmith->config['rrdpath'].$value[0].":".$value[1].":".$value[2]." ";

			$dscfg[$value[6]] = $recipeline;
		}
		elseif (preg_match("/^:/",$recipeline))
		{
			$recipeline = ltrim($recipeline,":");

			$value = explode(";",$recipeline);

			$dscfg[$value[6]] = $recipeline;
		}
		elseif (preg_match("/^\+/",$recipeline))
		{
			$recipeline = ltrim($recipeline,"+"); 

			$value = explode(";",$recipeline);

			$desc = $value[2];

			$cmdline .= " CDEF:".$value[0]."=".$value[1]." ";

			$dsvalue = explode(";",$dscfg[$value[3]]);

			$cmdline .= $dsvalue[5].":".$value[0].$dsvalue[3].":'".$desc."' ";
			$cmdline .= "GPRINT:".$value[0].":MAX:'Max %1.2lf%s' ";
			$cmdline .= "GPRINT:".$value[0].":AVERAGE:'Average %1.2lf%s' ";
			$cmdline .= "GPRINT:".$value[0].":MIN:'Min %1.2lf%s' ";
			$cmdline .= "GPRINT:".$value[0].":LAST:'Current %1.2lf%s\l' ";
		}
		elseif (preg_match("/^#Nolimit/",$recipeline,$match))
		{
			$cmdline = preg_replace("/ -l 0 /"," --alt-autoscale ",$cmdline);
		}
		elseif (preg_match("/^#Header: (.*)/",$recipeline,$match))
		{
			$header = $match[1];

			$date = date("D M d H:i:s Y T",time());

			$header = preg_replace("/%date%/",$date,$header);
			$header = preg_replace("/%scope%/",$scope_name[$scope],$header);
	
			$cmdline .= " -t '".$header."' ";
		}
		elseif (preg_match("/^[^# ]/",$recipeline))
		{
			$value = explode(";",$recipeline);

			$desc = $value[4];

			$cmdline .= " DEF:DS".$i."=".$blacksmith->config['rrdpath'].$value[0].":".$value[1].":".$value[2]." ";

			if ($i == 0 && $altbg == 1)
			{
				$cmdline .= " CDEF:DAYMARK=DS0,POP,TIME,7200,%,3600,LE,INF,UNKN,IF AREA:DAYMARK#DDDDDD ";
			}

			$cmdline .= $value[5].":DS".$i.$value[3].":'".$value[4]."' ";
			$cmdline .= "GPRINT:DS".$i.":MAX:'Max %1.2lf%s' ";
			$cmdline .= "GPRINT:DS".$i.":AVERAGE:'Average %1.2lf%s' ";
			$cmdline .= "GPRINT:DS".$i.":MIN:'Min %1.2lf%s' ";
			$cmdline .= "GPRINT:DS".$i.":LAST:'Current %1.2lf%s\l' ";
			$i++;
		}
	}

	return $cmdline;
}

#
# Get multirecipe
#

if (isset($_GET['recipetpl']))
{

	$width=660;
	$height=100;

	if (isset($_GET['width'])) $width=$_GET['width'];
	if (isset($_GET['height'])) $height=$_GET['height'];

	$cmdline .= " -w $width -h $height ";

	$blacksmith->assign("recipevar","recipetpl");
	$blacksmith->assign("recipe",$_GET['recipetpl']);

	$tplfile = $blacksmith->config['rrdmacro'].$_GET['recipetpl'];
	if (!is_readable($tplfile))
	{
		$nagios->print_error("recipe template $tplfile failed.");
	}

	$tpl = file($tplfile);
	$keys = array();

	foreach ($tpl as $tplline)
	{
		if (preg_match("/([^=]+)=(.*)/",$tplline,$match))
		{	
			$keys[$match[1]] = $match[2];
		}		
	}

	$recipes = explode(",",$keys['recipe']);

	foreach ($recipes as $recipe)
	{
		if (!rrdrecipetpl($recipe,$cmdline,$keys))
		{
			$nagios->print_error("recipe $recipe failed.");
		}
	}

}
elseif (isset($_GET['recipe']))
{
	$recipe = $_GET['recipe'];

	$width=660;
	$height=300;

	if (isset($_GET['width'])) $width=$_GET['width'];
	if (isset($_GET['height'])) $height=$_GET['height'];

	$cmdline .= " -w $width -h $height ";

	$blacksmith->assign("recipevar","recipe");
	$blacksmith->assign("recipe",$recipe);

	$recipes = explode(",",$_GET['recipe']);

	foreach ($recipes as $recipe)
	{
		if (!rrdrecipe($recipe,$cmdline))
		{
			$nagios->print_error("recipe $recipe failed.");
		}
	}
}
else
{
	$nagios->print_error("No recipes to process");
}

$title = "Graph View";

$nagios->print_header($title,$_GET['refresh']);

$url=$_SERVER['PHP_SELF'];
$blacksmith->assign("url",$url);
$blacksmith->assign("graph_array",$graph_array);
$blacksmith->display("graph.tpl");

$blacksmith->display("nagios-footer.tpl");

?>


