<?php
/* nagios.cfg.inc.php: Parse configuration file of Nagios
 *
 * This is an adapated excerpt from naupy (http://naupy.sourceforge.net/)
 * Copyright (C) <2003> Craig Small <csmall@small.dropbear.id.au>
 *
 * Adapted to nagios-php by Eldad Zack <eldadzack@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

class NagiosConfig {
	var $config;
	var $contactgroups;
	var $contacts;
	var $hostgroups;
	var $hosts;
	var $services;
	var $host_status;
	var $service_status;
	var $errormsg = "";
	
	function NagiosConfig()
	{
		$config = array();
		$contactgroups = array();
		$contacts = array();
		$hostgroups = array();
		$hosts = array();
		$services = array();
		$host_status = array();
		$service_status = array();
	}
	
	function ParseConfigFile($filename)
	{
		if ( ($fp = fopen($filename, 'r')) == FALSE) {
			$this->errormsg =  "Cannot open config file $filename";
			return FALSE;
		}
		while ($line = fgets($fp, 4096)) {
			  if (preg_match('/^\s*(|#.*)$/', $line)) {
				  continue;
			  }
			  if (preg_match('/^\s*cfg_file\s*=\s*(\S+)/', $line, $regs)) {
				if ($this->_ParseObjectFile($regs[1]) === FALSE) {
					return FALSE;
				}
				continue;
			  }
			  if (preg_match('/^\s*(\S+)\s*=\s*(\S+)/', $line, $regs)) {
				  $this->config[$regs[1]] = $regs[2];
				continue;
			  }
		}
	}

	function _ParseObjectFile($filename)
	{
		$scanstate = '';

		if ( ($fp = fopen($filename, 'r')) == FALSE) {
			$this->errormsg =  "Cannot open object file $filename";
			return FALSE;
		}
		while ($line = fgets($fp, 987)) {
			if (preg_match('/^\s*(|#.*)$/', $line)) {
				continue;
			}
			if (preg_match('/^\s*define\s+(\S+)\s*{\s*$/', $line, $regs)) {
				$scanstate = $regs[1];
				$tmpobject = array();
				continue;
			}
			if (preg_match('/\s*}/', $line)) {
				switch($scanstate) {
				case 'contactgroup':
					if (!empty($tmpobject['contactgroup_name'])) {
						$this->contactgroups[$tmpobject['contactgroup_name']] = $tmpobject;
					}
					break;
				case 'contact':
					if (!empty($tmpobject['contact_name'])) {
						$this->contacts[$tmpobject['contact_name']] = $tmpobject;
					}
					break;
				case 'host':
					if (!empty($tmpobject['host_name'])) {
						$this->hosts[$tmpobject['host_name']] = $tmpobject;
					}
					if (!empty($tmpobject['name'])) {
						$this->hosts[$tmpobject['name']] = $tmpobject;
					}
					break;
				case 'hostgroup':
					if (!empty($tmpobject['hostgroup_name'])) {
						$this->hostgroups[$tmpobject['hostgroup_name']] = $tmpobject;
					}
					break;
				case 'service':
					if (!empty($tmpobject['name'])) {
						$this->services[$tmpobject['name']] = $tmpobject;
					}
					break;
				}
				$scanstate = '';
				continue;
			}
			if (preg_match('/\s*(\S+)\s+(\S+)/', $line, $regs)) {
				if ($regs[1] == 'use')
				{
					$registered = isset($tmpobject['register']);
					switch ($scanstate) {
					case 'host':
						$tmpobject = array_merge($this->hosts[$regs[2]],$tmpobject);
						break;
					case 'hostgroup':
						$tmpobject = array_merge($this->hostgroups[$regs[2]],$tmpobject);
						break;
					case 'hostgroup':
						$tmpobject = array_merge($this->services[$regs[2]],$tmpobject);
						break;
					}
					if (!$registered) {
						unset($tmpobject['register']);
					}
				}
				else
				{
					$tmpobject[$regs[1]] = $regs[2];
				}
				continue;
			}
		} 
	}
} 
?>
