<?php

/*
 * Nagios PHP Interface: nagios.inc.php
 * 2003-2004 Eldad Zack <eldadzack@gmail.com>
 *
 * TODO: add various functionallity currently in status.php for reusability
 * TODO: parse nagios 2.x status files

 LICENSE:

 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

# Blacksmith Framework handles the PHP session management and authentication and wraps around smarty.

require_once("blacksmith.inc.php");

# NagiosConfig (adapated from naupy)

require_once("nagios.cfg.inc.php");

# Hardcoded Configuration

$nagios_php_config_file = "%config_dir%/nagios-php.cfg";

# Class definition

class Nagios 
{
	var $config;

	var $statusfile;
	var $logfile;
	var $logarchive;

	var $username;
	var $passfile;
	
	var $nagiosconfig;

	function Nagios($config_file)
	{
		if (!is_readable($config_file))
		{
			$this->print_error("Configuration file not found.");
		}		

		$config	= file ($config_file);

		# defaults
		$this->config['refresh_rate'] = 90;
		$this->config['web_date_format'] = "d/m/Y H:i:s";
		
		foreach ($config as $line)
		{
			if (preg_match("/^#|^$|^ *$/",$line))
			{
				continue;
			}

			preg_match("/^([A-Za-z_]*) *= *(.*) */",$line,$match);

			$this->config[$match[1]]=$match[2];
		}

		$this->read_main_config();
		
		$this->$nagiosconfig = new NagiosConfig;
		$this->config_cache_refresh();
		#$this->config_cache_read();
	}
	
	function config_cache_refresh()
	{
		$this->$nagiosconfig->ParseConfigFile($this->config['main_config_file']);
		file_put_contents($this->config['config_cache_file'],serialize($this->$nagiosconfig));
	}
	
	function config_cache_read()
	{
		$nagiosconfig = unserialize(file_get_contents($this->config['config_cache_file']));
	}
	
	function read_main_config()
	{
		$config = file ($this->config['main_config_file']);

		foreach ($config as $line)
		{
			if (preg_match("/^log_file *= *(.*) */",$line,$match))
			{
				$this->logfile = $match[1];
			}
			elseif (preg_match("/^log_archive_path *= *(.*) */",$line,$match))
			{
				$this->logarchive = $match[1];
			}
			elseif (preg_match("/^status_file *= *(.*) */",$line,$match))
			{
				$this->statusfile = $match[1];
			}
			
			preg_match("/^([A-Za-z_]*) *= *(.*) */",$line,$match);
			$this->config[$match[1]]=$match[2];
		}
	}

	function print_header($title,$refresh)
	{
		global $blacksmith;

		$blacksmith->assign("title",$title);
		$blacksmith->assign("stylesheet_url",$this->config['stylesheet_url']);
		$blacksmith->assign("refresh",$refresh);
		$blacksmith->assign("refresh_rate",$this->config['refresh_rate']);
		$blacksmith->display("nagios-header.tpl");
	}

	function print_error($error)
	{
		global $blacksmith;
		$blacksmith->assign("errmsg",$error);
		$blacksmith->display("error.tpl");
		exit();
	}
	
	function duration($duration_v)
	{
		$duration = (($duration_v % 60)."s");
		$duration_v /= 60;
		$duration = ((int)($duration_v % 60)."m ".$duration);
		$duration_v /= 60;
		$duration = ((int)($duration_v % 24)."h ".$duration);
		$duration_v /= 24;
		$duration = ((int)$duration_v."d ".$duration);

		return $duration;
	}

	function datetime($timestamp)
	{
		if ($timestamp ==0) return "Never";
		else return date($this->config['web_date_format'],$timestamp);
	}

	function yesno($val)
	{
		if ($val) return "Yes";
		else return "No";
	}

	function escape_preg($string)
	{
		# escapes \$() 
		$string = preg_replace("/([\/\&\(\)])/","\\\\$1",$string);
		return $string;
	}
}

#
# Startup
#

$nagios = new Nagios($nagios_php_config_file);
unset($nagios_php_config_file);

if (!is_readable($nagios->statusfile))
{
	$nagios->print_error("Status file is not available.<br>");
	# Nagios is either not running or is configured incorrectly.
}

$nagios->username = $blacksmith->username;

?>
