#!/usr/bin/perl -w
#
# check_snmptraps.pl - nagios plugin
#
#
# Copyright (C) 2007 Michael Luebben
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
# ==================== Database connect information ====================
my $dbHost = "localhost";
my $dbName = "snmptt_new";
my $dbUser = "root";
my $dbPass = "";
my $dbTable = "snmptt";

# ==================== Variables ====================
my ($opt_V, $opt_h, $opt_C, $opt_H, $opt_O, $opt_t, $opt_r, $opt_m, $opt_w, $opt_c);
my $PROGNAME = "check_snmptraps.pl";
my $version = "1.0 beta1";
my $queryCategory = "";
my $queryTrapOid = "";
my $queryTrapRead = "";
my $dbQuery;
my @resultWarning;
my @resultCritical;
my $lastWarningTrapMessage;
my $lastCriticalTrapMessage;
my $countWarning = "0";
my $countCritical = "0";
my $outputWarning;
my $outputCritical;
my $exitCode;

# ==================== Load Perl modules ====================
use strict;
use Getopt::Long;
use vars qw($PROGNAME);
use lib "./"; # Pfad zur util.pm !!
use utils qw($TIMEOUT %ERRORS &print_revision &support);
use DBI();

# ==================== Functions ====================
# Print Usage
sub print_usage (){
   printf "\nUsage:\n";
   printf "   -H (--hostname)\n";
   printf "	Hostname to query - (required)\n";
   printf "   -C (--category)\n";
   printf "	Category from SNMP-Trap (optional)\n";
   printf "   -O (--oid)\n";
   printf "  	OID from SNMP-Trap (optional)\n";
   printf "   -w (--warning)\n";
   printf "	Check for warning traps in the database\n";
   printf "   -c (--critical)\n";
   printf "	Check for critical traps in the database\n";
   printf "      (Default is set the option -w and -c)\n";
   printf "   -r (--read)\n";
   printf "	Read marked traps from database too.\n";
   printf "   -m (--message)\n";
   printf "	Print Message from last read trap from database.\n";
   printf "	This option can only used with -w or -c!\n";
   printf "   -t (--timeout)\n";
   printf "     seconds before the plugin times out (default=$TIMEOUT)\n";
   printf "   -V (--version)\n";
   printf "     Plugin version\n";
   printf "   -h (--help)\n";
   printf "     Print this help \n";
}

# Print help
sub print_help () {
   printf "Copyright (c) 2007 Michael Luebben\n\n";
   printf "check_snmptraps.pl plugin for Nagios monitors snmptraps \n";
   printf "in the database for a target host\n";
   print_usage();
   printf "\n";
   print_revision($PROGNAME, '$Revision: 1.0 alpha $');
}

# ==================== Get options ====================
Getopt::Long::Configure('bundling');
GetOptions(
   "H=s" => \$opt_H, "hostname"	=> \$opt_H,
   "C=s" => \$opt_C, "category"	=> \$opt_C,
   "O=s" => \$opt_O, "oid"	=> \$opt_O,
   "w"   => \$opt_w, "warning"  => \$opt_w,
   "c" 	 => \$opt_c, "critical" => \$opt_c,
   "r"   => \$opt_r, "read"	=> \$opt_r,
   "m"   => \$opt_m, "message"  => \$opt_m,
   "t=i" => \$opt_t, "timeout"  => \$opt_t,
   "V"   => \$opt_V, "version"  => \$opt_V,
   "h"   => \$opt_h, "help"     => \$opt_h);

# ==================== Main ====================
if ($opt_t) {
   $TIMEOUT=$opt_t;
}
 
# Just in case of problems, let's not hang Nagios
$SIG{'ALRM'} = sub {
   print "UNKNOWN - Plugin Timed out\n";
   exit $ERRORS{"UNKNOWN"};
};
alarm($TIMEOUT);

if ($opt_V) {
   printf "$PROGNAME Version $version\n";
   exit $ERRORS{'OK'};
}
 
if ($opt_h) {
   print_help();
   exit $ERRORS{'OK'};
}
 
if (! $opt_H) {
   print "No Hostname specified\n\n";
   print_usage();
   exit $ERRORS{'UNKNOWN'};
}

# Create query's for set options
if ($opt_C) {
   $queryCategory = "AND category='$opt_C'";
}

if ($opt_O) {
   $queryTrapOid = "AND trapoid='$opt_O'";
}

if ($opt_r) {
   $queryTrapRead = "";
} else {
   $queryTrapRead = "AND trapread='0'";
}

# Set -w and -c as default
if (!$opt_w && !$opt_c){
   $opt_w = "1";
   $opt_c = "1";
}

# Connect to the database.
my $dbConnect = DBI->connect("DBI:mysql:database=$dbName;host=$dbHost","$dbUser","$dbPass") ||
   die "ERROR - Can't connect to MySQL-Database: ".$DBI::errstr."\n";

# Read warning-Traps from database
if ($opt_w) {
   $dbQuery = $dbConnect->prepare("SELECT formatline FROM $dbTable WHERE hostname='$opt_H' AND severity='WARNING' $queryCategory $queryTrapOid $queryTrapRead");
   $dbQuery->execute();
   while (@resultWarning = $dbQuery->fetchrow_array) {
      $countWarning++;
      $lastWarningTrapMessage = $resultWarning['0'];
   }
}

# Read critical-Traps from database
if ($opt_c) {
   $dbQuery = $dbConnect->prepare("SELECT formatline FROM $dbTable WHERE hostname='$opt_H' AND severity='CRITICAL' $queryCategory $queryTrapOid $queryTrapRead");
   $dbQuery->execute();
   while (@resultCritical = $dbQuery->fetchrow_array) {
      $countCritical++;
      $lastCriticalTrapMessage = $resultCritical['0'];
   }
}

# Close connection to database
$dbConnect->disconnect;

# Create Output
if ($opt_w && $opt_c) {
   $exitCode = $ERRORS{'OK'};   
   if ($countWarning == "0") {
      $outputWarning = "No warning Traps";
   } elsif ($countWarning == "1") {
      $outputWarning = "$countWarning warning Trap";
      $exitCode = $ERRORS{'WARNING'};  
   } else {
      $outputWarning = "$countWarning warning Traps";
      $exitCode = $ERRORS{'WARNING'};
   }

   if ($countCritical == "0") {
      $outputCritical = "and no critical traps in the database";
   } elsif ($countCritical == "1") {
      $outputCritical = "and $countCritical critical Trap in the database";
      $exitCode = $ERRORS{'CRITICAL'};
   } else {
      $outputCritical = "and $countCritical critical Traps in the database";
      $exitCode = $ERRORS{'CRITICAL'};
   }

   if($exitCode == $ERRORS{'OK'}) {
      printf "OK - $outputWarning $outputCritical|'warning trap'=$countWarning;;;; 'critical trap'=$countCritical;;;;\n";
   }
   if($exitCode == $ERRORS{'WARNING'}) {
      printf "WARNING - $outputWarning $outputCritical|'warning trap'=$countWarning;;;; 'critical trap'=$countCritical;;;;\n";
   }
   if($exitCode == $ERRORS{'CRITICAL'}) {
      printf "CRITICAL - $outputWarning $outputCritical|'warning trap'=$countWarning;;;; 'critical trap'=$countCritical;;;;\n";
   }
   exit $exitCode;
}

if ($opt_w) {
   if ($countWarning == "0") {
      $outputWarning = "No warning Traps in the database";
      $exitCode = $ERRORS{'OK'};   
   } elsif ($countWarning == "1") {
      $outputWarning = "$countWarning warning Trap";
      $exitCode = $ERRORS{'WARNING'};   
   } else {
      $outputWarning = "$countWarning warning Traps";
      $exitCode = $ERRORS{'WARNING'};   
   }
   if ($opt_m) {
      if ($countWarning != "0") {
         $outputWarning .= ": $lastWarningTrapMessage";
         $exitCode = $ERRORS{'WARNING'};   
      } else {
         $exitCode = $ERRORS{'OK'};   
      }
   }

   if($exitCode == $ERRORS{'OK'}) {
      printf "OK - $outputWarning|'warning trap='$countWarning;;;;\n";
   }
   if($exitCode == $ERRORS{'WARNING'}) {
      printf "WARNING - $outputWarning|'warning trap='$countWarning;;;;\n";
   }
   exit $exitCode;
}

if ($opt_c) {
   if ($countCritical == "0") {
      $outputCritical = "No critical Traps in the database";
      $exitCode = $ERRORS{'OK'};
   } elsif ($countCritical == "1") {
      $outputCritical = "$countCritical critical Trap";
      $exitCode = $ERRORS{'CRITICAL'};
   } else {
      $outputCritical = "$countCritical critical Traps";
      $exitCode = $ERRORS{'CRITICAL'};
   }
   if ($opt_m) {
      if ($countCritical != "0") {
         $outputCritical .= ": $lastCriticalTrapMessage";
         $exitCode = $ERRORS{'CRITICAL'};
      } else {
         $exitCode = $ERRORS{'OK'};
      }
   }

   if($exitCode == $ERRORS{'OK'}) {
      printf "OK - $outputCritical|'critical trap='$countCritical;;;;\n";
   }
   if($exitCode == $ERRORS{'CRITICAL'}) {
      printf "CRITICAL - $outputCritical|'critical trap='$countCritical;;;;\n";
   }
   exit $exitCode;
}
