<?
#########################################################
#              SNMPTraps-Frontend for Nagios            #
#                                                       #
#                    by Michael Lbben                  #
#                   --- Lizenz GPL ---                  #
#########################################################

/**
* This Class creates the Web-Frontend for the SNMP-Trap Frontend
*/

class frontend {
  	var $site;
	
	/**
	* Constructor
	*
	* @param config $configINI
	*
	* @author Michael Luebben <michael_luebben@web.de>
	*/  
    function frontend(&$configINI) {
		$this->configINI = &$configINI;
	}

	// ==================================== Functions to create the page ====================================
	
	/**
	* Open a Web-Site in a Array site[].
	*
	* @author Michael Luebben <michael_luebben@web.de>
    */
	function openSite() {
		$this->site[] = '<HTML>';
		$this->site[] = '<HEAD>';
		$this->site[] = '<META HTTP-EQUIV="Content-Type" CONTENT="text/html; CHARSET=UTF-8"/>';
		$this->site[] = '<TITLE>'.$this->configINI['internal']['title'].' '.$this->configINI['internal']['version'].'</TITLE>';
		$this->site[] = '<SCRIPT TYPE="text/javascript" SRC="./include/js/nagtrap.js"></SCRIPT>';
		$this->site[] = '<SCRIPT TYPE="text/javascript" SRC="./include/js/overlib.js"></SCRIPT>';
		$this->site[] = '</HEAD>';
		$this->site[] = '<LINK HREF="'.$this->configINI['nagios']['prefix'].'/snmptraps/include/css/nagtrap.css" REL="stylesheet" TYPE="text/css">';
		$this->site[] = '<LINK HREF="'.$this->configINI['nagios']['prefix'].'/stylesheets/status.css" REL="stylesheet" TYPE="text/css">';
		$this->site[] = '<LINK HREF="'.$this->configINI['nagios']['prefix'].'/stylesheets/showlog.css" REL="stylesheet" TYPE="text/css">';
		$this->site[] = '<LINK HREF="'.$this->configINI['nagios']['prefix'].'/stylesheets/common.css" REL="stylesheet" TYPE="text/css">';
		$this->site[] = '<BODY CLASS="status">';
	}
	
	/**
	* Closed a Web-Site in the Array site[]
	*
	* @author Michael Luebben <michael_luebben@web.de>
    */
	function closeSite() {
		$this->site[] = '</BODY>';
		$this->site[] = '</HTML>';
	}
	
	/**
	* Create a Web-Side from the Array site[].
	*
	* @author Michael Luebben <michael_luebben@web.de>
	*/
	function printSite() {
		foreach ($this->site as $row) {
			echo $row."\n";
		}
	}
	
	// ======================= Contructor and functions for the header of the frontend ======================
	
	/**
	* Constructor for the header
	*
	* @author Michael Luebben <michael_luebben@web.de>
	*/
	function constructorHeader() {
	    global $table;
		$this->site[] = '<TABLE BORDER="0" WIDTH="100%" CELLPADDING="0" CELLSPACING="0">';
		$this->site[] = '   <TR>';
		$this->site[] = '      <TD ALIGN="left" VALIGN="top" WIDTH="33%">';
		$this->createInfoBox();
		$this->site[] = '         <BR>';
		$this->createFilter();
		$this->site[] = '      </TD>';
		$this->site[] = '      <TD ALIGN="center" VALIGN="top" WIDTH="33%">';
		$this->createNavBox();
		$this->site[] = '         <BR>';
		$this->createDBInfo($table);
		$this->site[] = '      </TD>';
		$this->site[] = '      <TD ALIGN="right" VALIGN="top" WIDTH="33%">';
		$this->createOptBox();
		$this->site[] = '      </TD>';
		$this->site[] = '   </TR>';
		$this->site[] = '</TABLE>';
		$this->site[] = '<BR><BR>';
	}
	
	/**
	* Create a Info-Box
	*
	* @author Michael Luebben <michael_luebben@web.de>
	*/
	function createInfoBox() {
	    global $languageXML;
		$this->site[] = '         <TABLE CLASS="infoBox" BORDER="1" CELLPADDING="0" CELLSPACING="0">';
		$this->site[] = '            <TR>';
        $this->site[] = '               <TD CLASS="infoBox">';
        $this->site[] = '                  <DIV CLASS="infoBoxTitle">'.$languageXML['LANG']['HEADER']['INFOBOX']['CURRENTTRAPLOG'].'</DIV>';
        $trapInfo = common::readTrapInfo();
        // FIXME: View function.php --> Class common!
        $this->site[] = '                  '.$languageXML['LANG']['HEADER']['INFOBOX']['LASTUPDATE'].': '.$trapInfo['last'].'<BR>';
        $this->site[] = '                  Nagios&reg; - <A HREF="http://www.nagios.org" TARGET="_new" CLASS="homepageURL">www.nagios.org</A><BR>';
        $this->site[] = '                  NagTrap&copy; by Michael L&#252;bben<BR>';
        $this->site[] = '                  '.$languageXML['LANG']['HEADER']['INFOBOX']['LOGGEDINAS'].' <I>'.$_SERVER['PHP_AUTH_USER'].'</I><BR>';
        $this->site[] = '               </TD>';
        $this->site[] = '            </TR>';
		$this->site[] = '         </TABLE>';
	}
	
	/**
	* Create a Filter-Box
	*
	* @author Michael Luebben <michael_luebben@web.de>
	*/
	function createFilter() {
	  	global $hostname, $languageXML, $configINI;
		$this->site[] = '         <TABLE BORDER="1" CLASS="filter" CELLSPACING="0" CELLPADDING="0">';
		$this->site[] = '            <TR>';
        $this->site[] = '               <TD CLASS="filter">';
        $this->site[] = '                  <TABLE BORDER="0" CELLSPACING="2" CELLPADDING="0">';
        $this->site[] = '                     <TR>';
        $this->site[] = '                        <TD COLSPAN="2" VALIGN="top" ALIGN="left" CLASS="filterTitle">'.$languageXML['LANG']['HEADER']['FILTER']['DISPLAYFILTERS'].':</TD>';
        $this->site[] = '                        <TD></TD>';
        $this->site[] = '                     </TR>';
        $this->site[] = '                     <TR>';
        $this->site[] = '                        <TD VALIGN="top" ALIGN="left" CLASS="filterName">'.$languageXML['LANG']['HEADER']['FILTER']['HOST'].':</TD>';
        $this->site[] = '                        <TD VALIGN="top" ALIGN="left" CLASS="filterName">';
		$this->site[] = '                            '.common::checkRequest($_REQUEST['hostname']);
		$this->site[] = '                        </TD>';
        $this->site[] = '                     </TR>';
        $this->site[] = '                     <TR>';
        $this->site[] = '                        <TD VALIGN="top" ALIGN="left" CLASS="filterName">'.$languageXML['LANG']['HEADER']['FILTER']['SEVERITYLEVEL'].':</TD>';
        $this->site[] = '                        <TD VALIGN="top" ALIGN="left" CLASS="filterName">';
        $this->site[] = '                            '.common::checkRequest($_REQUEST['severity']);
        $this->site[] = '                        </TD>';
        $this->site[] = '                     </TR>';
        $this->site[] = '                     <TR>';
        $this->site[] = '                            '.common::createCategoryEntry();
        $this->site[] = '                     <TR COLSPAN="2">';
        $this->site[] = '                        <TD COLSPAN="2" VALIGN="top" ALIGN="center" CLASS="filterName"><A HREF="./index.php"><B></I>'.$languageXML['LANG']['HEADER']['FILTER']['RESET'].'</I></B></A></TD>';
		$this->site[] = '                     </TR>';
        $this->site[] = '                  </TABLE>';
        $this->site[] = '               </TD>';
        $this->site[] = '            </TR>';
		$this->site[] = '         </TABLE>';
	}  
	
	/**
	* Create a Navigation-Box
	*
	* @author Michael Luebben <michael_luebben@web.de>
	*/
	function createNavBox() {
	    global $languageXML;
        $this->site[] = '         <TABLE CLASS="navBox" BORDER="0" CELLSPACING="0" CELLPADDING="0">';
        $this->site[] = '            <TR>';
        $this->site[] = '               <TD ALIGN="center" VALIGN="center" CLASS="navBoxItem">';
        $this->site[] = '                  <IMG SRC="'.$this->configINI['nagios']['images'].'empty.gif" BORDER="0" WIDTH="75" HEIGHT="1">';
        $this->site[] = '               </TD>';
        $this->site[] = '               <TD WIDTH=15></TD>';     
        $this->site[] = '               <TD ALIGN="center" CLASS="navBoxDate">';
        $this->site[] = '                  <DIV CLASS="navBoxTitle">'.$languageXML['LANG']['HEADER']['NAVBOX']['LOGFILENAV']['LINE1'].'<BR>'.$languageXML['LANG']['HEADER']['NAVBOX']['LOGFILENAV']['LINE2'].'</DIV><BR>';
        $trapInfo = common::readTrapInfo();
        $this->site[] = '                     '.$trapInfo['first'];
        $this->site[] = '                  <BR>'.$languageXML['LANG']['HEADER']['NAVBOX']['TO'].'<BR>';
        $this->site[] = '                     '.$trapInfo['last'];
        $this->site[] = '               </TD>';
        $this->site[] = '               <TD WIDTH=15></TD>';
        $this->site[] = '               <TD>';
        $this->site[] = '                  <IMG SRC="'.$this->configINI['nagios']['images'].'empty.gif" BORDER="0" WIDTH="75" HEIGHT="1">';
        $this->site[] = '               </TD>';
        $this->site[] = '            </TR>';
        $this->site[] = '         </TABLE>';
	}
	
	/**
	* Create a Database-Information for the Nagigation
	*
	* @author Michael Luebben <michael_luebben@web.de>
	*/
	function createDBInfo($table) {
	    global $languageXML;
	    $this->site[] = '         <DIV CLASS="navBoxFile">';
		$this->site[] = '            '.$languageXML['LANG']['HEADER']['DBINFO']['DATABASE'].': '.$this->configINI['database']['name'].' '.$languageXML['LANG']['HEADER']['DBINFO']['TABLE'].': '.$table['name'];
		$this->site[] = '         </DIV>';
	}
	  
	/**
	* Create a Box for Options
	*
	* @author Michael Luebben <michael_luebben@web.de>
	*/
	function createOptBox() {
	    global $languageXML;
        $this->site[] = '         <TABLE BORDER="0" CLASS="optBox">';
        $this->site[] = '            <FORM METHOD="get" ACTION="./index.php">';
        $this->site[] = '               <TR>';
        $this->site[] = '                  <TD ALIGN="left" COLSPAN="2" CLASS="optBoxItem">'.$languageXML['LANG']['HEADER']['OPTBOX']['SELECTTRAP'].':</TD>';
        $this->site[] = '               </TR>';
        $this->site[] = '               <TR>';
        $this->site[] = '                  <TD ALIGN="left" COLSPAN="2" class="optBoxItem">';
        $this->site[] = '                     <SELECT NAME="trapSelect">';
        $this->site[] = '                        <OPTION VALUE="all" '.common::selected("all",$_REQUEST['trapSelect'],"selected").' >'.$languageXML['LANG']['HEADER']['OPTBOX']['SELECTTRAPVALUE']['TRAPACTUEL'].'</OPTION>';
        $this->site[] = '                        <OPTION VALUE="ARCHIVED" '.common::selected("ARCHIVED",$_REQUEST['trapSelect'],"selected").' >'.$languageXML['LANG']['HEADER']['OPTBOX']['SELECTTRAPVALUE']['TRAPARCHIVED'].'</OPTION>';
        $this->site[] = common::checkIfEnableUnknownTraps($this->configINI['global']['useUnknownTraps']);
        $this->site[] = '                     </SELECT>';
        $this->site[] = '                  </TD>';
        $this->site[] = '               </TR>';
        
        $this->site[] = '               <TR>';
        $this->site[] = '                  <TD ALIGN="left" COLSPAN="2" CLASS="optBoxItem">'.$languageXML['LANG']['HEADER']['OPTBOX']['SEVERITYDETAIL'].':</TD>';
        $this->site[] = '               </TR>';
        $this->site[] = '               <TR>';
        $this->site[] = '                  <TD ALIGN="left" COLSPAN="2" class="optBoxItem">';
        $this->site[] = '                     <SELECT NAME="severity">';
        $this->site[] = '                        <OPTION VALUE="" '.common::selected("",$_REQUEST['severity'],"selected").' >'.$languageXML['LANG']['HEADER']['OPTBOX']['OPTION']['VALUEALL'].'</OPTION>';
        $this->site[] = '                        <OPTION VALUE="OK" '.common::selected("OK",$_REQUEST['severity'],"selected").' >Traps ok</OPTION>';
        $this->site[] = '                        <OPTION VALUE="WARNING" '.common::selected("WARNING",$_REQUEST['severity'],"selected").' >Traps warning</OPTION>';
        $this->site[] = '                        <OPTION VALUE="CRITICAL" '.common::selected("CRITICAL",$_REQUEST['severity'],"selected").' >Traps critical</OPTION>';
        $this->site[] = '                     </SELECT>';
        $this->site[] = '                  </TD>';
        $this->site[] = '               </TR>';
        
        $this->site[] = common::createCategoryFilter();
		$this->site[] = '               <TR>';
		$this->site[] = '                  <TD ALIGN="left" CLASS="optBoxItem">'.$languageXML['LANG']['HEADER']['OPTBOX']['OLDERENTRIESFIRST'].':</TD>';
		$this->site[] = '                  <TD></TD>';
		$this->site[] = '               </TR>';
		$this->site[] = '               <TR>';
        $this->site[] = '                  <TD ALIGN="left" VALIGN="bottom" CLASS="optBoxItem"><INPUT TYPE="checkbox" name="oldestfirst" '.common::selected("on",$_REQUEST['oldestfirst'],"checked").' ></TD>';
        $this->site[] = '                  <TD ALIGN="right" CLASS="optBoxItem"><INPUT TYPE="submit" VALUE="'.$languageXML['LANG']['HEADER']['OPTBOX']['UPDATEBUTTON'].'"></TD>';
        $this->site[] = '                  <INPUT TYPE="hidden" NAME="hostname" VALUE="'.$_GET['hostname'].'">';
        $this->site[] = '               </TR>';
        $this->site[] = '            </FORM>';
        $this->site[] = '         </TABLE>';
	}
	
	/**
	* Create a error-message
	*
	* @param string $error
	*
	* @author Michael Luebben <michael_luebben@web.de>
	*/ 
	function printError($error,$systemError) {
	   global $errorXML;
	   $this->site[] = '<HR>';
	   $this->site[] = '   <DIV CLASS="errorMessage">'.$errorXML['ERROR'][$error]['MESSAGE'].'</DIV>';
	   common::printErrorLines($errorXML['ERROR'][$error]['DESCRIPTION'],$systemError);
	   $this->site[] = '</HR>';
	}
	
	// ======================== Contructor and functions for the main of the frontend =======================
	
	/**
	* Constructor for the main
	*
	* @author Michael Luebben <michael_luebben@web.de>
	*/
	function constructorMain() {
	   global $languageXML, $traps, $hostname;
	   // Check database connection and read traps from database
	   $traps = common::readTraps();
	   $this->site[] = '<TABLE WIDTH="100%" BORDER="0">';
	   $this->site[] = '   <TR>';
	   $this->site[] = '      <TH CLASS="status" WIDTH="30px">'.$languageXML['LANG']['MAIN']['TRAPTABLEHEADER']['OPTION'].'</TH>';
       $this->site[] = '      <TH CLASS="status">'.$languageXML['LANG']['MAIN']['TRAPTABLEHEADER']['TRAPTIME'].'</TH>';
       $this->site[] = '      <TH CLASS="status" WIDTH="30px">'.$languageXML['LANG']['MAIN']['TRAPTABLEHEADER']['TRAPOID'].'</TH>';
       $this->site[] = '      <TH CLASS="status">'.$languageXML['LANG']['MAIN']['TRAPTABLEHEADER']['HOST'].'</TH>';
       common::showTrapFields("field",NULL,NULL,NULL);
       $this->site[] = '      <TH CLASS="status">'.$languageXML['LANG']['MAIN']['TRAPTABLEHEADER']['MESSAGE'].'</TH>';
	   $this->site[] = '   </TR>';
	   $this->site[] = '   <FORM NAME="form1" ACTION="index.php?severity='.$_REQUEST['severity'].'&category='.$_REQUEST['category'].'&hostname='.$_REQUEST['hostname'].'" METHOD="POST">';
	   common::createTrapPage($traps);
	   $this->site[] = '</TABLE>';
	}
	
	/**
	* Create a Java Infobox
	*
	* @author Michael Luebben <michael_luebben@web.de>
	*/ 
	function javaInfoBox($formatline) {
	   $infoBox = 'onmouseover="return overlib(\'';
	   $infoBox .= $formatline;
	   $infoBox .= '\', CAPTION, \'Trap-Message\', VAUTO);" onmouseout="return nd();" ';
	   return($infoBox);
	}
	
    /**
	* Show traps
	*
	* @author Michael Luebben <michael_luebben@web.de>
	*/ 
	function showTrap($trap,$rowColor,$styleLine) {
	   global $configINI, $languageXML, $hostname;
	   $this->site[] = '   <TR>';
	   // Checkbox
	   $this->site[] = '      <TD "CLASS="'.$rowColor.'"><INPUT TYPE="checkbox" NAME="trapIDs[]" VALUE="'.$trap['id'].'" '.$_GET['sel'].'>';
	   // Mark a trap
	   common::showTrapMenuIcons("mark",$trap['id'],$_REQUEST['severity'],$hostname);
	   // Delete a trap
	   common::showTrapMenuIcons("delete",$trap['id'],$_REQUEST['severity'],$hostname);
	   // Archive a trap
	   common::showTrapMenuIcons("archive",$trap['id'],$_REQUEST['severity'],$hostname);
	   $this->site[] = '      <TD CLASS="'.$rowColor.'"><P '.$styleLine.'>'.$trap['traptime'].'</P></TD>';
	   $this->site[] = '      <TD CLASS="'.$rowColor.'"><P '.$styleLine.'>'.$trap['trapoid'].'</P></TD>';
	   // Select host
	   $this->site[] = '      <TD CLASS="'.$rowColor.'"><A HREF="./index.php?severity='.$_REQUEST['severity'].'&category='.rawurlencode($_REQUEST['category']).'&hostname='.$trap['hostname'].'"><P '.$styleLine.'>'.$trap['hostname'].'</P></A></TD>';
	   common::showTrapFields("entry",$trap,$rowColor,$styleLine);
	   $this->site[] = '      <TD CLASS="'.$rowColor.'"><P '.$styleLine.' '.$this->javaInfoBox($trap['orgFormatline']).'CLASS="formatline">'.htmlentities($trap['formatline']).'</P></TD>';
	   $this->site[] = '   </TR>';
	}
	
	// ======================= Contructor and functions for the footer of the frontend ====================== 
	
	/**
	* Constructor for the main
	*
	* @author Michael Luebben <michael_luebben@web.de>
	*/
	function constructorFooter() {
	   global $configINI, $languageXML, $hostname, $table;
	   $this->site[] = '<TABLE WIDTH="100%" BORDER="0">';
	   $this->site[] = '   <TR>';
	   $this->site[] = '      <TD CLASS="linkBox">';
	   $this->site[] = '         <IMG SRC="'.$configINI['global']['images'].$configINI['global']['iconStyle'].'/arrow.png" BORDER="0">';
	   $this->site[] = '         <INPUT TYPE="checkbox" NAME="checkbox" VALUE="checkbox" onClick="checkAll(\'yes\'); return true;">(Mark all)';
	   common::showTrapMenuIconFooter("mark");
	   common::showTrapMenuIconFooter("delete");
	   common::showTrapMenuIconFooter("archive");
	   $this->site[] = '         <INPUT TYPE="hidden" NAME="oldestfirst" VALUE="'.$_REQUEST['oldestfirst'].'">';
	   $this->site[] = '         <INPUT TYPE="hidden" NAME="severity" VALUE="'.$_REQUEST['severity'].'">';
	   $this->site[] = '         <INPUT TYPE="hidden" NAME="category" VALUE="'.$_REQUEST['category'].'">';
	   $this->site[] = '         <INPUT TYPE="hidden" NAME="hostname" VALUE="'.$_REQUEST['hostname'].'">';
	   $this->site[] = '         <INPUT TYPE="hidden" NAME="trapSelect" VALUE="'.$_REQUEST['trapSelect'].'">';
	   $this->site[] = '      </TD>';	   
	   $this->site[] = '   </TR>';
	   $this->site[] = '</TABLE>';
	   $this->site[] = '</FORM>';
	}
	
}
?>
