<?php
// DHCP CONFIG WIZARD
//
// Copyright (c) 2010 Nagios Enterprises, LLC.  All rights reserved.
//  
// $Id: $

include_once(dirname(__FILE__) . '/../configwizardhelper.inc.php');
?>
<style type="text/css">
.checkboxes label {
    display: block;
    float: left;
    padding-right: 10px;
    white-space: nowrap;
}
.checkboxes input {
    vertical-align: middle;
}
.checkboxes label span {
    vertical-align: middle;
}


td {
font-family: Arial, Helvetica, sans-serif;
font-size: 12px;
border: none;

}
</style>

<script type="text/javascript">

function checkPhyComp(chanageval)
{
    //alert("Hi I am called"+ document.getElementById("phycomp_mode[ARRY]").checked );
    if(!document.getElementById('services[phycompst]').checked && chanageval){
        document.getElementById("phycomp_mode[EBIOM]").checked = false;
        document.getElementById("phycomp_mode[ARRY]").checked  = false;
        document.getElementById("phycomp_mode[RBCON]").checked = false;
        document.getElementById("phycomp_mode[TRAY]").checked = false;
        document.getElementById("phycomp_mode[FAN]").checked = false;
        document.getElementById("phycomp_mode[BATT]").checked = false;
        document.getElementById("phycomp_mode[PSU]").checked = false;
        document.getElementById("phycomp_mode[DDS]").checked = false;    
    }

}
function checkLogicalComp()
{
    //alert("Hi I am called"+);
    if(!document.getElementById('services[logicalcompst]').checked){
        document.getElementById("logicalcomp_mode[RPR]").checked = false;
        document.getElementById("logicalcomp_mode[DPOOL]").checked = false;
        document.getElementById("logicalcomp_mode[CON]").checked = false;
        document.getElementById("logicalcomp_mode[VOL]").checked = false;
        document.getElementById("logicalcomp_mode[SNP]").checked = false;
        document.getElementById("logicalcomp_mode[MIRV]").checked = false;
        
    }
}
function checkArrayField()
{
    if (document.getElementById('configurehost').checked){
        document.getElementById("ip1").disabled = false;
        document.getElementById("ip2").disabled = false;
    }
    else
    {
        document.getElementById("ip1").disabled = true;
        document.getElementById("ip2").disabled = true;
    }
}
function checkBasicService()
{
    if (!document.getElementById('chk_basic').checked){
       document.getElementById("services[phycompst]").checked = false;
        document.getElementById("services[logicalcompst]").checked = false;
        document.getElementById("services[arrayavailable]").checked = false;
        document.getElementById("services[melevents]").checked = false;

    }

    checkPhyComp(true);
    checkLogicalComp();
}
function checkAdvanceService()
{
    if (!document.getElementById('chk_advance').checked){
        document.getElementById("services[stpool]").checked = false;
        document.getElementById("services[thinvol]").checked = false;
        document.getElementById("services[phytmp]").checked = false;
        document.getElementById("services[ssd]").checked = false;

    }
    
    
}
function checkVolumeService()
{
    if (!document.getElementById('services[vol]').checked){
         document.getElementById("services[volriop]").checked = false;
        document.getElementById("services[volwiop]").checked = false;
        document.getElementById("services[volrlat]").checked = false;
        document.getElementById("services[volwlat]").checked = false;
        document.getElementById("services[volrthp]").checked = false;
        document.getElementById("services[volwthp]").checked = false;
        
    }
    
}

function checkVolumeGPService()
{
    if (!document.getElementById('services[vg]').checked){
        document.getElementById("services[vgriop]").checked = false;
        document.getElementById("services[vgwiop]").checked = false;
        document.getElementById("services[vgrlat]").checked = false;
        document.getElementById("services[vgwlat]").checked = false;
        document.getElementById("services[vgrthp]").checked = false;
        document.getElementById("services[vgwthp]").checked = false;

    }
    
}
function checkVolumeConService()
{
    if (!document.getElementById('services[con]').checked){
         document.getElementById("services[conriop]").checked = false;
        document.getElementById("services[conwiop]").checked = false;
        document.getElementById("services[conrlat]").checked = false;
        document.getElementById("services[conwlat]").checked = false;
        document.getElementById("services[conrthp]").checked = false;
        document.getElementById("services[conwthp]").checked = false;

    }
    
}
function checkDriveService()
{
    if (!document.getElementById('services[drv]').checked){
         document.getElementById("services[drvriop]").checked = false;
        document.getElementById("services[drvwiop]").checked = false;
        document.getElementById("services[drvrlat]").checked = false;
        document.getElementById("services[drvwlat]").checked = false;
        document.getElementById("services[drvrthp]").checked = false;
        document.getElementById("services[drvwthp]").checked = false;

    }
    
}

function chkPerformanceService()
{
    if(!document.getElementById('chk_performance').checked)
    {
        document.getElementById("services[vol]").checked = false;
         document.getElementById("services[vg]").checked = false;
        document.getElementById("services[con]").checked = false;
        document.getElementById("services[drv]").checked = false;
        document.getElementById("services[cachevol]").checked = false;
        document.getElementById("services[cachevg]").checked = false;
    }
    
    checkDriveService();
    checkVolumeGPService();
    checkVolumeConService();
    checkVolumeService();
    checkCacheService();
    checkCacheVGService();
}

function checkCacheService()
{
    if (!document.getElementById('services[cachevol]').checked){
        document.getElementById("services[cvprc]").checked = false;
        document.getElementById("services[cvssd]").checked = false;
    }
}

function checkCacheVGService()
{
    if (!document.getElementById('services[cachevg]').checked){
        document.getElementById("services[cvgprc]").checked = false;
        document.getElementById("services[cvgssd]").checked = false;
    }
}

</script>
<?php
// run the initialization function


santricitybundle_configwizard_init();
function santricitybundle_configwizard_init()
{

    $name = "santricitybundle";
   

    $args = array(
        CONFIGWIZARD_NAME => $name,
        CONFIGWIZARD_VERSION => "1.4",
        CONFIGWIZARD_TYPE => CONFIGWIZARD_TYPE_MONITORING,
        CONFIGWIZARD_DESCRIPTION => gettext("SANtricity bundle to monitor E-Series Arrays."),
        CONFIGWIZARD_DISPLAYTITLE => "SANtricity Bundle",
        CONFIGWIZARD_FUNCTION => "santricitybundle_configwizard_func",
        CONFIGWIZARD_PREVIEWIMAGE => "netAppl-logo_48px.png",
    );

    register_configwizard($name, $args);
}

/*
* @param string $name
* @param string $value
*/
function is_disabled_per($name, $value)
{
    
    $retVal="disabled";
    if (strcmp($name, 'yes') == 0)
    {
        $retVal= "";
    }
    
    return $retVal;
}


/**
 * @param string $mode
 * @param null   $inargs
 * @param        $outargs
 * @param        $result
 *
 * @return string
 */

function santricitybundle_configwizard_func($mode = "", $inargs = null, &$outargs, &$result)
{

    $wizard_name = "santricitybundle";
    
    // initialize return code and output
    $result = 0;
    $output = "";

    // initialize output args - pass back the same data we got
    $outargs[CONFIGWIZARD_PASSBACK_DATA] = $inargs;


    switch ($mode) {
        case CONFIGWIZARD_MODE_GETSTAGE1HTML:

            $webproxy = grab_array_var($inargs, "webproxy", "");
            $webproxyport =grab_array_var($inargs, "webproxyport", "");
            $arrayname = grab_array_var($inargs, "arrayname", "");
            $username = grab_array_var($inargs, "username", "");
            $password = grab_array_var($inargs, "password", "");
            $ip1 = grab_array_var($inargs, "ip1", "");
            $ip2 = grab_array_var($inargs, "ip2", "");
            
            
            $back = htmlentities(grab_array_var($_POST,'backButton',false),ENT_QUOTES);
            $configurehost=grab_array_var($inargs, "configurehost", "yes");
            
            $output = '

    <div class="sectionTitle">Web Proxy Host</div>
    
            
    <table>

    <tr>
    <td valign="top" colspan="2">
    <label>Web Proxy Details</label><br class="nobr" />
    </td>
    </tr>
    <tr>
    <td colspan="2">
    <table width="60%">
    <tr>
    <td valign="middle" width="5%"><label>IP:</label></td>
    <td valign="top" width="18%">
<input type="text" size="20" name="webproxy" id="webproxy" value="' . htmlentities($webproxy) . '" class="textfield" />
    </td>
    <td>&nbsp;</td>
    <td valign="middle" width="5%"><label>Port:</label></td>
    <td valign="top">
<input type="text" size="10" name="webproxyport" id="webproxyport" value="' . htmlentities($webproxyport) . '" class="textfield" />
</tr>
    <tr>
    <td>&nbsp;</td>
    <td> ' . gettext('Web Proxy IP') . '.</td>
    <td colspan="2">&nbsp;</td>
    <td>
    ' . gettext('Web Proxy Port') . '.
    </td>

    </tr>
    </table>
    </td>
    </tr>

    <tr>
    <td valign="middle" width="8%">
    <label>Username:</label><br class="nobr" />
    </td>
    <td >
    <input type="text" size="40" name="username" id="username" value="' . htmlentities($username) . '" class="textfield" /><br class="nobr" />
    </td></tr>
    <tr>
    <td>&nbsp;</td><td>' . gettext('Username to connect to the Web Proxy') . '.<br><br>
    </td>
    </tr>
    <tr>
    <td valign="middle">
    <label>Password:</label>
    </td>
    <td valign="top">
<input type="password" size="40" name="password" id="password" value="' . htmlentities($password) . '" class="textfield" /><br class="nobr" />
   </td>
   </tr>
   <tr>
   <td>&nbsp;</td>
   <td valign="top"> ' . gettext('Password to connect to the Web Proxy') . '.<br><br>
    </td>
    </tr>
</table>
<div class="sectionTitle">Array Details</div>
<table>    
<tr>
    <td valign="middle">
    <label>Array Name:</label>
    </td>
    <td valign="top">
        <input type="text" size="40" name="arrayname" id="arrayname" value="' . htmlentities($arrayname) . '" class="textfield" />
    </td>
   </tr>
   <tr>
   <td>&nbsp;</td>
   <td valign="top">
        ' . gettext('Name of the array, which is configured as host in Nagios') . '
    </td>
    </tr>  

<tr>
    <td valign="top" colspan="2">
    <table width="100%">
    <tr> <td width="5%" valign="middle"> 
    <input type="hidden" name="configurehost" value="no" />
    <input type="checkbox" class="checkbox" name="configurehost" id="configurehost" value="yes" ' . is_checked($configurehost, "yes") . ' onclick="checkArrayField();"> 
    </td> <td valign="middle">'.  gettext('Configure New Host') .'</td>
    </tr>
    <tr>
    <td>&nbsp;</td>
    <td>' . gettext('Select this field, to configure array as new host.') . '.</td></tr></table>
</tr>

<td valign="middle">
    <label>IP Address1:</label><br class="nobr" />
    </td>
    <td valign="top">
        <input type="text" size="40" name="ip1" id="ip1" value="' . htmlentities($ip1) . '" class="textfield" '.is_disabled_per($configurehost, "no").'/>
    </td>
    </tr>
    <tr>
    <td>&nbsp;</td>
    <td>    
    ' . gettext('Required for new host configuration. First IP address of array to be monitored') . '.<br><br>
    </td>
    </tr>
    <tr>
    <td valign="middle">
    <label>IP Address2:</label><br class="nobr" />
    </td>
    <td valign="top">
        <input type="text" size="40" name="ip2" id="ip2" value="' . htmlentities($ip2) . '" class="textfield" '.is_disabled_per($configurehost, "no").'/>
    </td>
    </tr>
    <tr>
    <td>&nbsp;</td>
    <td>
    ' . gettext('Required for new host configuration. Second IP address of array to be monitored') . '.<br><br>
    </td>
    </tr>
    </table>

            ';
            break;

        case CONFIGWIZARD_MODE_VALIDATESTAGE1DATA:
            
            // get variables that were passed to us
            $webproxy = grab_array_var($inargs, "webproxy", "");
            $webproxyport = grab_array_var($inargs, "webproxyport", "");
            $arrayname = grab_array_var($inargs, "arrayname", "");
            $username = grab_array_var($inargs, "username", "");
            $password = grab_array_var($inargs, "password", "");
            $ip1 = grab_array_var($inargs, "ip1", "");
            $ip2 = grab_array_var($inargs, "ip2", "");
            $configurehost=grab_array_var($inargs, "configurehost", "");
            // check for errors
            
            $errors = 0;
            $errmsg = array();
            if (have_value($webproxy) == false )
                $errmsg[$errors++] = gettext("Please enter Web Proxy IP.");
            else if (have_value($webproxy) == true && !filter_var($webproxy, FILTER_VALIDATE_IP))
                $errmsg[$errors++] = gettext("Invalid Web Proxy IP.");
            if (have_value($webproxyport) == true && !is_numeric($webproxyport))
                $errmsg[$errors++] = gettext("Invalid Web Proxy Port.");
            if (have_value($arrayname) == false)
                $errmsg[$errors++] = gettext("Please enter Array Name.");
            if (have_value($username) == false)
                $errmsg[$errors++] = gettext("Please enter User Name.");
            if (have_value($password) == false)
                $errmsg[$errors++] = gettext("Please enter Password.");
            if (have_value($ip1) == false && $configurehost =='yes')
                $errmsg[$errors++] = gettext("Please enter IP Address1.");
            elseif(have_value($ip1) == True && $configurehost =='yes' && filter_var($ip1, FILTER_VALIDATE_IP) ==false) 
                $errmsg[$errors++] = gettext("Invalid IP Address1.");
            if (have_value($ip2) == false && $configurehost =='yes')
                $errmsg[$errors++] = gettext("Please enter IP Address2.");
            elseif(have_value($ip2) == True && $configurehost =='yes' && filter_var($ip2, FILTER_VALIDATE_IP) ==false) 
                $errmsg[$errors++] = gettext("Invalid IP Address2.");
            if ($errors > 0) {
                $outargs[CONFIGWIZARD_ERROR_MESSAGES] = $errmsg;
                $result = 1;
            }

            break;
        case CONFIGWIZARD_MODE_GETSTAGE2HTML:

            // get variables that were passed to us
            $webproxy = grab_array_var($inargs, "webproxy");
            $webproxyport = grab_array_var($inargs, "webproxyport");
            $arrayname = grab_array_var($inargs, "arrayname");
            $username = grab_array_var($inargs, "username");
            $password = grab_array_var($inargs, "password");
            $ip1 = grab_array_var($inargs, "ip1");
            $ip2 = grab_array_var($inargs, "ip2");
            $configurehost=grab_array_var($inargs, "configurehost");

            $txtSpWar = grab_array_var($inargs, "txtSpWar", "75");
            $txtSpCrt = grab_array_var($inargs, "txtSpCrt", "90");
            $txtTvCrt = grab_array_var($inargs, "txtTvCrt", "10");
            $txtTvWar = grab_array_var($inargs, "txtTvWar", "25");
            $txtPhtWar = grab_array_var($inargs, "txtPhtWar", "75");
            $txtPhtCrt = grab_array_var($inargs, "txtPhtCrt", "90");
            $txtSDCrt = grab_array_var($inargs, "txtSDCrt", "90");
            $txtSDWar = grab_array_var($inargs, "txtSDWar", "75");
            
            $txtvoliopWar = grab_array_var($inargs, "txtvoliopWar", "5000");
            $txtvoliopCrt = grab_array_var($inargs, "txtvoliopCrt", "7500");
            $txtvolwiopWar = grab_array_var($inargs, "txtvolwiopWar", "5000");
            $txtvolwiopCrt = grab_array_var($inargs, "txtvolwiopCrt", "7500");
            $txtvolrlatWar = grab_array_var($inargs, "txtvolrlatWar", "5000");
            $txtvolrlatCrt = grab_array_var($inargs, "txtvolrlatCrt", "7500");

             $txtvolwlatWar = grab_array_var($inargs, "txtvolwlatWar", "5000");
            $txtvolwlatCrt = grab_array_var($inargs, "txtvolwlatCrt", "7500");

            $txtvolrthpWar = grab_array_var($inargs, "txtvolrthpWar", "5000");
            $txtvolrthpCrt = grab_array_var($inargs, "txtvolrthpCrt", "7500");
            $txtvolwthpWar = grab_array_var($inargs, "txtvolwthpWar", "5000");
            $txtvolwthpCrt = grab_array_var($inargs, "txtvolwthpCrt", "7500");

            $txtvgiopWar = grab_array_var($inargs, "txtvgiopWar", "5000");
            $txtvgiopCrt = grab_array_var($inargs, "txtvgiopCrt", "7500");
            $txtvgwiopWar = grab_array_var($inargs, "txtvgwiopWar", "5000");
            $txtvgwiopCrt = grab_array_var($inargs, "txtvgwiopCrt", "7500");
            $txtvgrlatWar = grab_array_var($inargs, "txtvgrlatWar", "5000");
            $txtvgrlatCrt = grab_array_var($inargs, "txtvgrlatCrt", "7500");

            $txtvgwlatWar = grab_array_var($inargs, "txtvgwlatWar", "5000");
            $txtvgwlatCrt = grab_array_var($inargs, "txtvgwlatCrt", "7500");

            $txtvgrthpWar = grab_array_var($inargs, "txtvgrthpWar", "5000");
            $txtvgrthpCrt = grab_array_var($inargs, "txtvgrthpCrt", "7500");
            $txtvgwthpWar = grab_array_var($inargs, "txtvgwthpWar", "5000");
            $txtvgwthpCrt = grab_array_var($inargs, "txtvgwthpCrt", "7500");
            
            $txtconiopWar = grab_array_var($inargs, "txtconiopWar", "5000");
            $txtconiopCrt = grab_array_var($inargs, "txtconiopCrt", "7500");
            $txtconwiopWar = grab_array_var($inargs, "txtconwiopWar", "5000");
            $txtconwiopCrt = grab_array_var($inargs, "txtconwiopCrt", "7500");
            $txtconrlatWar = grab_array_var($inargs, "txtconrlatWar", "5000");
            $txtconrlatCrt = grab_array_var($inargs, "txtconrlatCrt", "7500");
            $txtconwlatWar = grab_array_var($inargs, "txtconwlatWar", "5000");
            $txtconwlatCrt = grab_array_var($inargs, "txtconwlatCrt", "7500");
            $txtconrthpWar = grab_array_var($inargs, "txtconrthpWar", "5000");
            $txtconrthpCrt = grab_array_var($inargs, "txtconrthpCrt", "7500");
            $txtconwthpWar = grab_array_var($inargs, "txtconwthpWar", "5000");
            $txtconwthpCrt = grab_array_var($inargs, "txtconwthpCrt", "7500");

            $txtdrviopWar = grab_array_var($inargs, "txtdrviopWar", "5000");
            $txtdrviopCrt = grab_array_var($inargs, "txtdrviopCrt", "7500");
            $txtdrvwiopWar = grab_array_var($inargs, "txtdrvwiopWar", "5000");
            $txtdrvwiopCrt = grab_array_var($inargs, "txtdrvwiopCrt", "7500");
            $txtdrvrlatWar = grab_array_var($inargs, "txtdrvrlatWar", "5000");
            $txtdrvrlatCrt = grab_array_var($inargs, "txtdrvrlatCrt", "7500");
            $txtdrvwlatWar = grab_array_var($inargs, "txtdrvwlatWar", "5000");
            $txtdrvwlatCrt = grab_array_var($inargs, "txtdrvwlatCrt", "7500");
            $txtdrvrthpWar = grab_array_var($inargs, "txtdrvrthpWar", "5000");
            $txtdrvrthpCrt = grab_array_var($inargs, "txtdrvrthpCrt", "7500");
            $txtdrvwthpWar = grab_array_var($inargs, "txtdrvwthpWar", "5000");
            $txtdrvwthpCrt = grab_array_var($inargs, "txtdrvwthpCrt", "7500");

            $rdVol= grab_array_var($inargs,"rdVol","high");
            $rdVolWLAT = grab_array_var($inargs,"rdVolWLAT","high");
            $rdVolrthp = grab_array_var($inargs,"rdVolrthp","high");
            $rdVolWTHP = grab_array_var($inargs,"rdVolWTHP","high");
            $rdVolRLAT = grab_array_var($inargs,"rdVolRLAT","high");
            $rdVolWIOP = grab_array_var($inargs,"rdVolWIOP","high");
            
            $rdconRIOP= grab_array_var($inargs,"rdconRIOP","high");
            $rdconWLAT = grab_array_var($inargs,"rdconWLAT","high");
            $rdconrthp = grab_array_var($inargs,"rdconrthp","high");
            $rdconWTHP = grab_array_var($inargs,"rdconWTHP","high");
            $rdconRLAT = grab_array_var($inargs,"rdconRLAT","high");
            $rdconWIOP = grab_array_var($inargs,"rdconWIOP","high");
            
            $rddrvRIOP= grab_array_var($inargs,"rddrvRIOP","high");
            $rddrvWLAT = grab_array_var($inargs,"rddrvWLAT","high");
            $rddrvrthp = grab_array_var($inargs,"rddrvrthp","high");
            $rddrvWTHP = grab_array_var($inargs,"rddrvWTHP","high");
            $rddrvRLAT = grab_array_var($inargs,"rddrvRLAT","high");
            $rddrvWIOP = grab_array_var($inargs,"rddrvWIOP","high");

            $rdvgRIOP= grab_array_var($inargs,"rdvgRIOP","high");
            $rdvgWLAT = grab_array_var($inargs,"rdvgWLAT","high");
            $rdvgrthp = grab_array_var($inargs,"rdvgrthp","high");
            $rdvgWTHP = grab_array_var($inargs,"rdvgWTHP","high");
            $rdvgRLAT = grab_array_var($inargs,"rdvgRLAT","high");
            $rdvgWIOP = grab_array_var($inargs,"rdvgWIOP","high");
            $chk_basic =grab_array_var($inargs,"chk_basic","yes");
            $chk_advance =grab_array_var($inargs,"chk_advance","yes");
            $chk_performance=grab_array_var($inargs,"chk_performance","yes");

            

             $services = "";

            $services_default = array(
                "arrayavailable" => "on",
                "phycompst" => "on",
                "melevents" => "on",
                "logicalcompst" => "on",
                "stpool" => "on",
                "thinvol"=> "on",
                "ssd" => "on",
                "phytmp" => "on",
                "volriop" => "on",
                "volwiop" => "on",
                "volrlat" => "on",
                "volwlat" => "on",
                "volrthp" => "on",
                "volwthp" => "on",
                "vgriop" => "on",
                "vgwiop" => "on",
                "vgrlat" => "on",
                "vgwlat" => "on",
                "vgrthp" => "on",
                "vgwthp" => "on",
                "conriop" => "on",
                "conwiop" => "on",
                "conrlat" => "on",
                "conwlat" => "on",
                "conrthp" => "on",
                "conwthp" => "on",
                "drvriop" => "on",
                "drvwiop" => "on",
                "drvrlat" => "on",
                "drvwlat" => "on",
                "drvrthp" => "on",
                "drvwthp" => "on",
                "vol" => "on",
                "vg" => "on",
                "con" => "on",
                "drv" => "on",
                "cachevol"=>"on",
                "cvprc" =>"on",
                "cvssd" => "on",
                "cvgprc" =>"on",
                "cvgssd" =>"on",
                "cachevg" =>"on"
                );
            $phycomp_mode ="";
            $phycomp_mode_default = array(
                "RBCON" => "on",
                "EBIOM" => "on",
                "TRAY" => "on",
                "BATT" => "on",
                "FAN" => "on",
                "PSU" => "on",
                "ARRY" => "on",
                "DDS" => "on",
                "chk" => "on"
                
            );
            $logicalcomp_mode="";
            $logicalcomp_mode_default= array(
                "RPR" => "RPR",
                "DPOOL" => "DPOOL",
                "CON" => "CON",
                "SNP" => "SNP",
                "MIRV" => "MIRV",
                "VOL" =>"VOL"
            );
           
            $serviceargs_default = array(
                "phmode" => "",
            );
            $services_serial = grab_array_var($inargs, "services_serial");
            if ($services_serial != "")
                $services = unserialize(base64_decode($services_serial));
            if (!is_array($services))
                $services = grab_array_var($inargs, "services", $services_default);

            $serviceargs = "";
            

            $serviceargs_serial = grab_array_var($inargs, "serviceargs_serial");
            if ($serviceargs_serial != "") {
                //echo "ARGSSERIAL: $serviceargs_serial<BR>\n";
                $serviceargs = unserialize(base64_decode($serviceargs_serial));
            }
            if (!is_array($serviceargs))
                $serviceargs = grab_array_var($inargs, "serviceargs", $serviceargs_default);


             $phycomp_mode = "";
            

            $phycomp_mode_serial = grab_array_var($inargs, "phycomp_mode_serial");
            if ($phycomp_mode_serial != "") {
                //echo "ARGSSERIAL: $serviceargs_serial<BR>\n";
                $phycomp_mode = unserialize(base64_decode($phycomp_mode_serial));
            }
            if (!is_array($phycomp_mode))
                $phycomp_mode = grab_array_var($inargs, "phycomp_mode", $phycomp_mode_default);
            
            $logicalcomp_mode_serial= grab_array_var($inargs, "logicalcomp_mode_serial");
            if($logicalcomp_mode_serial !="")
                $logicalcomp_mode = unserialize(base64_decode($logicalcomp_mode_serial));
            if(!is_array($logicalcomp_mode))
                $logicalcomp_mode=grab_array_var($inargs, "logicalcomp_mode", $logicalcomp_mode_default);

            $output = '<input type="hidden" name="webproxy" value="' . htmlentities($webproxy) . '">
            <input type="hidden" name="webproxyport" value="' . htmlentities($webproxyport) . '">
            <input type="hidden" name="arrayname" value="' . htmlentities($arrayname) . '">
            <input type="hidden" name="ip1" value="' . htmlentities($ip1) . '">
            <input type="hidden" name="ip2" value="' . htmlentities($ip2) . '">
            <input type="hidden" name="username" value="' . htmlentities($username) . '">
            <input type="hidden" name="password" value="' . htmlentities($password) . '">
            <input type="hidden" name="configurehost" value="' . htmlentities($configurehost) . '">
            <div class="sectionTitle"><b>' . gettext('Net App SANtricity Services') . '</b></div>
    
    <p>' . gettext('Specify the services you\'d like to monitor for the given array.') . '</p>
    
    
    <table width="100%">
    <tr>
    <td align="center" valign="middle">
    <input type="hidden" name="chk_basic" value="no" />
    <input type="checkbox" class="checkbox" name="chk_basic" id="chk_basic" value="yes" ' . is_checked($chk_basic, "yes") . '  onclick="checkBasicService();">
    </td>
    <td valign="top" colspan="2">
    
    <b>Basic Services</b><br>
    </td>
    </tr>
    <tr>
    <td width="5%"></td>
    <td valign="top">
    <input type="checkbox" class="checkbox" name="services[arrayavailable]" id="services[arrayavailable]" value="arrayavailable"' . is_checked(grab_array_var($services, "arrayavailable"), "arrayavailable") . '>
    </td>
    <td valign="top">
    <b>' . gettext('Array Availability') . '</b><br>
    ' . gettext('Monitor the availability of the array.') . '
    </td>
    </tr>
    <tr>
    <td colspan="3">
    &nbsp;
    </td>
    </tr>
    <tr>
    <td width="5%"></td>
    <td valign="top">
    <input type="checkbox" class="checkbox" name="services[phycompst]" id="services[phycompst]" value="phycompst"' . is_checked(grab_array_var($services, "phycompst"), "phycompst") . ' onclick="checkPhyComp(true);">
    </td>
    <td valign="top">
    <b>' . gettext('Physical Component Status') . '</b><br>
    ' . gettext('Monitor the status of physical components for given array.') . '<br>
    <input type="hidden" name="phycomp_mode[unknown]" value="no" />
    <table width="80%">
        <tr>
        <td width="2%" valign="middle">
            <input type="checkbox" class="checkbox" name="phycomp_mode[RBCON]" id="phycomp_mode[RBCON]" value="RBCON"' . is_checked(grab_array_var($phycomp_mode, "RBCON"), "RBCON") . '>
        </td>
        <td valign="top" width="13%">
            '.gettext('RBOD Controllers').'
        </td>
        <td width="2%" valign="middle">
            <input type="checkbox" class="checkbox" name="phycomp_mode[EBIOM]" id="phycomp_mode[EBIOM]" value="EBIOM"' . is_checked(grab_array_var($phycomp_mode, "EBIOM"), "EBIOM") . '>
        </td>
        <td valign="top" width="10%">
            '.gettext('EBOD IOMS').'
        </td>
        <td width="2%" valign="middle">
            <input type="checkbox" class="checkbox" name="phycomp_mode[TRAY]" id="phycomp_mode[TRAY]" value="TRAY"' . is_checked(grab_array_var($phycomp_mode, "TRAY"), "TRAY") . '>
        </td>
        <td valign="top" width="5%">
            '.gettext('Tray').'
        </td>
        <td width="2%" valign="middle">
            <input type="checkbox" class="checkbox" name="phycomp_mode[BATT]" id="phycomp_mode[BATT]" value="BATT"' . is_checked(grab_array_var($phycomp_mode, "BATT"), "BATT") . '>
        </td>
        <td valign="top" width="8%">
            '.gettext('Batteries').'
        </td>
        <td width="2%" valign="middle">
            <input type="checkbox" class="checkbox" name="phycomp_mode[FAN]"  id="phycomp_mode[FAN]" value="FAN"' . is_checked(grab_array_var($phycomp_mode, "FAN"), "FAN") . '>
        </td>
        <td valign="top" width="5%">
            '.gettext('Fans').'
        </td>
        <td width="2%" valign="middle">
            <input type="checkbox" class="checkbox" name="phycomp_mode[PSU]" id="phycomp_mode[PSU]" value="PSU"' . is_checked(grab_array_var($phycomp_mode, "PSU"), "PSU") . '>
        </td>
        <td valign="top" width="12%">
            '.gettext('Power Supplies').'
        </td>
        <td width="2%" valign="middle">
            <input type="checkbox" class="checkbox" name="phycomp_mode[DDS]" id="phycomp_mode[DDS]" value="DDS"' . is_checked(grab_array_var($phycomp_mode, "DDS"), "DDS") . '>
        </td>
        <td valign="top" width="10%">
            '.gettext('Disk Drives').'
        </td>
        <td width="2%" valign="middle">
            <input type="checkbox" class="checkbox" name="phycomp_mode[ARRY]" id="phycomp_mode[ARRY]" value="ARRY"' . is_checked(grab_array_var($phycomp_mode, "ARRY"), "ARRY") . '>
        </td>
        <td valign="top">
            '.gettext('Arrays').'
        </td>
        </tr>

    </table>
    </td>
    </tr> 
    <tr>
    <td colspan="3">
    &nbsp;
    </td>
    </tr>
    <tr>
    <td width="5%"></td>
    <td valign="top">
    <input type="checkbox" class="checkbox" name="services[logicalcompst]" id="services[logicalcompst]" value="logicalcompst"' . is_checked(grab_array_var($services, "logicalcompst"), "logicalcompst") . ' onclick="checkLogicalComp();">
    </td>
    <td valign="top">
    <b>' . gettext('Logical Component Status') . '</b><br>
    ' . gettext('Monitor the status of logical components for given array.') . '<br>
    <input type="hidden" name="services[unknown]" value="no" />
    <input type="hidden" name="logicalcomp_mode[unknown]" value="no" />
     <table width="80%">
        <tr>
        <td width="2%" valign="middle"> 
            <input type="checkbox" class="checkbox" name="logicalcomp_mode[DPOOL]" id="logicalcomp_mode[DPOOL]" value="DPOOL"' . is_checked(grab_array_var($logicalcomp_mode, "DPOOL"), "DPOOL") . '>
        </td>
        <td valign="top" width="10%">
            '.gettext('Data Pools').'
        </td> 
        <td width="2%" valign="middle"> 
            <input type="checkbox" class="checkbox" name="logicalcomp_mode[CON]" id="logicalcomp_mode[CON]" value="CON"' . is_checked(grab_array_var($logicalcomp_mode, "CON"), "CON") . '>
        </td>
        <td valign="top" width="15%">
            '.gettext('Consistency Groups').'
        </td> 
        <td width="2%" valign="middle"> 
            <input type="checkbox" class="checkbox" name="logicalcomp_mode[VOL]" id="logicalcomp_mode[VOL]" value="VOL"' . is_checked(grab_array_var($logicalcomp_mode, "VOL"), "VOL") . '>
        </td>
        <td valign="top" width="8%">
            '.gettext('Volumes').'
        </td> 
        <td width="2%" valign="middle"> 
            <input type="checkbox" class="checkbox" name="logicalcomp_mode[SNP]" id="logicalcomp_mode[SNP]" value="SNP"' . is_checked(grab_array_var($logicalcomp_mode, "SNP"), "SNP") . '>
        </td>
        <td valign="top" width="20%">
            '.gettext('Snapshots (Legacy and PIT)').'
        </td> 
        <td width="2%" valign="middle"> 
            <input type="checkbox" class="checkbox" name="logicalcomp_mode[MIRV]" id="logicalcomp_mode[MIRV]" value="MIRV"' . is_checked(grab_array_var($logicalcomp_mode, "MIRV"), "MIRV") . '>
        </td>
        <td valign="top" width="13%">
            '.gettext('Mirror Volumes').'
        </td> 
        <td width="2%" valign="middle"> 
            <input type="checkbox" class="checkbox" name="logicalcomp_mode[RPR]" id="logicalcomp_mode[RPR]" value="RPR"' . is_checked(grab_array_var($logicalcomp_mode, "RPR"), "RPR") . '>
        </td>
        <td valign="top">
            '.gettext('PIT Repositories').'
        </td>   
        </tr>
        </table>
    </td>
    </tr> 
    <tr>
    <td colspan="3">
    &nbsp;
    </td>
    </tr>  
    <tr>
    <td width="5%"></td>
    <td valign="top">
    <input type="checkbox" class="checkbox" name="services[melevents]" id="services[melevents]" value="melevents"' . is_checked(grab_array_var($services, "melevents"), "melevents") . '>
    </td>
    <td valign="top">
    <b>' . gettext('Major Event Log') . '</b><br>
    ' . gettext('Monitor the event log of the array.') . '
    </td>
    </tr>
    <tr>
    <td colspan="3">
    &nbsp;
    </td>
    </tr>
    <tr>
    <td align="center" valign="middle">
        <input type="hidden" name="chk_advance" value="no" />
        <input type="checkbox" class="checkbox" name="chk_advance" id="chk_advance" value="yes" ' . is_checked($chk_advance,"yes") . ' onClick="checkAdvanceService();">
    </td>
    <td valign="top" colspan="2">
   
    <b>Advance Services</b><br>
    </td>
    </tr>
    <tr>
    <td width="5%"></td>
    <td valign="top">
    <input type="checkbox" class="checkbox" name="services[stpool]" id="services[stpool]" value="stpool"' . is_checked(grab_array_var($services, "stpool"), "stpool") . '>
    </td>
    <td valign="top">
    <b>' . gettext('Monitor Storage Pool') . '</b><br>
    ' . gettext('To track and report Storage Pool capacity information.') . '
    </td>
    </tr>
    <tr>
    <td width="5%"></td>
    <td valign="top" colspan="2">
    <table width="50%">
    <tr>
    <td valign="top">
        <label>' . gettext('Warning:') . '</label><br class="nobr" />
    </td>
    <td valign="top">
        <input type="text" class="textfield" name="txtSpWar" id="txtSpWar" value="' . htmlentities($txtSpWar) . '"><br class="nobr" />
    
    </td>
    <td valign="top">
        <label>' . gettext('Critical:') . '</label><br class="nobr" />
    </td>
    <td valign="top">
        <input type="text" class="textfield" name="txtSpCrt" id="txtSpCrt" value="' . htmlentities($txtSpCrt) . '"><br class="nobr" />
    
    </td>
    </tr> 
    </table>
    
    </td>
    
    </tr>
    <tr>
    <td width="5%"></td>
    <td valign="top">
    <input type="checkbox" class="checkbox" name="services[thinvol]" id="services[thinvol]" value="thinvol"' . is_checked(grab_array_var($services, "thinvol"), "thinvol") . '>
    </td>
    <td valign="top">
    <b>' . gettext('Monitor Thin Volumes') . '</b><br>
    ' . gettext('To track and report Thin Volumes capacity information.') . '
    </td>
    </tr>
    <tr>
    <td width="5%"></td>
    <td valign="top" colspan="2">
    <table width="50%">
    <tr>
    <td valign="top">
        <label>' . gettext('Warning:') . '</label><br class="nobr" />
    </td>
    <td valign="top">
        <input type="text" class="textfield" name="txtTvWar" id="txtTvWar" value="' . htmlentities($txtTvWar) . '"><br class="nobr" />
    
    </td>
    <td valign="top">
        <label>' . gettext('Critical:') . '</label><br class="nobr" />
    </td>
    <td valign="top">
        <input type="text" class="textfield" name="txtTvCrt" id="txtTvCrt" value="' . htmlentities($txtTvCrt) . '"><br class="nobr" />
    
    </td>
    </tr> 
    </table>
    
    </td>
    
    </tr>
    <tr>
    <td width="5%"></td>
    <td valign="top">
    <input type="checkbox" class="checkbox" name="services[phytmp]" id="services[phytmp]" value="phytmp"' . is_checked(grab_array_var($services, "phytmp"), "phytmp") . '>
    </td>
    <td valign="top">
    <b>' . gettext('Monitor Physical Component Temperature') . '</b><br>
    ' . gettext('To track and report Physical Component Temperature information.') . '
    </td>
    </tr>
    <tr>
    <td width="5%"></td>
    <td valign="top" colspan="2">
    <table width="50%">
    <tr>
    <td valign="top">
        <label>' . gettext('Warning:') . '</label><br class="nobr" />
    </td>
    <td valign="top">
        <input type="text" class="textfield" name="txtPhtWar" id="txtPhtWar" value="' . htmlentities($txtPhtWar) . '"><br class="nobr" />
    ' . gettext('Warning threshold.') . '
    </td>
    <td valign="top">
        <label>' . gettext('Critical:') . '</label><br class="nobr" />
    </td>
    <td valign="top">
        <input type="text" class="textfield" name="txtPhtCrt" id="txtPhtCrt" value="' . htmlentities($txtPhtCrt) . '"><br class="nobr" />
    ' . gettext('Critical threshold.') . '
    </td>
    </tr> 
    </table>
    
    </td>
    
    </tr>
    <tr>
    <td width="5%"></td>
    <td valign="top">
    <input type="checkbox" class="checkbox" name="services[ssd]" id="services[ssd]" value="ssd"' . is_checked(grab_array_var($services, "ssd"), "ssd") . ' ">
    </td>
    <td valign="top">
    <b>' . gettext('Monitor SSD drives Statistics') . '</b><br>
    ' . gettext('To track and report SSD Drive statistics.') . '
    </td>
    </tr>
    <tr>
    <td width="5%"></td>
    <td valign="top" colspan="2">
    <table width="50%">
    <tr>
    <td valign="top">
        <label>' . gettext('Warning:') . '</label><br class="nobr" />
    </td>
    <td valign="top">
        <input type="text" class="textfield" name="txtSDWar" id="txtSDWar" value="' . htmlentities($txtSDWar) . '"><br class="nobr" />
    
    </td>
    <td valign="top">
        <label>' . gettext('Critical:') . '</label><br class="nobr" />
    </td>
    <td valign="top">
        <input type="text" class="textfield" name="txtSDCrt" id="txtSDCrt" value="' . htmlentities($txtSDCrt) . '"><br class="nobr" />
    
    </td>
    </tr> 
    </table>
    
    </td>
    
    </tr>
    <tr>
    <td colspan="3">
    &nbsp;
    </td>
    </tr>
    <tr>
    <td align="center" valign="middle">
        <input type="hidden" name="chk_performance" value="no" />
    <input type="checkbox" class="checkbox" name="chk_performance" id="chk_performance" value="yes" ' . is_checked($chk_performance, "yes") . ' onClick="chkPerformanceService();" >
    </td>
    <td valign="top" colspan="2">
        <b>Performance Services</b><br>
    </td>
    </tr>
    
    <tr>
    <td width="5%"></td>
    <td valign="top">
    <input type="checkbox" class="checkbox" name="services[vol]" id="services[vol]" value="vol"' . is_checked(grab_array_var($services, "vol"), "vol") . ' onclick="checkVolumeService();">
    </td>
    <td valign="top">
    <b>' . gettext('Volume Statistics') . '</b><br>
    ' . gettext('Track and report performance statistics by Volume for given array.') . '<br>
    
    <table width=75%>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
            <input type="checkbox" class="checkbox" name="services[volriop]" id="services[volriop]" value="volriop"' . is_checked(grab_array_var($services, "volriop"), "volriop") . '>
            </td>
            <td valign="top" width="10%">'.gettext('Read IOPs').'
            </td>
            <td valign="top" width="20%">
            <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                         <label>' . gettext('Range Selector:') . '</label>
                </td>
                </tr>
                <tr>
                    <td valign="middle"><input type="radio" class="radio" name="rdVol" id="rdVol" value="low"'.is_checked($rdVol,"low").'>
                    </td><td >    Low</td>
                    <td valign="middle"><input type="radio" class="radio" name="rdVol" id="rdVol" value="high" '.is_checked($rdVol,"high").'>
                    </td><td> High</td>
                </tr>
            </table>
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvoliopWar" id="txtvoliopWar" value="' . htmlentities($txtvoliopWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvoliopCrt" id="txtvoliopCrt" value="' . htmlentities($txtvoliopCrt) . '"><br class="nobr" />
            </td> 
              
        </tr>
        <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
            <input type="checkbox" class="checkbox" name="services[volwiop]" id="services[volwiop]" value="volwiop"' . is_checked(grab_array_var($services, "volwiop"), "volwiop") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Write IOPs').'
            </td>
            <td valign="top" width="20%">
            <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rdVolWIOP" id="rdVolWIOP" value="low" '.is_checked($rdVolWIOP,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rdVolWIOP" id="rdVolWIOP" value="high" '.is_checked($rdVolWIOP,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvolwiopWar" id="txtvolwiopWar" value="' . htmlentities($txtvolwiopWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvolwiopCrt" id="txtvolwiopCrt" value="' . htmlentities($txtvolwiopCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
        <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
                <input type="checkbox" class="checkbox" name="services[volrlat]" id="services[volrlat]" value="volrlat"' . is_checked(grab_array_var($services, "volrlat"), "volrlat") . '>
            </td>
            <td valign="top">
            '.gettext('Read Latency').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">

             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rdVolRLAT" id="rdVolRLAT" value="low" '.is_checked($rdVolRLAT,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rdVolRLAT" id="rdVolRLAT" value="high" '.is_checked($rdVolRLAT,"high").'></td>
                    <td>High</td>
                </tr>
                </table>
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvolrlatWar" id="txtvolrlatWar" value="' . htmlentities($txtvolrlatWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvolrlatCrt" id="txtvolrlatCrt" value="' . htmlentities($txtvolrlatCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
         <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
                <input type="checkbox" class="checkbox" name="services[volwlat]" id="services[volwlat]" value="volwlat"' . is_checked(grab_array_var($services, "volwlat"), "volwlat") . '>
            </td>
            <td valign="top">
            '.gettext('Write Latency').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rdVolWLAT" id="rdVolWLAT" value="low" '.is_checked($rdVolWLAT,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rdVolWLAT" id="rdVolWLAT" value="high" '.is_checked($rdVolWLAT,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvolwlatWar" id="txtvolwlatWar" value="' . htmlentities($txtvolwlatWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvolwlatCrt" id="txtvolwlatCrt" value="' . htmlentities($txtvolwlatCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
         <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="middle" width="2%">
                <input type="checkbox" class="checkbox" name="services[volrthp]" id="services[volrthp]" value="volrthp"' . is_checked(grab_array_var($services, "volrthp"), "volrthp") . '>&nbsp;
            </td>
            <td valign="top">
            '.gettext('Read Throughput').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rdVolrthp" id="rdVolrthp" value="low" '.is_checked($rdVolrthp,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rdVolrthp" id="rdVolrthp" value="high" '.is_checked($rdVolrthp,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvolrthpWar" id="txtvolrthpWar" value="' . htmlentities($txtvolrthpWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvolrthpCrt" id="txtvolrthpCrt" value="' . htmlentities($txtvolrthpCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
         <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="middle" width="2%">
            <input type="checkbox" class="checkbox" name="services[volwthp]" id="services[volwthp]" value="volwthp"' . is_checked(grab_array_var($services, "volwthp"), "volwthp") . '>
            </td>
            <td valign="top">
            '.gettext('Write Throughput').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td>
                <input type="radio" class="radio" name="rdVolWTHP" id="rdVolWTHP" value="low" '.is_checked($rdVolWTHP,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rdVolWTHP" id="rdVolWTHP" value="high" '.is_checked($rdVolWTHP,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvolwthpWar" id="txtvolwthpWar" value="' . htmlentities($txtvolwthpWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvolwthpCrt" id="txtvolwthpCrt" value="' . htmlentities($txtvolwthpCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
         <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
    </table>
    </td>
    </tr>    
    <tr>
    <td width="5%"></td>
    <td valign="top">
    <input type="checkbox" class="checkbox" name="services[vg]" id="services[vg]" value="vg"' . is_checked(grab_array_var($services, "vg"), "vg") . ' onclick="checkVolumeGPService();">
    </td>
    <td valign="top"><b>' . gettext('Volume Statistics by Volume Group') . '</b><br>
    ' . gettext('Track and report performance statistics by Volume for given array.') . '<br>
    
    <table width=75%>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
            <input type="checkbox" class="checkbox" name="services[vgriop]" id="services[vgriop]" value="vgriop"' . is_checked(grab_array_var($services, "vgriop"), "vgriop") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Read IOPs').'
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rdvgRIOP" id="rdvgRIOP" value="low" '.is_checked($rdvgRIOP,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rdvgRIOP" id="rdvgRIOP" value="high" '.is_checked($rdvgRIOP,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvgiopWar" id="txtvgiopWar" value="' . htmlentities($txtvgiopWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvgiopCrt" id="txtvgiopCrt" value="' . htmlentities($txtvgiopCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
        <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
            <input type="checkbox" class="checkbox" name="services[vgwiop]" id="services[vgwiop]" value="vgwiop"' . is_checked(grab_array_var($services, "vgwiop"), "vgwiop") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Write IOPs').'
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rdvgWIOP" id="rdvgWIOP" value="low" '.is_checked($rdvgWIOP,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rdvgWIOP" id="rdvgWIOP" value="high" '.is_checked($rdvgWIOP,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
         </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvgwiopWar" id="txtvgwiopWar" value="' . htmlentities($txtvgwiopWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvgwiopCrt" id="txtvgwiopCrt" value="' . htmlentities($txtvgwiopCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
        <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
            <input type="checkbox" class="checkbox" name="services[vgrlat]" id="services[vgrlat]" value="vgrlat"' . is_checked(grab_array_var($services, "vgrlat"), "vgrlat") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Read Latency').'
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td>  <input type="radio" class="radio" name="rdvgRLAT" id="rdvgRLAT" value="low" '.is_checked($rdvgRLAT,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rdvgRLAT" id="rdvgRLAT" value="high" '.is_checked($rdvgRLAT,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvgrlatWar" id="txtvgrlatWar" value="' . htmlentities($txtvgrlatWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvgrlatCrt" id="txtvgrlatCrt" value="' . htmlentities($txtvgrlatCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
        <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
            <input type="checkbox" class="checkbox" name="services[vgwlat]" id="services[vgwlat]" value="vgwlat"' . is_checked(grab_array_var($services, "vgwlat"), "vgwlat") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Write Latency').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rdvgWLAT" id="rdvgWLAT" value="low" '.is_checked($rdvgWLAT,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rdvgWLAT" id="rdvgWLAT" value="high" '.is_checked($rdvgWLAT,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvgwlatWar" id="txtvgwlatWar" value="' . htmlentities($txtvgwlatWar) . '"><br class="nobr" />
                
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvgwlatCrt" id="txtvgwlatCrt" value="' . htmlentities($txtvgwlatCrt) . '"><br class="nobr" />
                
            </td> 
              
        </tr>
        <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
            <input type="checkbox" class="checkbox" name="services[vgrthp]" id="services[vgrthp]" value="vgrthp"' . is_checked(grab_array_var($services, "vgrthp"), "vgrthp") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Read Throughput').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rdvgrthp" id="rdvgrthp" value="low" '.is_checked($rdvgrthp,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rdvgrthp" id="rdvgrthp" value="high" '.is_checked($rdvgrthp,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvgrthpWar" id="txtvgrthpWar" value="' . htmlentities($txtvgrthpWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvgrthpCrt" id="txtvgrthpCrt" value="' . htmlentities($txtvgrthpCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
        <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
                <input type="checkbox" class="checkbox" name="services[vgwthp]" id="services[vgwthp]" value="vgwthp"' . is_checked(grab_array_var($services, "vgwthp"), "vgwthp") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Write Throughput').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rdvgWTHP" id="rdvgWTHP" value="low" '.is_checked($rdvgWTHP,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rdvgWTHP" id="rdvgWTHP" value="high" '.is_checked($rdvgWTHP,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvgwthpWar" id="txtvgwthpWar" value="' . htmlentities($txtvgwthpWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtvgwthpCrt" id="txtvgwthpCrt" value="' . htmlentities($txtvgwthpCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
        <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
     </table>
     
    </td>
    
    </tr>
    
    <tr>
    <td width="5%">

    <td valign="top">
    <input type="checkbox" class="checkbox" name="services[con]" id="services[con]" value="con"' . is_checked(grab_array_var($services, "con"), "con") . ' onclick="checkVolumeConService();">
    </td>
    <td valign="top"> 
    <b>' . gettext('Volume Statistics by Controller') . '</b><br>
    ' . gettext('Track and report performance statistics by Controller for given array.') . '<br>
    
    <table width=75%>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
                <input type="checkbox" class="checkbox" name="services[conriop]" id="services[conriop]" value="conriop"' . is_checked(grab_array_var($services, "conriop"), "conriop") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Read IOPs').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rdconRIOP" id="rdconRIOP" value="low" '.is_checked($rdconRIOP,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rdconRIOP" id="rdconRIOP" value="high" '.is_checked($rdconRIOP,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtconiopWar" id="txtconiopWar" value="' . htmlentities($txtconiopWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtconiopCrt" id="txtconiopCrt" value="' . htmlentities($txtconiopCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
         <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
            <input type="checkbox" class="checkbox" name="services[conwiop]" id="services[conwiop]" value="conwiop"' . is_checked(grab_array_var($services, "conwiop"), "conwiop") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Write IOPs').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rdconWIOP" id="rdconWIOP" value="low" '.is_checked($rdconWIOP,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rdconWIOP" id="rdconWIOP" value="high" '.is_checked($rdconWIOP,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtconwiopWar" id="txtconwiopWar" value="' . htmlentities($txtconwiopWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtconwiopCrt" id="txtconwiopCrt" value="' . htmlentities($txtconwiopCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
         <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
            <input type="checkbox" class="checkbox" name="services[conrlat]" id="services[conrlat]" value="conrlat"' . is_checked(grab_array_var($services, "conrlat"), "conrlat") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Read Latency').'
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rdconRLAT" id="rdconRLAT" value="low" '.is_checked($rdconRLAT,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rdconRLAT" id="rdconRLAT" value="high" '.is_checked($rdconRLAT,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
            
                
                Low&nbsp;&nbsp;
                
                High&nbsp;&nbsp;
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtconrlatWar" id="txtconrlatWar" value="' . htmlentities($txtconrlatWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtconrlatCrt" id="txtconrlatCrt" value="' . htmlentities($txtconrlatCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
         <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
            <input type="checkbox" class="checkbox" name="services[conwlat]" id="services[conwlat]" value="conwlat"' . is_checked(grab_array_var($services, "conwlat"), "conwlat") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Write Latency').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rdconWLAT" id="rdconWLAT" value="low" '.is_checked($rdconWLAT,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rdconWLAT" id="rdconWLAT" value="high" '.is_checked($rdconWLAT,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
            
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtconwlatWar" id="txtconwlatWar" value="' . htmlentities($txtconwlatWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtconwlatCrt" id="txtconwlatCrt" value="' . htmlentities($txtconwlatCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
         <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
                <input type="checkbox" class="checkbox" name="services[conrthp]" id="services[conrthp]" value="conrthp"' . is_checked(grab_array_var($services, "conrthp"), "conrthp") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Read Throughput').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rdconrthp" id="rdconrthp" value="low" '.is_checked($rdconrthp,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rdconrthp" id="rdconrthp" value="high" '.is_checked($rdconrthp,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtconrthpWar" id="txtconrthpWar" value="' . htmlentities($txtconrthpWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtconrthpCrt" id="txtconrthpCrt" value="' . htmlentities($txtconrthpCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
         <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
                <input type="checkbox" class="checkbox" name="services[conwthp]" id="services[conwthp]" value="conwthp"' . is_checked(grab_array_var($services, "conwthp"), "conwthp") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Write Throughput').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rdconWTHP" id="rdconWTHP" value="low" '.is_checked($rdconWTHP,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rdconWTHP" id="rdconWTHP" value="high" '.is_checked($rdconWTHP,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtconwthpWar" id="txtconwthpWar" value="' . htmlentities($txtconwthpWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtconwthpCrt" id="txtconwthpCrt" value="' . htmlentities($txtconwthpCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
         <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        </table>
        </td>
        </tr>
        
        <tr>
    <td width="5%"></td>
    <td valign="top">
    <input type="checkbox" class="checkbox" name="services[drv]" id="services[drv]" value="drv"' . is_checked(grab_array_var($services, "drv"), "drv") . ' onclick="checkDriveService();">
    </td>
    <td valign="top"><b>' . gettext('Drive Statistics') . '</b><br>
    ' . gettext('Track and report performance statistics by drives for given array.') . '<br>
    
    <table width=75%>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
                <input type="checkbox" class="checkbox" name="services[drvriop]" id="services[drvriop]" value="drvriop"' . is_checked(grab_array_var($services, "drvriop"), "drvriop") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Read IOPs').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rddrvRIOP" id="rddrvRIOP" value="low" '.is_checked($rddrvRIOP,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rddrvRIOP" id="rddrvRIOP" value="high" '.is_checked($rddrvRIOP,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
            
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtdrviopWar" id="txtdrviopWar" value="' . htmlentities($txtdrviopWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtdrviopCrt" id="txtdrviopCrt" value="' . htmlentities($txtdrviopCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
         <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
            <input type="checkbox" class="checkbox" name="services[drvwiop]" id="services[drvwiop]" value="drvwiop"' . is_checked(grab_array_var($services, "drvwiop"), "drvwiop") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Write IOPs').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rddrvWIOP" id="rddrvWIOP" value="low" '.is_checked($rddrvWIOP,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rddrvWIOP" id="rddrvWIOP" value="high" '.is_checked($rddrvWIOP,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
            
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtdrvwiopWar" id="txtdrvwiopWar" value="' . htmlentities($txtdrvwiopWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtdrvwiopCrt" id="txtdrvwiopCrt" value="' . htmlentities($txtdrvwiopCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
         <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
            <input type="checkbox" class="checkbox" name="services[drvrlat]" id="services[drvrlat]" value="drvrlat"' . is_checked(grab_array_var($services, "drvrlat"), "drvrlat") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Read Latency').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rddrvRLAT" id="rddrvRLAT" value="low" '.is_checked($rddrvRLAT,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rddrvRLAT" id="rddrvRLAT" value="high" '.is_checked($rddrvRLAT,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
           
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtdrvrlatWar" id="txtdrvrlatWar" value="' . htmlentities($txtdrvrlatWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtdrvrlatCrt" id="txtdrvrlatCrt" value="' . htmlentities($txtdrvrlatCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
         <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
                <input type="checkbox" class="checkbox" name="services[drvwlat]" id="services[drvwlat]" value="drvwlat"' . is_checked(grab_array_var($services, "drvwlat"), "drvwlat") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Write Latency').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rddrvWLAT" id="rddrvWLAT" value="low" '.is_checked($rddrvWLAT,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rddrvWLAT" id="rddrvWLAT" value="high" '.is_checked($rddrvWLAT,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
            
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label>
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtdrvwlatWar" id="txtdrvwlatWar" value="' . htmlentities($txtdrvwlatWar) . '"><br class="nobr" />
               
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label>
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtdrvwlatCrt" id="txtdrvwlatCrt" value="' . htmlentities($txtdrvwlatCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
         <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
            <input type="checkbox" class="checkbox" name="services[drvrthp]" id="services[drvrthp]" value="drvrthp"' . is_checked(grab_array_var($services, "drvrthp"), "drvrthp") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Read Throughput').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rddrvrthp" id="rddrvrthp" value="low" '.is_checked($rddrvrthp,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rddrvrthp" id="rddrvrthp" value="high" '.is_checked($rddrvrthp,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtdrvrthpWar" id="txtdrvrthpWar" value="' . htmlentities($txtdrvrthpWar) . '"><br class="nobr" />
                
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label><br class="nobr" />
            </td>
            <td valign="top"> 
                <input type="text" class="textfield" name="txtdrvrthpCrt" id="txtdrvrthpCrt" value="' . htmlentities($txtdrvrthpCrt) . '"><br class="nobr" />
                 
            </td> 
              
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top" width="2%">
            <input type="checkbox" class="checkbox" name="services[drvwthp]" id="services[drvwthp]" value="drvwthp"' . is_checked(grab_array_var($services, "drvwthp"), "drvwthp") . '>
            </td>
            <td valign="top" width="10%">
            '.gettext('Write Throughput').'&nbsp;&nbsp;
            </td>
            <td valign="top" width="20%">
             <table>
                <tr>
                <td colspan="4" align="center" valign="top">
                        <label> ' . gettext('Range Selector:') . '<label>
                </td>
                </tr>
                <tr>
                    <td><input type="radio" class="radio" name="rddrvWTHP" id="rddrvWTHP" value="low" '.is_checked($rddrvWTHP,"low").'></td>
                    <td>Low</td>
                    <td><input type="radio" class="radio" name="rddrvWTHP" id="rddrvWTHP" value="high" '.is_checked($rddrvWTHP,"high").'></td>
                    <td>High</td>
                </tr>
            </table>
 
             </td>
            <td valign="top">
             <label>' . gettext('Warning:') . '</label><br class="nobr" />
            </td>
            <td valign="top">
                <input type="text" class="textfield" name="txtdrvwthpWar" id="txtdrvwthpWar" value="' . htmlentities($txtdrvwthpWar) . '">
                
             </td>
            <td valign="top">
                <label>' . gettext('Critical:') . '</label>
            </td>
            <td valign="top"> 
                <input type="text" class="textfield" name="txtdrvwthpCrt" id="txtdrvwthpCrt" value="' . htmlentities($txtdrvwthpCrt) . '">
                 
            </td> 
              
        </tr>
         <tr>
            <td colspan="8"> &nbsp;</td>
        </tr>
        </table>
        </td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top">
            <input type="checkbox" class="checkbox" name="services[cachevol]" id="services[cachevol]" value="cachevol"' . is_checked(grab_array_var($services, "cachevol"), "cachevol") . ' onclick ="checkCacheService();">
            </td>
            <td valign="top">
            <b>' . gettext('Cache Statistics by Volume') . '</b><br>
            ' . gettext('Cache Statistics of the array by Volume.') . '<br class="nobr" />
            <table width="30%">
                <tr>
                    <td width="5%">
                    </td>
                    <td valign="top" width="2%">
                        <input type="checkbox" class="checkbox" name="services[cvprc]" id="services[cvprc]" value="cvprc"' . is_checked(grab_array_var($services, "cvprc"), "cvprc") . '>
                        </td><td valign="top">' . gettext('Primary Cache') . ' </td>
                        <td width="2%"><input type="checkbox" class="checkbox" name="services[cvssd]" id="services[cvssd]" value="cvssd"' . is_checked(grab_array_var($services, "cvssd"), "cvssd") . '>
                        </td><td valign="top">' . gettext('SSD Cache') . '
                    </td>
                </tr>
            </table>
            </td>
            </tr>
            <tr>
            <td colspan="3"> &nbsp;</td>
        </tr>
        <tr>
            <td width="5%"></td>
            <td valign="top">
            <input type="checkbox" class="checkbox" name="services[cachevg]" id="services[cachevg]" value="cachevg"' . is_checked(grab_array_var($services, "cachevg"), "cachevg") . ' onclick ="checkCacheVGService();">
            </td>
            <td valign="top">
            <b>' . gettext('Cache Statistics by Volume Group') . '</b><br>
            ' . gettext('Cache Statistics of the array by Volume Group.') . '<br class="nobr" />
            <table width="30%">
                <tr>
                    <td width="5%">
                    </td>
                    <td valign="top" width="2%">
                        <input type="checkbox" class="checkbox" name="services[cvgprc]" id="services[cvgprc]" value="cvgprc"' . is_checked(grab_array_var($services, "cvgprc"), "cvgprc") . '>
                        </td><td valign="top">' . gettext('Primary Cache') . '</td> <td valign="top" width="2%">
                        <input type="checkbox" class="checkbox" name="services[cvgssd]" id="services[cvgssd]" value="cvgssd"' . is_checked(grab_array_var($services, "cvgssd"), "cvgssd") . '>
                        </td><td valign="top">' . gettext('SSD Cache') . '
                    </td>
                </tr>
            </table>
            </td>
            </tr>
    </table>
            ';
            break;
        case CONFIGWIZARD_MODE_VALIDATESTAGE2DATA:
            $services = grab_array_var($inargs, "services", "");
            $txtSpWar = grab_array_var($inargs, "txtSpWar", "");
            $txtSpCrt = grab_array_var($inargs, "txtSpCrt", "");
            $txtTvCrt = grab_array_var($inargs, "txtTvCrt", "");
            $txtTvWar = grab_array_var($inargs, "txtTvWar", "");
            $txtPhtWar = grab_array_var($inargs, "txtPhtWar", "");
            $txtPhtCrt = grab_array_var($inargs, "txtPhtCrt", "");
            $txtSDCrt = grab_array_var($inargs, "txtSDCrt", "");
            $txtSDWar = grab_array_var($inargs, "txtSDWar", "");
            $chk_advance =grab_array_var($inargs, "chk_advance", "");
            $txtvoliopWar =grab_array_var($inargs,"txtvoliopWar","");
            $txtvoliopCrt =grab_array_var($inargs,"txtvoliopCrt","");
            $txtvolwiopWar = grab_array_var($inargs, "txtvolwiopWar", "");
            $txtvolwiopCrt = grab_array_var($inargs, "txtvolwiopCrt", "");
            $txtvolrlatWar = grab_array_var($inargs, "txtvolrlatWar", "");
            $txtvolrlatCrt = grab_array_var($inargs, "txtvolrlatCrt", "");

            $txtvolwlatWar = grab_array_var($inargs, "txtvolwlatWar", "");
            $txtvolwlatCrt = grab_array_var($inargs, "txtvolwlatCrt", "");

            $txtvolrthpWar = grab_array_var($inargs, "txtvolrthpWar", "");
            $txtvolrthpCrt = grab_array_var($inargs, "txtvolrthpCrt", "");
            $txtvolwthpWar = grab_array_var($inargs, "txtvolwthpWar", "");
            $txtvolwthpCrt = grab_array_var($inargs, "txtvolwthpCrt", "");

            $txtvgiopWar = grab_array_var($inargs, "txtvgiopWar", "");
            $txtvgiopCrt = grab_array_var($inargs, "txtvgiopCrt", "");
            $txtvgwiopWar = grab_array_var($inargs, "txtvgwiopWar", "");
            $txtvgwiopCrt = grab_array_var($inargs, "txtvgwiopCrt", "");
            $txtvgrlatWar = grab_array_var($inargs, "txtvgrlatWar", "");
            $txtvgrlatCrt = grab_array_var($inargs, "txtvgrlatCrt", "");

             $txtvgwlatWar = grab_array_var($inargs, "txtvgwlatWar", "");
            $txtvgwlatCrt = grab_array_var($inargs, "txtvgwlatCrt", "");

            $txtvgrthpWar = grab_array_var($inargs, "txtvgrthpWar", "");
            $txtvgrthpCrt = grab_array_var($inargs, "txtvgrthpCrt", "");
            $txtvgwthpWar = grab_array_var($inargs, "txtvgwthpWar", "");
            $txtvgwthpCrt = grab_array_var($inargs, "txtvgwthpCrt", "");

             $rdvgRIOP = grab_array_var($inargs,"rdvgRIOP","");
            $rdvgWLAT = grab_array_var($inargs,"rdvgWLAT","");
            $rdvgrthp = grab_array_var($inargs,"rdvgrthp","");
            $rdvgWTHP = grab_array_var($inargs,"rdvgWTHP","");
            $rdvgRLAT = grab_array_var($inargs,"rdvgRLAT","");
            $rdvgWIOP = grab_array_var($inargs,"rdvgWIOP","");

            $rdVol= grab_array_var($inargs,"rdVol","");
            $rdVolWLAT = grab_array_var($inargs,"rdVolWLAT","");
            $rdVolrthp = grab_array_var($inargs,"rdVolrthp","");
            $rdVolWTHP = grab_array_var($inargs,"rdVolWTHP","");
            $rdVolRLAT = grab_array_var($inargs,"rdVolRLAT","");
            $rdVolWIOP = grab_array_var($inargs,"rdVolWIOP","");
            $rdconRIOP= grab_array_var($inargs,"rdconRIOP","");
            $rdconWLAT = grab_array_var($inargs,"rdconWLAT","");
            $rdconrthp = grab_array_var($inargs,"rdconrthp","");
            $rdconWTHP = grab_array_var($inargs,"rdconWTHP","");
            $rdconRLAT = grab_array_var($inargs,"rdconRLAT","");
            $rdconWIOP = grab_array_var($inargs,"rdconWIOP","");
            $rddrvRIOP= grab_array_var($inargs,"rddrvRIOP","");
            $rddrvWLAT = grab_array_var($inargs,"rddrvWLAT","");
            $rddrvrthp = grab_array_var($inargs,"rddrvrthp","");
            $rddrvWTHP = grab_array_var($inargs,"rddrvWTHP","");
            $rddrvRLAT = grab_array_var($inargs,"rddrvRLAT","");
            $rddrvWIOP = grab_array_var($inargs,"rddrvWIOP","");

            $txtconiopWar = grab_array_var($inargs, "txtconiopWar", "");
            $txtconiopCrt = grab_array_var($inargs, "txtconiopCrt", "");
            $txtconwiopWar = grab_array_var($inargs, "txtconwiopWar", "");
            $txtconwiopCrt = grab_array_var($inargs, "txtconwiopCrt", "");
            $txtconrlatWar = grab_array_var($inargs, "txtconrlatWar", "");
            $txtconrlatCrt = grab_array_var($inargs, "txtconrlatCrt", "");
            $txtconwlatWar = grab_array_var($inargs, "txtconwlatWar", "");
            $txtconwlatCrt = grab_array_var($inargs, "txtconwlatCrt", "");
            $txtconrthpWar = grab_array_var($inargs, "txtconrthpWar", "");
            $txtconrthpCrt = grab_array_var($inargs, "txtconrthpCrt", "");
            $txtconwthpWar = grab_array_var($inargs, "txtconwthpWar", "");
            $txtconwthpCrt = grab_array_var($inargs, "txtconwthpCrt", "");

            $txtdrviopWar = grab_array_var($inargs, "txtdrviopWar", "");
            $txtdrviopCrt = grab_array_var($inargs, "txtdrviopCrt", "");
            $txtdrvwiopWar = grab_array_var($inargs, "txtdrvwiopWar", "");
            $txtdrvwiopCrt = grab_array_var($inargs, "txtdrvwiopCrt", "");
            $txtdrvrlatWar = grab_array_var($inargs, "txtdrvrlatWar", "");
            $txtdrvrlatCrt = grab_array_var($inargs, "txtdrvrlatCrt", "");
            $txtdrvwlatWar = grab_array_var($inargs, "txtdrvwlatWar", "");
            $txtdrvwlatCrt = grab_array_var($inargs, "txtdrvwlatCrt", "");
            $txtdrvrthpWar = grab_array_var($inargs, "txtdrvrthpWar", "");
            $txtdrvrthpCrt = grab_array_var($inargs, "txtdrvrthpCrt", "");
            $txtdrvwthpWar = grab_array_var($inargs, "txtdrvwthpWar", "");
            $txtdrvwthpCrt = grab_array_var($inargs, "txtdrvwthpCrt", "");

            
            $errors = 0;
            $errmsg = array();
            
            foreach ($services as $var => $val)
            {
                
                switch($var){
                    case "stpool":
                        if (!have_value($txtSpWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold for Storage Pool.");
                        elseif (have_value($txtSpWar) && !is_numeric($txtSpWar) ) 
                            $errmsg[$errors++] = gettext("Invalid Warning threshold for Storage Pool.");
                        if (have_value($txtSpCrt) == false )
                            $errmsg[$errors++] = gettext("Please enter Critical threshold for Storage Pool.");
                        elseif (have_value($txtSpCrt) && !is_numeric($txtSpCrt) ) 
                            $errmsg[$errors++] = gettext("Invalid Critical threshold for Storage Pool.");
                        if (have_value($txtSpWar) &&  have_value($txtSpCrt) && $txtSpWar >=$txtSpCrt)
                            $errmsg[$errors++] = gettext("Invalid threshold values for Storage Pool, Critical threshold must be greater than Warning threshold.");
             
                    break;

                    case "thinvol":
                        if (!have_value($txtTvWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold for Thin Volumes.");
                        elseif (have_value($txtTvWar) && !is_numeric($txtTvWar) ) 
                            $errmsg[$errors++] = gettext("Invalid Warning threshold for Thin Volumes.");
                        if (have_value($txtTvCrt) == false )
                            $errmsg[$errors++] = gettext("Please enter Critical threshold for Thin Volumes.");
                        elseif (have_value($txtTvCrt) && (!is_numeric($txtTvCrt) || $txtTvCrt < 5) ) 
                            $errmsg[$errors++] = gettext("Invalid Critical threshold for Thin Volumes.");
                        if (have_value($txtTvWar) &&  have_value($txtTvCrt) && $txtTvWar <=$txtTvCrt)
                            $errmsg[$errors++] = gettext("Invalid threshold values for Thin Volumes, Critical threshold must be less than Warning threshold.");
                        break;
                    case "phytmp":
                        if (!have_value($txtPhtWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold for monitoring Physical Component Temperature.");
                        elseif (have_value($txtPhtWar) && !is_numeric($txtPhtWar) ) 
                            $errmsg[$errors++] = gettext("Invalid Warning threshold for monitoring Physical Component Temperature.");
                        if (have_value($txtPhtCrt) == false )
                            $errmsg[$errors++] = gettext("Please enter Critical threshold for monitoring Physical Component Temperature.");
                        elseif (have_value($txtPhtCrt) && !is_numeric($txtPhtCrt) ) 
                            $errmsg[$errors++] = gettext("Invalid Critical threshold for monitoring Physical Component Temperature.");
                        if (have_value($txtPhtWar) &&  have_value($txtPhtCrt) && $txtPhtWar >=$txtPhtCrt)
                            $errmsg[$errors++] = gettext("Invalid threshold values for monitoring Physical Component Temperature, Critical threshold must be greater than Warning threshold.");
             
                        break;
                    case "ssd":
                        if (!have_value($txtSDWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold for monitoring SSD Drives.");
                        elseif (have_value($txtSDWar) && !is_numeric($txtSDWar) ) 
                            $errmsg[$errors++] = gettext("Invalid Warning threshold for monitoring SSD Drives.");
                        if (have_value($txtSDCrt) == false )
                            $errmsg[$errors++] = gettext("Please enter Critical threshold for monitoring SSD Drives.");
                        elseif (have_value($txtSDCrt) && !is_numeric($txtSDCrt) ) 
                            $errmsg[$errors++] = gettext("Invalid Critical threshold for monitoring SSD Drives.");
                        if (have_value($txtSDWar) &&  have_value($txtSDCrt) && $txtSDWar >=$txtSDCrt)
                            $errmsg[$errors++] = gettext("Invalid threshold values for monitoring SSD Drives, Critical threshold must be greater than Warning threshold.");
             
                        break; 
                    case "volriop":
                            if (!have_value($txtvoliopWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold for Read IOP statistics by Volume.");
                            elseif (have_value($txtvoliopWar) && !is_numeric($txtvoliopWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Read IOP statistics by Volume.");
                            if (have_value($txtvoliopCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold  for Read IOP statistics by Volume.");
                            elseif (have_value($txtvoliopCrt) && !is_numeric($txtvoliopCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold  for Read IOP statistics by Volume.");
                            if (have_value($txtvoliopWar) &&  have_value($txtvoliopCrt) && $rdVol =='high' && $txtvoliopWar >=$txtvoliopCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values  for Read IOP statistics by Volume, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtvoliopWar) &&  have_value($txtvoliopCrt) && $rdVol =='low' && $txtvoliopWar <=$txtvoliopCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values  for Read IOP statistics by Volume, Critical threshold must be less than Warning threshold.");
                            break;
                    case "volwiop":
                            if (!have_value($txtvolwiopWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Write IOP statistics by Volume.");
                            elseif (have_value($txtvolwiopWar) && !is_numeric($txtvolwiopWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Write IOP statistics by Volume.");
                            if (have_value($txtvolwiopCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Write IOP statistics by Volume.");
                            elseif (have_value($txtvolwiopCrt) && !is_numeric($txtvolwiopCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Write IOP statistics by Volume.");
                            if (have_value($txtvolwiopWar) &&  have_value($txtvolwiopCrt) && $rdVolWIOP =='high' && $txtvolwiopWar >=$txtvolwiopCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write IOP statistics by Volume, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtvolwiopWar) &&  have_value($txtvolwiopCrt) && $rdVolWIOP =='low' && $txtvolwiopWar <=$txtvolwiopCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write IOP statistics by Volume, Critical threshold must be less than Warning threshold.");
                            break;
                    case "volrlat":
                            if (!have_value($txtvolrlatWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Read Latency statistics by Volume.");
                            elseif (have_value($txtvolrlatWar) && !is_numeric($txtvolrlatWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Read Latency statistics by Volume.");
                            if (have_value($txtvolrlatCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Read Latency statistics by Volume.");
                            elseif (have_value($txtvolrlatCrt) && !is_numeric($txtvolrlatCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Read Latency statistics by Volume.");
                            if (have_value($txtvolrlatWar) &&  have_value($txtvolrlatCrt) && $rdVolRLAT =='high' && $txtvolrlatWar >=$txtvolrlatCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Read Latency statistics by Volume, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtvolrlatWar) &&  have_value($txtvolrlatCrt) && $rdVolRLAT =='low' && $txtvolrlatWar <=$txtvolrlatCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Read Latency statistics by Volume, Critical threshold must be less than Warning threshold.");
                            break;
                    case "volwlat":
                            if (!have_value($txtvolwlatWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Write Latency statistics by Volume.");
                            elseif (have_value($txtvolwlatWar) && !is_numeric($txtvolwlatWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Write Latency statistics by Volume.");
                            if (have_value($txtvolwlatCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Write Latency statistics by Volume.");
                            elseif (have_value($txtvolwlatCrt) && !is_numeric($txtvolwlatCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Write Latency statistics by Volume.");
                            if (have_value($txtvolwlatWar) &&  have_value($txtvolwlatCrt) && $rdVolWLAT =='high' && $txtvolwlatWar >=$txtvolwlatCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write Latency statistics by Volume, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtvolwlatWar) &&  have_value($txtvolwlatCrt) && $rdVolWLAT =='low' && $txtvolwlatWar <=$txtvolwlatCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write Latency statistics by Volume, Critical threshold must be less than Warning threshold.");
                            break;
                    case "volrthp":
                            if (!have_value($txtvolrthpWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Read Throughput statistics by Volume.");
                            elseif (have_value($txtvolrthpWar) && !is_numeric($txtvolrthpWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Read Throughput statistics by Volume.");
                            if (have_value($txtvolrthpCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Read Throughput statistics by Volume.");
                            elseif (have_value($txtvolrthpCrt) && !is_numeric($txtvolrthpCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Read Throughput statistics by Volume.");
                            if (have_value($txtvolrthpWar) &&  have_value($txtvolrthpCrt) && $rdVolrthp =='high' && $txtvolrthpWar >=$txtvolrthpCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Read Throughput statistics by Volume, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtvolrthpWar) &&  have_value($txtvolrthpCrt) && $rdVolrthp =='low' && $txtvolrthpWar <=$txtvolrthpCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Read Throughput statistics by Volume, Critical threshold must be less than Warning threshold.");
                            break;
                    case "volwthp":
                            if (!have_value($txtvolwthpWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Write Throughput statistics by Volume.");
                            elseif (have_value($txtvolwthpWar) && !is_numeric($txtvolwthpWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Write Throughput statistics by Volume.");
                            if (have_value($txtvolwthpCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Write Throughput statistics by Volume.");
                            elseif (have_value($txtvolwthpCrt) && !is_numeric($txtvolwthpCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Write Throughput statistics by Volume.");
                            if (have_value($txtvolwthpWar) &&  have_value($txtvolwthpCrt) && $rdVolWTHP =='high' && $txtvolwthpWar >=$txtvolwthpCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write Throughput statistics by Volume, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtvolwthpWar) &&  have_value($txtvolwthpCrt) && $rdVolWTHP =='low' && $txtvolwthpWar <=$txtvolwthpCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write Throughput statistics by Volume, Critical threshold must be less than Warning threshold.");
                            break;
                    case "vgriop":
                            if (!have_value($txtvgiopWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold for Read IOP statistics by Volume Group.");
                            elseif (have_value($txtvgiopWar) && !is_numeric($txtvgiopWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Read IOP statistics by Volume Group.");
                            if (have_value($txtvgiopCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold  for Read IOP statistics by Volume Group.");
                            elseif (have_value($txtvgiopCrt) && !is_numeric($txtvgiopCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold  for Read IOP statistics by Volume Group.");
                            if (have_value($txtvgiopWar) &&  have_value($txtvgiopCrt) && $rdvgRIOP =='high' && $txtvgiopWar >=$txtvgiopCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values  for Read IOP statistics by Volume Group, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtvgiopWar) &&  have_value($txtvgiopCrt) && $rdvgRIOP =='low' && $txtvgiopWar <=$txtvgiopCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values  for Read IOP statistics by Volume Group, Critical threshold must be less than Warning threshold.");
                            break;        
                    case "vgwiop":
                            if (!have_value($txtvgwiopWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Write IOP statistics by Volume Group.");
                            elseif (have_value($txtvgwiopWar) && !is_numeric($txtvgwiopWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Write IOP statistics by Volume Group.");
                            if (have_value($txtvgwiopCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Write IOP statistics by Volume Group.");
                            elseif (have_value($txtvgwiopCrt) && !is_numeric($txtvgwiopCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Write IOP statistics by Volume Group.");
                            if (have_value($txtvgwiopWar) &&  have_value($txtvgwiopCrt) && $rdvgWIOP =='high' && $txtvgwiopWar >=$txtvgwiopCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write IOP statistics by Volume Group, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtvgwiopWar) &&  have_value($txtvgwiopCrt) && $rdvgWIOP =='low' && $txtvgwiopWar <=$txtvgwiopCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write IOP statistics by Volume Group, Critical threshold must be less than Warning threshold.");
                            break;
                    case "vgrlat":
                            if (!have_value($txtvgrlatWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Read Latency statistics by Volume Group.");
                            elseif (have_value($txtvgrlatWar) && !is_numeric($txtvgrlatWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Read Latency statistics by Volume Group.");
                            if (have_value($txtvgrlatCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Read Latency statistics by Volume Group.");
                            elseif (have_value($txtvgrlatCrt) && !is_numeric($txtvgrlatCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Read Latency statistics by Volume Group.");
                            if (have_value($txtvgrlatWar) &&  have_value($txtvgrlatCrt) && $rdvgRLAT =='high' && $txtvgrlatWar >=$txtvgrlatCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Read Latency statistics by Volume Group, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtvgrlatWar) &&  have_value($txtvgrlatCrt) && $rdvgRLAT =='low' && $txtvgrlatWar <=$txtvgrlatCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Read Latency statistics by Volume Group, Critical threshold must be less than Warning threshold.");
                            break;
                    case "vgwlat":
                            if (!have_value($txtvgwlatWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Write Latency statistics by Volume Group.");
                            elseif (have_value($txtvgwlatWar) && !is_numeric($txtvgwlatWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Write Latency statistics by Volume Group.");
                            if (have_value($txtvgwlatCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Write Latency statistics by Volume Group.");
                            elseif (have_value($txtvgwlatCrt) && !is_numeric($txtvgwlatCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Write Latency statistics by Volume Group.");
                            if (have_value($txtvgwlatWar) &&  have_value($txtvgwlatCrt) && $rdvgWLAT =='high' && $txtvgwlatWar >=$txtvgwlatCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write Latency statistics by Volume Group, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtvgwlatWar) &&  have_value($txtvgwlatCrt) && $rdvgWLAT =='low' && $txtvgwlatWar <=$txtvgwlatCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write Latency statistics by Volume Group, Critical threshold must be less than Warning threshold.");
                            break;
                    case "vgrthp":
                            if (!have_value($txtvgrthpWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Read Throughput statistics by Volume Group.");
                            elseif (have_value($txtvgrthpWar) && !is_numeric($txtvgrthpWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Read Throughput statistics by Volume Group.");
                            if (have_value($txtvgrthpCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Read Throughput statistics by Volume Group.");
                            elseif (have_value($txtvgrthpCrt) && !is_numeric($txtvgrthpCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Read Throughput statistics by Volume Group.");
                            if (have_value($txtvgrthpWar) &&  have_value($txtvgrthpCrt) && $rdvgrthp =='high' && $txtvgrthpWar >=$txtvgrthpCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Read Throughput statistics by Volume Group, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtvgrthpWar) &&  have_value($txtvgrthpCrt) && $rdvgrthp =='low' && $txtvgrthpWar <=$txtvgrthpCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Read Throughput statistics by Volume Group, Critical threshold must be less than Warning threshold.");
                            break;
                    case "vgwthp":
                            if (!have_value($txtvgwthpWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Write Throughput statistics by Volume Group.");
                            elseif (have_value($txtvgwthpWar) && !is_numeric($txtvgwthpWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Write Throughput statistics by Volume Group.");
                            if (have_value($txtvgwthpCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Write Throughput statistics by Volume Group.");
                            elseif (have_value($txtvgwthpCrt) && !is_numeric($txtvgwthpCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Write Throughput statistics by Volume Group.");
                            if (have_value($txtvgwthpWar) &&  have_value($txtvgwthpCrt) && $rdvgWTHP =='high' && $txtvgwthpWar >=$txtvgwthpCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write Throughput statistics by Volume Group, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtvgwthpWar) &&  have_value($txtvgwthpCrt) && $rdvgWTHP =='low' && $txtvgwthpWar <=$txtvgwthpCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write Throughput statistics by Volume Group, Critical threshold must be less than Warning threshold.");
                            break;  
                    case "conriop":
                            if (!have_value($txtconiopWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold for Read IOP statistics by Controller.");
                            elseif (have_value($txtconiopWar) && !is_numeric($txtconiopWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Read IOP statistics by Controller.");
                            if (have_value($txtconiopCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold  for Read IOP statistics by Controller.");
                            elseif (have_value($txtconiopCrt) && !is_numeric($txtconiopCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold  for Read IOP statistics by Controller.");
                            if (have_value($txtconiopWar) &&  have_value($txtconiopCrt) && $rdconRIOP =='high' && $txtconiopWar >=$txtconiopCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values  for Read IOP statistics by Controller, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtconiopWar) &&  have_value($txtconiopCrt) && $rdconRIOP =='low' && $txtconiopWar <=$txtconiopCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values  for Read IOP statistics by Controller, Critical threshold must be less than Warning threshold.");
                            break;        
                    case "conwiop":
                            if (!have_value($txtconwiopWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Write IOP statistics by Controller.");
                            elseif (have_value($txtconwiopWar) && !is_numeric($txtconwiopWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Write IOP statistics by Controller.");
                            if (have_value($txtconwiopCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Write IOP statistics by Controller.");
                            elseif (have_value($txtconwiopCrt) && !is_numeric($txtconwiopCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Write IOP statistics by Controller.");
                            if (have_value($txtconwiopWar) &&  have_value($txtconwiopCrt) && $rdconWIOP =='high' && $txtconwiopWar >=$txtconwiopCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write IOP statistics by Controller, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtconwiopWar) &&  have_value($txtconwiopCrt) && $rdconWIOP =='low' && $txtconwiopWar <=$txtconwiopCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write IOP statistics by Controller, Critical threshold must be less than Warning threshold.");
                            break;
                    case "conrlat":
                            if (!have_value($txtconrlatWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Read Latency statistics by Controller.");
                            elseif (have_value($txtconrlatWar) && !is_numeric($txtconrlatWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Read Latency statistics by Controller.");
                            if (have_value($txtconrlatCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Read Latency statistics by Controller.");
                            elseif (have_value($txtconrlatCrt) && !is_numeric($txtconrlatCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Read Latency statistics by Controller.");
                            if (have_value($txtconrlatWar) &&  have_value($txtconrlatCrt) && $rdconRLAT =='high' && $txtconrlatWar >=$txtconrlatCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Read Latency statistics by Controller, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtconrlatWar) &&  have_value($txtconrlatCrt) && $rdconRLAT =='low' && $txtconrlatWar <=$txtconrlatCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Read Latency statistics by Controller, Critical threshold must be less than Warning threshold.");
                            break;
                    case "conwlat":
                            if (!have_value($txtconwlatWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Write Latency statistics by Controller.");
                            elseif (have_value($txtconwlatWar) && !is_numeric($txtconwlatWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Write Latency statistics by Controller.");
                            if (have_value($txtconwlatCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Write Latency statistics by Controller.");
                            elseif (have_value($txtconwlatCrt) && !is_numeric($txtconwlatCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Write Latency statistics by Controller.");
                            if (have_value($txtconwlatWar) &&  have_value($txtconwlatCrt) && $rdconWLAT =='high' && $txtconwlatWar >=$txtconwlatCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write Latency statistics by Controller, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtconwlatWar) &&  have_value($txtconwlatCrt) && $rdconWLAT =='low' && $txtconwlatWar <=$txtconwlatCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write Latency statistics by Controller, Critical threshold must be less than Warning threshold.");
                            break;
                    case "conrthp":
                            if (!have_value($txtconrthpWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Read Throughput statistics by Controller.");
                            elseif (have_value($txtconrthpWar) && !is_numeric($txtconrthpWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Read Throughput statistics by Controller.");
                            if (have_value($txtconrthpCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Read Throughput statistics by Controller.");
                            elseif (have_value($txtconrthpCrt) && !is_numeric($txtconrthpCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Read Throughput statistics by Controller.");
                            if (have_value($txtconrthpWar) &&  have_value($txtconrthpCrt) && $rdconrthp =='high' && $txtconrthpWar >=$txtconrthpCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Read Throughput statistics by Controller, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtconrthpWar) &&  have_value($txtconrthpCrt) && $rdconrthp =='low' && $txtconrthpWar <=$txtconrthpCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Read Throughput statistics by Controller, Critical threshold must be less than Warning threshold.");
                            break;
                    case "conwthp":
                            if (!have_value($txtconwthpWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Write Throughput statistics by Controller.");
                            elseif (have_value($txtconwthpWar) && !is_numeric($txtconwthpWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Write Throughput statistics by Controller.");
                            if (have_value($txtconwthpCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Write Throughput statistics by Controller.");
                            elseif (have_value($txtconwthpCrt) && !is_numeric($txtconwthpCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Write Throughput statistics by Controller.");
                            if (have_value($txtconwthpWar) &&  have_value($txtconwthpCrt) && $rdconWTHP =='high' && $txtconwthpWar >=$txtconwthpCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write Throughput statistics by Controller, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtconwthpWar) &&  have_value($txtconwthpCrt) && $rdconWTHP =='low' && $txtconwthpWar <=$txtconwthpCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write Throughput statistics by Controller, Critical threshold must be less than Warning threshold.");
                            break; 
                    
                    case "drvriop":
                            if (!have_value($txtdrviopWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold for Read IOP statistics by Drive.");
                            elseif (have_value($txtdrviopWar) && !is_numeric($txtdrviopWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Read IOP statistics by Drive.");
                            if (have_value($txtdrviopCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold  for Read IOP statistics by Drive.");
                            elseif (have_value($txtdrviopCrt) && !is_numeric($txtdrviopCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold  for Read IOP statistics by Drive.");
                            if (have_value($txtdrviopWar) &&  have_value($txtdrviopCrt) && $rddrvRIOP =='high' && $txtdrviopWar >=$txtdrviopCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values  for Read IOP statistics by Drive, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtdrviopWar) &&  have_value($txtdrviopCrt) && $rddrvRIOP =='low' && $txtdrviopWar <=$txtdrviopCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values  for Read IOP statistics by Drive, Critical threshold must be less than Warning threshold.");
                            break;        
                    case "drvwiop":
                            if (!have_value($txtdrvwiopWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Write IOP statistics by Drive.");
                            elseif (have_value($txtdrvwiopWar) && !is_numeric($txtdrvwiopWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Write IOP statistics by Drive.");
                            if (have_value($txtdrvwiopCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Write IOP statistics by Drive.");
                            elseif (have_value($txtdrvwiopCrt) && !is_numeric($txtdrvwiopCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Write IOP statistics by Drive.");
                            if (have_value($txtdrvwiopWar) &&  have_value($txtdrvwiopCrt) && $rddrvWIOP =='high' && $txtdrvwiopWar >=$txtdrvwiopCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write IOP statistics by Drive, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtdrvwiopWar) &&  have_value($txtdrvwiopCrt) && $rddrvWIOP =='low' && $txtdrvwiopWar <=$txtdrvwiopCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write IOP statistics by Drive, Critical threshold must be less than Warning threshold.");
                            break;
                    case "drvrlat":
                            if (!have_value($txtdrvrlatWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Read Latency statistics by Drive.");
                            elseif (have_value($txtdrvrlatWar) && !is_numeric($txtdrvrlatWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Read Latency statistics by Drive.");
                            if (have_value($txtdrvrlatCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Read Latency statistics by Drive.");
                            elseif (have_value($txtdrvrlatCrt) && !is_numeric($txtdrvrlatCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Read Latency statistics by Drive.");
                            if (have_value($txtdrvrlatWar) &&  have_value($txtdrvrlatCrt) && $rddrvRLAT =='high' && $txtdrvrlatWar >=$txtdrvrlatCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Read Latency statistics by Drive, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtdrvrlatWar) &&  have_value($txtdrvrlatCrt) && $rddrvRLAT =='low' && $txtdrvrlatWar <=$txtdrvrlatCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Read Latency statistics by Drive, Critical threshold must be less than Warning threshold.");
                            break;
                    case "drvwlat":
                            if (!have_value($txtdrvwlatWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Write Latency statistics by Drive.");
                            elseif (have_value($txtdrvwlatWar) && !is_numeric($txtdrvwlatWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Write Latency statistics by Drive.");
                            if (have_value($txtdrvwlatCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Write Latency statistics by Drive.");
                            elseif (have_value($txtdrvwlatCrt) && !is_numeric($txtdrvwlatCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Write Latency statistics by Drive.");
                            if (have_value($txtdrvwlatWar) &&  have_value($txtdrvwlatCrt) && $rddrvWLAT =='high' && $txtdrvwlatWar >=$txtdrvwlatCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write Latency statistics by Drive, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtdrvwlatWar) &&  have_value($txtdrvwlatCrt) && $rddrvWLAT =='low' && $txtdrvwlatWar <=$txtdrvwlatCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write Latency statistics by Drive, Critical threshold must be less than Warning threshold.");
                            break;
                    case "drvrthp":
                            if (!have_value($txtdrvrthpWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Read Throughput statistics by Drive.");
                            elseif (have_value($txtdrvrthpWar) && !is_numeric($txtdrvrthpWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Read Throughput statistics by Drive.");
                            if (have_value($txtdrvrthpCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Read Throughput statistics by Drive.");
                            elseif (have_value($txtdrvrthpCrt) && !is_numeric($txtdrvrthpCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Read Throughput statistics by Drive.");
                            if (have_value($txtdrvrthpWar) &&  have_value($txtdrvrthpCrt) && $rddrvrthp =='high' && $txtdrvrthpWar >=$txtdrvrthpCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Read Throughput statistics by Drive, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtdrvrthpWar) &&  have_value($txtdrvrthpCrt) && $rddrvrthp =='low' && $txtdrvrthpWar <=$txtdrvrthpCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Read Throughput statistics by Drive, Critical threshold must be less than Warning threshold.");
                            break;
                    case "drvwthp":
                            if (!have_value($txtdrvwthpWar))
                            $errmsg[$errors++] = gettext("Please enter Warning threshold  for Write Throughput statistics by Drive.");
                            elseif (have_value($txtdrvwthpWar) && !is_numeric($txtdrvwthpWar) ) 
                                $errmsg[$errors++] = gettext("Invalid Warning threshold for Write Throughput statistics by Drive.");
                            if (have_value($txtdrvwthpCrt) == false )
                                $errmsg[$errors++] = gettext("Please enter Critical threshold for Write Throughput statistics by Drive.");
                            elseif (have_value($txtdrvwthpCrt) && !is_numeric($txtdrvwthpCrt) ) 
                                $errmsg[$errors++] = gettext("Invalid Critical threshold for Write Throughput statistics by Drive.");
                            if (have_value($txtdrvwthpWar) &&  have_value($txtdrvwthpCrt) && $rddrvWTHP =='high' && $txtdrvwthpWar >=$txtdrvwthpCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write Throughput statistics by Drive, Critical threshold must be greater than Warning threshold.");
                            if (have_value($txtdrvwthpWar) &&  have_value($txtdrvwthpCrt) && $rddrvWTHP =='low' && $txtdrvwthpWar <=$txtdrvwthpCrt)
                                $errmsg[$errors++] = gettext("Invalid threshold values for Write Throughput statistics by Drive, Critical threshold must be less than Warning threshold.");
                            break;                                              
                    
                }

                if (in_array("cachevol", services) && !in_array("cvprc", services) && !in_array("cvssd", services) )
                    $errmsg[$errors++] = gettext("Please select atleast one mode for Cache Statistics by Volume.");
                
            }
            if ($errors > 0) {
                $outargs[CONFIGWIZARD_ERROR_MESSAGES] = $errmsg;
                $result = 1;
            }
            break;
        case CONFIGWIZARD_MODE_GETSTAGE3HTML:

            // get variables that were passed to us
            $webproxy = grab_array_var($inargs, "webproxy");
            $webproxyport = grab_array_var($inargs, "webproxyport");
            $services = grab_array_var($inargs, "services");
            $serviceargs = grab_array_var($inargs, "serviceargs");
            $phycomp_mode = grab_array_var($inargs, "phycomp_mode");
            $logicalcomp_mode = grab_array_var($inargs, "logicalcomp_mode");
            $performance_mode = grab_array_var($inargs, "performance_mode");
            $arrayname = grab_array_var($inargs, "arrayname");
            $username = grab_array_var($inargs, "username");
            $password = grab_array_var($inargs, "password");
            $ip1 = grab_array_var($inargs, "ip1");
            $ip2 = grab_array_var($inargs, "ip2");
            $txtvoliopCrt = grab_array_var($inargs, "txtvoliopCrt");
            $txtvoliopWar = grab_array_var($inargs, "txtvoliopWar");
            $txtvolwiopWar = grab_array_var($inargs, "txtvolwiopWar");
            $txtvolwiopCrt = grab_array_var($inargs, "txtvolwiopCrt");
            $rdVol = grab_array_var($inargs,"rdVol");
            $txtvolrlatWar = grab_array_var($inargs, "txtvolrlatWar");
            $txtvolrlatCrt = grab_array_var($inargs, "txtvolrlatCrt");
            $rdVolRLAT = grab_array_var($inargs,"rdVolRLAT");
            $rdVolWIOP = grab_array_var($inargs,"rdVolWIOP");
            $txtSpCrt = grab_array_var($inargs, "txtSpCrt");
            $txtSpWar = grab_array_var($inargs, "txtSpWar");
            $txtTvCrt = grab_array_var($inargs, "txtTvCrt");
            $txtTvWar = grab_array_var($inargs, "txtTvWar");
            $txtPhtWar= grab_array_var($inargs, "txtPhtWar");
            $txtPhtCrt= grab_array_var($inargs, "txtPhtCrt");
            $txtSDWar = grab_array_var($inargs, "txtSDWar");
            $txtSDCrt = grab_array_var($inargs, "txtSDCrt");
            $configurehost=grab_array_var($inargs, "configurehost");
            $chk_basic=grab_array_var($inargs, "chk_basic");
            $chk_advance=grab_array_var($inargs, "chk_advance");
            $chk_performance = grab_array_var($inargs, "chk_performance");
            $services_serial = grab_array_var($inargs, "services_serial");
            
            $txtvolwlatWar = grab_array_var($inargs, "txtvolwlatWar");
            $txtvolwlatCrt = grab_array_var($inargs, "txtvolwlatCrt");

            $txtvolrthpWar = grab_array_var($inargs, "txtvolrthpWar");
            $txtvolrthpCrt = grab_array_var($inargs, "txtvolrthpCrt");
            $txtvolwthpWar = grab_array_var($inargs, "txtvolwthpWar");
            $txtvolwthpCrt = grab_array_var($inargs, "txtvolwthpCrt");
            $rdVolWLAT = grab_array_var($inargs,"rdVolWLAT");
            $rdVolrthp = grab_array_var($inargs,"rdVolrthp");
            $rdVolWTHP = grab_array_var($inargs,"rdVolWTHP");

            $txtvgwlatWar = grab_array_var($inargs, "txtvgwlatWar");
            $txtvgrlatWar = grab_array_var($inargs, "txtvgrlatWar");
            $txtvgrlatCrt = grab_array_var($inargs, "txtvgrlatCrt");
            $txtvgwlatCrt = grab_array_var($inargs, "txtvgwlatCrt");
            $txtvgiopCrt = grab_array_var($inargs, "txtvgiopCrt");
            $txtvgiopWar = grab_array_var($inargs, "txtvgiopWar");
            $txtvgwiopWar = grab_array_var($inargs, "txtvgwiopWar");
            $txtvgwiopCrt = grab_array_var($inargs, "txtvgwiopCrt");
            $txtvgrthpWar = grab_array_var($inargs, "txtvgrthpWar");
            $txtvgrthpCrt = grab_array_var($inargs, "txtvgrthpCrt");
            $txtvgwthpWar = grab_array_var($inargs, "txtvgwthpWar");
            $txtvgwthpCrt = grab_array_var($inargs, "txtvgwthpCrt");
            $rdvgRIOP = grab_array_var($inargs,"rdvgRIOP");
            $rdvgWLAT = grab_array_var($inargs,"rdvgWLAT");
            $rdvgrthp = grab_array_var($inargs,"rdvgrthp");
            $rdvgWTHP = grab_array_var($inargs,"rdvgWTHP");
            $rdvgRLAT = grab_array_var($inargs,"rdvgRLAT");
            $rdvgWIOP = grab_array_var($inargs,"rdvgWIOP");

            $txtconwlatWar = grab_array_var($inargs, "txtconwlatWar");
            $txtconrlatWar = grab_array_var($inargs, "txtconrlatWar");
            $txtconrlatCrt = grab_array_var($inargs, "txtconrlatCrt");
            $txtconwlatCrt = grab_array_var($inargs, "txtconwlatCrt");
            $txtconiopCrt = grab_array_var($inargs, "txtconiopCrt");
            $txtconiopWar = grab_array_var($inargs, "txtconiopWar");
            $txtconwiopWar = grab_array_var($inargs, "txtconwiopWar");
            $txtconwiopCrt = grab_array_var($inargs, "txtconwiopCrt");
            $txtconrthpWar = grab_array_var($inargs, "txtconrthpWar");
            $txtconrthpCrt = grab_array_var($inargs, "txtconrthpCrt");
            $txtconwthpWar = grab_array_var($inargs, "txtconwthpWar");
            $txtconwthpCrt = grab_array_var($inargs, "txtconwthpCrt");
            $rdconRIOP = grab_array_var($inargs,"rdconRIOP");
            $rdconWLAT = grab_array_var($inargs,"rdconWLAT");
            $rdconrthp = grab_array_var($inargs,"rdconrthp");
            $rdconWTHP = grab_array_var($inargs,"rdconWTHP");
            $rdconRLAT = grab_array_var($inargs,"rdconRLAT");
            $rdconWIOP = grab_array_var($inargs,"rdconWIOP");

            $txtdrvwlatWar = grab_array_var($inargs, "txtdrvwlatWar");
            $txtdrvrlatWar = grab_array_var($inargs, "txtdrvrlatWar");
            $txtdrvrlatCrt = grab_array_var($inargs, "txtdrvrlatCrt");
            $txtdrvwlatCrt = grab_array_var($inargs, "txtdrvwlatCrt");
            $txtdrviopCrt = grab_array_var($inargs, "txtdrviopCrt");
            $txtdrviopWar = grab_array_var($inargs, "txtdrviopWar");
            $txtdrvwiopWar = grab_array_var($inargs, "txtdrvwiopWar");
            $txtdrvwiopCrt = grab_array_var($inargs, "txtdrvwiopCrt");
            $txtdrvrthpWar = grab_array_var($inargs, "txtdrvrthpWar");
            $txtdrvrthpCrt = grab_array_var($inargs, "txtdrvrthpCrt");
            $txtdrvwthpWar = grab_array_var($inargs, "txtdrvwthpWar");
            $txtdrvwthpCrt = grab_array_var($inargs, "txtdrvwthpCrt");
            $rddrvRIOP = grab_array_var($inargs,"rddrvRIOP");
            $rddrvWLAT = grab_array_var($inargs,"rddrvWLAT");
            $rddrvrthp = grab_array_var($inargs,"rddrvrthp");
            $rddrvWTHP = grab_array_var($inargs,"rddrvWTHP");
            $rddrvRLAT = grab_array_var($inargs,"rddrvRLAT");
            $rddrvWIOP = grab_array_var($inargs,"rddrvWIOP");
            
            if ($services_serial != "")
                $services = unserialize(base64_decode($services_serial));
            else
                $services = grab_array_var($inargs, "services");
            $serviceargs_serial = grab_array_var($inargs, "serviceargs_serial");
            if ($serviceargs_serial != "")
                $serviceargs = unserialize(base64_decode($serviceargs_serial));
            else
                $serviceargs = grab_array_var($inargs, "serviceargs");
            $phycomp_mode_serial = grab_array_var($inargs, "phycomp_mode_serial");
            if ($phycomp_mode_serial != "")
                $phycomp_mode = unserialize(base64_decode($phycomp_mode_serial));
            else
                $phycomp_mode = grab_array_var($inargs, "phycomp_mode");

            

            $output = '<input type="hidden" name="webproxy" value="' . htmlentities($webproxy) . '">
            <input type="hidden" name="webproxyport" value="' . htmlentities($webproxyport) . '">
            <input type="hidden" name="arrayname" value="' . htmlentities($arrayname) . '">
            <input type="hidden" name="ip1" value="' . htmlentities($ip1) . '">
            <input type="hidden" name="ip2" value="' . htmlentities($ip2) . '">
            <input type="hidden" name="txtSpCrt" value="' . htmlentities($txtSpCrt) . '">
            <input type="hidden" name="txtvoliopWar" value="' . htmlentities($txtvoliopWar) . '">
            <input type="hidden" name="txtvoliopCrt" value="' . htmlentities($txtvoliopCrt) . '">
            <input type="hidden" name="txtvolwiopWar" value="' . htmlentities($txtvolwiopWar) . '">
            <input type="hidden" name="txtvolwiopCrt" value="' . htmlentities($txtvolwiopCrt) . '">
            <input type="hidden" name="txtvolrlatWar" value="' . htmlentities($txtvolrlatWar) . '">
            <input type="hidden" name="txtvolrlatCrt" value="' . htmlentities($txtvolrlatCrt) . '">
            <input type="hidden" name="txtvolwlatCrt" value="' . htmlentities($txtvolwlatCrt) . '">
            <input type="hidden" name="txtvolwlatWar" value="' . htmlentities($txtvolwlatWar) . '">
            <input type="hidden" name="txtvolrthpCrt" value="' . htmlentities($txtvolrthpCrt) . '">
            <input type="hidden" name="txtvolrthpWar" value="' . htmlentities($txtvolrthpWar) . '">
            <input type="hidden" name="txtvolwthpCrt" value="' . htmlentities($txtvolwthpCrt) . '">
            <input type="hidden" name="txtvolwthpWar" value="' . htmlentities($txtvolwthpWar) . '">
            <input type="hidden" name="rdVolRLAT" value="' . htmlentities($rdVolRLAT) . '">
            <input type="hidden" name="txtSpWar" value="' . htmlentities($txtSpWar) . '">
            <input type="hidden" name="txtTvWar" value="' . htmlentities($txtTvWar) . '">
            <input type="hidden" name="txtTvCrt" value="' . htmlentities($txtTvCrt) . '">
            <input type="hidden" name="txtSDWar" value="' . htmlentities($txtSDWar) . '">
            <input type="hidden" name="txtSDCrt" value="' . htmlentities($txtSDCrt) . '">
            <input type="hidden" name="txtPhtWar" value="' . htmlentities($txtPhtWar) . '">
            <input type="hidden" name="txtPhtCrt" value="' . htmlentities($txtPhtCrt) . '">
            <input type="hidden" name="username" value="' . htmlentities($username) . '">
            <input type="hidden" name="password" value="' . htmlentities($password) . '">
            <input type="hidden" name="configurehost" value="' . htmlentities($configurehost) . '">
            <input type="hidden" name="rdVolWLAT" value="' . htmlentities($rdVolWLAT) . '">
            <input type="hidden" name="rdVolRLAT" value="' . htmlentities($rdVolRLAT) . '">
            <input type="hidden" name="rdVolrthp" value="' . htmlentities($rdVolrthp) . '">
            <input type="hidden" name="rdVolWTHP" value="' . htmlentities($rdVolWTHP) . '">
            <input type="hidden" name="rdVol" value="' . htmlentities($rdVol) . '">
            <input type="hidden" name="rdVolWIOP" value="' . htmlentities($rdVolWIOP) . '">
            <input type="hidden" name="txtvgiopWar" value="' . htmlentities($txtvgiopWar) . '">
            <input type="hidden" name="txtvgiopCrt" value="' . htmlentities($txtvgiopCrt) . '">
            <input type="hidden" name="txtvgwiopWar" value="' . htmlentities($txtvgwiopWar) . '">
            <input type="hidden" name="txtvgwiopCrt" value="' . htmlentities($txtvgwiopCrt) . '">
            <input type="hidden" name="txtvgrlatWar" value="' . htmlentities($txtvgrlatWar) . '">
            <input type="hidden" name="txtvgrlatCrt" value="' . htmlentities($txtvgrlatCrt) . '">
            <input type="hidden" name="txtvgwlatCrt" value="' . htmlentities($txtvgwlatCrt) . '">
            <input type="hidden" name="txtvgwlatWar" value="' . htmlentities($txtvgwlatWar) . '">
            <input type="hidden" name="txtvgrthpCrt" value="' . htmlentities($txtvgrthpCrt) . '">
            <input type="hidden" name="txtvgrthpWar" value="' . htmlentities($txtvgrthpWar) . '">
            <input type="hidden" name="txtvgwthpCrt" value="' . htmlentities($txtvgwthpCrt) . '">
            <input type="hidden" name="txtvgwthpWar" value="' . htmlentities($txtvgwthpWar) . '">
            <input type="hidden" name="rdvgWLAT" value="' . htmlentities($rdvgWLAT) . '">
            <input type="hidden" name="rdvgRLAT" value="' . htmlentities($rdvgRLAT) . '">
            <input type="hidden" name="rdvgrthp" value="' . htmlentities($rdvgrthp) . '">
            <input type="hidden" name="rdvgWTHP" value="' . htmlentities($rdvgWTHP) . '">
            <input type="hidden" name="rdvgRIOP" value="' . htmlentities($rdvgRIOP) . '">
            <input type="hidden" name="rdvgWIOP" value="' . htmlentities($rdvgWIOP) . '">
            <input type="hidden" name="rdvgRLAT" value="' . htmlentities($rdvgRLAT) . '">
            <input type="hidden" name="txtconiopWar" value="' . htmlentities($txtconiopWar) . '">
            <input type="hidden" name="txtconiopCrt" value="' . htmlentities($txtconiopCrt) . '">
            <input type="hidden" name="txtconwiopWar" value="' . htmlentities($txtconwiopWar) . '">
            <input type="hidden" name="txtconwiopCrt" value="' . htmlentities($txtconwiopCrt) . '">
            <input type="hidden" name="txtconrlatWar" value="' . htmlentities($txtconrlatWar) . '">
            <input type="hidden" name="txtconrlatCrt" value="' . htmlentities($txtconrlatCrt) . '">
            <input type="hidden" name="txtconwlatCrt" value="' . htmlentities($txtconwlatCrt) . '">
            <input type="hidden" name="txtconwlatWar" value="' . htmlentities($txtconwlatWar) . '">
            <input type="hidden" name="txtconrthpCrt" value="' . htmlentities($txtconrthpCrt) . '">
            <input type="hidden" name="txtconrthpWar" value="' . htmlentities($txtconrthpWar) . '">
            <input type="hidden" name="txtconwthpCrt" value="' . htmlentities($txtconwthpCrt) . '">
            <input type="hidden" name="txtconwthpWar" value="' . htmlentities($txtconwthpWar) . '">
            <input type="hidden" name="rdconWLAT" value="' . htmlentities($rdconWLAT) . '">
            <input type="hidden" name="rdconRLAT" value="' . htmlentities($rdconRLAT) . '">
            <input type="hidden" name="rdconrthp" value="' . htmlentities($rdconrthp) . '">
            <input type="hidden" name="rdconWTHP" value="' . htmlentities($rdconWTHP) . '">
            <input type="hidden" name="rdconRIOP" value="' . htmlentities($rdconRIOP) . '">
            <input type="hidden" name="rdconWIOP" value="' . htmlentities($rdconWIOP) . '">
            <input type="hidden" name="txtdrviopWar" value="' . htmlentities($txtdrviopWar) . '">
            <input type="hidden" name="txtdrviopCrt" value="' . htmlentities($txtdrviopCrt) . '">
            <input type="hidden" name="txtdrvwiopWar" value="' . htmlentities($txtdrvwiopWar) . '">
            <input type="hidden" name="txtdrvwiopCrt" value="' . htmlentities($txtdrvwiopCrt) . '">
            <input type="hidden" name="txtdrvrlatWar" value="' . htmlentities($txtdrvrlatWar) . '">
            <input type="hidden" name="txtdrvrlatCrt" value="' . htmlentities($txtdrvrlatCrt) . '">
            <input type="hidden" name="txtdrvwlatCrt" value="' . htmlentities($txtdrvwlatCrt) . '">
            <input type="hidden" name="txtdrvwlatWar" value="' . htmlentities($txtdrvwlatWar) . '">
            <input type="hidden" name="txtdrvrthpCrt" value="' . htmlentities($txtdrvrthpCrt) . '">
            <input type="hidden" name="txtdrvrthpWar" value="' . htmlentities($txtdrvrthpWar) . '">
            <input type="hidden" name="txtdrvwthpCrt" value="' . htmlentities($txtdrvwthpCrt) . '">
            <input type="hidden" name="txtdrvwthpWar" value="' . htmlentities($txtdrvwthpWar) . '">
            <input type="hidden" name="rddrvWLAT" value="' . htmlentities($rddrvWLAT) . '">
            <input type="hidden" name="rddrvRLAT" value="' . htmlentities($rddrvRLAT) . '">
            <input type="hidden" name="rddrvrthp" value="' . htmlentities($rddrvrthp) . '">
            <input type="hidden" name="rddrvWTHP" value="' . htmlentities($rddrvWTHP) . '">
            <input type="hidden" name="rddrvRIOP" value="' . htmlentities($rddrvRIOP) . '">
            <input type="hidden" name="rddrvWIOP" value="' . htmlentities($rddrvWIOP) . '">
            <input type="hidden" name="chk_basic" value="' . htmlentities($chk_basic) . '">
            <input type="hidden" name="chk_advance" value="' . htmlentities($chk_advance) . '">
            <input type="hidden" name="chk_performance" value="' . htmlentities($chk_performance) . '">
            <input type="hidden" name="services_serial" value="' . base64_encode(serialize($services)) . '">
            <input type="hidden" name="serviceargs_serial" value="' . base64_encode(serialize($serviceargs)) . '">
            <input type="hidden" name="logicalcomp_mode_serial" value="' . base64_encode(serialize($logicalcomp_mode)) . '">
            <input type="hidden" name="performance_mode_serial" value="' . base64_encode(serialize($performance_mode)) . '">
            <input type="hidden" name="phycomp_mode_serial" value="' . base64_encode(serialize($phycomp_mode)) . '">
              ';

            break;        
        
        case CONFIGWIZARD_MODE_GETOBJECTS:

            $webproxy = grab_array_var($inargs, "webproxy", "");
            $webproxyport=grab_array_var($inargs, "webproxyport", "");
            $webproxy = $webproxy .":".$webproxyport;
            $services_serial = grab_array_var($inargs, "services_serial", "");
            $serviceargs_serial = grab_array_var($inargs, "serviceargs_serial", "");
            $phycomp_mode_serial = grab_array_var($inargs, "phycomp_mode_serial", "");
            $logicalcomp_mode_serial = grab_array_var($inargs, "logicalcomp_mode_serial", "");
            $performance_mode_serial = grab_array_var($inargs, "performance_mode_serial", "");

            $services = unserialize(base64_decode($services_serial));
            $serviceargs = unserialize(base64_decode($serviceargs_serial));
            $phycomp_mode = unserialize(base64_decode($phycomp_mode_serial));
            $logicalcomp_mode=unserialize(base64_decode($logicalcomp_mode_serial));
            $performance_mode=unserialize(base64_decode($performance_mode_serial));

            $arrayname = grab_array_var($inargs, "arrayname", "");
            $username = grab_array_var($inargs, "username", "");
            $password = grab_array_var($inargs, "password", "");
            $ip1 = grab_array_var($inargs, "ip1", "");
            $ip2 = grab_array_var($inargs, "ip2", "");
            $configurehost=grab_array_var($inargs, "configurehost");
            $chk_basic=grab_array_var($inargs, "chk_basic");
            $chk_advance=grab_array_var($inargs, "chk_advance");
            $chk_performance=grab_array_var($inargs, "chk_performance");
            $txtSpCrt = grab_array_var($inargs, "txtSpCrt");
            $txtSpWar = grab_array_var($inargs, "txtSpWar");
            $txtTvCrt = grab_array_var($inargs, "txtTvCrt");
            $txtTvWar = grab_array_var($inargs, "txtTvWar");
            $txtPhtWar= grab_array_var($inargs, "txtPhtWar");
            $txtPhtCrt= grab_array_var($inargs, "txtPhtCrt");
            $txtSDWar = grab_array_var($inargs, "txtSDWar");
            $txtSDCrt = grab_array_var($inargs, "txtSDCrt");
            $txtvoliopCrt = grab_array_var($inargs, "txtvoliopCrt");
            $txtvoliopWar = grab_array_var($inargs, "txtvoliopWar");
            $rdVol =grab_array_var($inargs,"rdVol");

            $txtvolwiopWar = grab_array_var($inargs, "txtvolwiopWar");
            $txtvolwiopCrt = grab_array_var($inargs, "txtvolwiopCrt");
            
            $rdVolWIOP = grab_array_var($inargs,"rdVolWIOP");

             $txtvolrlatWar = grab_array_var($inargs, "txtvolrlatWar");
            $txtvolrlatCrt = grab_array_var($inargs, "txtvolrlatCrt");
            $rdVolRLAT = grab_array_var($inargs,"rdVolRLAT");

            $txtvolwlatWar = grab_array_var($inargs, "txtvolwlatWar");
            $txtvolwlatCrt = grab_array_var($inargs, "txtvolwlatCrt");

            $txtvolrthpWar = grab_array_var($inargs, "txtvolrthpWar");
            $txtvolrthpCrt = grab_array_var($inargs, "txtvolrthpCrt");
            $txtvolwthpWar = grab_array_var($inargs, "txtvolwthpWar");
            $txtvolwthpCrt = grab_array_var($inargs, "txtvolwthpCrt");
            $rdVolWLAT = grab_array_var($inargs,"rdVolWLAT");
            $rdVolrthp = grab_array_var($inargs,"rdVolrthp");
            $rdVolWTHP = grab_array_var($inargs,"rdVolWTHP");


            $txtvgwlatWar = grab_array_var($inargs, "txtvgwlatWar");
            $txtvgrlatWar = grab_array_var($inargs, "txtvgrlatWar");
            $txtvgrlatCrt = grab_array_var($inargs, "txtvgrlatCrt");
            $txtvgwlatCrt = grab_array_var($inargs, "txtvgwlatCrt");
            $txtvgiopCrt = grab_array_var($inargs, "txtvgiopCrt");
            $txtvgiopWar = grab_array_var($inargs, "txtvgiopWar");
            $txtvgwiopWar = grab_array_var($inargs, "txtvgwiopWar");
            $txtvgwiopCrt = grab_array_var($inargs, "txtvgwiopCrt");
            $txtvgrthpWar = grab_array_var($inargs, "txtvgrthpWar");
            $txtvgrthpCrt = grab_array_var($inargs, "txtvgrthpCrt");
            $txtvgwthpWar = grab_array_var($inargs, "txtvgwthpWar");
            $txtvgwthpCrt = grab_array_var($inargs, "txtvgwthpCrt");
            $rdvgRIOP = grab_array_var($inargs,"rdvgRIOP");
            $rdvgWLAT = grab_array_var($inargs,"rdvgWLAT");
            $rdvgrthp = grab_array_var($inargs,"rdvgrthp");
            $rdvgWTHP = grab_array_var($inargs,"rdvgWTHP");
            $rdvgRLAT = grab_array_var($inargs,"rdvgRLAT");
            $rdvgWIOP = grab_array_var($inargs,"rdvgWIOP");

            $txtconwlatWar = grab_array_var($inargs, "txtconwlatWar");
            $txtconrlatWar = grab_array_var($inargs, "txtconrlatWar");
            $txtconrlatCrt = grab_array_var($inargs, "txtconrlatCrt");
            $txtconwlatCrt = grab_array_var($inargs, "txtconwlatCrt");
            $txtconiopCrt = grab_array_var($inargs, "txtconiopCrt");
            $txtconiopWar = grab_array_var($inargs, "txtconiopWar");
            $txtconwiopWar = grab_array_var($inargs, "txtconwiopWar");
            $txtconwiopCrt = grab_array_var($inargs, "txtconwiopCrt");
            $txtconrthpWar = grab_array_var($inargs, "txtconrthpWar");
            $txtconrthpCrt = grab_array_var($inargs, "txtconrthpCrt");
            $txtconwthpWar = grab_array_var($inargs, "txtconwthpWar");
            $txtconwthpCrt = grab_array_var($inargs, "txtconwthpCrt");
            $rdconRIOP = grab_array_var($inargs,"rdconRIOP");
            $rdconWLAT = grab_array_var($inargs,"rdconWLAT");
            $rdconrthp = grab_array_var($inargs,"rdconrthp");
            $rdconWTHP = grab_array_var($inargs,"rdconWTHP");
            $rdconRLAT = grab_array_var($inargs,"rdconRLAT");
            $rdconWIOP = grab_array_var($inargs,"rdconWIOP");

            $txtdrvwlatWar = grab_array_var($inargs, "txtdrvwlatWar");
            $txtdrvrlatWar = grab_array_var($inargs, "txtdrvrlatWar");
            $txtdrvrlatCrt = grab_array_var($inargs, "txtdrvrlatCrt");
            $txtdrvwlatCrt = grab_array_var($inargs, "txtdrvwlatCrt");
            $txtdrviopCrt = grab_array_var($inargs, "txtdrviopCrt");
            $txtdrviopWar = grab_array_var($inargs, "txtdrviopWar");
            $txtdrvwiopWar = grab_array_var($inargs, "txtdrvwiopWar");
            $txtdrvwiopCrt = grab_array_var($inargs, "txtdrvwiopCrt");
            $txtdrvrthpWar = grab_array_var($inargs, "txtdrvrthpWar");
            $txtdrvrthpCrt = grab_array_var($inargs, "txtdrvrthpCrt");
            $txtdrvwthpWar = grab_array_var($inargs, "txtdrvwthpWar");
            $txtdrvwthpCrt = grab_array_var($inargs, "txtdrvwthpCrt");
            $rddrvRIOP = grab_array_var($inargs,"rddrvRIOP");
            $rddrvWLAT = grab_array_var($inargs,"rddrvWLAT");
            $rddrvrthp = grab_array_var($inargs,"rddrvrthp");
            $rddrvWTHP = grab_array_var($inargs,"rddrvWTHP");
            $rddrvRLAT = grab_array_var($inargs,"rddrvRLAT");
            $rddrvWIOP = grab_array_var($inargs,"rddrvWIOP");
            
            
            
            // save data for later use in re-entrance
            $meta_arr = array();
            $meta_arr["webproxy"] = $webproxy;
            $meta_arr["username"] = $username;
            $meta_arr["password"] = $password;
            $meta_arr["arrayname"] = $arrayname;
            $meta_arr["ip1"] = $ip1;
            $meta_arr["ip2"] = $ip2;
            $meta_arr["services"] = $services;
            $meta_arr["serivceargs"] = $serviceargs;
            $meta_arr["phycomp_mode"] = $phycomp_mode;
            
            $meta_arr["logicalcomp_mode"] = $logicalcomp_mode;
            

            save_configwizard_object_meta($wizard_name, $arrayname, "", $meta_arr);

            $objs = array();
            $dhcpargs = "-webproxy ". $webproxy ." -username ". $username." -password ".$password . " -ip1 ".$ip1." -ip2 ".$ip2;
            if (!host_exists($arrayname) && $configurehost =="yes") {
                $objs[] = array(
                    "type" => OBJECTTYPE_HOST,
                    "use" => "xiwizard_santricity_host",
                    "host_name" => $arrayname,
                    "address" => $ip1,
                    "check_command" =>"Check_Host_Configuration_Wiz!".$dhcpargs,
                    "_xiwizard" => $wizard_name,
                );
            }

            $commonopts = "-webproxy ". $webproxy ." -username ". $username." -password ".$password ;
            // DHCP service
            $dhcpargs = "";
            
            if ($webproxy != "")
                $dhcpargs .= $webproxy;
            

            
                foreach ($services as $svcvar => $svcval) {

                    $pluginopts = "";
                    $pluginopts .= $commonopts;

                    
                    switch ($svcvar) {
                        case "arrayavailable":

                            $objs[] = array(
                                "type" => OBJECTTYPE_SERVICE,
                                "host_name" => $arrayname,
                                "service_description" => "Check Array Availability",
                                "use" => "xiwizard_santricity_check_array_avalibility_wizard",
                                "check_command" => "Check_Array_Availability_Configuration_Wiz!" . $pluginopts,
                                "_xiwizard" => $wizard_name,
                            );
                            break;

                        case "melevents":
                            
                            $objs[] = array(
                                "type" => OBJECTTYPE_SERVICE,
                                "host_name" => $arrayname,
                                "service_description" => "Major Event Log",
                                "use" => "xiwizard_santricity_check_mel_events_wizard",
                                "check_command" => "Check_Mel_Events_Wiz!" . $pluginopts,
                                "_xiwizard" => $wizard_name,
                            );
                            break;

                        case "phycompst":
                            $compexist=False;
                            foreach ($phycomp_mode as $phymodvar => $phymodval){
                                if($phymodvar =='unknown')
                                    continue;
                                if ($phymodvar == "ARRY")
                                {
                                    $phypluginopts = $pluginopts . " -mode ARRY";
                                }
                                else
                                {
                                    $phypluginopts = $pluginopts . " -mode " . $phymodvar . "";
                                }
                                $compexist=True;
                                $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Check Physical Component status of the Array - ". $phymodvar,
                                    "use" => "xiwizard_santricity_check_phycomp_status_wizard",
                                    "check_command" => "Check_Physical_Comp_Status_Wiz!" . $phypluginopts,
                                    "_xiwizard" => $wizard_name,
                                );
                            }

                            if(!$compexist){
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Check status for all Physical Components of the Array ",
                                    "use" => "xiwizard_santricity_check_phycomp_status_wizard",
                                    "check_command" => "Check_Physical_Comp_Status_Wiz!" . $pluginopts,
                                    "_xiwizard" => $wizard_name,
                                );
                            }
                            
                            break;

                        case "logicalcompst":
                            $logcompsel=False;
                            foreach ($logicalcomp_mode as $logicalmodvar => $logicalmodval){
                                if($logicalmodvar =='unknown')
                                    continue;
                                $phypluginopts = $pluginopts . " -mode " . $logicalmodvar . "";
                                 $logcompsel=True;
                                $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Check Logical Component status of the Array - ". $logicalmodvar,
                                    "use" => "xiwizard_santricity_check_logicalcomp_status_wizard",
                                    "check_command" => "Check_Logical_Comp_Status_Wiz!" . $phypluginopts,
                                    "_xiwizard" => $wizard_name,
                                );
                            }

                            if(!$logcompsel)
                            {
                                $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Check status for all Logical Components of the Array ",
                                    "use" => "xiwizard_santricity_check_logicalcomp_status_wizard",
                                    "check_command" => "Check_Logical_Comp_Status_Wiz!" . $pluginopts,
                                    "_xiwizard" => $wizard_name,
                                );
                            }
                            
                            break;
                       
                        case "stpool":
                            if ($chk_advance =='yes')
                            {
                                $stpoolop=  $pluginopts . " -warning ".$txtSpWar ." -critical ".$txtSpCrt;
                                $objs[] = array(
                                "type" => OBJECTTYPE_SERVICE,
                                "host_name" => $arrayname,
                                "service_description" => "Check Storage Pool Capacity Information",
                                "use" => "xiwizard_santricity_check_storagepool_status_wizard",
                                "check_command" => "Check_Storage_Pool_Status_Wiz!" . $stpoolop,
                                "_xiwizard" => $wizard_name,
                                ); 
                            }
                           
                            break;
                        case "thinvol":
                            if ($chk_advance =='yes')
                            {
                                $stpoolop=  $pluginopts . " -warning ".$txtTvWar ." -critical ".$txtTvCrt;
                                $objs[] = array(
                                "type" => OBJECTTYPE_SERVICE,
                                "host_name" => $arrayname,
                                "service_description" => "Check Thin Volumes Capacity Information",
                                "use" => "xiwizard_santricity_check_thinvolumes_status_wizard",
                                "check_command" => "Check_Thin_Volumes_Status_Wiz!" . $stpoolop,
                                "_xiwizard" => $wizard_name,
                                ); 
                            }
                           
                            break;

                        case "phytmp":
                            if ($chk_advance =='yes')
                            {
                                $stpoolop=  $pluginopts . " -warning ".$txtPhtWar ." -critical ".$txtPhtCrt;
                                $objs[] = array(
                                "type" => OBJECTTYPE_SERVICE,
                                "host_name" => $arrayname,
                                "service_description" => "Monitor Physical Component Temperature Information",
                                "use" => "xiwizard_santricity_check_physicalcomp_temp_wizard",
                                "check_command" => "Check_Physical_Comp_Temperature_Wiz!" . $stpoolop,
                                "_xiwizard" => $wizard_name,
                                ); 
                            }
                           
                            break; 

                        case "ssd":
                            if ($chk_advance =='yes')
                            {
                                $stpoolop=  $pluginopts . " -warning ".$txtSDWar ." -critical ".$txtSDCrt;
                                $objs[] = array(
                                "type" => OBJECTTYPE_SERVICE,
                                "host_name" => $arrayname,
                                "service_description" => "Monitor SSD Drives",
                                "use" => "xiwizard_santricity_check_ssddrive_status_wizard",
                                "check_command" => "Check_SSD_Drive_Status_Wiz!" . $stpoolop,
                                "_xiwizard" => $wizard_name,
                                ); 
                            }
                           
                            break; 
                        case "volriop":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtvoliopWar ." -critical ".$txtvoliopCrt ." -mode RIOP -r ".$rdVol;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics - RIOP",
                                    "use" => "xiwizard_santricity_check_vol_status_wizard",
                                    "check_command" => "Check_Vol_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break; 
                        case "volwiop":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtvolwiopWar ." -critical ".$txtvolwiopCrt ." -mode WIOP -r ".$rdVolWIOP;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics - WIOP",
                                    "use" => "xiwizard_santricity_check_vol_status_wizard",
                                    "check_command" => "Check_Vol_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break; 
                        case "volrlat":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtvolrlatWar ." -critical ".$txtvolrlatCrt ." -mode RLAT -r ".$rdVolRLAT;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics - RLAT",
                                    "use" => "xiwizard_santricity_check_vol_status_wizard",
                                    "check_command" => "Check_Vol_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break; 
                        case "volwlat":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtvolwlatWar ." -critical ".$txtvolwlatCrt ." -mode WLAT -r ".$rdVolWLAT;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics - WLAT",
                                    "use" => "xiwizard_santricity_check_vol_status_wizard",
                                    "check_command" => "Check_Vol_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break; 
                        case "volrthp":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtvolrthpWar ." -critical ".$txtvolrthpCrt ." -mode RTHP -r ".$rdVolRLAT;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics - RTHP",
                                    "use" => "xiwizard_santricity_check_vol_status_wizard",
                                    "check_command" => "Check_Vol_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break; 
                        case "volwthp":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtvolwthpWar ." -critical ".$txtvolwthpCrt ." -mode WTHP -r ".$rdVolRLAT;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics - WTHP",
                                    "use" => "xiwizard_santricity_check_vol_status_wizard",
                                    "check_command" => "Check_Vol_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break; 
                        case "vgriop":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtvgiopWar ." -critical ".$txtvgiopCrt ." -mode RIOP -r ".$rdvgRIOP;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Volume Group - RIOP",
                                    "use" => "xiwizard_santricity_check_vol_byvg_status_wizard",
                                    "check_command" => "Check_Vol_BYVG_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name, 
                                    ); 
                                
                            }
                            break;
                        case "vgwiop":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtvgwiopWar ." -critical ".$txtvgwiopCrt ." -mode WIOP -r ".$rdvgWIOP;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Volume Group - WIOP",
                                    "use" => "xiwizard_santricity_check_vol_byvg_status_wizard",
                                    "check_command" => "Check_Vol_BYVG_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break;
                        case "vgrlat":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtvgrlatWar ." -critical ".$txtvgrlatCrt ." -mode RLAT -r ".$rdvgRLAT;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Volume Group - RLAT",
                                    "use" => "xiwizard_santricity_check_vol_byvg_status_wizard",
                                    "check_command" => "Check_Vol_BYVG_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break;   
                         case "vgwlat":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtvgwlatWar ." -critical ".$txtvgwlatCrt ." -mode WLAT -r ".$rdvgWLAT;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Volume Group - WLAT",
                                    "use" => "xiwizard_santricity_check_vol_byvg_status_wizard",
                                    "check_command" => "Check_Vol_BYVG_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break; 
                          case "vgrthp":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtvgrthpWar ." -critical ".$txtvgrthpCrt ." -mode RTHP -r ".$rdvgrthp;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Volume Group - RTHP",
                                    "use" => "xiwizard_santricity_check_vol_byvg_status_wizard",
                                    "check_command" => "Check_Vol_BYVG_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break;  
                        case "vgwthp":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtvgwthpWar ." -critical ".$txtvgwthpCrt ." -mode WTHP -r ".$rdvgWTHP;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Volume Group - WTHP",
                                    "use" => "xiwizard_santricity_check_vol_byvg_status_wizard",
                                    "check_command" => "Check_Vol_BYVG_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break; 
                        case "conriop":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtconiopWar ." -critical ".$txtconiopCrt ." -mode RIOP -r ".$rdconRIOP;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Controller - RIOP",
                                    "use" => "xiwizard_santricity_check_vol_bycon_status_wizard",
                                    "check_command" => "Check_Vol_BYCON_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name, 
                                    ); 
                                
                            }
                            break;
                        case "conwiop":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtconwiopWar ." -critical ".$txtconwiopCrt ." -mode WIOP -r ".$rdconWIOP;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Controller - WIOP",
                                    "use" => "xiwizard_santricity_check_vol_bycon_status_wizard",
                                    "check_command" => "Check_Vol_BYCON_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break;
                        case "conrlat":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtconrlatWar ." -critical ".$txtconrlatCrt ." -mode RLAT -r ".$rdconRLAT;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Controller - RLAT",
                                    "use" => "xiwizard_santricity_check_vol_bycon_status_wizard",
                                    "check_command" => "Check_Vol_BYCON_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break;   
                        case "conwlat":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtconwlatWar ." -critical ".$txtconwlatCrt ." -mode WLAT -r ".$rdconWLAT;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Controller - WLAT",
                                    "use" => "xiwizard_santricity_check_vol_bycon_status_wizard",
                                    "check_command" => "Check_Vol_BYCON_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break; 
                        case "conrthp":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtconrthpWar ." -critical ".$txtconrthpCrt ." -mode RTHP -r ".$rdconrthp;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Controller - RTHP",
                                    "use" => "xiwizard_santricity_check_vol_bycon_status_wizard",
                                    "check_command" => "Check_Vol_BYCON_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break;  
                        case "conwthp":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtconwthpWar ." -critical ".$txtconwthpCrt ." -mode WTHP -r ".$rdconWTHP;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Controller - WTHP",
                                    "use" => "xiwizard_santricity_check_vol_bycon_status_wizard",
                                    "check_command" => "Check_Vol_BYCON_Stat_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break;
                                                case "drvriop":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtdrviopWar ." -critical ".$txtdrviopCrt ." -mode RIOP -r ".$rddrvRIOP;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Drive - RIOP",
                                    "use" => "xiwizard_santricity_check_drive_status_wizard",
                                    "check_command" => "Check_Drive_Status_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name, 
                                    ); 
                                
                            }
                            break;
                        case "drvwiop":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtdrvwiopWar ." -critical ".$txtdrvwiopCrt ." -mode WIOP -r ".$rddrvWIOP;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Drive - WIOP",
                                    "use" => "xiwizard_santricity_check_drive_status_wizard",
                                    "check_command" => "Check_Drive_Status_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break;
                        case "drvrlat":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtdrvrlatWar ." -critical ".$txtdrvrlatCrt ." -mode RLAT -r ".$rddrvRLAT;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Drive - RLAT",
                                    "use" => "xiwizard_santricity_check_drive_status_wizard",
                                    "check_command" => "Check_Drive_Status_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break;   
                        case "drvwlat":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtdrvwlatWar ." -critical ".$txtdrvwlatCrt ." -mode WLAT -r ".$rddrvWLAT;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Drive - WLAT",
                                    "use" => "xiwizard_santricity_check_drive_status_wizard",
                                    "check_command" => "Check_Drive_Status_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break; 
                        case "drvrthp":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtdrvrthpWar ." -critical ".$txtdrvrthpCrt ." -mode RTHP -r ".$rddrvrthp;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Drive - RTHP",
                                    "use" => "xiwizard_santricity_check_drive_status_wizard",
                                    "check_command" => "Check_Drive_Status_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break;  
                        case "drvwthp":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -warning ".$txtdrvwthpWar ." -critical ".$txtdrvwthpCrt ." -mode WTHP -r ".$rddrvWTHP;
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Monitor Volume Statistics by Drive - WTHP",
                                    "use" => "xiwizard_santricity_check_drive_status_wizard",
                                    "check_command" => "Check_Drive_Status_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break; 
                        case "cvprc":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -mode PRC ";
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Primary Cache Statistics by Volume.",
                                    "use" => "xiwizard_santricity_check_cache_status_byvol_wizard",
                                    "check_command" => "Check_Cache_Stat_BYVOL_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break;  
                        case "cvssd":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -mode SSDC ";
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "SSD Cache Statistics by Volume.",
                                    "use" => "xiwizard_santricity_check_cache_status_byvol_wizard",
                                    "check_command" => "Check_Cache_Stat_BYVOL_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break; 
                        case "cvgprc":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -mode PRC ";
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "Primary Cache Statistics by Volume Group.",
                                    "use" => "xiwizard_santricity_check_cache_status_byvg_wizard",
                                    "check_command" => "Check_Cache_Stat_BYVG_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break;  
                        case "cvgssd":
                            if ($chk_performance =='yes')
                            {
                                    $stpoolop=  $pluginopts . " -mode SSDC ";
                                    $objs[] = array(
                                    "type" => OBJECTTYPE_SERVICE,
                                    "host_name" => $arrayname,
                                    "service_description" => "SSD Cache Statistics by Volume Group.",
                                    "use" => "xiwizard_santricity_check_cache_status_byvg_wizard",
                                    "check_command" => "Check_Cache_Stat_BYVG_Wiz!" . $stpoolop,
                                    "_xiwizard" => $wizard_name,
                                    ); 
                                
                            }
                            break;                                                                     
                        default:
                            break;
                    }
                }
            
            
            $outargs[CONFIGWIZARD_NAGIOS_OBJECTS] = $objs;

            break;
    
        default:
            break;
    }

    return $output;
}


?>