#!/bin/bash
#
# Nagios Check Cisco UCS Logs
#
# Description: Check UCS logs collected by rsyslog
# Author     : Fabio Pardi pachistano@gmail.com
# Version    : 0.1 1st of June 2015
#
# Tested on UCS C240 M3

# Requirements: the user running this script must have read permissions on the logs
# UCS system must send logs to a remote syslog server
# Tested On CentOS 6

#############################################
#############################################
print_help() {
        echo ""
        echo "Usage: check_cisco_ucs  -t target - the folder in which the ucs logs are  "
        echo "Eg:   check_cisco_ucs -t my_ucs_folder - means your ucs logfiles are in /var/log/my_ucs_folder"
	    echo "By default we assume that your logfiles are in /var/log, otherwise edit the plugin" 
        echo ""
}
##############################################
##############################################

target=empty
mydir=/home/nagios/ucs_log_checks
log_folder=/var/log

if [ ! -d $mydir ] 
then
        mkdir -p $mydir
fi


#parameters check
while test -n "$1"; do
   case "$1" in
        --help)
            print_help
            exit 2
            ;;
        -t)
            target=$2
            shift
            ;;
        *)
            echo "Unknown argument: $1"
            print_help
            exit 2
            ;;
    esac
    shift
done 

if [ -z $target ] || [[ $target == "empty" ]] ;then print_help ; exit 2 ; fi

target_logs=$log_folder/$target

#echo target logs are in $target_logs

if [ ! -d $target_logs ] ; then echo "Folder $target_logs does not exist" ; exit 2 ;fi
if [ `ls $target_logs | wc -l` -eq 0 ] ; then echo "No file to analyze"; exit 2 ; fi

# Look for the most recent file
most_recent=`ls -t $target_logs  | head -1`
myfile=$target_logs/$most_recent
#echo most recent file is $myfile

# We need a marker to count line numbers
marker=$mydir/marker_$target

errors_file=$mydir/errors_$target
cleared_file=$mydir/cleared_$target

# if the marker does not exist, then is the first time we run


how_many_lines=`cat  $myfile | wc -l`

# We need to take into consideration that logfiles rotate. 
# In that specific case, then the new file needs to be parsed entirely, thus i delete the old marker
if [  -e $marker ]
then
	# we need to check if the logfile rotated since the last run
	line_number=`cat $marker`
	if [ $how_many_lines -lt $line_number ]
	then
		rm $marker
	fi
fi

if [ ! -e $marker ] 
then 
	# the file has never been processed
	#echo this is my first time i run on this logs
        echo $how_many_lines > $marker
	#Looking for errors and recovery
	grep "\:\[F" $myfile | grep -v cleared >> $errors_file 
	grep "\:\[F" $myfile | grep  cleared | awk 'BEGIN { FS = "[" } ; { print $5 }' | awk 'BEGIN { FS = ":" } ; { print $1 }'  >> $cleared_file
else
	# we are processing only the new part of the logfile
	#echo "continue to process a file"
        line_number=`cat $marker`
	# need to increment line number because tail otherwise picks the last checked line. Might produce duplicate errors then.
	(($line_numer+1))
        #echo line number is $line_number
	# make a new marker so the next time we process only the new logs
        echo $how_many_lines > $marker
	tail -n +$line_number $myfile | grep "\:\[F" | grep -v cleared >> $errors_file
	tail -n +$line_number $myfile | grep "\:\[F" | grep  cleared | awk 'BEGIN { FS = "[" } ; { print $5 }' | awk 'BEGIN { FS = ":" } ; { print $1 }' >> $cleared_file
fi


# At this point, errors are collected into $errors_file
# The only thing we need to do is to see if they are cleared or not
# We do not take into consideration errors that are raised and then cleared immediately, because in that case:
# Or there is a bug, like the 'infamous' one that is raised at every 'battery check cycle', and then cleared when the  check is finished, or is already acknowledged and fixed. In both cases, we do not have to worry about 


# This will only run if there is some content into $cleared_file

# Parse the 'cleared' file and remove for the errors file the errors that are recovered 
while read line; do
	#echo processing "$line"
	remove_line=`grep -ni "$line" $errors_file | head -1 | awk 'BEGIN { FS = ":" } ; { print $1 }' `
	#echo found error to remove at line $remove_line
	sed $remove_line\d -i $errors_file
done < $cleared_file

rm -f $cleared_file

# Errors reporting

if [  -s $errors_file ] 
then 
	cat $errors_file
	exit 2
else
	echo OK
	exit 0
fi

