#!/usr/bin/perl -w
#####################################################################################################
# Author: Derek Brewer (derekbr@us.ibm.com) / IBM
# Last Modified: 3-17-17
# License: GNU GPL V2
# Package: Nagios Core Mass Functions
# Description: Perl CGI script for selecting hosts to acknowledge problems including all associated services
#####################################################################################################

use strict;
no warnings 'uninitialized';
require 'parse_nagios.pl';
my $debug = 0;
my @hosts;
my $attribs;
my $numcheckbox;
my $key;
my $thispage = "mass_ack_combined.cgi";
my @hostsfiltered;
my $i;

# read in the sort key or set default if not given
use CGI qw(:standard);
my $query = new CGI;
my $sortkey = $query->param('sort');
if (! defined "$sortkey"){
	$sortkey = "host_name";
}
my $order = $query->param('order');
if (! defined "$order" || ( $order ne "ascending" && $order ne "descending" )){
	$order = "ascending";
}

my $filterfield = $query->param('filterfield');
if (! defined "$filterfield"){
        $filterfield = "";
}

my $filterstring = $query->param('filterstring');
if (! defined "$filterstring"){
        $filterstring = "";
}

# determine what instance we will be acting on.
my @tokens = split(/\//, $ENV{'SCRIPT_FILENAME'});
my $instance = $tokens[4];
if ($instance eq "sbin"){
        $instance = "";
}

#Call the parse_status_dat function in parse_nagios.pl
@hosts = parse_status_dat($instance,"hoststatus","$filterstring","$filterfield","host_name","current_state","problem_has_been_acknowledged","state_type","plugin_output");

if ($debug){
	for $i ( 0 .. $#hosts ) {
		for $attribs ( keys %{ $hosts[$i] } ) {
			print "$attribs=$hosts[$i]{$attribs}\n";
		}
		print "##################\n";
	}
}
my $arrcount = 0;
#put the hosts that are not acknowledged into another hash so we can sort it later
for $i ( 0 .. $#hosts ) {
        if ($hosts[$i]{current_state} ne "Up" &&  $hosts[$i]{problem_has_been_acknowledged} eq "0" && $hosts[$i]{state_type} eq "1" ) {
		#copy each key/value pair into the new array of hashes
		foreach $key (keys %{ $hosts[$i] }) {
                	$hostsfiltered[$arrcount]{$key} = "$hosts[$i]{$key}";
                }
                $arrcount++;
        }
}

#sort the output based on the key determined above
if($order eq "ascending"){
	@hostsfiltered = sort { $a->{$sortkey} cmp $b->{$sortkey} } @hostsfiltered;
}else{
	@hostsfiltered = sort { $b->{$sortkey} cmp $a->{$sortkey} } @hostsfiltered;
}

print "Content-type: text/html\n\n";
print <<"EOF";
<html>
<head>
<title>Nagios - Acknowledge Multiple Hosts/Services</title>
EOF
print "<link href=\"/nagios/$instance/stylesheets/common.css\" type=\"text/css\" rel=\"stylesheet\">";
print "<script type=\"text/javascript\" src=\"/nagios/$instance/scripts.js\"></script>";
print <<"EOF";
</head>
<body>
<a href="mass_functions.cgi">Return to Mass Functions Main Page</a><br>
<h2>Acknowledge Multiple Hosts/Services Problems:</h2>
EOF
print "User: $ENV{'REMOTE_USER'}<br><br>\n";
$numcheckbox = 1;
print <<"EOF";

<table border=0 width=100% class='status'>
	<tr>
		<th class='status'>&nbsp;</th>
EOF
build_header($instance,$thispage,"$filterstring","$filterfield","host_name","current_state","plugin_output");
print <<"EOF";
<form name="myform" action="ack_combined_problems.cgi" method="post" onsubmit="return checkform(this);">
<input type="button" name="CheckAll" value="Check All" onClick="checkAll()">
<input type="button" name="UnCheckAll" value="Uncheck All" onClick="uncheckAll()"><br>
</tr>
EOF

for $i ( 0 .. $#hostsfiltered ) {
        	print "<tr><td><input type=\"checkbox\" name=\"$numcheckbox\" value=\"$hostsfiltered[$i]{host_name}\"></td><td>$hostsfiltered[$i]{host_name}</td><td>$hostsfiltered[$i]{current_state}</td><td>$hostsfiltered[$i]{plugin_output}</td></tr>\n";
		$numcheckbox++;
}
print "</table>\n";

if ($numcheckbox == 1){
	print "All problems have been acknowledged or there are no problems<br>\n";
}else{
print "<input type=\"hidden\" name=\"instance\" value=\"$instance\">\n";
print <<"EOF";
<br>Comment:
<input type="text" name="msg" size="50"><br>
<input type="button" name="CheckAll" value="Check All" onClick="checkAll()">
<input type="button" name="UnCheckAll" value="Uncheck All" onClick="uncheckAll()"><br>
<input type="submit" value="Submit">
EOF
}
print <<"EOF";
<br>
</form>
</body>
</html>
EOF
