#!/usr/bin/perl -w
#####################################################################################################
# Author: Derek Brewer (derekbr@us.ibm.com) / IBM
# Last Modified: 3-17-17
# License: GNU GPL V2
# Package: Nagios Core Mass Functions
# Description: Perl CGI script for selecting multiple service problems to acknowledge
#####################################################################################################

use strict;
no warnings 'uninitialized';
require 'parse_nagios.pl';
my $debug = 0;
my @services;
my $attribs;
my $numcheckbox;
my $key;
my $thispage = "mass_ack_services.cgi";
my @servicesfiltered;
my $i;

# read in the sort key or set default if not given
use CGI qw(:standard);
my $query = new CGI;
my $sortkey = $query->param('sort');
if (! defined "$sortkey"){
	$sortkey = "host_name";
}
my $order = $query->param('order');
if (! defined "$order" || ( $order ne "ascending" && $order ne "descending" )){
	$order = "ascending";
}

my $filterfield = $query->param('filterfield');
if (! defined "$filterfield"){
        $filterfield = "";
}

my $filterstring = $query->param('filterstring');
if (! defined "$filterstring"){
        $filterstring = "";
}

# determine what instance we will be acting on.
my @tokens = split(/\//, $ENV{'SCRIPT_FILENAME'});
my $instance = $tokens[4];
if ($instance eq "sbin"){
        $instance = "";
}

#Call the parse_status_dat function in parse_nagios.pl
@services = parse_status_dat($instance,"servicestatus","$filterstring","$filterfield","host_name","service_description","current_state","problem_has_been_acknowledged","state_type","plugin_output");

if ($debug){
	for $i ( 0 .. $#services ) {
	       for $attribs ( keys %{ $services[$i] } ) {
	                print "$attribs=$services[$i]{$attribs}\n";
	       }
	}
}
my $arrcount = 0;
#put the services that are not acknowledged into another hash so we can sort it later
for $i ( 0 .. $#services ) {
        if ($services[$i]{current_state} ne "Ok" &&  $services[$i]{problem_has_been_acknowledged} eq "0" && $services[$i]{state_type} eq "1" ) {
		#copy each key/value pair into the new array of hashes
		foreach $key (keys %{ $services[$i] }) {
                	$servicesfiltered[$arrcount]{$key} = "$services[$i]{$key}";
                }
                $arrcount++;
        }
}

#sort the output based on the key determined above
if($order eq "ascending"){
	@servicesfiltered = sort { $a->{$sortkey} cmp $b->{$sortkey} } @servicesfiltered;
}else{
	@servicesfiltered = sort { $b->{$sortkey} cmp $a->{$sortkey} } @servicesfiltered;
}

print "Content-type: text/html\n\n";
print <<"EOF";
<html>
<head>
<title>Nagios - Acknowledge Multiple Services</title>
EOF
print "<link href=\"/nagios/$instance/stylesheets/common.css\" type=\"text/css\" rel=\"stylesheet\">";
print "<script type=\"text/javascript\" src=\"/nagios/$instance/scripts.js\"></script>";
print <<"EOF";
</head>
<body>
<a href="mass_functions.cgi">Return to Mass Functions Main Page</a><br>
<h2>Acknowledge Multiple Service Problems:</h2>
EOF
print "User: $ENV{'REMOTE_USER'}<br><br>\n";
$numcheckbox = 1;
print <<"EOF";

<table border=0 width=100% class='status'>
	<tr>
		<th class='status'>&nbsp;</th>
EOF
build_header($instance,$thispage,$filterstring,$filterfield,"host_name","service_description","current_state","plugin_output");
print <<"EOF";
<form name="myform" action="ack_service_problems.cgi" method="post" onsubmit="return checkform(this);">
<input type="button" name="CheckAll" value="Check All" onClick="checkAll()">
<input type="button" name="UnCheckAll" value="Uncheck All" onClick="uncheckAll()"><br>
</tr>
EOF

for $i ( 0 .. $#servicesfiltered ) {
        	print "<tr><td><input type=\"checkbox\" name=\"$numcheckbox\" value=\"$servicesfiltered[$i]{host_name}::$servicesfiltered[$i]{service_description}\"></td><td>$servicesfiltered[$i]{host_name}</td><td>$servicesfiltered[$i]{service_description}</td><td>$servicesfiltered[$i]{current_state}</td><td>$servicesfiltered[$i]{plugin_output}</td></tr>\n";
		$numcheckbox++;
}
print "</table>\n";

if ($numcheckbox == 1){
	print "All problems have been acknowledged or there are no problems<br>\n";
}else{
print "<input type=\"hidden\" name=\"instance\" value=\"$instance\">\n";
print <<"EOF";
<br>Comment:
<input type="text" name="msg" size="50"><br>
<input type="button" name="CheckAll" value="Check All" onClick="checkAll()">
<input type="button" name="UnCheckAll" value="Uncheck All" onClick="uncheckAll()"><br>
<input type="submit" value="Submit">
EOF
}
print <<"EOF";
<br>
</form>
</body>
</html>
EOF
