#!/usr/bin/perl -w
#####################################################################################################
# Author: Derek Brewer (derekbr@us.ibm.com) / IBM
# Last Modified: 3-17-17
# License: GNU GPL V2
# Package: Nagios Core Mass Functions
# Description: Perl CGI script for selecting hosts to schedule downtime including all associated services
#####################################################################################################

use strict;
no warnings 'uninitialized';
require 'parse_nagios.pl';
my $debug = 0;
my @hosts;
my $attribs;
my $numcheckbox;
my $key;
my $thispage = "mass_downtime_combined.cgi";
my $tmpaddr;
my $i;

# read in the sort key or set default if not given
use CGI qw(:standard);
my $query = new CGI;
my $sortkey = $query->param('sort');
if (! defined "$sortkey"){
	$sortkey = "host_name";
}
my $order = $query->param('order');
if (! defined "$order" || ( $order ne "ascending" && $order ne "descending" )){
	$order = "ascending";
}

my $filterfield = $query->param('filterfield');
if (! defined "$filterfield"){
        $filterfield = "";
}

my $filterstring = $query->param('filterstring');
if (! defined "$filterstring"){
        $filterstring = "";
}

# determine what instance we will be acting on.
my @tokens = split(/\//, $ENV{'SCRIPT_FILENAME'});
my $instance = $tokens[4];
if ($instance eq "sbin"){
        $instance = "";
}

#Call the parse_status_dat function in parse_nagios.pl
@hosts = parse_status_dat($instance,"hoststatus","$filterstring","$filterfield","host_name","current_state","plugin_output");

if ($debug){
	for $i ( 0 .. $#hosts ) {
	       for $attribs ( keys %{ $hosts[$i] } ) {
	                print "$attribs=$hosts[$i]{$attribs}\n";
	       }
	}
}

#get the IP address for each service found so we can place it in the /tmp/nagios.errpt.clear.queue file
for (my $i = $#hosts; $i > -1; $i-- ) {
	$tmpaddr = get_ip($instance,$hosts[$i]{host_name});
	# if the output needs filtered by address, we do it here
	if ("$filterfield" eq "address" && "$filterstring" ne "" ){
		if ($tmpaddr =~ /$filterstring/ ){
			$hosts[$i]{address} = $tmpaddr;
		}else {
			# if the filter string doesn't match, then we completely remove the host from the results
			splice @hosts, $i, 1;
		}
	} else {
        	$hosts[$i]{address} = $tmpaddr;
	}
}

#sort the output based on the key determined above
if($order eq "ascending"){
	@hosts = sort { $a->{$sortkey} cmp $b->{$sortkey} } @hosts;
}else{
	@hosts = sort { $b->{$sortkey} cmp $a->{$sortkey} } @hosts;
}

print "Content-type: text/html\n\n";
print <<"EOF";
<html>
<head>
<title>Nagios - Schedule Downtime For Multiple Hosts and Their Services</title>
EOF
print "<link href=\"/nagios/$instance/stylesheets/common.css\" type=\"text/css\" rel=\"stylesheet\">";
print "<script type=\"text/javascript\" src=\"/nagios/$instance/scripts.js\"></script>";
print <<"EOF";
</head>
<body>
<a href="mass_functions.cgi">Return to Mass Functions Main Page</a><br>
<h2>Schedule Downtime For Multiple Hosts and Their Services:</h2>
EOF
print "User: $ENV{'REMOTE_USER'}<br><br>\n";
$numcheckbox = 1;
print <<"EOF";

<table border=0 width=100% class='status'>
	<tr>
		<th class='status'>&nbsp;</th>
EOF
build_header($instance,$thispage,"$filterstring","$filterfield","host_name","address","current_state","plugin_output");
print <<"EOF";
<form name="myform" action="schedule_downtime_combined.cgi" method="post" onsubmit="return checkform(this);">
<input type="button" name="CheckAll" value="Check All" onClick="checkAll()">
<input type="button" name="UnCheckAll" value="Uncheck All" onClick="uncheckAll()"><br>
</tr>
EOF

for $i ( 0 .. $#hosts ) {
        	print "<tr><td><input type=\"checkbox\" name=\"$numcheckbox\" value=\"$hosts[$i]{host_name}\"></td><td>$hosts[$i]{host_name}</td><td>$hosts[$i]{address}</td><td>$hosts[$i]{current_state}</td><td>$hosts[$i]{plugin_output}</td></tr>\n";
		$numcheckbox++;
}
print "</table>\n";

if ($numcheckbox == 1){
	print "Unable to find any Hosts<br>\n";
}else{
print "<input type=\"hidden\" name=\"instance\" value=\"$instance\">\n";
print <<"EOF";
<br>Comment:
<input type="text" name="msg" size="50"><br>
Times below are based off of this server's time which is
EOF
my $current_date_time = get_time("current_date_time");
my $two_hours_ahead = get_time("two_hours_ahead");
print $current_date_time;
print "<br>";
print "Start Time: (mm-dd-yyyy hh:mm:ss)";
print "<input type=\"text\" name=\"start\" size=\"50\" value=\"$current_date_time\"><br>";
print "End Time: (mm-dd-yyyy hh:mm:ss)";
print "<input type=\"text\" name=\"end\" size=\"50\" value=\"$two_hours_ahead\"><br>";
print <<"EOF";
<input type="button" name="CheckAll" value="Check All" onClick="checkAll()">
<input type="button" name="UnCheckAll" value="Uncheck All" onClick="uncheckAll()"><br>
<input type="submit" value="Submit">
EOF
}
print <<"EOF";
<br>
</form>
</body>
</html>
EOF
