#!/usr/bin/perl -w
#####################################################################################################
# Author: Derek Brewer (derekbr@us.ibm.com) / IBM
# Last Modified: 3-17-17
# License: GNU GPL V2
# Package: Nagios Core Mass Functions
# Description: Perl CGI script for selecting service groups for downtime
#####################################################################################################

no warnings 'uninitialized';
require 'parse_nagios.pl';
my $debug = 0;
my @servicegroups;
my $attribs;
my $numcheckbox;
my $key;
my $thispage = "mass_downtime_servicegroup.cgi";
my @servicegroupssfiltered;
my $i;

# read in the sort key or set default if not given
use CGI qw(:standard);
my $query = new CGI;
my $sortkey = $query->param('sort');
if (! defined "$sortkey"){
	$sortkey = "host_name";
}
my $order = $query->param('order');
if (! defined "$order" || ( $order ne "ascending" && $order ne "descending" )){
	$order = "ascending";
}

my $filterfield = $query->param('filterfield');
if (! defined "$filterfield"){
        $filterfield = "";
}

my $filterstring = $query->param('filterstring');
if (! defined "$filterstring"){
        $filterstring = "";
}

# determine what instance we will be acting on.
my @tokens = split(/\//, $ENV{'SCRIPT_FILENAME'});
my $instance = $tokens[4];
if ($instance eq "sbin"){
        $instance = "";
}

#Call the parse_status_dat function in parse_nagios.pl
@servicegroups = parse_objects_cache($instance,"servicegroup","$filterstring","$filterfield","servicegroup_name","alias","members");

#If servicegroup is empty, remove it from the array
@servicegroups = grep {
	$_->{members} ne ""
} @servicegroups;

if ($debug){
	for $i ( 0 .. $#servicegroups ) {
	       for $attribs ( keys %{ $servicegroups[$i] } ) {
	                print "$attribs=$servicegroups[$i]{$attribs}\n";
	       }
	}
}

#sort the output based on the key determined above
if($order eq "ascending"){
	@servicegroups = sort { $a->{$sortkey} cmp $b->{$sortkey} } @servicegroups;
}else{
	@servicegroups = sort { $b->{$sortkey} cmp $a->{$sortkey} } @servicegroups;
}

print "Content-type: text/html\n\n";
print <<"EOF";
<html>
<head>
<title>Nagios - Schedule Downtime For Multiple Service Groups</title>
EOF
print "<link href=\"/nagios/$instance/stylesheets/common.css\" type=\"text/css\" rel=\"stylesheet\">";
print "<script type=\"text/javascript\" src=\"/nagios/$instance/scripts.js\"></script>";
print <<"EOF";
</head>
<body>
<a href="mass_functions.cgi">Return to Mass Functions Main Page</a><br>
<h2>Schedule Downtime For Multiple Service Groups and All Their Services:</h2>
EOF
print "User: $ENV{'REMOTE_USER'}<br><br>\n";
$numcheckbox = 1;
print <<"EOF";

<table border=0 width=100% class='status'>
	<tr>
		<th class='status'>&nbsp;</th>
EOF
build_header($instance,$thispage,"$filterstring","$filterfield","servicegroup_name","alias","members");
print <<"EOF";
<form name="myform" action="schedule_downtime_servicegroup.cgi" method="post" onsubmit="return checkform(this);">
<input type="button" name="CheckAll" value="Check All" onClick="checkAll()">
<input type="button" name="UnCheckAll" value="Uncheck All" onClick="uncheckAll()"><br>
</tr>
EOF
print "<tr><td colspan=4><hr></td></tr>";
my @servicenamearray;
for $i ( 0 .. $#servicegroups ) {
        	print "<tr><td><input type=\"checkbox\" name=\"$numcheckbox\" value=\"$servicegroups[$i]{servicegroup_name}\"></td><td>$servicegroups[$i]{servicegroup_name}</td><td>$servicegroups[$i]{alias}</td></tr>\n";
		@servicenamearray = split(/,/, $servicegroups[$i]{members});
#                for my $j ( 0 .. $#servicenamearray ) {
		my $hostandservicename;
		while (my $j < $#servicenamearray ) {
			$hostandservicename = $servicenamearray[$j];
			shift @servicenamearray;
			$hostandservicename = $hostandservicename . " - " . $servicenamearray[$j];
			shift @servicenamearray;
                        print "<tr><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>$hostandservicename</td></tr>\n";
                }
		print "<tr><td colspan=4><hr></td></tr>";
		$numcheckbox++;
}
print "</table>\n";

if ($numcheckbox == 1){
	print "Unable to find any Service Groups<br>\n";
}else{
print "<input type=\"hidden\" name=\"instance\" value=\"$instance\">\n";
print <<"EOF";
<br>Comment:
<input type="text" name="msg" size="50"><br>
Times below are based off of this server's time which is
EOF
my $current_date_time = get_time("current_date_time");
my $two_hours_ahead = get_time("two_hours_ahead");
print $current_date_time;
print "<br>";
print "Start Time: (mm-dd-yyyy hh:mm:ss)";
print "<input type=\"text\" name=\"start\" size=\"50\" value=\"$current_date_time\"><br>";
print "End Time: (mm-dd-yyyy hh:mm:ss)";
print "<input type=\"text\" name=\"end\" size=\"50\" value=\"$two_hours_ahead\"><br>";
print <<"EOF";
<input type="button" name="CheckAll" value="Check All" onClick="checkAll()">
<input type="button" name="UnCheckAll" value="Uncheck All" onClick="uncheckAll()"><br>
<input type="submit" value="Submit">
EOF
}
print <<"EOF";
<br>
</form>
</body>
</html>
EOF
