#!/usr/bin/perl -w
#####################################################################################################
# Author: Derek Brewer (derekbr@us.ibm.com) / IBM
# Last Modified: 3-17-17
# License: GNU GPL V2
# Package: Nagios Core Mass Functions
# Description: Perl CGI script for selecting services for downtime
#####################################################################################################

use strict;
no warnings 'uninitialized';
require 'parse_nagios.pl';
my @servicestates = ("Ok","Warning","Critical","Unknown");
my $debug = 0;
my @services;
my $attribs;
my $numcheckbox;
my $key;
my $thispage = "mass_downtime_services.cgi";
my @servicesfiltered;
my $i;

# read in the sort key or set default if not given
use CGI qw(:standard);
my $query = new CGI;
my $sortkey = $query->param('sort');
if (! defined "$sortkey"){
	$sortkey = "host_name";
}
my $order = $query->param('order');
if (! defined "$order" || ( $order ne "ascending" && $order ne "descending" )){
	$order = "ascending";
}

my $filterfield = $query->param('filterfield');
if (! defined "$filterfield"){
        $filterfield = "";
}

my $filterstring = $query->param('filterstring');
if (! defined "$filterstring"){
        $filterstring = "";
}

# determine what instance we will be acting on.
my @tokens = split(/\//, $ENV{'SCRIPT_FILENAME'});
my $instance = $tokens[4];
if ($instance eq "sbin"){
        $instance = "";
}

#Call the parse_status_dat function in parse_nagios.pl
@services = parse_status_dat($instance,"servicestatus","$filterstring","$filterfield","host_name","service_description","current_state","plugin_output");

if ($debug){
	for $i ( 0 .. $#services ) {
	       for $attribs ( keys %{ $services[$i] } ) {
	                print "$attribs=$services[$i]{$attribs}\n";
	       }
	}
}

#sort the output based on the key determined above
if($order eq "ascending"){
	@services = sort { $a->{$sortkey} cmp $b->{$sortkey} } @services;
}else{
	@services = sort { $b->{$sortkey} cmp $a->{$sortkey} } @services;
}

print "Content-type: text/html\n\n";
print <<"EOF";
<html>
<head>
<title>Nagios - Schedule Downtime For Multiple Services</title>
EOF
print "<link href=\"/nagios/$instance/stylesheets/common.css\" type=\"text/css\" rel=\"stylesheet\">";
print "<script type=\"text/javascript\" src=\"/nagios/$instance/scripts.js\"></script>";
print <<"EOF";
</head>
<body>
<a href="mass_functions.cgi">Return to Mass Functions Main Page</a><br>
<h2>Schedule Downtime For Multiple Services:</h2>
EOF
print "User: $ENV{'REMOTE_USER'}<br><br>\n";
$numcheckbox = 1;
print <<"EOF";

<table border=1 width=100% class='status'>
	<tr>
		<th class='status'>&nbsp;</th>
EOF
build_header($instance,$thispage,$filterstring,$filterfield,"host_name","service_description","current_state","plugin_output");
print <<"EOF";
<form name="myform" action="schedule_downtime_services.cgi" method="post" onsubmit="return checkform(this);">
<input type="button" name="CheckAll" value="Check All" onClick="checkAll()">
<input type="button" name="UnCheckAll" value="Uncheck All" onClick="uncheckAll()"><br>
</tr>
EOF

for $i ( 0 .. $#services ) {
        	print "<tr><td><input type=\"checkbox\" name=\"$numcheckbox\" value=\"$services[$i]{host_name}::$services[$i]{service_description}\"></td><td>$services[$i]{host_name}</td><td>$services[$i]{service_description}</td><td>$services[$i]{current_state}</td><td>$services[$i]{plugin_output}</td></tr>\n";
		$numcheckbox++;
}
print "</table>\n";

if ($numcheckbox == 1){
	print "Unable to find any Services<br>\n";
}else{
print "<input type=\"hidden\" name=\"instance\" value=\"$instance\">\n";
print <<"EOF";
<br>Comment:
<input type="text" name="msg" size="50"><br>
Times below are based off of this server's time which is
EOF
my $current_date_time = get_time("current_date_time");
my $two_hours_ahead = get_time("two_hours_ahead");
print $current_date_time;
print "<br>";
print "Start Time: (mm-dd-yyyy hh:mm:ss)";
print "<input type=\"text\" name=\"start\" size=\"50\" value=\"$current_date_time\"><br>";
print "End Time: (mm-dd-yyyy hh:mm:ss)";
print "<input type=\"text\" name=\"end\" size=\"50\" value=\"$two_hours_ahead\"><br>";
print <<"EOF";
<input type="button" name="CheckAll" value="Check All" onClick="checkAll()">
<input type="button" name="UnCheckAll" value="Uncheck All" onClick="uncheckAll()"><br>
<input type="submit" value="Submit">
EOF
}
print <<"EOF";
<br>
</form>
</body>
</html>
EOF
