#!/usr/bin/perl -w
#####################################################################################################
# Author: Derek Brewer (derekbr@us.ibm.com) / IBM
# Last Modified: 3-17-17
# License: GNU GPL V2
# Package: Nagios Core Mass Functions
# Description: Perl CGI script for top level Mass Functions page
#####################################################################################################

my @tokens = split(/\//, $ENV{'SCRIPT_FILENAME'});
my $instance = $tokens[4];
if ($instance eq "sbin"){
	$instance = "";
}
print "Instance:>>" . $instance . "<<\n";
print "Content-type: text/html\n\n";
print <<"EOF";
<html>
<head>
<title>Nagios - Mass Functions</title>
EOF
print "<link href=\"/nagios/$instance/stylesheets/common.css\" type=\"text/css\" rel=\"stylesheet\">\n";
print "<link href=\"/nagios/$instance/stylesheets/status.css\" type=\"text/css\" rel=\"stylesheet\">\n";
print <<"EOF";
</head>
<body>
<div class="filterTitle">Nagios Mass Functions</div><br>
EOF
print "<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\">\n";
print "<tr class=\"command\"><td><img border=\"0\" src=\"/nagios/$instance/images/ack.gif\"></td><td valign=\"middle\"><a href=\"mass_ack_services.cgi\">Acknowledge Multiple Service Problems</a></td></tr>\n";
print "<tr class=\"command\"><td><img border=\"0\" src=\"/nagios/$instance/images/noack.gif\"></td><td valign=\"middle\"><a href=\"mass_unack_services.cgi\">Unacknowledge Multiple Service Problems</a></td></tr>\n";
print "</table>\n";
print "<br><br>\n";
print "<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\">\n";
print "<tr class=\"command\"><td><img border=\"0\" src=\"/nagios/$instance/images/ack.gif\"></td><td valign=\"middle\"><a href=\"mass_ack_combined.cgi\">Acknowledge Multiple Host/Service Problems (Combined)</a></td></tr>\n";
print "<tr class=\"command\"><td><img border=\"0\" src=\"/nagios/$instance/images/noack.gif\"></td><td valign=\"middle\"><a href=\"mass_unack_combined.cgi\">Unacknowledge Multiple Host/Service Problems (Combined)</a></td></tr>\n";
print "</table>\n";
print "<br><br>\n";
print "<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\">\n";
print "<tr class=\"command\"><td><img border=\"0\" src=\"/nagios/$instance/images/downtime.gif\"></td><td valign=\"middle\"><a href=\"mass_downtime_services.cgi\">Schedule Downtime for Multiple Services</a></td></tr>\n";
print "<tr class=\"command\"><td><img border=\"0\" src=\"/nagios/$instance/images/delete.gif\"></td><td valign=\"middle\"><a href=\"mass_remove_downtime_services.cgi\">Remove Scheduled Downtime for Multiple Services</a></td></tr>\n";
print "</table>\n";
print "<br><br>\n";
print "<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\">\n";
print "<tr class=\"command\"><td><img border=\"0\" src=\"/nagios/$instance/images/downtime.gif\"></td><td valign=\"middle\"><a href=\"mass_downtime_combined.cgi\">Schedule Downtime for Multiple Hosts/Services (Combined)</a></td></tr>\n";
print "<tr class=\"command\"><td><img border=\"0\" src=\"/nagios/$instance/images/delete.gif\"></td><td valign=\"middle\"><a href=\"mass_remove_downtime_combined.cgi\">Remove Scheduled Downtime for Multiple Hosts/Services (Combined)</a></td></tr>\n";
print "</table>\n";
print "<br><br>\n";
print "<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\">\n";
print "<tr class=\"command\"><td><img border=\"0\" src=\"/nagios/$instance/images/downtime.gif\"></td><td valign=\"middle\"><a href=\"mass_downtime_hostgroup.cgi\">Schedule Downtime for Multiple Hostgroups and All Respective Services</a></td></tr>\n";
print "<tr class=\"command\"><td><img border=\"0\" src=\"/nagios/$instance/images/downtime.gif\"></td><td valign=\"middle\"><a href=\"mass_downtime_servicegroup.cgi\">Schedule Downtime for Multiple Service Groups</a></td></tr>\n";
print "</table>\n";
print "<br><br>\n";
if ($instance ne ""){
	print "<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\">\n";
	print "<tr class=\"command\"><td><img border=\"0\" src=\"/nagios/$instance/images/enabled.gif\"></td><td valign=\"middle\"><a href=\"mass_clear_hw_error.cgi\">Clear the System:Hw_Error flag file on AIX system(s)</a></td></tr>\n";
	print "</table>\n";
	print "<br><br>\n";
}
print "<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\">\n";
print "<tr class=\"command\"><td><img border=\"0\" src=\"/nagios/$instance/images/passiveonly.gif\"></td><td valign=\"middle\"><a href=\"mass_submit_passive_service_checks.cgi\">Submit Passive Checks for Services</a></td></tr>\n";
print "</table>\n";
print <<"EOF";
</body>
</html>
EOF
