#!/usr/bin/perl -w
#####################################################################################################
# Author: Derek Brewer (derekbr@us.ibm.com) / IBM
# Last Modified: 3-17-17
# License: GNU GPL V2
# Package: Nagios Core Mass Functions
# Description: Perl CGI script for selecting downtime for hosts and associated services to be removed
#####################################################################################################

use strict;
no warnings 'uninitialized';
require 'parse_nagios.pl';
my $debug = 0;
my @hosts;
my $attribs;
my $numcheckbox;
my $key;
my $thispage = "mass_remove_downtime_combined.cgi";
my @hostsfiltered;
my $i;

# read in the sort key or set default if not given
use CGI qw(:standard);
my $query = new CGI;
my $sortkey = $query->param('sort');
if (! defined "$sortkey"){
	$sortkey = "host_name";
}
my $order = $query->param('order');
if (! defined "$order" || ( $order ne "ascending" && $order ne "descending" )){
	$order = "ascending";
}

my $filterfield = $query->param('filterfield');
if (! defined "$filterfield"){
        $filterfield = "";
}

my $filterstring = $query->param('filterstring');
if (! defined "$filterstring"){
        $filterstring = "";
}

# determine what instance we will be acting on.
my @tokens = split(/\//, $ENV{'SCRIPT_FILENAME'});
my $instance = $tokens[4];
if ($instance eq "sbin"){
        $instance = "";
}

#Call the parse_status_dat function in parse_nagios.pl
@hosts = parse_status_dat($instance,"hostdowntime","$filterstring","$filterfield","host_name","start_time","end_time","comment","author","downtime_id");

if ($debug){
	for $i ( 0 .. $#hosts ) {
	       for $attribs ( keys %{ $hosts[$i] } ) {
	                print "$attribs=$hosts[$i]{$attribs}\n";
	       }
	}
}

#sort the output based on the key determined above
if($order eq "ascending"){
	@hosts = sort { $a->{$sortkey} cmp $b->{$sortkey} } @hosts;
}else{
	@hosts = sort { $b->{$sortkey} cmp $a->{$sortkey} } @hosts;
}

print "Content-type: text/html\n\n";
print <<"EOF";
<html>
<head>
<title>Nagios - Remove Schedule Downtime For Multiple Hosts and Their Services</title>
EOF
print "<link href=\"/nagios/$instance/stylesheets/common.css\" type=\"text/css\" rel=\"stylesheet\">";
print "<script type=\"text/javascript\" src=\"/nagios/$instance/scripts.js\"></script>";
print <<"EOF";
</head>
<body>
<a href="mass_functions.cgi">Return to Mass Functions Main Page</a><br>
<h2>Remove Scheduled Downtime For Multiple Hosts and Their Services:</h2>
EOF
print "User: $ENV{'REMOTE_USER'}<br><br>\n";
$numcheckbox = 1;
print <<"EOF";

<table border=0 width=100% class='status'>
	<tr>
		<th class='status'>&nbsp;</th>
EOF
build_header($instance,$thispage,"$filterstring","$filterfield","host_name","start_time","end_time","comment","author");
print <<"EOF";
<form name="myform" action="remove_scheduled_downtime_combined.cgi" method="post" onsubmit="return checkform(this);">
<input type="button" name="CheckAll" value="Check All" onClick="checkAll()">
<input type="button" name="UnCheckAll" value="Uncheck All" onClick="uncheckAll()"><br>
</tr>
EOF

my $start_time;
my $end_time;
for $i ( 0 .. $#hosts ) {
		$start_time = localtime($hosts[$i]{start_time});
		$end_time = localtime($hosts[$i]{end_time});
        	print "<tr><td><input type=\"checkbox\" name=\"$numcheckbox\" value=\"$hosts[$i]{host_name}::$hosts[$i]{downtime_id}\"></td><td>$hosts[$i]{host_name}</td><td>$start_time</td><td>$end_time</td><td>$hosts[$i]{comment}</td><td>$hosts[$i]{author}</td></tr>\n";
		$numcheckbox++;
}
print "</table>\n";

if ($numcheckbox == 1){
	print "Unable to find any downtime scheduled for hosts<br>\n";
}else{
print "<input type=\"hidden\" name=\"instance\" value=\"$instance\">\n";
print <<"EOF";
<input type="button" name="CheckAll" value="Check All" onClick="checkAll()">
<input type="button" name="UnCheckAll" value="Uncheck All" onClick="uncheckAll()"><br>
<input type="submit" value="Submit">
EOF
}
print <<"EOF";
<br>
</form>
</body>
</html>
EOF
