#####################################################################################################
# Author: Derek Brewer (derekbr@us.ibm.com) / IBM
# Last Modified: 3-17-17
# License: GNU GPL V2
# Package: Nagios Core Mass Functions
# Description: Perl module with functions to 
# 		parse a particular type of stanza from the status.dat file.  Results are returned in an array of hashes
# 		Arguments: ARG1 = instance, ARG2 = stanza type, ARG3 = filter, ARG4 = filter field, ARG3 = directive 1, ARG4 = directive 2, ARGN = directive n-2...
#####################################################################################################
sub parse_status_dat {
	my $instance = $_[0];
	shift;
	my $stanzaname = $_[0];
	shift;
	my $filterstring = $_[0];
	shift;
	my $filterfield = $_[0];
	shift;
	my $status_file;
	if ($instance eq ""){
		$status_file = "/usr/local/nagios/var/status.dat";
	}else{
		$status_file = "/usr/local/nagios/$instance/var/ramdisk/status.dat";
	}
	my %tmphash;
	foreach (@_) {
		$tmphash{$_} = "";
	}
	#if the filter field is address, we will ignore.  This sort has to be done while looking at the object cache file, not status.dat
	if ($filterfield eq "address"){
		$filterfield = "";
	}
	my @tmparray;
	my $key;
	my @servicestates = ("Ok","Warning","Critical","Unknown");
	my @hoststates = ("Up","Down","Unreachable");
	my $arrcount = 0;
	my $reading_stanza = 0;
	my $debug = 0;
	if (-r $status_file){	
		open (STATUS, $status_file);
	}
	else {
		print STDERR "FAILED TO READ NAGIOS STATUS FILE\n";
		exit 1;
	}
	while(<STATUS>){
		#if the line starts with "<stanza name> {" then we're reading the values within
		if($_ =~ /$stanzaname \{/){
			$reading_stanza=1;
		#if the line is just "}" then we're at the end of the stanza
		}elsif($_ =~ /\}/ && $reading_stanza){
			$reading_stanza=0;
			#Apply the filter here so we only add the correct values to the array to be returned
			if (($filterfield eq "" || $filterstring eq "") || $tmphash{$filterfield} =~ /$filterstring/ ){
				foreach $key (keys %tmphash) {
					$tmparray[$arrcount]{$key} = "$tmphash{$key}";
				}
				$arrcount++;
			}
		}elsif($reading_stanza){
			foreach $key (keys %tmphash) {
				if ($_=~/\s+$key\=(.*)/){
					$tmphash{$key} = "$1";
					# Convert service state integers to the corresponding state string
					if("$key" eq "current_state"){
                                                if ("$stanzaname" eq "servicestatus"){
                                                        $tmphash{$key} = "$servicestates[$tmphash{$key}]";
                                                }else{
                                                        $tmphash{$key} = "$hoststates[$tmphash{$key}]";
                                                }
                                        }
				}
			}
		}
	}
	close(STATUS);

	#debug, print out everything in the array/hash
	if ($debug){
		for $i ( 0 .. $#tmparray ) {
			for $attribs ( keys %{ $tmparray[$i] } ) {
				print "$attribs=$tmparray[$i]{$attribs}\n";
			}
			print "##################\n";
		}
	}
	return @tmparray
}

sub parse_objects_cache{
	my $instance = $_[0];
        shift;
        my $stanzaname = $_[0];
        shift;
	my $filterstring = $_[0];
        shift;
        my $filterfield = $_[0];
        shift;
        my $objects_file = "/usr/local/nagios/$instance/var/objects.cache";
        my %tmphash;
        foreach (@_) {
                $tmphash{$_} = "";
        }
        my @tmparray;
        my $key;
        my $arrcount = 0;
        my $reading_stanza = 0;
        my $debug = 0;
	my $token;
        if (-r $objects_file){    
                open (OBJECTS, $objects_file);
        }
        else {
                print STDERR "FAILED TO READ NAGIOS OBJECTS FILE\n";
                exit 1;
        }
        while(<OBJECTS>){
		#if the line starts with "<stanza name> {" then we're reading the values within
                if($_ =~ /define $stanzaname \{/){
                        $reading_stanza=1;
                #if the line is just "}" then we're at the end of the stanza
                }elsif($_ =~ /\}/ && $reading_stanza){
                        $reading_stanza=0;
			#Apply the filter here so we only add the correct values to the array to be returned
                        if (($filterfield eq "" || $filterstring eq "") || $tmphash{$filterfield} =~ /$filterstring/ ){
                        	foreach $key (keys %tmphash) {
                       			$tmparray[$arrcount]{$key} = "$tmphash{$key}";
                        	}
                        	$arrcount++;
			}
			# clear the array to make sure there aren't residual keys/values
			foreach $key (keys %tmphash){
				$tmphash{$key} = "";
			}
                }elsif($reading_stanza){
                        foreach $key (keys %tmphash) {
                                if ($_=~/\s+$key(.*)/){
					$token = $1;
		                        $token =~ s/^\s*(.*?)\s*$/$1/;
                                        $tmphash{$key} = "$token";
                                }
                        }
                }
        }
        close(OBJECTS);

        #debug, print out everything in the array/hash
        if ($debug){
                for $i ( 0 .. $#tmparray ) {
                        for $attribs ( keys %{ $tmparray[$i] } ) {
                                print "$attribs=$tmparray[$i]{$attribs}\n";
                        }
                        print "##################\n";
                }
        }
        return @tmparray
}

sub passive_hw_check{
	my $instance = $_[0];
        my $hostnametofind = $_[1];
        my $hostname = "";
	my $servicedescription;
	my $active_checks_enabled;
	my $parents;
        my $objects_file = "/usr/local/nagios/$instance/var/objects.cache";
        my $reading_stanza = 0;
        my $debug = 0;
        my $token;
        if (-r $objects_file){
                open (OBJECTS, $objects_file);
        }
        else {
                print STDERR "FAILED TO READ NAGIOS OBJECTS FILE\n";
                exit 1;
        }
        while(<OBJECTS>){
                #if the line starts with "define host {" then we're reading the values within
                if($_ =~ /define host \{/){
                        $reading_stanza=1;
                #if the line is just "}" then we're at the end of the stanza
                }elsif($_ =~ /\}/ && $reading_stanza){
                        $reading_stanza=0;
                        if ("$hostname" eq "$hostnametofind"){
				# we found the stanza we need
				close(OBJECTS);
				if ("$active_checks_enabled" eq "0" && "$parents" ne ""){
					#return the parent IP address
					my $tmpvar = get_ip($instance,$parents);
					return get_ip($instance,$parents);
				}else{
					return "";
				}
                        }
                }elsif($reading_stanza){
			if ($_=~/\s+host_name(.*)/){
                                $token = $1;
                                $token =~ s/^\s*(.*?)\s*$/$1/;
                                $hostname = "$token";
                        }
                        if ($_=~/\s+active_checks_enabled(.*)/){
                                $token = $1;
                                $token =~ s/^\s*(.*?)\s*$/$1/;
                                $active_checks_enabled = "$token";
                        }
                        if ($_=~/\s+parents(.*)/){
                                $token = $1;
                                $token =~ s/^\s*(.*?)\s*$/$1/;
				#only grab the first parent in the list
				($parents) = split /\,/,$token;
                        }
                }
        }
        close(OBJECTS);
	# we shouldn't ever get here unless someohow we can't find the hostname
        return "";
}

sub get_ip{
        my $instance = $_[0];
        my $hostnametofind = $_[1];
	my $hostname = "";
        my $objects_file = "/usr/local/nagios/$instance/var/objects.cache";
        my $reading_stanza = 0;
        my $debug = 0;
        my $token;
        if (-r $objects_file){
                open (OBJECTS, $objects_file);
        }
        else {
                print STDERR "FAILED TO READ NAGIOS OBJECTS FILE\n";
                exit 1;
        }
        while(<OBJECTS>){
                #if the line starts with "<stanza name> {" then we're reading the values within
                if($_ =~ /define host \{/){
                        $reading_stanza=1;
                #if the line is just "}" then we're at the end of the stanza
                }elsif($_ =~ /\}/ && $reading_stanza){
                        $reading_stanza=0;
			if ("$hostname" eq "$hostnametofind"){
				close(OBJECTS);
				return $address;
			}
                }elsif($reading_stanza){
                	if ($_=~/\s+host_name(.*)/){
                                $token = $1;
                                $token =~ s/^\s*(.*?)\s*$/$1/;
                                $hostname = "$token";
                        }
			if ($_=~/\s+address(.*)/){
                                $token = $1;
                                $token =~ s/^\s*(.*?)\s*$/$1/;
                                $address = "$token";
                        }
                }
        }
        close(OBJECTS);
	return "Unable to find address";
}

sub build_header{
	my $instance = $_[0];
	shift;
	my $thispage = $_[0];
	shift;
	my $filterstring = $_[0];
        shift;
        my $filterfield = $_[0];
        shift;

	my @columns = @_;
	my $filtertext;
	my %columnkey = (
		host_name => "Hostname",
		address => "Address",
		hostgroup_name => "Host Group",
		servicegroup_name => "Service Group",
		alias => "Alias",
		service_description => "Service Description",
		current_state => "Status",
		plugin_output => "Status Information",
		start_time => "Start Time",
		end_time => "End Time",
		author => "Author",
		comment => "Comment",
		members => "Members"
	);
	foreach my $column (@columns){
		$filtertext = "";
		if ( $column eq $filterfield ){
			$filtertext = "value=\"$filterstring\"";
		}
		#for hostgroups, we can't easily sort by hostname
		if ($thispage eq "mass_downtime_hostgroup.cgi" && $column eq "host_name"){
			print "		<th class='status' align=left nowrap>$columnkey{$column}</th>";
		}else{
			print "         <th class='status' align=left nowrap>$columnkey{$column}&nbsp;<a href='$thispage?sort=$column&order=ascending'><IMG SRC='/nagios/$instance/images/up.gif' border=0 ALT='Sort by $columnkey{$column} (ascending)' TITLE='Sort by $columnkey{$column} (ascending)'></a><a href='$thispage?sort=$column&order=descending'><IMG SRC='/nagios/$instance/images/down.gif' border=0 ALT='Sort by $columnkey{$column} (descending)' TITLE='Sort by $columnkey{$column} (descending)'></a><br> 
			<form name=\"filterform\" action=\"$thispage\" method=\"post\">
				<input type=\"text\" name=\"filterstring\" size=\"10\" $filtertext>
				<input type=\"hidden\" name=\"filterfield\" value=\"$column\">
				<input type=\"submit\" value=\"Filter\">
			</form></th>";
		}
	}
}

sub get_time {
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);
	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
	$mon+=1;
	$year+=1900;
	if ( length($mon) == 1 ){ $mon="0$mon"; }
	if ( length($mday) == 1 ){ $mday="0$mday"; }
	if ( length($hour) == 1 ){ $hour="0$hour"; }
	if ( length($min) == 1 ){ $min="0$min"; }
	if ( length($sec) == 1 ){ $sec="0$sec"; }
	$current_date_time="$mon-$mday-$year $hour:$min:$sec";
	$hour+=2;
	if ( $hour == 24 || $hour == 25 ){
	        $hour-=24;
	        $mday+=1;
	        if ( $mon == 1 || $mon == 3 || $mon == 5 || $mon == 7 || $mon == 8 || $mon == 10 ){
	                if ($mday == 32 ){
	                        $mday=01;
	                        $mon+=1;
	                }
	        }
	        if ( $mon == 4 || $mon == 6 || $mon == 9 || $mon == 11 ){
	                if ($mday == 31 ){
	                        $mday=01;
	                        $mon+=1;
	                }
	        }
	        if ( $mon == 2 ){
	                if ($mday == 29 ){
	                        $mday=01;
	                        $mon+=1;
	                }
	        }
	        if ( $mon == 12 ){
	                if ($mday == 32 ){
	                        $mday=01;
	                        $mon=01;
	                        $year+=1;
	                }
	        }
	}
	if ( length($mon) == 1 ){ $mon="0$mon"; }
	if ( length($mday) == 1 ){ $mday="0$mday"; }
	if ( length($hour) == 1 ){ $hour="0$hour"; }
	$two_hours_ahead="$mon-$mday-$year $hour:$min:$sec";
	if ( $_[0] eq "current_date_time" ){
		return $current_date_time;
	}elsif ( $_[0] eq "two_hours_ahead" ){
		return $two_hours_ahead;
	}else{
		return "Unknown Argument";
	}
}

#perl requires the last expression in the file to return a true value
1;
