#!/usr/bin/perl -w
#####################################################################################################
# Author: Derek Brewer (derekbr@us.ibm.com) / IBM
# Created: 10-4-10
# Last Modified: 3-17-17
# License: GNU GPL V2
# Package: Nagios Core Mass Functions
# Description: Perl CGI script for removing scheduled downtime for host(s) and associated service(s)
#####################################################################################################

use Time::Local;

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
    ($name, $value) = split(/=/, $pair);
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $FORM{$name} = $value;
}

$instance = $FORM{instance};
delete $FORM{instance};

if ($instance eq ""){
        $command_file = "/usr/local/nagios/var/rw/nagios.cmd";
	$status_file = "/usr/local/nagios/var/status.dat";
}else{
        $command_file = "/usr/local/nagios/$instance/var/ramdisk/nagios.cmd";
	$status_file = "/usr/local/nagios/$instance/var/ramdisk/status.dat";
}

$log_file = "/usr/local/nagios/$instance/var/rw/massfunctions.log";
$user = $ENV{'REMOTE_USER'};
$htime = localtime(time);
$epochnow = time();

print "Content-type: text/html\n\n";
print <<"EOF";
<html>
<head>
<title>Nagios - Removing Scheduled Downtime</title>
EOF
print "<link href=\"/nagios/$instance/stylesheets/common.css\" type=\"text/css\" rel=\"stylesheet\">";
print <<"EOF";
</head>
<body>
EOF

my $reading_service = 0;
my $service_host_name;

if (-w $command_file){
	print "<a href=\"mass_functions.cgi\">Return to Mass Functions Main Page</a><br>\n";
	print "Removing Scheduled downtime for host(s) and their associated service(s) with the following info:<br>\n";
	print "User: $user<br>\n";
	print "\n<h2>Removing scheduled downtime for the following host(s) and associated service(s)</h2>\n";
	print "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n";
	print "<tr><td><b>Hostname</b></td><td><b>Service Description</b></td><td><b>Downtime ID</b></td></tr>\n";
	foreach $key (sort (keys(%FORM))) {
		($host_name,$downtime_id) = split(/::/, $FORM{$key});
		print "<tr><td>$host_name</td><td>&nbsp;</td><td>$downtime_id</td></tr>\n";
		open (CMD, '>>'.$command_file);
		print CMD "[$epochnow] DEL_HOST_DOWNTIME;$downtime_id\n";
		close (CMD);
		open (LOG, '>>'.$log_file);
                print LOG "[$htime] Delete Host Downtime Combined - $host_name - $user - $downtime_id\n";
                close (LOG);

		if (-r $status_file){
		        open (STATUS, $status_file);
		}
		else {
		        print STDERR "FAILED TO READ NAGIOS STATUS FILE\n";
		        exit 1;
		}
		while(<STATUS>){
		        #if the line starts with "servicedowntime {" then we're reading the values within
		        if($_ =~ /servicedowntime \{/){
		                $reading_service = 1;
		        #if the line is just "}" then we're at the end of the stanza
		        }elsif($_ =~ /\}/ && $reading_service){
		                $reading_service =0;
				if ($host_name eq $service_host_name){
					print "<tr><td>&nbsp;</td><td>$service_description</td><td>$downtime_id</td></tr>\n";
		                	open (CMD, '>>'.$command_file);
                			print CMD "[$epochnow] DEL_SVC_DOWNTIME;$downtime_id\n";
                			close (CMD);
					open (LOG, '>>'.$log_file);
			                print LOG "[$htime] Delete Service Downtime Combined - $host_name - $service_description - $user - $downtime_id\n";
        			        close (LOG);
				}
		        }elsif($reading_service){
		                if($_=~/\s+host_name\=(.*)/){
		                        $service_host_name = $1;
		                }
		                if($_=~/\s+service_description\=(.*)/){
		                        $service_description = $1;
		                }
		                if($_=~/\s+downtime_id\=(.*)/){
		                        $downtime_id = $1;
		                }
		        }
		}
		close(STATUS);
	}
	print "</table>\n";
}else{
	print "Unable to write to $command_file<br>\n";
}

print <<"EOF";
</body>
</html>
EOF
