#!/usr/bin/perl -w
#####################################################################################################
# Author: Derek Brewer (derekbr@us.ibm.com) / IBM
# Created: 10-4-10
# Last Modified: 3-17-17
# License: GNU GPL V2
# Package: Nagios Core Mass Functions
# Description: Perl CGI script for removing scheduled downtime for multiple services
#####################################################################################################

use Time::Local;

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
    ($name, $value) = split(/=/, $pair);
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $FORM{$name} = $value;
}

$instance = $FORM{instance};
delete $FORM{instance};

if ($instance eq ""){
        $command_file = "/usr/local/nagios/var/rw/nagios.cmd";
}else{
        $command_file = "/usr/local/nagios/$instance/var/ramdisk/nagios.cmd";
}

$log_file = "/usr/local/nagios/$instance/var/rw/massfunctions.log";
$user = $ENV{'REMOTE_USER'};
$htime = localtime(time);
$epochnow = time();

print "Content-type: text/html\n\n";
print <<"EOF";
<html>
<head>
<title>Nagios - Removing Scheduled Downtime</title>
EOF
print "<link href=\"/nagios/$instance/stylesheets/common.css\" type=\"text/css\" rel=\"stylesheet\">";
print <<"EOF";
</head>
<body>
EOF

if (-w $command_file){
	print "<a href=\"mass_functions.cgi\">Return to Mass Functions Main Page</a><br>\n";
	print "Removing Scheduled downtime for services with the following info:<br>\n";
	print "User: $user<br>\n";
	print "\n<h2>Removing scheduled downtime for the following service(s)</h2>\n";
	print "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n";
	print "<tr><td><b>Hostname</b></td><td><b>Service Description</b></td><td><b>Downtime ID</b></td></tr>\n";
	foreach $key (sort (keys(%FORM))) {
		($host_name,$service_description,$downtime_id) = split(/::/, $FORM{$key});
		print "<tr><td>$host_name</td><td>$service_description</td><td>$downtime_id</td></tr>\n";
		open (CMD, '>>'.$command_file);
		print CMD "[$epochnow] DEL_SVC_DOWNTIME;$downtime_id\n";
		close (CMD);
		open (LOG, '>>'.$log_file);
                print LOG "[$htime] Delete Service Downtime - $host_name - $service_description - $user - $downtime_id\n";
                close (LOG);
	}
	print "</table>\n";
}else{
	print "Unable to write to $command_file<br>\n";
}

print <<"EOF";
</body>
</html>
EOF
