#!/usr/bin/perl -w
#####################################################################################################
# Author: Derek Brewer (derekbr@us.ibm.com) / IBM
# Created: 10-4-10
# Last Modified: 3-17-17
# License: GNU GPL V2
# Package: Nagios Core Mass Functions
# Description: Perl CGI script for scheduling downtime for host(s) and associated service(s)
#####################################################################################################

use Time::Local;

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
    ($name, $value) = split(/=/, $pair);
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $FORM{$name} = $value;
}

$message = $FORM{msg};
delete $FORM{msg};
$start = $FORM{start};
delete $FORM{start};
$end = $FORM{end};
delete $FORM{end};
$instance = $FORM{instance};
delete $FORM{instance};

if ($instance eq ""){
        $command_file = "/usr/local/nagios/var/rw/nagios.cmd";
	$status_file = "/usr/local/nagios/var/status.dat";
}else{
        $command_file = "/usr/local/nagios/$instance/var/ramdisk/nagios.cmd";
	$status_file = "/usr/local/nagios/$instance/var/ramdisk/status.dat";
}

print "Content-type: text/html\n\n";
print <<"EOF";
<html>
<head>
<title>Nagios - Scheduling Downtime</title>
EOF
print "<link href=\"/nagios/$instance/stylesheets/common.css\" type=\"text/css\" rel=\"stylesheet\">";
print <<"EOF";
</head>
<body>
EOF

if ($message eq "" || $start eq "" || $end eq ""){
	print "You must enter a Comment and a valid start and end time<br>\n";
	print "Comment: $message<br>";
	print "Start Time: $start<br>";
	print "End Time: $end<br>";
	print "Use your browser's back button to go back and try again";
	print "</body></html>";
	exit;
}

$log_file = "/usr/local/nagios/$instance/var/rw/massfunctions.log";
$user = $ENV{'REMOTE_USER'};
$htime = localtime(time);
$epochnow = time();

# Convert human readable date to epoch date
sub convertToEpoch{
	my ($time1) = @_;
	($date, $time) = split(/ /, $time1);
	($month, $day, $year) = split (/-/, $date);
	($hour, $minute, $second) = split (/:/, $time);
	$month--; #timelocal function requires January to be represented as 0
	$year = $year - 1900; #timelocal function requires year to be the number from 1900
	return timelocal($second, $minute, $hour, $day, $month, $year);
}

$startepoch = convertToEpoch($start);
$endepoch = convertToEpoch($end);

# Now schedule the downtime for the services that are associated with the hosts
if (-w $command_file){
	print "<a href=\"mass_functions.cgi\">Return to Mass Functions Main Page</a><br>\n";
        print "Scheduling downtime for services with the following info:<br>\n";
        print "User: $user<br>\n";
        print "Comment: $message<br>\n";
        print "Start Time: $start<br>\n";
        print "End Time: $end <br><br>\n";
        print "\n<h2>Scheduling downtime for the following host(s) and service(s)</h2>\n";
        print "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n";
        print "<tr><td><b>Hostname</b></td><td><b>Service Name</b></td></tr>\n";
        foreach $key (sort (keys(%FORM))) {
                $host_name = $FORM{$key};
		print "<tr><td>$host_name</td><td>&nbsp;</td></tr>\n";
                open (CMD, '>>'.$command_file);
                print CMD "[$epochnow] SCHEDULE_HOST_DOWNTIME;$host_name;$startepoch;$endepoch;1;0;0;$user;$message\n";
                close (CMD);
		open (LOG, '>>'.$log_file);
                print LOG "[$htime] Schedule Host Downtime Combined - $host_name - $user - $message - Start: $startepoch - End: $endepoch\n";
                close (LOG);
		# Now that we have the hostname, we need to find all the services for that host and schedule the downtime for them.
		# determine what instance we will be acting on.
		my @tokens = split(/\//, $ENV{'SCRIPT_FILENAME'});
		my $instance = $tokens[4];
		my $reading_service = 0;
		my $service_host_name;
		my $service_description;
		if (-r $status_file){
		        open (STATUS, $status_file);
		}
		else {
		        print STDERR "FAILED TO READ NAGIOS STATUS FILE\n";
		        exit 1;
		}
		while(<STATUS>){
		        if($_ =~ /servicestatus \{/){
		               	$reading_service = 1;
		        #if the line is just "}" then we're at the end of the stanza
		        }elsif($_ =~ /\}/ && $reading_service){
				# at this point, we have read in a service name of a matching host and we need to schedule the downtime for that service
		                $reading_service =0;
				if ($host_name eq $service_host_name){
					print "<tr><td>&nbsp;</td><td>$service_description</td></tr>\n";
					open (CMD, '>>'.$command_file);
		                	print CMD "[$epochnow] SCHEDULE_SVC_DOWNTIME;$host_name;$service_description;$startepoch;$endepoch;1;0;0;$user;$message\n";
		                	close (CMD);
					open (LOG, '>>'.$log_file);
			                print LOG "[$htime] Schedule Service Downtime Combined - $host_name - $service_description - $user - $message - Start: $startepoch - End: $endepoch\n";
        			        close (LOG);
				}
		        }elsif($reading_service){
				if($_=~/\s+host_name\=(.*)/){
                                        $service_host_name = $1;
                                }
		                if($_=~/\s+service_description\=(.*)/){
		                        $service_description = $1;
		                }
		        }
		}
		close(STATUS);
        }
        print "</table>\n";
}else{
        print "Unable to write to $command_file<br>\n";
}

print <<"EOF";
</body>
</html>
EOF
