#!/usr/bin/perl -w
#####################################################################################################
# Author: Derek Brewer (derekbr@us.ibm.com) / IBM
# Created: 10-4-10
# Last Modified: 3-17-17
# License: GNU GPL V2
# Package: Nagios Core Mass Functions
# Description: Perl CGI script for scheduling downtime for multiple service groups
#####################################################################################################

use Time::Local;

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
my @pairs = split(/&/, $buffer);
my $pair;
my $value;
foreach $pair (@pairs) {
    ($name, $value) = split(/=/, $pair);
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $FORM{$name} = $value;
}

my $message = $FORM{msg};
delete $FORM{msg};
my $start = $FORM{start};
delete $FORM{start};
my $end = $FORM{end};
delete $FORM{end};
my $instance = $FORM{instance};
delete $FORM{instance};

if ($instance eq ""){
        $command_file = "/usr/local/nagios/var/rw/nagios.cmd";
}else{
        $command_file = "/usr/local/nagios/$instance/var/ramdisk/nagios.cmd";
}

print "Content-type: text/html\n\n";
print <<"EOF";
<html>
<head>
<title>Nagios - Scheduling Downtime</title>
EOF
print "<link href=\"/nagios/$instance/stylesheets/common.css\" type=\"text/css\" rel=\"stylesheet\">";
print <<"EOF";
</head>
<body>
EOF

if ($message eq "" || $start eq "" || $end eq ""){
	print "You must enter a Comment and a valid start and end time<br>\n";
	print "Comment: $message<br>";
	print "Start Time: $start<br>";
	print "End Time: $end<br>";
	print "Use your browser's back button to go back and try again";
	print "</body></html>";
	exit;
}

$log_file = "/usr/local/nagios/$instance/var/rw/massfunctions.log";
my $user = $ENV{'REMOTE_USER'};
$htime = localtime(time);
my $epochnow = time();
my $servicelist;
my $uniqueservices;

# Convert human readable date to epoch date
sub convertToEpoch{
	my ($time1) = @_;
	($date, $time) = split(/ /, $time1);
	($month, $day, $year) = split (/-/, $date);
	($hour, $minute, $second) = split (/:/, $time);
	$month--; #timelocal function requires January to be represented as 0
	$year = $year - 1900; #timelocal function requires year to be the number from 1900
	return timelocal($second, $minute, $hour, $day, $month, $year);
}

$startepoch = convertToEpoch($start);
$endepoch = convertToEpoch($end);

# Get a unique list of services in all the selected servicegroups passed in
my $objects_file = "/usr/local/nagios/$instance/var/objects.cache";

unless (-e $objects_file){
        print "$objects_file does not exist.  Make sure you specified the correct instance name and that it's running.\n";
        exit 1;
}

my $reading_servicegroup = 0;
my $servicegroup_name;
my $token;
my @members;
my $members;

if (-r $objects_file){
        open (OBJECTS, $objects_file);
}
else {
        print STDERR "FAILED TO READ NAGIOS OBJECTS FILE\n";
        exit 1;
}
while(<OBJECTS>){
        #if the line starts with "define servicegroup {" then we're reading the values within
        if($_ =~ /define servicegroup \{/){
                $reading_servicegroup = 1;
        #if the line is just "}" then we're at the end of the stanza
        }elsif($_ =~ /\}/ && $reading_servicegroup){
                $reading_servicegroup =0;
		foreach $key (sort (keys(%FORM))) {
                        if ("$FORM{$key}" eq "$servicegroup_name"){
				#Add all the services in the servicegroup to the array
				push(@servicelist, split(/,/, $members));
			}
		}
        }elsif($reading_servicegroup){
                if($_=~/\s+servicegroup_name(.*)/){
                        $token = $1;
                        $token =~ s/^\s*(.*?)\s*$/$1/;
                        $servicegroup_name = $token;
                }
                if($_=~/\s+members(.*)/){
                        $token = $1;
                        $token =~ s/^\s*(.*?)\s*$/$1/;
			# since service group members are listed in pairs (<hostname>,<servicename>)
			# we need to parse them accordingly
			@members = split(',', $token);
			$members = "";
			while (@members){
				$members .= shift(@members) . "::" . shift(@members);
				$members .= ',' if @members;
			}
                }
        }
}

close(OBJECTS);

# Trim out the duplicate services in the @servicelist array
@uniqueservices = do { my %seen; grep { !$seen{$_}++ } @servicelist};

my $service;
# Now schedule the downtime for the services that are associated with the services
if (-w $command_file){
        open (CMD, '>>'.$command_file);
        print "<a href=\"mass_functions.cgi\">Return to Mass Functions Main Page</a><br>\n";
        print "Scheduling downtime for services with the following info:<br>\n";
        print "User: $user<br>\n";
        print "Comment: $message<br>\n";
        print "Start Time: $start<br>\n";
        print "End Time: $end <br><br>\n";
        print "\n<h2>Scheduling downtime for the following service(s)</h2>\n";
        print "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n";
        print "<tr><td><b>Hostname</b></td><td><b>Service Description</b></td></tr>\n";
        foreach $service (@uniqueservices) {
                ($host_name, $service_description) = split(/::/, $service);
                print "<tr><td>$host_name</td><td>$service_description</td></tr>\n";
                open (CMD, '>>'.$command_file);
                print CMD "[$epochnow] SCHEDULE_SVC_DOWNTIME;$host_name;$service_description;$startepoch;$endepoch;1;0;0;$user;$message\n";
                close (CMD);
                open (LOG, '>>'.$log_file);
                print LOG "[$htime] Schedule Service Group Downtime - $host_name - $service_description - $user - $message - Start: $startepoch - End: $endepoch\n";
                close (LOG);
        }
        print "</table>\n";
        close (CMD);
}else{
        print "Unable to write to $command_file<br>\n";
}

print <<"EOF";
</body>
</html>
EOF
