#!/usr/bin/perl -w
#####################################################################################################
# Author: Derek Brewer (derekbr@us.ibm.com) / IBM
# Created: 10-4-10
# Last Modified: 3-17-17
# License: GNU GPL V2
# Package: Nagios Core Mass Functions
# Description: Perl CGI script for submitting passive checks for multiple non-OK services
#####################################################################################################

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
    ($name, $value) = split(/=/, $pair);
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $FORM{$name} = $value;
}

$message = $FORM{msg};
delete $FORM{msg};
$instance = $FORM{instance};
delete $FORM{instance};
$state = $FORM{state};
delete $FORM{state};
if ("$state" eq "OK" ){
	$statecode = 0;
}elsif ("$state" eq "WARNING" ){
	$statecode = 1;
}elsif ("$state" eq "CRITICAL" ){
	$statecode = 2;
}else{
	$statecode = 3;
}

if ($instance eq ""){
        $command_file = "/usr/local/nagios/var/rw/nagios.cmd";
}else{
        $command_file = "/usr/local/nagios/$instance/var/ramdisk/nagios.cmd";
}

$log_file = "/usr/local/nagios/$instance/var/rw/massfunctions.log";
$user = $ENV{'REMOTE_USER'};
$htime = localtime(time);
$time = time();

print "Content-type: text/html\n\n";
print <<"EOF";
<html>
<head>
<title>Nagios - Submitting Passive Service Checks</title>
EOF
print "<link href=\"/nagios/$instance/stylesheets/common.css\" type=\"text/css\" rel=\"stylesheet\">";
print <<"EOF";
</head>
<body>
EOF

if (-w $command_file){
	print "<a href=\"mass_functions.cgi\">Return to Mass Functions Main Page</a><br>\n";
	print "Sending passive check results with the following info:<br>\n";
	print "User: $user<br>\n";
	print "State: $state<br>\n";
	print "State Code: $statecode<br>\n";
	print "Comment: $message<br><br>\n";
	print "\n<h2>Submitting results to the following Host(s)' Service(s)</h2>\n";
	print "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n";
	print "<tr><td><b>Hostname</b></td><td><b>Service Description</b></td></tr>\n";
	foreach $key (sort (keys(%FORM))) {
		($host_name, $service_description) = split(/::/, $FORM{$key});
		print "<tr><td>$host_name</td><td>$service_description</td></tr>\n";
		open (CMD, '>>'.$command_file);
		print CMD "[$time] PROCESS_SERVICE_CHECK_RESULT;$host_name;$service_description;$statecode;$message\n";
		close (CMD);
		open (LOG, '>>'.$log_file);
                print LOG "[$htime] Submit Passive Check Service - $host_name - $service_description - $user - Status: $statecode - $message\n";
                close (LOG);
	}
	print "</table>\n";
}else{
	print "Unable to write to $command_file<br>\n";
}

print <<"EOF";
</body>
</html>
EOF
