#!/usr/bin/perl -w
#####################################################################################################
# Author: Derek Brewer (derekbr@us.ibm.com) / IBM
# Created: 10-4-10
# Last Modified: 3-17-17
# License: GNU GPL V2
# Package: Nagios Core Mass Functions
# Description: Perl CGI script for unacknowledging all problems on host(s) including it's services
#####################################################################################################

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
    ($name, $value) = split(/=/, $pair);
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $FORM{$name} = $value;
}

delete $FORM{msg};
$instance = $FORM{instance};
delete $FORM{instance};

if ($instance eq ""){
        $command_file = "/usr/local/nagios/var/rw/nagios.cmd";
	$status_file = "/usr/local/nagios/var/status.dat";
}else{
        $command_file = "/usr/local/nagios/$instance/var/ramdisk/nagios.cmd";
	$status_file = "/usr/local/nagios/$instance/var/ramdisk/status.dat";
}

$log_file = "/usr/local/nagios/$instance/var/rw/massfunctions.log";
$user = $ENV{'REMOTE_USER'};
$htime = localtime(time);
$time = time();

print "Content-type: text/html\n\n";
print <<"EOF";
<html>
<head>
<title>Nagios - Unacknowledging Host/Service Problems (Combined)</title>
EOF
print "<link href=\"/nagios/$instance/stylesheets/common.css\" type=\"text/css\" rel=\"stylesheet\">";
print <<"EOF";
</head>
<body>
EOF

if (-w $command_file){
	print "<a href=\"mass_functions.cgi\">Return to Mass Functions Main Page</a><br>\n";
	print "Sending Unacknowledge commands with the following info:<br>\n";
	print "User: $user<br>\n";
	print "\n<h2>Unacknowledging the following Host(s) and Service(s)</h2>\n";
	print "<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n";
	print "<tr><td><b>Hostname</b></td><td><b>Service Name</b></td></tr>\n";
	foreach $key (sort (keys(%FORM))) {
		$host_name = $FORM{$key};
		print "<tr><td>$host_name</td><td>&nbsp;</td></tr>\n";
		open (CMD, '>>'.$command_file);
		print CMD "[$time] REMOVE_HOST_ACKNOWLEDGEMENT;$host_name\n";
		close (CMD);
		open (LOG, '>>'.$log_file);
                print LOG "[$htime] Remove Host Acknowledgement Combined - $host_name - $user\n";
                close (LOG);

		# Now that we have the hostname, we need to find all the services for that host that aren't acknowledged and acknowledge them
                # determine what instance we will be acting on.
                my $reading_service = 0;
                my $service_host_name;
                my $service_description;
                my $acknowledged;
                if (-r $status_file){ 
                        open (STATUS, $status_file);
                }
                else {
                        print STDERR "FAILED TO READ NAGIOS STATUS FILE\n";
                        exit 1;
                }
                while(<STATUS>){
                        if($_ =~ /servicestatus \{/){
                                $reading_service = 1;
                        #if the line is just "}" then we're at the end of the stanza
                        }elsif($_ =~ /\}/ && $reading_service){
                                # at this point, we have read in a service name of a matching host and we need to schedule the downtime for that service
                                $reading_service =0;
                                if ("$host_name" eq "$service_host_name" &&  "$acknowledged" ne "0"){
                                        print "<tr><td>&nbsp;</td><td>$service_description</td></tr>\n";
                                        open (CMD, '>>'.$command_file);
					print CMD "[$time] REMOVE_SVC_ACKNOWLEDGEMENT;$host_name;$service_description\n";
                                        close (CMD);
					open (LOG, '>>'.$log_file);
			                print LOG "[$htime] Remove Service Acknowledgement Combined - $host_name - $service_description - $user\n";
        			        close (LOG);
                                }
                        }elsif($reading_service){
                                if($_=~/\s+host_name\=(.*)/){
                                        $service_host_name = $1;
                                }
                                if($_=~/\s+service_description\=(.*)/){
                                        $service_description = $1;
                                }
                                if($_=~/\s+problem_has_been_acknowledged\=([0-9]*)/){
                                        $acknowledged = $1;
                                }
                        }
                }
                close(STATUS);
	}
	print "</table>\n";
}else{
	print "Unable to write to $command_file<br>\n";
}

print <<"EOF";
</body>
</html>
EOF
