/*#####################################################################################################
# Author: Derek Brewer (derekbr@us.ibm.com) / IBM
# Last Modified: 3-17-17
# License: GNU GPL V2
# Package: Nagios Core Mass Functions
# Description: Various JavaScript functions for use with the Mass Functions CGIs
#####################################################################################################*/

function checkAll( form )
{
	var inputs = document.getElementsByTagName('input');
	for(var i = 0; i < inputs.length; i++) {
	    if(inputs[i].type == "checkbox") {
	        inputs[i].checked = true; 
	    }  
	}
}

function uncheckAll()
{
	var inputs = document.getElementsByTagName('input');
        for(var i = 0; i < inputs.length; i++) {
            if(inputs[i].type == "checkbox") {
                inputs[i].checked = false;
            }
        }
}
function checkform ( form )
{
	if(typeof(form.msg) != "undefined"){
		if (form.msg.value == "") {
			alert( "Please enter a comment." );
			form.msg.focus();
			return false ;
		}
	}
        var checkedAtLeastOne = false;
        var formelements=document.getElementsByTagName('input');
        for(var x=0; x<formelements.length; x++){
                if(formelements[x].type=='checkbox'){
                        if (formelements[x].checked){
                                checkedAtLeastOne = true;
                        }
                }
        }
        if (checkedAtLeastOne == false){
                alert( "You must check at least one checkbox." );
                return false ;
        }
	if(typeof(form.start) != "undefined" && typeof(form.end) != "undefined"){
		var regexpr=/^[01][0-9]-[0-3][0-9]-20[0-9][0-9] [012][0-9]:[0-5][0-9]:[0-9][0-9]$/;
		if(!form.start.value.match(regexpr) || !form.end.value.match(regexpr)){
			alert( "Bad date/time format entered." );
	                return false ;
		}
	}

	var startparts = form.start.value.split(/\D/);
	var startDate = new Date(startparts[2], --startparts[0], startparts[1], startparts[3], startparts[4], startparts[5]);
	var startEpoch = startDate.getTime()/1000.0;

	var endparts = form.end.value.split(/\D/);
        var endDate = new Date(endparts[2], --endparts[0], endparts[1], endparts[3], endparts[4], endparts[5]);
        var endEpoch = endDate.getTime()/1000.0;

	if(startEpoch >= endEpoch){
		alert( "End time must be after start time." );
		return false ;	
	}
        return true ;
}
