#!/usr/bin/perl
use Switch;
use SLA;
use SLA_LOG;
use SLA_REPORT;
use DBI;

# Nagios SLA Reporting Script Part 2 - Reporting
# Philipp Lachberger, X-Tention IT GmbH

# --- Configuration Data (modify to match your system) --- #
$sla_mysqldb = 'sla_user';
$sla_mysqlhost = 'localhost';
$sla_mysqluser = 'sla-user';
$sla_mysqlpass = 'this.passw0rd';

my @SLA = parseData();
if (@SLA == 0)
{
	exit 2;
}

my @log = retrieveData("sla_log");
my @exclusion = retrieveData("sla_exclusion");

my $i = 0;
do
{
	my $temp = SLA_LOG->new();
	push @SLA_LOG,$temp;
	$SLA_LOG[$i]->timestamp(shift @log);
	$SLA_LOG[$i]->state(shift @log);
	$SLA_LOG[$i]->host_service(shift @log);
	$i++;
} while (@log != 0);

undef $i;

my @SLA_REPORT;

foreach(@SLA)
{
	my $sla_obj = $_;
	foreach (@SLA_LOG)
	{
		my $log_obj = $_;
		if ($sla_obj->{DEPENDENCY} =~ /\Q$log_obj->{HOST_SERVICE}\E/)
		{
			if ($log_obj->{STATE} eq "Critical" || $log_obj->{STATE} eq "CRITICAL")
			{
				my $new_report = SLA_REPORT->new();
				$log_obj = calculateTimestamp($sla_obj, $log_obj);
				$new_report->service_name($sla_obj->{SERVICE_NAME});
				$new_report->start_time($log_obj->{TIMESTAMP});
				push @SLA_REPORT, $new_report;
			}
			if ($log_obj->{STATE} eq "OK")
			{
				foreach(@SLA_REPORT)
				{
					if ($_->{SERVICE_NAME} eq $sla_obj->{SERVICE_NAME})
					{	
						$log_obj = calculateTimestamp($sla_obj, $log_obj);
						$_->end_time($log_obj->{TIMESTAMP});
						$_->sla_seconds($sla_obj->{SECONDS});
					}
				}
			}
		}
	}
}

truncateTable("sla_report");
my $dbh = DBI->connect("DBI:mysql:$sla_mysqldb:$sla_mysqlhost", $sla_mysqluser, $sla_mysqlpass) or die $DBI::errstr;

my $reportedService = "";
foreach(@SLA_REPORT)
{
	my $diff_time = 0;
	my $SLA = $_;
	if ($reportedService !~ /\Q$SLA->{SERVICE_NAME}\E/)
	{
		$diff_time = $SLA->{END_TIME} - $SLA->{START_TIME};
		$SLA->{SLA_SECONDS} -= $diff_time;
		$reportedService .= $SLA->{SERVICE_NAME};
		$reportedService .= ";";
	}
	else
	{
		# second occurence of Service
        $diff_time = $SLA->{END_TIME} - $SLA->{START_TIME};
        $SLA->{SLA_SECONDS} -= $diff_time;
	}
}

@final_report = shift @SLA_REPORT;
my $reportService = "$final_report[0]->{SERVICE_NAME}";
$reportService .= ";";
do
{
	if ($reportService =~ /$SLA_REPORT[$#SLA_REPORT]->{SERVICE_NAME}/)
	{
		my $i = 0;
		while ($final_report[$i]->{SERVICE_NAME} ne $SLA_REPORT[$#SLA_REPORT]->{SERVICE_NAME})
		{
			$i++;
		}
		$final_report[$i]->{SLA_SECONDS} -= ($SLA_REPORT[$#SLA_REPORT]->{END_TIME} - $SLA_REPORT[$#SLA_REPORT]->{START_TIME});
		pop @SLA_REPORT;
	}
	else
	{
		push @final_report,$SLA_REPORT[$#SLA_REPORT];
		pop @SLA_REPORT;
		$reportService .= "$final_report[$#final_report]->{SERVICE_NAME}";
		$reportService .= ";";
	}
} while (@SLA_REPORT);

foreach (@final_report)
{
	my $SLA = $_;
	$SQL="INSERT INTO `sla_user`.`sla_report` ( `service_name` , `seconds_left` ) VALUES ( '$SLA->{SERVICE_NAME}', '$SLA->{SLA_SECONDS}');";
        $cursor = $dbh->prepare($SQL);
        $cursor->execute();
}
$dbh->disconnect();

# ----- Method Definition goes below ----- #
sub truncateTable
{
	my $dbh = DBI->connect("DBI:mysql:$sla_mysqldb:$sla_mysqlhost", $sla_mysqluser, $sla_mysqlpass) or die $DBI::errstr;
	my $SQL = "TRUNCATE TABLE $_[0]";
	my $cursor = $dbh->prepare($SQL);
	$cursor->execute();
	$cursor->finish();
	$dbh->disconnect();
}

# parsing the data output from database, storing it in an object-array
sub parseData {
	my @SLA;
	my $i = 0;
	my @data = retrieveData ("sla_config");
	do
	{
		for my $i ($data->{MONDAY},$data->{TUESDAY},$data->{WEDNESDAY},$data->{THURSDAY},$data->{FRIDAY},$data->{SATURDAY},$data->{SUNDAY})
		{
			if ($i !~ /^\d{1,2}:\d{1,2},\d{1,2}:\d{1,2}$/)
			{
				print "Date has to be in Format \"xx:xx,yy:yy\" in Service $data->{service_name}\n";
				return;
			}
		}
  
		# verify numbers
		if ($data->{SERVICE_SECONDS} !~ /^\d+$/ && $data->{NO_SERVICE_SECONDS} !~ /^\d+$/)
		{
			return;
		}
		my $temp = SLA->new();
		push @SLA,$temp;

		$SLA[$i]->monday(shift @data);
		$SLA[$i]->tuesday(shift @data);
		$SLA[$i]->wednesday(shift @data);
		$SLA[$i]->thursday(shift @data);
		$SLA[$i]->friday(shift @data);
		$SLA[$i]->saturday(shift @data);
		$SLA[$i]->sunday(shift @data);
		$SLA[$i]->service_seconds(shift @data);
		$SLA[$i]->no_service_seconds(shift @data);
		$SLA[$i]->dependency(shift @data);
		$SLA[$i]->service_name(shift @data);
		$i++
	} while (@data != 0);
	undef $i;
	return @SLA;
}

sub retrieveData
{
	my $name = $_[0];
	my $SQL = "SELECT * FROM $name";
	my $dbh = DBI->connect("DBI:mysql:$sla_mysqldb:$sla_mysqlhost", $sla_mysqluser, $sla_mysqlpass) or die $DBI::errstr;
	my $cursor = $dbh->prepare($SQL);
	$cursor->execute();
	my @return;

	while(@temp = $cursor->fetchrow_array)
	{
		push @return, @temp;
	}
	$cursor->finish();
	$dbh->disconnect();

	return @return;
}

sub calculateTimestamp
{
	my $day = 0;
	my $sla = $_[0];
	my $sla_log = $_[1];
	my @log_time = localtime($sla_log->{TIMESTAMP});
	switch($log_time[6])
	{
		case 0 { $day = $sla->{SUNDAY} }
		case 1 { $day = $sla->{MONDAY} }
		case 2 { $day = $sla->{TUESDAY} }
		case 3 { $day = $sla->{WEDNESDAY} }
		case 4 { $day = $sla->{THURSDAY} }
		case 5 { $day = $sla->{FRIDAY} }
		case 6 { $day = $sla->{SATURDAY} }
		else { $day = 0 }
	}
	
	$day =~ /(\d+):(\d+),(\d+):(\d+)/;
	$sla_start_hour = $1;
	$sla_start_min = $2;
	$sla_end_hour = $3;
	$sla_end_min = $4;
	
	# correcting start times
	if ($log_time[2] < $sla_start_hour)
	{
		$sla_log->{TIMESTAMP} += (($sla_start_hour - $log_time[2]) * 3600);
		if ($log_time[1] < $sla_start_min)
		{
			#correcting minutes [eg.: 04:15 to 07:20]
			$sla_log->{TIMESTAMP} -= (($sla_start_min - $log_time[1]) * 60) - $log_time[0];
		}
		else
		{
			# correcting minutes [eg.: 04:48 to 07:20]
			$sla_log->{TIMESTAMP} -= (($log_time[1] - $sla_start_min) * 60) - $log_time[0];
		}
	}
	# correcting if event occured at eg. 07:28 and sla_start is at 07:30
	elsif($log_time[2] == $sla_start_hour && $log_time[1] < $sla_start_min)
	{
		$sla_log->{TIMESTAMP} += (($sla_start_min - $log_time[1]) * 60) - $log_time[0];
	}
	elsif($log_time[2] > $sla_end_hour)
	{
		$sla_log->{TIMESTAMP} -= (($log_time[2] - $sla_end_hour) * 3600);
		if ($log_time[1] > $sla_end_min)
		{
			$sla_log->{TIMESTAMP} -= (($log_time[1] - $sla_end_min) * 60 - $log_time[0]);
		}
		else
		{
			$sla_log->{TIMESTAMP} -= (($sla_end_min - $log_time[1]) * 60 - $log_time[0]);
		}
	}
	elsif($log_time[2] == $sla_end_hour && $log_time[1] > $sla_end_min)
	{
		$sla_log->{TIMESTAMP} -= (($log_time[1] - $sla_end_min) * 60 - $log_time[0]);
	}
	return $sla_log;
}
