use 5.006;
use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME               => 'check_xmpp',
    AUTHOR             => 'Tom Ryder <tom@sanctum.geek.nz>',
    VERSION_FROM       => 'libexec/check_xmpp',
    LICENSE            => 'MIT',
    INSTALLSCRIPT      => '/usr/local/nagios/libexec',
    INSTALLSITESCRIPT  => '/usr/local/nagios/libexec',
    EXE_FILES          => ['libexec/check_xmpp'],
    MIN_PERL_VERSION   => '5.006',
    CONFIGURE_REQUIRES => {
        'ExtUtils::MakeMaker' => '0',
    },
    PREREQ_PM => {
        'English'            => 0,
        'Monitoring::Plugin' => 0,
        'Net::XMPP'          => 0,
    },
    META_MERGE => {
        'meta-spec' => { version => 2 },
        resources   => {
            homepage   => 'https://sanctum.geek.nz/cgit/check_xmpp.git/',
            repository => {
                type => 'git',
                url  => 'https://sanctum.geek.nz/code/check_xmpp.git/',
                web  => 'https://sanctum.geek.nz/cgit/check_xmpp.git/',
            },
        },
    },
    clean => { FILES => 'check_xmpp-*' },
);
