/*
Copyright 2009 Jeroen Claeys

This file is part of Birdseye.

    Birdseye is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Birdseye is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Birdseye.  If not, see <http://www.gnu.org/licenses/>.
*/

function checkObjectLists(){
	if(hostsOk==1&&servicesOk==1){
		delete hostsOk;
		delete servicesOk;
		
		clearInterval(timerOne);
		delete timerOne;
		
		if(zeroServicesBugWorkaround==1){
			if(serviceMap.length==0){
				window.location.reload();
			}
		}
		
		showGroups();
		checkShowGroups();
	}else{
		clearInterval(timerOne);
		timerOne = setTimeout('checkObjectLists();',500);
	}
}

function checkShowGroups(){
	if(showGroupsOk==1){
		delete showGroupsOk;
		
		clearInterval(timerTwo);
		delete timerTwo;

		showAllHosts();
		checkShowHosts();	
	}else{
		clearInterval(timerTwo);
		timerTwo = setTimeout('checkShowGroups();',500);
	}
}

function checkShowHosts(){
	if(showHostsOk==1){	
		delete showHostsOk;
		
		clearInterval(timerThree);
		delete timerThree;
		
		workIt();
	}else{
		clearInterval(timerThree);
		timerThree = setTimeout('checkShowHosts();',500);
	}
}

function workIt(){
	if(workItCounter==0){
		getNewEvents();
		askNagios();
		askDb();
		askLoad();
		queryMonitoring();

		$("#nrHostsServices").html("Hosts/services: "+hostMapSize+"/"+serviceMapSize);
		var hPerc=100-((downHostsSize/hostMapSize)*100);
		$("#hostHealth").html("Host health: "+hPerc.toFixed(0)+"% ("+downHostsSize+"/"+hostMapSize+")");
		var sPerc=100-(((criticalServicesSize+warningServicesSize)/serviceMapSize)*100);
		$("#serviceHealth").html("Service health: "+sPerc.toFixed(0)+"% ("+(criticalServicesSize+warningServicesSize)+"/"+serviceMapSize+")");
		
		workItCounter=refreshInterval;
	}
	$("#nextUpdate").html("Next update: "+workItCounter);
	workItCounter--;
	
	var time=new Date();
	var h=time.getHours()
    var m=time.getMinutes()
    var s=time.getSeconds();
	$("#clock").html(checkZero(h)+":"+checkZero(m)+":"+checkZero(s));

	delete time;
	delete h;
	delete m;
	delete s;

	clearInterval(timerFour);
	timerFour = setTimeout('workIt();',1000);	
}

function checkZero(toCheck){
	if(toCheck<10){
		toCheck="0"+toCheck;	
	}	
	return toCheck;
}
