/*
Copyright 2009 Jeroen Claeys

This file is part of Birdseye.

    Birdseye is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Birdseye is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Birdseye.  If not, see <http://www.gnu.org/licenses/>.
*/

function makeInitialHosts(){
	$.post("backend.php", {action: "getHosts"}, function(data){
		var response = data;
		var nameNode = response.getElementsByTagName('display_name');
		var idNode = response.getElementsByTagName('id');
		var stateNode = response.getElementsByTagName('current_state');
		var ackNode = response.getElementsByTagName('ack');
		var notifEnNode = response.getElementsByTagName('notifEn');
		var timeNode = response.getElementsByTagName('time');
		var iconNode = response.getElementsByTagName('icon');	
	
		for(var j=0;j<nameNode.length;j++){	
			var nagiosHost = new NagiosHost();
			nagiosHost.nameHost=nameNode[j].firstChild.nodeValue;
			nagiosHost.id=idNode[j].firstChild.nodeValue;
			nagiosHost.groupId=nagiosHost.id+"group";
			nagiosHost.state=stateNode[j].firstChild.nodeValue;
			nagiosHost.ack=ackNode[j].firstChild.nodeValue;
			nagiosHost.notifEn=notifEnNode[j].firstChild.nodeValue;
			nagiosHost.time=timeNode[j].firstChild.nodeValue;
			nagiosHost.icon=iconNode[j].firstChild.nodeValue;
			
			hostMap[nagiosHost.id]=nagiosHost;
			
			if(nagiosHost.state==0){				
				upHosts.push(nagiosHost.id);
			}else{	
				downHosts.push(nagiosHost.id);
				downHostsSize++;
			}
			delete nagiosHost;
			hostMapSize++;
		}
		delete response;
		delete nameNode;
		delete idNode;
		delete stateNode;
		delete ackNode;
		delete notifEnNode;
		delete timeNode;
		delete iconNode;
		
		hostsOk=1;
	});
}

function makeInitialServices(){
	$.post("backend.php", {action: "getServices"}, function(data){
		var response = data;
		var nameNode = response.getElementsByTagName('display_name');
		var idNode = response.getElementsByTagName('id');
		var parentIdNode = response.getElementsByTagName('parent_id');
		var stateNode = response.getElementsByTagName('current_state');
		var ackNode = response.getElementsByTagName('ack');
		var notifEnNode = response.getElementsByTagName('notifEn');
		var timeNode = response.getElementsByTagName('time');
		var outputNode = response.getElementsByTagName('output');

		for(var j=0;j<nameNode.length;j++){
			var nagiosService = new NagiosService();
			nagiosService.nameService=nameNode[j].firstChild.nodeValue;
			nagiosService.id=idNode[j].firstChild.nodeValue;
			nagiosService.parentId=parentIdNode[j].firstChild.nodeValue;
			nagiosService.state=stateNode[j].firstChild.nodeValue;
			nagiosService.ack=ackNode[j].firstChild.nodeValue;
			nagiosService.notifEn=notifEnNode[j].firstChild.nodeValue;
			nagiosService.time=timeNode[j].firstChild.nodeValue;
			nagiosService.output=outputNode[j].firstChild.nodeValue;
					
			if(hostMap[nagiosService.parentId]!=null){
				serviceMap[idNode[j].firstChild.nodeValue]=nagiosService;
				if(stateNode[j].firstChild.nodeValue==0){
					upServices.push(idNode[j].firstChild.nodeValue);
				}else if(stateNode[j].firstChild.nodeValue==1||stateNode[j].firstChild.nodeValue==3){
					warningServices.push(idNode[j].firstChild.nodeValue);
					warningServicesSize++;
				}else{
					criticalServices.push(idNode[j].firstChild.nodeValue);
					criticalServicesSize++;
				}
				hostMap[nagiosService.parentId].services.push(idNode[j].firstChild.nodeValue);
			}
			delete nagiosService;
			serviceMapSize++;
		}
		delete response;
		delete nameNode;
		delete idNode;
		delete parentIdNode;
		delete stateNode;
		delete ackNode;
		delete notifEnNode;
		delete timeNode;
		delete outputNode;
		
		servicesOk=1;
	});
}
