/*
Copyright 2009 Jeroen Claeys

This file is part of Birdseye.

    Birdseye is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Birdseye is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Birdseye.  If not, see <http://www.gnu.org/licenses/>.
*/

function showGroups(){
	
	for(var i in hostMap){
		var groupDiv=document.createElement('div');
		groupDiv.setAttribute('id',hostMap[i].id+"group");
		groupDiv.setAttribute('class',"overviewTileLight");
		groupDiv.setAttribute('style',"display: none;");
		var hostDiv=document.createElement('div');
		hostDiv.setAttribute('id',hostMap[i].id);
		hostDiv.setAttribute('style',"display: none;");
		groupDiv.appendChild(hostDiv);
		document.getElementById('overview').appendChild(groupDiv);
		delete groupDiv;
		delete hostDiv;
		showGroupsOk=1;
	}	
}

function showHost(hostArray){	
	
	checkScreen();
	
	if(screenFull==0){	
		var toDecode=new Array();
		for(var i in hostArray){
			var info = {};
  			info['type']=hostArray[i].objectType;
  			info['name']=hostArray[i].nameHost;
  			info['id']=hostArray[i].id;
			info['state']=hostArray[i].state;
			info['ack']=hostArray[i].ack;
			info['notifEn']=hostArray[i].notifEn;
			info['time']=hostArray[i].time;
			info['icon']=iconLocation+hostArray[i].icon;
			var foundServiceDown=0;
			for(var j in hostArray[i].services){
				if(serviceMap[hostArray[i].services[j]].parentId==hostArray[i].id){
					if(serviceMap[hostArray[i].services[j]].state!=0){
						foundServiceDown=1;	
					}
				}
			}

			toDecode.push(info);
			delete info;
			delete foundServiceDown;
		}
		var encoded = $.toJSON(toDecode);   
		  
		$.post("backend.php", {action: "hostWidget", json: encoded}, function(data){
			var response = data;
			var idNode = response.getElementsByTagName('id');
			var htmlNode = response.getElementsByTagName('html');
			var idValue;
			var htmlValue;
				
			for(var j=0;j<idNode.length;j++){
				idValue = idNode[j].firstChild.nodeValue;
				htmlValue = htmlNode[j].firstChild.nodeValue;		
						
				var hostDiv=document.getElementById(idValue);
				hostDiv.innerHTML=htmlValue;
				
				if(document.getElementById('popUp').getAttribute('style')=="display: none;"){
					$("#"+idValue+"group").fadeIn(2000);
					$("#"+idValue).fadeIn(2000);
				}else{
					$("#"+idValue+"group").attr('style',"display: block;");
					$("#"+idValue).attr('style',"display: block;");
				}
	
				delete hostDiv;
			}
			
			delete response;
			delete idNode;
			delete htmlNode;
			delete idValue;
			delete htmlValue;
		});
	
		delete toDecode;
		delete encoded;
	}
	
	checkScreen();
}

function showService(serviceArray){
	
	checkScreen();
	
	if(screenFull==0){
		var toDecode=new Array();
		
		for(var i in serviceArray){
			var info = {};
  			info['type']=serviceArray[i].objectType;
  			info['name']=serviceArray[i].nameService;
  			info['id']=serviceArray[i].id;
			info['parentId']=serviceArray[i].parentId;
			info['state']=serviceArray[i].state;
			info['ack']=serviceArray[i].ack;
			info['notifEn']=serviceArray[i].notifEn;
			info['time']=serviceArray[i].time;
			info['output']=serviceArray[i].output;
		
			toDecode.push(info);
		}
		
		var encoded = $.toJSON(toDecode);    
		
		$.post("backend.php", {action: "serviceWidget", json: encoded}, function(data){
			var response = data;
			var idNode = response.getElementsByTagName('id');
			var parentIdNode = response.getElementsByTagName('parentId');
			var htmlNode = response.getElementsByTagName('html');
			
			var idValue;
			var parentIdValue;
			var htmlValue;
			
			for(var j=0;j<idNode.length;j++){
				idValue = idNode[j].firstChild.nodeValue;
				parentIdValue = parentIdNode[j].firstChild.nodeValue;
				htmlValue = htmlNode[j].firstChild.nodeValue;	

				var group = document.getElementById(parentIdValue+"group");
				var oldServiceDiv = document.getElementById(idValue);
	
				if(oldServiceDiv!=null){
					oldServiceDiv.innerHTML=htmlValue;
					if(document.getElementById('popUp').getAttribute('style')=="display: none;"){
						$("#"+idValue).fadeIn(2000);
					}else{
						$("#"+idValue).attr('style',"display: block;");
					}
				}else{
					if(hostMap[parentIdValue].state!=1){
						var serviceDiv = document.createElement('div');
	
						if(group.childNodes.length>3){
							var dotsFound=0;
	
							for(var i=0;i<group.childNodes.length;i++){
								if(group.childNodes[i].innerHTML=="..."){
									dotsFound=1;
								}
							}
							if(dotsFound==0){
								serviceDiv.innerHTML="...";
								group.appendChild(serviceDiv);	
							}
						}else{
							
							var dotsFound=-1;
	
							for(var i=0;i<group.childNodes.length;i++){
								if(group.childNodes[i].innerHTML=="..."){
									dotsFound=i;
								}
							}
							if(dotsFound!=-1){
								var temp=group.childNodes[dotsFound];
								group.removeChild(temp);	
							}
							
							serviceDiv.setAttribute('id',idValue);
							serviceDiv.innerHTML=htmlValue;
							group.appendChild(serviceDiv);
						}
	
						delete serviceDiv;
					}
				}
	
				delete group;
				delete oldServiceDiv;
			}
		
			delete response;
			delete idNode;
			delete parentIdNode;
			delete htmlNode;
			delete idValue;
			delete parentIdValue;
			delete htmlValue;
		});

		delete toDecode;
		delete encoded;
	}
	
	checkScreen();
}

function checkScreen(){
	var parentCounter=new Array();
	for(var i in serviceMap){	
		if(serviceMap[i].state!=0&&hostMap[serviceMap[i].parentId].state==0){
			parentCounter.push(serviceMap[i].parentId);
		}
	} 
	parentCounter=unique(parentCounter);
	if(parentCounter.length>15||downHosts.length>20||(parentCounter.length+downHosts.length)>20){
		screenFull=1;
		if(!$("#popUp").attr('style')||$("#popUp").attr('style')!="display: block;"){
			var doomed=document.createElement('div');
			doomed.setAttribute('id','doomed');
			$("#popUp").append(doomed);
			$("#doomed").html("Critical hosts = "+downHosts.length+"<br>Critical parents = "+parentCounter.length);
			$("#darken").attr('style',"display: block;");
			$("#popUp").attr('style',"display: block;");
		}else{
			$("#doomed").html("Critical hosts = "+downHosts.length+"<br>Critical parents = "+parentCounter.length);
		}
	}else{
		screenFull=0;
		if($("#popUp").attr('style')=="display: block;"){
			$("#popUp").html("");
			$("#darken").attr('style',"display: none;");
			$("#popUp").attr('style',"display: none;");
		}
	}	
}

function unique(b) {
    var a = [];
    var l = b.length;
    for(var i=0; i<l; i++) {
      for(var j=i+1; j<l; j++) {
        if (b[i] === b[j])
          j = ++i;
      }
      a.push(b[i]);
    }
    return a;
  };
