/*
Copyright 2009 Jeroen Claeys

This file is part of Birdseye.

    Birdseye is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Birdseye is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Birdseye.  If not, see <http://www.gnu.org/licenses/>.
*/

function showHostOnPopUp(hostArray){
	var toDecode=new Array();

	for(var i in hostArray){
		info = {};
  		info['type']=hostArray[i].objectType;
  		info['name']=hostArray[i].nameHost;
  		info['id']=hostArray[i].id;
		info['state']=hostArray[i].state;
		info['ack']=hostArray[i].ack;
		info['notifEn']=hostArray[i].notifEn;
		info['time']=hostArray[i].time;
		
		toDecode.push(info);

		delete info;
	}
	var encoded = $.toJSON(toDecode);   
	  
	$.post("backend.php", {action: "hostWidgetPopUp", json: encoded}, function(data){
		var response = data;
		var htmlNode = response.getElementsByTagName('html');

		var htmlValue;
			
		for(var j=0;j<htmlNode.length;j++){
			htmlValue = htmlNode[j].firstChild.nodeValue;	

			var popUpElement=document.createElement('div');
			popUpElement.innerHTML=htmlValue;		
					
			$("#popUp").append(popUpElement);
			
			delete popUpElement;
			delete popUpDiv;
		}
		delete response;
		delete htmlNode;
		delete htmlValue;
	});

	delete toDecode;
	delete encoded;
}

function showServiceOnPopUp(serviceArray){
	var toDecode=new Array();

	for(var i in serviceArray){
		info = {};
  		info['type']=serviceArray[i].objectType;
  		info['name']=serviceArray[i].nameService;
  		info['parentName']=hostMap[serviceArray[i].parentId].nameHost;
  		info['id']=serviceArray[i].id;
		info['parentId']=serviceArray[i].parentId;
		info['state']=serviceArray[i].state;
		info['ack']=serviceArray[i].ack;
		info['notifEn']=serviceArray[i].notifEn;
		info['time']=serviceArray[i].time;
		info['output']=serviceArray[i].output;
		
		toDecode.push(info);
		
		delete info;
	}
	var encoded = $.toJSON(toDecode);   
	  
	$.post("backend.php", {action: "serviceWidgetPopUp", json: encoded}, function(data){
		var response = data;
		var htmlNode = response.getElementsByTagName('html');
			
		var htmlValue;
			
		for(var j=0;j<htmlNode.length;j++){
			htmlValue = htmlNode[j].firstChild.nodeValue;	
	
			var popUpElement=document.createElement('div');
			popUpElement.innerHTML=htmlValue;		
					
			$("#popUp").append(popUpElement);

			delete popUpElement;
			delete popUpDiv;
		}

		delete response;
		delete htmlNode;
		delete htmlValue;
	});

	delete toDecode;
	delete encoded;
}

function hidePopUp(){
	$("#popUp").html("");
	$("#popUp").fadeOut(1000);
	$("#darken").fadeOut(1000);
}