/*
Copyright 2009 Jeroen Claeys

This file is part of Birdseye.

    Birdseye is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Birdseye is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Birdseye.  If not, see <http://www.gnu.org/licenses/>.
*/

function updateHost(hostIds){
	var encoded = $.toJSON(hostIds); 
	var hostsToShow=new Array();   
	var servicesToShow=new Array();
	var hostsToShowOnPopUp=new Array();  
	
	$.post("backend.php", {action: "getHostById",json: encoded}, function(data){
		var response = data;
		var idNode = response.getElementsByTagName('id');
		var nameNode = response.getElementsByTagName('display_name');
		var stateNode = response.getElementsByTagName('current_state');
		var ackNode = response.getElementsByTagName('ack');
		var notifEnNode = response.getElementsByTagName('notifEn');
		var timeNode = response.getElementsByTagName('time');
		var iconNode = response.getElementsByTagName('icon');
			
		for(var i=0;i<idNode.length;i++){
			var hostId=idNode[i].firstChild.nodeValue;
			hostMap[hostId].nameHost=nameNode[i].firstChild.nodeValue;
			hostMap[hostId].state=stateNode[i].firstChild.nodeValue;
			hostMap[hostId].ack=ackNode[i].firstChild.nodeValue;
			hostMap[hostId].notifEn=notifEnNode[i].firstChild.nodeValue;
			hostMap[hostId].time=timeNode[i].firstChild.nodeValue;
			hostMap[hostId].icon=iconNode[i].firstChild.nodeValue;
				
			var overview=document.getElementById("overview");
			var group=document.getElementById(hostId+"group");
			
			var foundUp=-1;
			var foundDown=-1;
			
			for(var j=0;j<upHosts.length;j++){
				if(hostId==upHosts[j]){
					foundUp=j;	
					if(hostMap[hostId].state==1){
						downHosts.push(hostId);
						downHostsSize++;
						upHosts.splice(foundUp,1);
						
						var temp=group.childNodes;
						for(var k=0;k<temp.length;k++){
							if(temp[k].getAttribute('id')!=hostId){
								group.removeChild(temp[k]);
								k--;	
							}
						}
						
						hostsToShowOnPopUp.push(hostMap[hostId]);
						delete temp;	
						
						updateTicker=2;
					}
				}		
			}
			if(foundUp==-1){
				for(var k=0;k<downHosts.length;k++){
					if(hostId==downHosts[k]){
						foundDown=k;
						if(hostMap[hostId].state==0){
							upHosts.push(hostId);
							downHosts.splice(foundDown,1);
							downHostsSize--;
							var foundDownService=0;
							for(var l in hostMap[hostId].services){
								if(serviceMap[hostMap[hostId].services[l]].state!=0){
									servicesToShow.push(serviceMap[hostMap[hostId].services[l]]);
									foundDownService=1;
								}
							}
							if(foundDownService==1){
								hostsToShow.push(hostMap[hostId]);	
							}
							delete foundDownService;
							
							updateTicker=2;
						}	
					}		
				}
			}
	
				if(hostMap[hostId].state==1){
					hostsToShow.push(hostMap[hostId]);		
				}else if(group.childNodes.length>1){
					hostsToShow.push(hostMap[hostId]);	
				}else{					
					if(document.getElementById('popUp').getAttribute('style')=="display: none;"){
						$("#"+hostId+"group").fadeOut(2000);
					}else{
						$("#"+hostId+"group").attr('style',"display: none;");
					}
					
				}
			
			delete hostId;
			delete overview;
			delete group;
			delete foundUp;
			delete foundDown;
		}

		if(hostsToShow.length!=0){
			showHost(hostsToShow);
		}
		if(servicesToShow.length!=0){
			showService(servicesToShow);
		}	
		if(servicesToShow.length!=0){
			showService(servicesToShow);
		}
		if(hostsToShowOnPopUp.length!=0){
			if(screenFull==0){
				showHostOnPopUp(hostsToShowOnPopUp);	
				$("#darken").fadeIn(1000);
				$("#popUp").fadeIn(1000);
				var popUpTimer=setTimeout('hidePopUp();',(refreshInterval-5)*1000);	
			}
		}

		delete response;
		delete idNode;
		delete nameNode;
		delete stateNode;
		delete ackNode;
		delete notifEnNode;
		delete timeNode;
		delete iconNode;
	});
	hostsToUpdate=new Array();
	hostsToShowOnPopUp=new Array();

	delete encoded;
	delete hostsToShow;
	delete servicesToShow;
	delete hostsToShowOnPopUp

	$("#criticalHosts").html("Critical hosts: "+downHosts.length);
}

function updateService(serviceIds){
	var encoded = $.toJSON(serviceIds); 
	var hostsToShow=new Array();
	var servicesToShow=new Array(); 
	
	var servicesToShowOnPopUp=new Array(); 
	
	$.post("backend.php", {action: "getServiceById",json: encoded}, function(data){
		var response = data;
		var idNode = response.getElementsByTagName('id');
		var nameNode = response.getElementsByTagName('display_name');
		var stateNode = response.getElementsByTagName('current_state');
		var ackNode = response.getElementsByTagName('ack');
		var notifEnNode = response.getElementsByTagName('notifEn');
		var timeNode = response.getElementsByTagName('time');
		var outputNode = response.getElementsByTagName('output');
		
		for(var i=0;i<nameNode.length;i++){
			var serviceId=idNode[i].firstChild.nodeValue;
			serviceMap[serviceId].nameService=nameNode[i].firstChild.nodeValue;
			serviceMap[serviceId].state=stateNode[i].firstChild.nodeValue;
			serviceMap[serviceId].ack=ackNode[i].firstChild.nodeValue;
			serviceMap[serviceId].notifEn=notifEnNode[i].firstChild.nodeValue;
			serviceMap[serviceId].time=timeNode[i].firstChild.nodeValue;
			serviceMap[serviceId].output=outputNode[i].firstChild.nodeValue;
			
			var overview=document.getElementById("overview");
			var group;
			var oldService;
			
			var foundUp=-1;
			var foundWarning=-1;
			var foundCritical=-1;

			for(var j=0;j<upServices.length;j++){
				if(serviceId==upServices[j]){
					foundUp=j;
					if(serviceMap[serviceId].state==1||serviceMap[serviceId].state==3){
						warningServices.push(serviceId);
						warningServicesSize++;
						upServices.splice(foundUp,1);
						
						servicesToShowOnPopUp.push(serviceMap[serviceId]);

					}else if(serviceMap[serviceId].state==2){
						criticalServices.push(serviceId);
						criticalServicesSize++;
						upServices.splice(foundUp,1);
						
						servicesToShowOnPopUp.push(serviceMap[serviceId]);	
					}
				}	
			}
			if(foundUp==-1){
				for(var k=0;k<warningServices.length;k++){
					if(serviceId==warningServices[k]){
						foundWarning=k;	
						if(serviceMap[serviceId].state==0){
							upServices.push(serviceId);
							warningServices.splice(foundWarning,1);
							warningServicesSize--;
						}else if(serviceMap[serviceId].state==2){
							criticalServices.push(serviceId);
							criticalServicesSize++;
							warningServices.splice(foundWarning,1);
							warningServicesSize--;
							
							servicesToShowOnPopUp.push(serviceMap[serviceId]);
						}
					}	
				}
			}
			if(foundUp==-1&&foundWarning==-1){
				for(var l=0;l<criticalServices.length;l++){
					if(serviceId==criticalServices[l]){
						foundCritical=l;	
						if(serviceMap[serviceId].state==0){
							upServices.push(serviceId);
							criticalServices.splice(foundCritical,1);
							criticalServicesSize--;
						}else if(serviceMap[serviceId].state==1||serviceMap[serviceId].state==3){
							warningServices.push(serviceId);
							warningServicesSize++;
							criticalServices.splice(foundCritical,1);
							criticalServicesSize--;							

							servicesToShowOnPopUp.push(serviceMap[serviceId]);
						}
					}	
				}
			}

	
				if(serviceMap[serviceId].state==1||serviceMap[serviceId].state==2||serviceMap[serviceId].state==3){
					hostsToShow.push(hostMap[serviceMap[serviceId].parentId]);
					servicesToShow.push(serviceMap[serviceId]);		
				}else if(foundUp==-1){
					group=document.getElementById(serviceMap[serviceId].parentId+"group");
					if(group!=null){
						oldService=document.getElementById(serviceId);
						if(oldService!=null){
							group.removeChild(oldService);
						}else if(group.childNodes.length==2){
							if(group.childNodes[1].innerHTML=="..."){
								group.removeChild(group.childNodes[1]);	
							}
						}

						if(group.childNodes.length<=1){
							if(document.getElementById('popUp').getAttribute('style')=="display: none;"){
								$("#"+serviceMap[serviceId].parentId+"group").fadeOut(2000);
							}else{
								$("#"+serviceMap[serviceId].parentId+"group").attr('style',"display: none;");
							}
						}
					}
				}

			
			delete serviceId;
			delete overview;
			delete group;
			delete oldService;
			delete foundUp;
			delete foundWarning;
			delete foundCritical;
		}
		
		if(hostsToShow.length!=0){
			showHost(hostsToShow);
		}
		if(servicesToShow.length!=0){
			showService(servicesToShow); 
		}
		
		if(servicesToShowOnPopUp.length!=0){
			if(screenFull==0){	
				showServiceOnPopUp(servicesToShowOnPopUp);
				$("#darken").fadeIn(1000);
				$("#popUp").fadeIn(1000);
				var popUpTimer=setTimeout('hidePopUp();',(refreshInterval-5)*1000);	
			}
		}

		delete response;
		delete idNode;
		delete nameNode;
		delete stateNode;
		delete ackNode;
		delete notifEnNode;
		delete timeNode;
		delete outputNode;
	});
	
	servicesToUpdate=new Array();

	delete encoded;
	delete hostsToShow;
	delete servicesToShow;
	delete servicesToShowOnPopUp;

	$("#criticalServices").html("Critical services: "+criticalServices.length);
	$("#warningServices").html("Warning services: "+warningServices.length);
	
	var temp="";
	for(var i in criticalServices){
		if(hostMap[serviceMap[criticalServices[i]].parentId].state==0){
			temp=temp+'<span><div style="display:inline;padding:0px 40px 0px 40px">'+hostMap[serviceMap[criticalServices[i]].parentId].nameHost+' > '+serviceMap[criticalServices[i]].nameService+' > '+serviceMap[criticalServices[i]].output+'</div></span>';
		}
	}
	$("#ticker").html(temp);
	
	temp="";
	
	for(var i in warningServices){
		if(hostMap[serviceMap[warningServices[i]].parentId].state==0){
			temp=temp+'<span><div style="display:inline;padding:0px 20px 0px 20px">'+hostMap[serviceMap[warningServices[i]].parentId].nameHost+' > '+serviceMap[warningServices[i]].nameService+' > '+serviceMap[warningServices[i]].output+'</div></span>';
		}
	}
	$("#ticker2").html(temp);
	delete temp;
	
	
	ticker_start(document.getElementById("ticker").scrollLeft);
	ticker_start2(document.getElementById("ticker2").scrollLeft);
}
