/*
Copyright 2009 Jeroen Claeys

This file is part of Birdseye.

    Birdseye is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Birdseye is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Birdseye.  If not, see <http://www.gnu.org/licenses/>.
*/

function askNagios(){
	$.post("backend.php", {action: "askNagios"}, function(data){	
		var resultValue = data.getElementsByTagName('result')[0].firstChild.nodeValue;
		
		$("#nagiosRunning").html("Nagios ...");
		if(resultValue==1){
			$("#nagiosRunning").html("<img src=\"green.png\" /> Nagios");
		}else{
			$("#nagiosRunning").html("<img src=\"red.png\" /> Nagios");
		}
		
		delete resultValue;
	});
}

function askDb(){
	$.post("backend.php", {action: "askDb"}, function(data){
		var resultValue = data.getElementsByTagName('result')[0].firstChild.nodeValue;
		
		$("#dbRunning").html("Ndo2db ...");
		if(resultValue==1){
			$("#dbRunning").html("<img src=\"green.png\" /> Ndo2db");
		}else{
			$("#dbRunning").html("<img src=\"red.png\" /> Ndo2db");
		}
		
		delete resultValue;
	});
}

function askLoad(){
	$.post("backend.php", {action: "askLoad"}, function(data){
		var resultValue = data.getElementsByTagName('result')[0].firstChild.nodeValue;

		if(resultValue==null){
			$("#load").html("SONAR DOWN");
		}else{
			$("#load").html(resultValue);
		}

		delete resultValue;
	});
}

function queryMonitoring(){
	$.post("backend.php", {action: "getMonitoring"}, function(data){
		var response = data;
		var flapDetectionNode = response.getElementsByTagName('flap_detection');
		var notificationsNode = response.getElementsByTagName('notifications');
		var eventHandlersNode = response.getElementsByTagName('event_handlers');
		var activeHostChecksNode = response.getElementsByTagName('active_host_checks');
		var activeServiceChecksNode = response.getElementsByTagName('active_service_checks');
		var passiveHostChecksNode = response.getElementsByTagName('passive_host_checks');
		var passiveServiceChecksNode = response.getElementsByTagName('passive_service_checks');
		var programStartTimeNode = response.getElementsByTagName('program_start_time');

		$("#programStartTime").html("PST: "+programStartTime);

		if(programStartTime==0){
			if(programStartTimeNode[0]){
				programStartTime=programStartTimeNode[0].firstChild.nodeValue;
			}
		}else{
			if(!programStartTimeNode[0]){
				window.location.reload();
			}else{
				 if(programStartTime!=programStartTimeNode[0].firstChild.nodeValue){
                        		window.location.reload();
	                	}
			}
		}
	
		if(flapDetectionNode[0].firstChild.nodeValue==1){
			$("#flapDetection").html("<img src=\"green.png\" /> Flap detection");
		}else{
			$("#flapDetection").html("<img src=\"red.png\" /> Flap detection");
		}
		if(eventHandlersNode[0].firstChild.nodeValue==1){
			$("#eventHandlers").html("<img src=\"green.png\" /> Event handlers");
		}else{
			$("#eventHandlers").html("<img src=\"red.png\" /> Event handlers");
		}
		if(notificationsNode[0].firstChild.nodeValue==1){
			$("#notifications").html("<img src=\"green.png\" /> Notifications");
		}else{
			$("#notifications").html("<img src=\"red.png\" /> Notifications");
		}
		if(activeHostChecksNode[0].firstChild.nodeValue==1&&activeServiceChecksNode[0].firstChild.nodeValue==1){
			$("#activeChecks").html("<img src=\"green.png\" /> Active checks");
		}else{
			$("#activeChecks").html("<img src=\"red.png\" /> Active checks");
		}
		if(passiveHostChecksNode[0].firstChild.nodeValue==1&&passiveServiceChecksNode[0].firstChild.nodeValue==1){
			$("#passiveChecks").html("<img src=\"green.png\" /> Passive checks");
		}else{
			$("#passiveChecks").html("<img src=\"red.png\" /> Passive checks");
		}
		
		delete flapDetectionNode;
		delete notificationsNode;
		delete eventHandlersNode;
		delete activeHostChecksNode;
		delete activeServiceChecksNode;
		delete passiveHostChecksNode;
		delete passiveServiceChecksNode;
	});
}	
