/*
Copyright 2009 Jeroen Claeys

This file is part of Birdseye.

    Birdseye is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Birdseye is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Birdseye.  If not, see <http://www.gnu.org/licenses/>.
*/

<?php 
include 'connection.php';
header('Content-Type: application/xml; charset=ISO-8859-1');
 
$action = $_POST['action'];

//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------
	if($action=='askNagios'){
		$nagios=0;
		if(exec('pidof nagios3')!=null){
			$nagios=1;
		}
		echo "<"."?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?".">";
		echo "<results>";
		echo "<result>";
		echo $nagios;
		echo "</result>";
		echo "</results>";
	
//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------
	}else if($action=='askDb'){
		$ndo2db=0;
		if(exec('pidof ndo2db')!=null){
			$ndo2db=1;
		}
		echo "<"."?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?".">";
		echo "<results>";
		echo "<result>";
		echo $ndo2db;
		echo "</result>";
		echo "</results>";
	
//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------

	}else if($action=='askLoad'){
		$load=exec('uptime');
		echo "<"."?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?".">";
		echo "<results>";
		echo "<result>";
		$temp=explode("load average: ",$load);
		echo $temp[1];
		echo "</result>";
		echo "</results>";
	
//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------
	}else if($action=='getMonitoring'){
		$sql='select program_start_time, flap_detection_enabled,notifications_enabled,event_handlers_enabled,active_host_checks_enabled,active_service_checks_enabled,passive_host_checks_enabled,passive_service_checks_enabled from ndoutils.nagios_programstatus;';
		$connection = new Connection;
		$connection->connect();
		$res = $connection->getDb()->query($sql);
		$connection->disconnect();
		
		if (DB::isError($res)) {   
   	 		die($res->getMessage());
		}
 
		$xml = "";
		while ($row = $res->fetchRow(DB_FETCHMODE_OBJECT)) {
			$xml .= "<program>";
			$xml .= "<program_start_time>$row->program_start_time</program_start_time>";
			$xml .= "<flap_detection>$row->flap_detection_enabled</flap_detection>";
			$xml .= "<notifications>$row->notifications_enabled</notifications>";
			$xml .= "<event_handlers>$row->event_handlers_enabled</event_handlers>";
			$xml .= "<active_host_checks>$row->active_host_checks_enabled</active_host_checks>";
			$xml .= "<active_service_checks>$row->active_service_checks_enabled</active_service_checks>";
			$xml .= "<passive_host_checks>$row->passive_host_checks_enabled</passive_host_checks>";
			$xml .= "<passive_service_checks>$row->passive_service_checks_enabled</passive_service_checks>";
			$xml .= "</program>";
		}
		
		echo "<"."?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?".">";
		echo "<programs>";
		echo $xml;
		echo "</programs>";
		
		unset($xml);
		
		$res->free();
	
//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------
	}else if ($action == 'getHosts'){
		
		$sql='select a.display_name, a.host_object_id, a.icon_image, b.current_state, b.problem_has_been_acknowledged, b.notifications_enabled, b.status_update_time from ndoutils.nagios_hosts a, ndoutils.nagios_hoststatus b, ndoutils.nagios_host_contactgroups c, ndoutils.nagios_contactgroups d where a.host_object_id=b.host_object_id and a.host_id=c.host_id and c.contactgroup_object_id=d.contactgroup_object_id and d.alias!="Invisible" order by a.display_name;';		
		$connection = new Connection;
		$connection->connect();
		$res = $connection->getDb()->query($sql);
		$connection->disconnect();
		
		if (DB::isError($res)) {   
   	 		die($res->getMessage());
		}
 
		$xml = "";
		while ($row = $res->fetchRow(DB_FETCHMODE_OBJECT)) {
			$xml .= "<host>";
			$lowerCaseName=strtolower($row->display_name);
			$xml .= "<display_name>$lowerCaseName</display_name>";
			$xml .= "<id>$row->host_object_id</id>";
			$xml .= "<current_state>$row->current_state</current_state>";
			$xml .= "<ack>$row->problem_has_been_acknowledged</ack>";
			$xml .= "<notifEn>$row->notifications_enabled</notifEn>";
			$xml .= "<time>$row->status_update_time</time>";
			if($row->icon_image==null){
				$xml .= "<icon>test</icon>";
			}else{	
				$xml .= "<icon>$row->icon_image</icon>";	
			}				
			$xml .= "</host>";
		}
		
		echo "<"."?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?".">";
		echo "<hosts>";
		echo $xml;
		echo "</hosts>";
		
		unset($xml);
		
		$res->free();
//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------
	}else if ($action == 'getServices'){
		
		$sql = "select a.display_name, a.host_object_id, a.service_object_id, b.current_state, b.problem_has_been_acknowledged, b.notifications_enabled, b.status_update_time, b.output from ndoutils.nagios_services a inner join ndoutils.nagios_servicestatus b on a.service_object_id = b.service_object_id";
		$connection = new Connection;
		$connection->connect();
		$res = $connection->getDb()->query($sql);
		$connection->disconnect();
		
		if (DB::isError($res)) {   
   	 		die($res->getMessage());
		}
 
		$xml = "";
		while ($row = $res->fetchRow(DB_FETCHMODE_OBJECT)) {
			$xml .= "<service>";
			$lowerCaseName=strtolower($row->display_name);
			$xml .= "<display_name>$lowerCaseName</display_name>";
			$xml .= "<id>$row->service_object_id</id>";
			$xml .= "<parent_id>$row->host_object_id</parent_id>";
			$xml .= "<current_state>$row->current_state</current_state>";
			$xml .= "<ack>$row->problem_has_been_acknowledged</ack>";
			$xml .= "<notifEn>$row->notifications_enabled</notifEn>";
			$xml .= "<time>$row->status_update_time</time>";
			$temp = strip_tags($row->output);
			$xml .= "<output>$temp</output>";
			$xml .= "</service>";
		}
		
		echo "<"."?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?".">";
		echo "<services>";
		echo $xml;
		echo "</services>";
		
		unset($xml);
		
		$res->free();
//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------
	}else if ($action == 'getHostById'){
				
		$temp=stripcslashes($_POST['json']);
		$decoded = json_decode($temp,true);
		
		$sql='select a.display_name, a.host_object_id, a.icon_image, b.current_state, b.problem_has_been_acknowledged, b.notifications_enabled, b.status_update_time from ndoutils.nagios_hosts a, ndoutils.nagios_hoststatus b, ndoutils.nagios_host_contactgroups c, ndoutils.nagios_contactgroups d where a.host_object_id=b.host_object_id and a.host_id=c.host_id and c.contactgroup_object_id=d.contactgroup_object_id and d.alias!="Invisible" and a.host_object_id in (';
	
	    for($i=0;$i<sizeof($decoded);$i++){
			$id=$decoded[$i];
			if($i!=0){
				$sql .= ",";	
			}
			$sql .= $id;
		}
		
		$sql .= ");";
		
		$connection = new Connection;
		$connection->connect();
		$res = $connection->getDb()->query($sql);
		$connection->disconnect();
		
		if (DB::isError($res)) {   
   	 		die($res->getMessage());
		}
 
		$xml = "";
		while ($row = $res->fetchRow(DB_FETCHMODE_OBJECT)) {
			$xml .= "<host>";
			$xml .= "<id>$row->host_object_id</id>";
			$lowerCaseName=strtolower($row->display_name);
			$xml .= "<display_name>$lowerCaseName</display_name>";
			$xml .= "<current_state>$row->current_state</current_state>";
			$xml .= "<ack>$row->problem_has_been_acknowledged</ack>";
			$xml .= "<notifEn>$row->notifications_enabled</notifEn>";
			$xml .= "<time>$row->status_update_time</time>";
			if($row->icon_image==null){
				$xml .= "<icon>test</icon>";
			}else{	
				$xml .= "<icon>$row->icon_image</icon>";	
			}	
			$xml .= "</host>";
		}
		
		echo "<"."?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?".">";
		echo "<hosts>";
		echo $xml;
		echo "</hosts>";
		
		unset($xml);
		
		$res->free();
//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------
	}else if ($action == 'getServiceById'){
		
		$temp=stripcslashes($_POST['json']);	
		$decoded = json_decode($temp,true);
		
		$sql = "select a.service_object_id, a.display_name, a.host_object_id, a.service_object_id, b.current_state, b.problem_has_been_acknowledged, b.notifications_enabled, b.status_update_time, b.output from ndoutils.nagios_services a inner join ndoutils.nagios_servicestatus b on a.service_object_id = b.service_object_id where a.service_object_id in (";
		
		for($i=0;$i<sizeof($decoded);$i++){
			$id=$decoded[$i];
			if($i!=0){
				$sql .= ",";	
			}
			$sql .= $id;
		}
		
		$sql .= ");";

		$connection = new Connection;
		$connection->connect();
		$res = $connection->getDb()->query($sql);
		$connection->disconnect();
		
		if (DB::isError($res)) {   
   	 		die($res->getMessage());
		}
 
		$xml = "";
		while ($row = $res->fetchRow(DB_FETCHMODE_OBJECT)) {
			$xml .= "<service>";
			$xml .= "<id>$row->service_object_id</id>";
			$lowerCaseName=strtolower($row->display_name);
			$xml .= "<display_name>$lowerCaseName</display_name>";
			$xml .= "<current_state>$row->current_state</current_state>";
			$xml .= "<ack>$row->problem_has_been_acknowledged</ack>";
			$xml .= "<notifEn>$row->notifications_enabled</notifEn>";
			$xml .= "<time>$row->status_update_time</time>";
			$temp = strip_tags($row->output);
			$xml .= "<output>$temp</output>";
			$xml .= "</service>";
		}
		
		echo "<"."?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?".">";
		echo "<services>";
		echo $xml;
		echo "</services>";
		
		unset($xml);
		
		$res->free();
//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------
	}else if ($action == 'getNewEvents'){
		
		$refreshInterval=$_POST['refreshInterval'];
		$refreshInterval=$refreshInterval+2;

		$sql = "select * from e where date_add(status_update_time,interval $refreshInterval second) > now();";
		
		$connection = new Connection;
		$connection->connect();
		$res = $connection->getDb()->query($sql);
		$connection->disconnect();
		
		if (DB::isError($res2)) {   
   	 		die($res2->getMessage());
		}

		$xml = "";
		while ($row = $res->fetchRow(DB_FETCHMODE_OBJECT)) {
			$xml .= "<object>";
			$xml .= "<object_id>$row->object_id</object_id>";			
			$xml .= "</object>";
		}
		
		echo "<"."?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?".">";
		echo "<objects>";
		echo $xml;
		echo "</objects>";
		
		unset($xml);
//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------
	}else if ($action == 'hostWidget'){
		
		$temp=stripcslashes($_POST['json']);	
		$decoded = json_decode($temp,true);
		
		$xml="";
		
	    for($i=0;$i<sizeof($decoded);$i++){
			$hostObject=$decoded[$i];
			$id=$hostObject['id'];
			$state=$hostObject['state'];
			$name=$hostObject['name'];
			$icon=$hostObject['icon'];

			$xml .= "<object>";
			$xml .= "<id>$id</id>";
			$xml .= "<state>$state</state>";
			$xml .= "<html><![CDATA[";

			$xml.="<div id=host$id class=host$id><div style=\"display:inline;padding-right:10px;\"><img src=$icon height=30 width=30></div>$name</div>";
			
			$color="";

			if($state==0){
				$color="0,0,0";
			}else{
				$color="100,0,0";
			}
			
			$xml.="<style><!--.host$id{background-color: rgb($color";
			$xml.=");margin: 4px;-moz-border-radius: 10px;border: thin solid rgb($color);border-bottom: thin solid rgb(131,131,131);border-top: thin solid rgb(131,131,131);}--></style>";

			$xml .= "]]></html>";
			$xml .= "</object>";
		}
		
		echo "<"."?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?".">";
		echo "<objects>";
		echo $xml;
		echo "</objects>";
		
		unset($xml);
//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------
	}else if ($action == 'hostWidgetPopUp'){
		
		$temp=stripcslashes($_POST['json']);	
		$decoded = json_decode($temp,true);
		
		$xml="";
		
	    for($i=0;$i<sizeof($decoded);$i++){
			$hostObject=$decoded[$i];
			$id=$hostObject['id'];
			$state=$hostObject['state'];
			$name=$hostObject['name'];
			
			$xml .= "<object>";
			$xml .= "<id>$id</id>";
			$xml .= "<state>$state</state>";
			$xml .= "<html><![CDATA[";

			$xml.="<div id=hostPopUp$id class=hostPopUp$id>$name</div>";
			$xml.="<style><!--.hostPopUp$id{background-color: rgb(";
			
			if($state==0){
				$xml.="0,0,0";
			}else{
				$xml.="100,0,0";
			}
			$xml.=");font-size: 30px;margin: 4px;}--></style>";

			$xml .= "]]></html>";
			$xml .= "</object>";
		}
		
		echo "<"."?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?".">";
		echo "<objects>";
		echo $xml;
		echo "</objects>";
		
		unset($xml);
//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------
	}else if ($action == 'serviceWidget'){	
		$temp=stripcslashes($_POST['json']);	
		$decoded = json_decode($temp,true);
		
		$xml="";
		
	    for($i=0;$i<sizeof($decoded);$i++){
			$serviceObject=$decoded[$i];
			$id=$serviceObject['id'];
			$parentId=$serviceObject['parentId'];
			$name=$serviceObject['name'];
			$state=$serviceObject['state'];
			
			$xml .= "<object>";
			$xml .= "<id>$id</id>";
			$xml .= "<parentId>$parentId</parentId>";
			$xml .= "<html><![CDATA[";
			$xml .= "<div id=service$id class=service$id><i>$name</i></div>";
			
			$color="";
			if($state==0){
				$color="0,0,0";
			}else if($state==1){
				$color="200,160,0";
			}else if($state==2){
				$color="100,0,0";
			}else{
				$color="200,120,0";
			}
			$xml.="<style><!--.service$id{background-color: rgb($color);-moz-border-radius: 10px;border: thin solid rgb($color);margin-left: 4px;margin-right: 4px;margin-bottom: 4px;}--></style>";
			
			$xml .= "]]></html>";
			$xml .= "</object>";
		}
		
		echo "<"."?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?".">";
		echo "<objects>";
		echo $xml;
		echo "</objects>";
		
		unset($xml);
//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------
	}else if ($action == 'serviceWidgetPopUp'){	
		
		$temp=stripcslashes($_POST['json']);	
		$decoded = json_decode($temp,true);
		
		$xml="";
		
	    for($i=0;$i<sizeof($decoded);$i++){
			$serviceObject=$decoded[$i];
			$id=$serviceObject['id'];
			$parentId=$serviceObject['parentId'];
			$parentName=$serviceObject['parentName'];
			$name=$serviceObject['name'];
			$state=$serviceObject['state'];
			$output=$serviceObject['output'];
			
			$xml .= "<object>";
			$xml .= "<id>$id</id>";
			$xml .= "<parentId>$parentId</parentId>";
			$xml .= "<html><![CDATA[";
			
			$xml .= "<div id=servicePopUp$id class=servicePopUp$id>$parentName - <i>$name</i><br>$output</div>";
			
			$xml.="<style><!--.servicePopUp$id{background-color: rgb(";
			if($state==0){
				$xml.="0,0,0";
			}else if($state==1){
				$xml.="200,160,0";
			}else if($state==2){
				$xml.="100,0,0";
			}else{
				$xml.="200,120,0";
			}
			$xml.=");font-size: 30px;margin: 4px;}--></style>";
			$xml .= "]]></html>";
			$xml .= "</object>";
		}
		
		echo "<"."?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?".">";
		echo "<objects>";
		echo $xml;
		echo "</objects>";
		
		unset($xml);
//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------
	}
?>
