/*
Copyright 2009 Jeroen Claeys

This file is part of Birdseye.

    Birdseye is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Birdseye is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Birdseye.  If not, see <http://www.gnu.org/licenses/>.
*/

<?php
require_once 'DB.php';

class Connection{
	
	var $db;

	function connect(){	
		$host       = "";  // the hostname of the database server
		$DB_user    = "";            // the username to connect with
		$DB_pass    = "";     	 // the user's password
		$DB_dbName  = "";          // the name of the database to connect to
		$DB_dbType  = "";           // the type of database server.

		$dsn = $DB_dbType . "://"        // Build a DSN string (Data Source Name)
        		. $DB_user . ":"         // Required by DB::connect()
        		. $DB_pass . "@" 
       			. $DB_host . "/" 
        		. $DB_dbName;

		$this->db = DB::connect($dsn, TRUE);

		if (DB::isError($this->db)) {                      
    		die($this->db->getMessage());     
        }	
	}
	
	function disconnect(){
		$this->db->disconnect();	
	}
	
	function getDb(){
		return $this->db;	
	}
}	
?>
