#!/bin/bash
#check_backup 0.4
#checks using cmin
#checks if a valid backup has been done 
#made by Fabio Pardi on August 2012, pachistano@gmail.com

#variables definition 
check_file=0.0.0.0      #passed via command line
work_dir=/usr/local/nagios/libexec/check_backup
awk=/usr/bin/awk
report=$work_dir/report.txt
#clean the old report
debug=$work_dir/debug

exit_code=0
##################################################
#############################################
print_help() {
        echo ""
        echo "Usage: $PROGNAME --help"
	echo "Usage: $PROGNAME -f check_file"
        echo ""
        echo "Plugin to check backups"
	echo ""
	echo "PARAMETERS:"
	echo "-> check_file: is the configuration file contains what you want to check."
	echo "common syntax of the check_file is backup_path backup_name, minimum size"
        echo ""
}
##################################################
##############################################
#parameters check
while test -n "$1"; do
   case "$1" in
        --help)
            print_help
            exit 2
            ;;

        -f)
            check_file=$2
            shift
            ;;
        *)
            echo "Unknown argument: $1"
            print_help
            exit 2
            ;;
    esac
    shift
done 

if [ $check_file == "0.0.0.0" ] ;then
echo "target config file missing!"
echo "please use -f check_file"
exit
fi

if [ ! -s $report ]
then
	echo "report is empty, so no problem"
/bin/bash $work_dir/indexer.sh -f $check_file  </dev/null &>/dev/null &

else
	cat $report
	#now we should call the indexer
/bin/bash $work_dir/indexer.sh -f $check_file  </dev/null &>/dev/null &
	exit 2
fi


#if we reach this point, it means everything worked out
exit 0

		#NAGIOSEXIT
		#exit codes (service status)
		#0=OK
		#1=warning
		#2=critical
