#!/bin/bash

#variables definition 
check_file=0.0.0.0      #passed via command line
work_dir=/usr/local/nagios/libexec/check_backup
awk=/usr/bin/awk
report=$work_dir/report.txt
#clean the old report
debug=$work_dir/debug
today=`date \+%u`
# %u     day of week (1..7); 1 is Monday

> $report
#> $debug

exit_code=0
##################################################
#############################################
print_help() {
        echo ""
        echo "Usage: $PROGNAME --help"
	echo "Usage: $PROGNAME -f check_file"
        echo ""
        echo "Plugin to check backups"
	echo ""
	echo "PARAMETERS:"
	echo "-> check_file: is the configuration file contains what you want to check."
	echo "common syntax of the check_file is backup_path backup_name, minimum size, day of the week the backup is done"
        echo ""
}
##################################################
##############################################
#parameters check
while test -n "$1"; do
   case "$1" in
        --help)
            print_help
            exit 2
            ;;

        -f)
            check_file=$2
            shift
            ;;
        *)
            echo "Unknown argument: $1"
            print_help
            exit 2
            ;;
    esac
    shift
done 

if [ $check_file == "0.0.0.0" ] ;then
echo "target config file missing!"
echo "please use -f check_file"
exit
fi

######################change my grep
echo im inside index >> $work_dir/debug_me

cat $work_dir/check_file | grep -v "#"  | while read line; do
	echo line is $line >> $debug
	position=`echo $line |  $awk '{print $1}'`
	what_check=`echo $line |  $awk '{print $2}'`
	size_check=`echo $line |  $awk '{print $3}'`
	day_of_week=`echo $line |  $awk '{print $4}'`

#	echo position is $position
#	echo what is $what_check 
#	echo size is $size_check 

# This checks if the backup is supposed to arrive today
	if [ `echo $day_of_week | grep $today`  ] || [  "$day_of_week" == "all"  ]
	then
echo checking $position
		if [[ "$size_check" == "0k" ]]
		then
			result=$(find $position -mmin -1600  | grep $what_check)
		else
			result=$(find $position -mmin -1600 -size +$size_check | grep $what_check)
		fi

		if [ ! -n "$result" ] && [[ $position = *dimasys* ]]
		then 
			echo "Problem $position/$what_check. Backup too old, missing or too small, dimasys-MSSQL backup run failed!" >> $report
		elif [ ! -n "$result" ]
			then
			echo "Problem $position/$what_check. Backup missing or too small" >> $report
		fi
#echo index finished >> $work_dir/debug_me

	fi
done
exit 0

