#!/bin/sh
# vim: set ts=2 sw=2:
############################################################################
# This file is part of nscam.                                              #
#                                                                          #
# nscam is free software: you can redistribute it and/or modify            #
# it under the terms of the GNU General Public License as published by     #
# the Free Software Foundation, either version 3 of the License, or        #
# (at your option) any later version.                                      #
#                                                                          #
# nscam is distributed in the hope that it will be useful,                 #
# but WITHOUT ANY WARRANTY; without even the implied warranty of           #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            #
# GNU General Public License for more details.                             #
#                                                                          #
# You should have received a copy of the GNU General Public License        #
# along with nscam.  If not, see <http://www.gnu.org/licenses/>.           #
#                                                                          #
############################################################################
# filename : test.sh                                                       #
#                                                                          #
# id: $Id$
#                                                                          #
# date:    : 2011-02-11                                                    #
# purpose  : Test nsca multicast messages.                                 #
#                                                                          #
# author   : Peter Meszaros                                                #
#            e-mail: hauptadler@gmail.com                                  #
#                                                                          #
############################################################################
#

echo "NSCAM TEST RUN"

rm -f nscam.key
:> temp.out

if [ -x ../src/keygen ]
then
  echo "GENERATE KEY"
  ../src/keygen -f nscam.key -p 12345 -a twofish -m cfb -s -d

  echo "PRINT KEY"
  ../src/keygen -f nscam.key -P
fi

echo "START NSCAMD"
../src/nscamd -k nscam.key -o temp.out &
DPID=$!

sleep 2

echo "SEND MESSAGE"
echo TEST | ../src/nscam_send -k nscam.key

sleep 2
sync

kill $DPID 

echo "EVALUATE RESULT"
diff temp.out test.out

