/* vim: set ts=2 sw=2: */
/****************************************************************************
 * This file is part of nscam.                                              *
 *                                                                          *
 * nscam is free software: you can redistribute it and/or modify            *
 * it under the terms of the GNU General Public License as published by     *
 * the Free Software Foundation, either version 3 of the License, or        *
 * (at your option) any later version.                                      *
 *                                                                          *
 * nscam is distributed in the hope that it will be useful,                 *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with nscam.  If not, see <http://www.gnu.org/licenses/>.           *
 *                                                                          *
 ****************************************************************************
 * filename : crypt.h                                                       *
 *                                                                          *
 * id: $Id$
 *                                                                          *
 * date:    : 2011-05-08                                                    *
 * purpose  : Mcrypt intarface and other crypt functions.                   *
 *                                                                          *
 * author   : Peter Meszaros                                                *
 *            e-mail: hauptadler@gmail.com                                  *
 *                                                                          *
 ****************************************************************************/

#define _GNU_SOURCE
#include <mcrypt.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <err.h>
#include <libgen.h>

#include "../config.h"

enum genmode {
	RANDOM,
	DEVRANDOM
};

void printhex(FILE *f, unsigned char *b, int length);
void generateIVrandom(unsigned char *b, int length, int seed);
void generateIVdevrandom(unsigned char *b, int length);
void loadkeyfile(char *fn);
void printkeyfile(FILE *out);
int McryptPrintInfo(int print);
void McryptDone(void);
int McryptInit(char *fn);
int McryptEncrypt(char *buf, int len);
int McryptDecrypt(char *buf, int len);
