#include "../common/common.h"
#include "mt.h"

static HANDLE *lock_cs;

void locking_function(int mode, int n, const char *file, int line);
unsigned long id_function(void);


int mt_setup(void)
{
    int i;

    lock_cs = OPENSSL_malloc(CRYPTO_num_locks() * sizeof(HANDLE));
    if (!lock_cs)
        return 0;
    for (i = 0; i < CRYPTO_num_locks(); i++) {
        lock_cs[i] = CreateMutex(NULL, FALSE, NULL);
    }

    CRYPTO_set_locking_callback(locking_function);
    CRYPTO_set_id_callback(id_function);
    return 1;
}

int mt_cleanup(void)
{
    int i;

    if (!lock_cs)
        return 0;

    CRYPTO_set_locking_callback(NULL);
    CRYPTO_set_id_callback(NULL);
    for (i = 0; i < CRYPTO_num_locks(); i++)
        CloseHandle(lock_cs[i]);
    OPENSSL_free(lock_cs);

    return 1;
}

void locking_function(int mode, int n, const char *file, int line)
{
    if (mode & CRYPTO_LOCK) {
        WaitForSingleObject(lock_cs[n], INFINITE);
    }
    else {
        ReleaseMutex(lock_cs[n]);
    }
}
unsigned long id_function(void)
{
    return ((unsigned long) GetCurrentThreadId());
}
