#!/usr/bin/perl
#
#----------------------------------------------------------------------
#
#    Copyright (C) 2003 by Martin Schmitz net&works GmbH, Germany
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# History:
#
#    04.07.2003 - Initial Version
#
#----------------------------------------------------------------------
#
# This Plugin asks the eventlogAgent for Events matching to the parameters
# given to this plugin.
# To make this work, you need to install the eventLogAgent on your Windows
# Maschine.
# For more Infos look at the Usage Info
#
use IO::Socket::INET;
use Getopt::Std;

# Sends the Parameter to the agent using the global variable $socket
sub sendCommand
{
        my $host = $opt_H;
        my $port = $opt_p;
        my $list = $opt_l;
        my $status_id = $opt_s;
        my $event_ids = $opt_i;
        my $sources = $opt_q;
        my $types = $opt_t;
        my $messages = $opt_m;
        $socket->send("list=" . $list . "\n");
        $socket->send("status_id=" . $status_id . "\n");
        $socket->send("types=" . $types . "\n");
        $socket->send("sources=" . $sources . "\n");
        $socket->send("event_ids=" . $event_ids . "\n");
        $socket->send("messages=" . $messages . "\n");
        $socket->send("COMMAND_END\n");
}

#read the state that was send by the agent into the global hash $state
sub readState
{
        while($line ne "STATE_END")
        {
                $line = <$socket>;
                $line = trim( $line );
                @tmp = split(/=/,$line);
                $state{$tmp[0]} = $tmp[1];
        }
}

sub trim
{
    $_ = shift;
    chomp $_; # Remove Linefeeds
    s/#.*//; # Remove Comments
    s/^\s+//; # Remove Spaces from Beginning
    s/\s+$//; # Remove Space from End
    return $_;
}

$EVENTLOG_ERROR_TYPE  =        1;
$EVENTLOG_WARNING_TYPE = 2 ;
$EVENTLOG_INFORMATION_TYPE = 4 ;
$EVENTLOG_AUDIT_SUCCESS = 8;
$EVENTLOG_AUDIT_FAILURE = 16;

$STATE_WARNING = 1;
$STATE_OK = 0;
$STATE_CRITICAL = 2;
$STATE_UNKNOWN = 3;

getopts("m:i:t:q:H:p:l:s:");
if( (not defined($opt_H)) or (not defined($opt_s)))
{
        print "\n";
        print "This Plugin checks the eventlog_agent on Windows Maschines.\n";
        print "The nagios service that uses this plugin should be configured\n";
        print "to send notifications on the first error state, because the\n";
        print "Agent will not return the same Error more than one time.\n";
    print "\nUsage: check_win_eventlog -h <HOST> [-p <PORT>] -l <SOURCENAME> -s <ID> [-m <MESSAGES>] [-i <EVENT_IDS>] [-t <EVENT_TYPES>] [-q <SOURCES>]\n";
    print "-H Hostname or Hostaddress.\n";
    print "-p Portnumber (Defaults to 1903)\n";
    print "-l The Eventlog protocol name. This is one of 'System', 'Application'"
            . "\n   or 'Security'."
            . "\n   Some Systems may have additional protocols. The names of those"
            . "\n   protocols can be found by looking into the registry key"
            . "\n   [HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\Eventlog]"
            . "\n";
    print "-s unique ID that is used by the Agent to identify an request.\n";
    print "-m A list of regular expressions divided by colons (:)."
            . "\n   If any of those regular Expression matches, then the Message"
            . "\n   will NOT be selected for notification."
            . "\n   If the RegExp begins with '+', then the expression will reset"
            . "\n   the match. This way you can do an exclude all but xy."
            . "\n   An example for this would be '.*:+ALARM' which would only detect"
            . "\n   all messages that include 'ALARM', but ignore anything else."
            . "\n";
    print "-i Like -m but for EventIDs\n";
    print "-t Like -m but for EventTypes\n";
    print "-q Like -m but for Sources\n\n";
    exit (-1);
}

if(not defined($opt_m))
{
        $opt_m = "";
}
if(not defined($opt_i))
{
        $opt_i = "";
}
if(not defined($opt_t))
{
        $opt_t = "";
}
if(not defined($opt_q))
{
        $opt_q = "";
}
if(not defined($opt_p))
{
        $opt_p = "1903";
}
$|=1; #Flush any output directly
$status = $STATE_CRITICAL;
eval
{
    $socket = new IO::Socket::INET( PeerAddr => $opt_H,
                                                                    PeerPort => $opt_p,
                                                                    Proto => 'tcp') ||die $!;
    %state = ();
    sendCommand();
    readState();
    if(defined($state{"MATCH_COUNT"}))
    {
            # if matchcount == 0 then state should be OK
            if( $state{"MATCH_COUNT"} == 0)
            {
                    print "EventLog OK\n";
                    $status = $STATE_OK;
            }
            # if we have exactly one match and its type is not an eventlog error, then
            # we will output a warning instead of CRITICAL error.
            # if we have more than one error, then we cant know what types of events we
            # have (only the last one is submitted by the agent). so we have to
            # assume, that there is probably an eventlog_error_type and we should exit
            # with CRITICAL state
            elsif( $state{"MATCH_COUNT"} == 1 and $state{'LAST_TYPE'} > $EVENTLOG_ERROR_TYPE)
            {
                    $status = $STATE_WARNING;
                    print "Found $state{'MATCH_COUNT'} errors. Last was: EVT_ID: $state{'LAST_EVENTID'} Time: $state{'LAST_TIME'} $state{'LAST_MESSAGE'}";
            }
            else #if( $state{'MATCH_COUNT'} >= 1)
            {
                    print "Found $state{'MATCH_COUNT'} errors. Last was: EVT_ID: $state{'LAST_EVENTID'} Time: $state{'LAST_TIME'} $state{'LAST_MESSAGE'}";
            }
    }
    else
    {
            $status = $STATE_UNKNOWN;
            print "Unknown Error";
    }
};
if($@)
{
    print "An Error occured before state could be read: $@";
}
exit $status;
