#!/usr/bin/perl -w

use strict;

my %config;

#
# Defaults
#

#$config{php_dir} = "html/Nagios/";
$config{php_dir} = "html/NagiosPHP/";

$config{html_root} = "/home/httpd/";
$config{smarty_dir} = "smarty/nagios-php/";
$config{config_dir} = "var/nagios-php/";

#$config{nagioscfg} = "/etc/nagios/nagios.cfg";
$config{nagioscfg} = "/usr/local/nagios/etc/nagios.cfg";

$config{webuser} = "apache";

print <<TEXTEND;

-------------------------------------
Nagios PHP Web Interface installation
-------------------------------------

Before installing, please make sure that you have PHP and SMARTY
installed on your system.

It is required that you will have the following PEAR packages as well:
* Auth (tested with 1.2.3)
* Files_Passwd (tested with 1.1.0)

(See INSTALL for URLs)

-----------------------------------------------
This release has been tested with SMARTY 2.6.2,
and WILL ONLY WORK FOR nagios 1.x.
-----------------------------------------------

TEXTEND

sub user_input
{
	my ($var) = @_;

	print "\n[".$$var."] ";

	my $line = <STDIN>;
	chomp $line;

	if (! $line =~ /^ *$/ )
	{
		$$var = $line;
	}

	print "\n\n";
}



print "Please enter the ABSOLUTE path of your webserver ROOT (usually /home/httpd/ or /var/www/):\n";
user_input(\$config{html_root});

# Add trailing slash
if (! ($config{html_root} =~ /\/$/))
{
	$config{html_root} .= "/";
}


print "Please enter the RELATIVE path of the PHP scripts path inside the webserver ROOT:\n";
user_input(\$config{php_dir});
$config{php_dir} = $config{html_root}.$config{php_dir};

print "Please enter the ABSOLUTE path of the PHP scripts INCLUDEs :\n";
print "This can be the same as PHP script path, or can be in a different directory.\n";
print "Note: if you choose it to be different than your PHP scripts path, you will have\n";
print "to add the path to the include_path directive in your php.ini.\n";
$config{phpinc_dir} = $config{php_dir};
user_input(\$config{phpinc_dir});

print "Please enter the ABSOLUTE path of the smarty root for nagios-php :\n";
$config{smarty_dir} = $config{html_root}.$config{smarty_dir};
user_input(\$config{smarty_dir});

print "Please enter the ABSOLUTE path of the configuration files:\n";
$config{config_dir} = $config{html_root}.$config{config_dir};
user_input(\$config{config_dir});

print "Please enter the ABSOULTE filename of your main nagios.cfg file:\n";
user_input(\$config{nagioscfg});

print "Please enter the webserver user:\n";
user_input(\$config{webuser});

open(MAKEFILE,">Makefile");
print MAKEFILE <<ENDMAKE;
all: install cfg

install:

# php/html to $config{php_dir}

	install -g $config{webuser} -m 0750 -d $config{php_dir}
	cp -r php/html/* $config{php_dir}

# php/inc to $config{phpinc_dir}

	install -g $config{webuser} -m 0750 -d $config{phpinc_dir}
	cp -r php/inc/* $config{phpinc_dir}

# smarty root creation, templates

	install -g $config{webuser} -m 0750 -d $config{smarty_dir}
	install -g $config{webuser} -m 0770 -d $config{smarty_dir}/cache/
	install -g $config{webuser} -m 0750 -d $config{smarty_dir}/configs/
	install -g $config{webuser} -m 0770 -d $config{smarty_dir}/templates_c/
	install -g $config{webuser} -m 0750 -d $config{smarty_dir}/templates/
	cp -r smarty/*tpl $config{smarty_dir}/templates

# sed'ing

	cat php/inc/blacksmith.inc.php | sed 's;%config_dir%;$config{config_dir};g' > $config{phpinc_dir}/blacksmith.inc.php
	cat php/inc/nagios.inc.php | sed 's;%config_dir%;$config{config_dir};g' > $config{phpinc_dir}/nagios.inc.php

cfg:

	mv $config{config_dir}/blacksmith.cfg $config{config_dir}/blacksmith.cfg.saved
	mv $config{config_dir}/nagios-php.cfg $config{config_dir}/nagios-php.cfg.saved

	cat config/blacksmith.cfg | sed 's;%config_dir%;$config{config_dir};g; s;%smarty_dir%;$config{smarty_dir};g;' > $config{config_dir}/blacksmith.cfg
	cat config/nagios-php.cfg | sed 's;%php_dir%;$config{php_dir};g; s;%nagioscfg%;$config{nagioscfg};g;' > $config{config_dir}/nagios-php.cfg

upgrade: clean install

clean:

	rm -Rf $config{php_dir}
	rm -Rf $config{phpinc_dir}
	rm -Rf $config{smarty_dir}

ENDMAKE
close(MAKEFILE);

print "Upgrading? SAVE YOUR CONFIGURATION FILES FIRST and run 'make upgrade'.\n";
print "To install for the first time, just run 'make'.\n\n";
print "*** NOTICE *** You'll have to add a proper user. Look in INSTALL for how to do this. *** NOTICE ***"





