<?php

/*
 * Nagios PHP Interface: cmd.php
 * 2004 Eldad Zack <eldadzack@gmail.com>
 *
 * TODO: Pre-compile command-list XML to array.

 LICENSE:
  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

if (!include "nagios.inc.php")
{
	exit("Nagios PHP initalization error.");
}

ini_set("variables_order","GP");	// Causes $_REQUEST to contain $_GET and $_POST only in that order

if (!isset($_REQUEST['type']))
{
        $nagios->print_error("No Command Specified.");
}

$type = strtoupper($_REQUEST['type']);

# function adapted from comment by mmustafa@vsnl.com on the xml_parse_into_struct page
# (www.php.net/manual/en/function.xml-parse-into-struct.php)
function read_xml_file($file,&$xml_object)
{

	$xml_parser = xml_parser_create();

	if (!($fp = fopen($file, "r")))
	{
		return false;
	}

	$data = fread($fp, filesize($file));
	fclose($fp);

	xml_parse_into_struct($xml_parser, $data, $vals, $index);
	xml_parser_free($xml_parser);

	$xml_object = array();
	$level = array();
	foreach ($vals as $element)
	{
		if ($element['type'] == 'open')
		{
			if (array_key_exists('attributes',$element))
			{
				list($level[$element['level']],$extra) = array_values($element['attributes']);
			}

			else
			{
				$level[$element['level']] = $element['tag'];
			}
		}
		if ($element['type'] == 'complete')
		{
			$start_level = 1;
			$php_stmt = '$xml_object';

			while($start_level < $element['level'])
			{
				$php_stmt .= '[$level['.$start_level.']]';
				$start_level++;
			}
			$php_stmt .= '[$element[\'tag\']] = $element[\'value\'];';
			eval($php_stmt);
		}
	}

	return true;
}

read_xml_file("cmd.def.xml",$cmd_obj_temp);
$cmd_obj = $cmd_obj_temp['COMMANDS'];

if (!isset($cmd_obj[$type]))
{
	$nagios->print_error("No such command.");
}

#
# Read status file
#

$status = file ($nagios->statusfile);

foreach ($status as $line)
{
	if (preg_match("/\[([0-9]+)\].*PROGRAM/",$line,$reg))
	{
		$date = date("D M d H:i:s Y T",$reg[1]);
	}
}

#Infobox

$blacksmith->assign("date",$date);
$blacksmith->assign("username",$nagios->username);

if ($_REQUEST['commit'] == 1)
{
	$send_cmd = strtoupper($cmd_obj[$type]['CMD']);

	# Check fields
	foreach (array_keys($cmd_obj[$type]['FIELD']) as $key)
	{
		if ($cmd_obj[$type]['FIELD'][$key]['TYPE'] == "checkbox")
		{
			if ($_REQUEST[$key] == "on")
                        {
                                $_REQUEST[$key] = 1;
                        }
                        else
                        {
                                $_REQUEST[$key] = 0;
                        }
		}
		else
		{
			if ((!isset($_REQUEST[$key])) || $_REQUEST[$key] == "")
			{
				$nagios->print_error("Command Execution failed: Missing field $key.");
				exit;
			}
		}
	}

	foreach (array_keys($_REQUEST) as $key)
	{
		$send_cmd = preg_replace("/%".$key."%/",$_REQUEST[$key],$send_cmd);
	}

	$send_cmd = "[".time()."] $send_cmd";

	$pipe_handle = fopen($nagios->config['command_file'],"w");

	if (! $pipe_handle)
	{
		$nagios->print_error("Command Execution failed: can't write to command file.");
	}

	fputs($pipe_handle,$send_cmd);
	fclose($pipe_handle);

	$nagios->print_header("External Nagios Command",false);
	$blacksmith->display("cmd-commited.tpl");
}
else
{
	foreach (array_keys($_REQUEST) as $key)
	{
		$ukey = strtoupper($key);
		if (isset($cmd_obj[$type]['FIELD'][$ukey]))
		{
			$cmd_obj[$type]['FIELD'][$ukey]['DEFAULT'] = $_REQUEST[$key];
		}
	}

	$nagios->print_header("External Nagios Command",false);
	$blacksmith->assign("type",$type);
	$blacksmith->assign("cmd_array",$cmd_obj[$type]);
	$blacksmith->display("cmd.tpl");
}

$blacksmith->display("nagios-footer.tpl");

#print("</center><pre>");
#print_r($cmd_obj);
?>